//=============================================================================
// Header: JT808 firmware update RAM code
// Date Time: 1/17/2013 11:49:18 AM
// Author: Xuedong.Liu
//
// Description: This is JT808 firmware field update RAM code.  it is svaed in extrnal
//     flash with JT808 firmware application.  it is first section of flash file.
//     when user like to use saved extrnal flash file as update applicaiton.  The code
//     is copied to RAM 0x1C00 start place. the size is depend code development.
//     at initial release the size is less then 2K. This code is running in RAM
//     Erase all flash area and copy section 2 start file to application.
//
//     Code standard is CD0084 revision A date: 14 Jul, 2000
//
//==============================================================
#include "masterHeader.h"
#include "DefineUpdateFw.h"

// prototype
tU16 u16CCIT(tU8 *u8BuffPtr, tU32 u32Length, tU16 inCrc);
void main_update (void);

__no_init FLASH_SECTION FwSecInfor1; //@SEC_INFO_STRAT;
__no_init tU16 ReadInforCrc;// @CRC_SEC_INFO_START;

#pragma location="CRCTABLE"
static const tU8 u8crctb2[] =
{
#include "crctable.h"
};
#pragma location="CALCRC"
tU16 u16CCIT(tU8 *u8BuffPtr, tU32 u32Length, tU16 inCrc)
{
  tU32 i;                     // Counts down # characters in buffer, length = 1 do one byte
  tU8 *pBuffer = u8BuffPtr;   // Local copy of buffer pointer
  tU8 *pTbl;                  // Current character from modifier table
  union
  {
    tU16  word;
    tU8   byte[2];
  } crc;
  crc.word = inCrc;

  // Initial CRC to starting value; then, look through all chars.
  crc.byte[0] = ~crc.byte[0];

  // loop all chars
  for (i = u32Length; i > 0; i--)
  {
    // following line was pTbl = (tU8 *)&((tU16 *)u8crctb2)[(tU8)(*pBuffer++) ^ (tU8) crc.byte[0]]; result not match
    pTbl = (tU8 *)&((tU16 *)u8crctb2)[(tU8)(*pBuffer++) ^ (tU8) crc.byte[0]];
    //pTbl = (tU8 *)&((tU16 *)u8crctb2)[(tU8)(*pBuffer++) ^ (tU8) crc.byte[0]];
    crc.byte[0] = crc.byte[1]  ^ (*pTbl++);
    crc.byte[1]  = *pTbl;
  }
  //  Looping done, invert low byte, then,
  crc.byte[0] = ~crc.byte[0];

  // return current 16bits-crc
  return crc.word;
} // u16BaspCCIT

#pragma location="FLASHTOMSP"
void main_update (void)
{
  tU8 tempdata, i;
  tU32 loopEnd_i, loopEnd_j;
  tU16 Fw_RamKey;
  tU32 temp_i, temp_j, addr_up, SecStartAdd;
  tU16 calCrc;
  tU16 error;
  FLASH_SECTION ramSecInfo;

  // move section information from Flash to RAM
  for (temp_i = 0; temp_i < SEC_INFO_SIZE; temp_i++)
  {
    ((tU8 *)&ramSecInfo)[temp_i] = ((tU8 *)&FwSecInfor1)[temp_i];
  }

  //__low_level_init();
  for (i = 0; i < 10; i++)   //while (1)
  {
    // init intrenal veriables
    error = SUCCESSFUL_OPERATION;

    Fw_RamKey = FWKEY;
    // init SPI port

    // calculate sectio infor checksum
    calCrc = u16CCIT((tU8 *)&ramSecInfo, PROG_INFOR_SIZE, 0xFFFF);
    // could update keep the process?
    if ( calCrc == ReadInforCrc)
    {
      // yes, keep the process going
      // erase application area from 0x6C00 to 0xFFFF
      //erase_appl_flash();
      while( FCTL3 & BUSY )
      {
        _NOP();
      }
      asm("movx.a  #0x6400,R15");        // Initialize write address
      asm("dint");                       // 5xx Workaround: Disable global
                                         // interrupt while erasing. Re-Enable
                                         // GIE if needed
      asm("mov.w   #0xA500,&FCTL3");     // Clear Lock bit
      asm("mov.w   #0xA504,&FCTL1");     // Set Erase bit
      asm("mov.w   #0,0(R15)");          // Dummy write to erase Flash seg

      while( FCTL3 & BUSY )
      {
        _NOP();
      }
      asm("movx.a  #0x010000,R15");      // Initialize write address
      asm("dint");                       // 5xx Workaround: Disable global
                                         // interrupt while erasing. Re-Enable
                                         // GIE if needed
      asm("mov.w   #0xA500,&FCTL3");     // Clear Lock bit
      asm("mov.w   #0xA504,&FCTL1");     // Set Erase bit
      asm("mov.w   #0,0(R15)");          // Dummy write to erase Flash seg
      //asm("eint");
      while( FCTL3 & BUSY )
      {
        _NOP();
      }

      //****** 1. read from a section data from extranl storage area ******
      addr_up = FIX_START_ADDR + ramSecInfo.sectionSize[0];
      loopEnd_i = ramSecInfo.totalSection + 1;
      for (temp_i = 1; temp_i < loopEnd_i; temp_i++)
      {
        // this section read from which address start
        addr_up += ramSecInfo.evenModifier[temp_i];

        // clear out unused address bits
        ramSecInfo.sectionStartAddr[temp_i] = ramSecInfo.sectionStartAddr[temp_i] & VOID5438A_ADDR_MASK;
        // if this first block, it is the application run address.
        // save first block address as run address
        SecStartAdd = ramSecInfo.sectionStartAddr[temp_i];
        loopEnd_j = ramSecInfo.sectionSize[temp_i];
        for (temp_j = 0; temp_j < loopEnd_j; temp_j++)
        {
          //get extranel flash data
          tempdata = __data20_read_char(addr_up);
          FCTL3 = Fw_RamKey;              // Clear unLock bit
          // doing byte write, the section application area
          while( FCTL3 & BUSY )
          {
            _NOP();
          }
          FCTL1 = Fw_RamKey + WRT;        // Set write bit
          __data20_write_char( SecStartAdd, tempdata );
          while( FCTL3 & BUSY )
          {
            _NOP();
          }
          FCTL3 = Fw_RamKey + LOCK;               // Set LOCK bit
          addr_up++;
          SecStartAdd++;
        } // for temp_j
      } // for temp_i

      // do the CRC check, do not check section number = 0, because it is running
      loopEnd_i = ramSecInfo.totalSection + 1;

      for (temp_i = 1; temp_i < loopEnd_i; temp_i++)
      {
        // initilize
        calCrc = u16CCIT((tU8 *)ramSecInfo.sectionStartAddr[temp_i],
                         ramSecInfo.sectionSize[temp_i],
                         0xFFFF);
        if ( calCrc != ramSecInfo.sectionCRC[temp_i].crc.word)
        {
          error = 1;   // error return, restart process.
        }
      }

      // get here write and check are right
      if (error == SUCCESSFUL_OPERATION)
      {
        // excute application.
        //this instruction forces system reset
        WDTCTL = WRONG_WDTPW + WDTHOLD;
      }
    }
    // else section information CRC read and calculate are not same, not erase
    // current application, power cycle system back to normal
  } // forever loop, if not program currently, otherwise, control will go to application
}

