//=============================================================================
// Header: detectPotocol.c
// Date Time: 2/14/2013 1:59 PM
// Author: Xuedong.Liu
//
// Description: Rx char from USB, to look each protocol
//    detect message meet which protocoll standards, then pass to the next layer
//    to process the request and generaic response, or let host the resuest is
//    not support by this device.
//
//=============================================================================
// constant definitions, type definitions
#include "masterHeader.h"
//#include "defineUART.h"

// global volatile variables
#include "externGlobalVar.h"

//global function prototypes definitions
#include "externFunc.h"

// static local variables
// static COMM_ENV *portEnv;
// local function prototype definitions:
static void portRxModeLookRxChar(COMM_ENV *ptEnv);

// global & local function implementation
static void setNextLayerUsePort(COMM_ENV *ptEnv)
{
  // MP430F5638
  if(ptEnv->u8PortID == USB_PORTIN)
  {
    u8UsedPort[LAYER_2ND] |= USE_USB_PORT;
  }
  else
  {
    u8UsedPort[LAYER_2ND] |= USE_RADIO_PORT;
  }
}

//==============================================================================
//
// FUNCTION:        driversLookCommRxBuf
//
// DESCRIPTION:     called from kernel, when received char. three protocol driver
//                  look same received char.  if receive state to the end, and
//                  message meet protocol standard. the message process status
//                  set. or look next received char. or sleep waite for next char.
//
// PARAMETERS:      NAME       TYPE   DESCRIPTION
//                  ---------- ------ ------------------------------------------
//
// RETURNS:         None
//
// PRE-CONDITIONS:  NA
//
// POST-CONDITIONS: NA
//
// MODIFIES:        u8DriverStatus, u8LookCharPtr
//
// NOTES:
//
//==============================================================================
static void portRxModeLookRxChar(COMM_ENV *ptEnv)
{
  // Modbus driver looks received this char if not get complete request.
  if ((ptEnv->u8DriverStatus & MSG_MEET_MD_STD) != MSG_MEET_MD_STD)
  {
    ModbusLayer1Driver(ptEnv);
  }
//#ifndef __JT808_MSP430F5638__
  // BASP driver looks received this char if not get complete request.
  if ((ptEnv->u8DriverStatus & MSG_MEET_BASP_STD) != MSG_MEET_BASP_STD)
  {
    BaspLayer1Driver(ptEnv);
  }
  // HART driver looks received this char if not get complete request.
  if ((ptEnv->u8DriverStatus & MSG_MEET_HART_STD) != MSG_MEET_HART_STD)
  {
    //HartLayer1driver(ptEnv);
  }
//#endif
  // if we already know what protocol message is, this protocol process the request and
  // not look RX data any more, RX data has been moved to the protocol request buffer
  // extra char could be noise, or other protocol start talking.
  if ((ptEnv->u8DriverStatus & MSG_MEET_MD_STD) == MSG_MEET_MD_STD)
  {
    // we start process a request, host may talk to other device on same line or send 2nd request to this
    // device, we ignore them from now on.
    ptEnv->u8TxStatus |= TX_PROCESS_REQUEST;    // switch the port to the Tx state, ignore the other chars
    // set u8UsedPort according to the ptEnv
    setNextLayerUsePort(ptEnv);

    // Radio and USB can use same next layer protocol process to generate response
    u8Layer2TaskScheduler |= USB_MD_REQ_READY; // layer2 process the Modbus request, create the response

    if(ptEnv->u8PortID == RADIO_PORTID)
    {
        // Radio on ly Tx message, should no tget in here
    }

    // process request, when it is ready USB port send out, Radio prot wait for RTS delay
  }
//#ifndef __JT808_MSP430F5638__
  else if ((ptEnv->u8DriverStatus & MSG_MEET_BASP_STD) == MSG_MEET_BASP_STD)
  {
    // we start process a request, host may talk to other device on same line or send 2nd request to this
    // device, we ignore them from now on.
    ptEnv->u8TxStatus |= TX_PROCESS_REQUEST;            // switch the port to the Tx state, ignore the other Rx chars
    u8Layer1TaskScheduler |= RS485_BASP_REQ_READY;// start to process BASP request, create response

    // process request, when it is ready send out
  }
  else if ((ptEnv->u8DriverStatus & MSG_MEET_HART_STD) == MSG_MEET_HART_STD)
  {
    // we start process a request, host may talk to other device on same line or send 2nd request to this
    // device, we ignore them from now on.
    ptEnv->u8TxStatus |= TX_PROCESS_REQUEST;      // switch the port to the Tx state, ignore the other Rx chars
    //u8OtherTaskScheduler |= USB_HART_REQ_READY; // start to process HART request, create response

    // process request, when it is ready send out
  }
//#endif
  else
  {
    // not meet any of protocol at this char
  }
}
static tU8 u8CntProReq;
static void driversLookRxBuf(COMM_ENV *ptEnv)
{
  if ((ptEnv->u8TxStatus & TX_PROCESS_REQUEST) != TX_PROCESS_REQUEST)
  {
    // port is in Rx mode received char, portocols look the char
    portRxModeLookRxChar(ptEnv);
  }
  else
  {
    u8CntProReq++;
    if(u8CntProReq >= 3)
    {
      // maybe lock down, clear it for next time to run
      ptEnv->u8TxStatus &= ~TX_PROCESS_REQUEST;
      // reset counter
      u8CntProReq = 0;
    }
    // the port is in Tx mode, discard Rx char.
    ptEnv->u8LookCharPtr = ptEnv->u8IncomePtr;
  }
}

void commonLookRxBuf(COMM_ENV *portEnv)
{
  while (portEnv->u8LookCharPtr != portEnv->u8IncomePtr)
  {
    // look one income char, when three protocol looks the char, point to next char
    driversLookRxBuf(portEnv);

    if (portEnv->u8LookCharPtr != portEnv->u8IncomePtr)
    {
      // all protocol looked this char, point to next one, if has more char, look again
      portEnv->u8LookCharPtr++;
      portEnv->u8LookCharPtr &= (RX_BUF_SIZE-1);
    }
  }
#ifdef __JT808_MSP430F5638__
  if(portEnv->u8LookCharPtr == portEnv->u8IncomePtr)
  {
    if(portEnv->u8DriverStatus == 0)
    {
      portEnv->u8LookCharPtr = 0;
//      USB_setEnabledEvents(0); //kUSB_allUsbEvents);
    }
  }
#endif
}

// USB from MSP430F5638
void driversLookCommRxBuf(void)
{
  COMM_ENV *portEnv;
  // clear look char flag, next char interrupt will start look it again
  u8Layer1TaskScheduler &= (tU8)~USB_RECEIVED_CHARS;
  // get port process resource or environments
  portEnv = getUsbPortEnv();

  commonLookRxBuf(portEnv);
}


//=============================================================================
// end file by xuedong
//=============================================================================
