//=============================================================================
// Header: JTI808 feature board MSP430F5438A init
// Date Time: 1/19/2013 9:53 AM
// Author: Xuedong.Liu
//
// Description: init system clock, ports, USCIs, RTC, ADC.
//
//=============================================================================

// constant definitions, type definitions
#include "masterHeader.h"

// global volatile variables
#include "externGlobalVar.h"

// global function prototypes definitions:
#include "externFunc.h"

// local static variables
static void I2CReinit(void);
//static void getAclkSpeed(void);
static void initClocks(DWORD mclkFreq);

// copy from 
// C:\ti\msp430\MSP430ware_1_95_00_32\examples\boards\MSP-EXP430F5529LP\
//    MSP-EXP430F5529LP Software Examples\Source\SimpleUsbBackchannel\hal.c
static void initClocks(DWORD mclkFreq)
{
    // Assign the REFO as the FLL reference clock
	UCS_clockSignalInit(
	   UCS_BASE,
	   UCS_FLLREF,
	   UCS_REFOCLK_SELECT,
	   UCS_CLOCK_DIVIDER_1);

	// Assign the REFO as the source for ACLK
	UCS_clockSignalInit(
	   UCS_BASE,
	   UCS_ACLK,
	   UCS_REFOCLK_SELECT,
	   UCS_CLOCK_DIVIDER_1);

    UCS_initFLLSettle(
        UCS_BASE,
        mclkFreq/1000,
        mclkFreq/32768);
        //use REFO for FLL and ACLK
        UCSCTL3 = (UCSCTL3 & ~(SELREF_7)) | (SELREF__REFOCLK);
        UCSCTL4 = (UCSCTL4 & ~(SELA_7)) | (SELA__REFOCLK);

}

//==============================================================================
//
// FUNCTION:        fbStartXT1
//
// DESCRIPTION:     copy from "MSP430 Liberay\grlib\MSP-EXP5438_Grlib_Example\main.c"
//   also reference to example\driverlib\5xx_6xx\ucs\ucs_XTsources_DCOinternal.c
//   and example\driverlib\5xx_6xx\ucs\ucs_XT1_sources_ACLK.c
//   also reference to void clockInit(void) in map430_EXP5638_Grlib_example, main.c
//
//   Output 32768Hz crystal on XT1 and observe failsafe
//
//   Description: Configure ACLK = XT1 in LF mode and enter LPM3.
//   If we want to observe failsafe behavior, than short the crystal briefly on the feature board.
//   This will cause an NMI to occur. the board debug LED is toggled inside the NMI ISR.
//   Once the fault flag is cleared XT1 operation continues from 32768Hz crystal
//   Otherwise ACLK defaults to VLO (~8KHz).
//   ACLK = LFXT1 = 32kHz, MCLK = SMCLK = 8MHz
//
//           MSP430F54x
//         ---------------
//     /|\|            xin|-
//      | |               | 32KHz
//      --|RST        xout|-
//        |               |
//        |          P11.0|--->ACLK  --  32KHz LED D48
//        |          P11.1|--->MCLK   -> 8MHz
//        |          P11.2|--->SMCLK  -> 8MHz
//
//
//     Initialization routine for XT1.  XT1 has 32KHz crystal
//     connect to it. Sets the necessary internal capacitor values
//     and loops until all ocillator fault flags remain cleared. or
//     it is up running.
//
//==============================================================================
tU8 initDone;
void fbStartXT1(tU8 u8UsbClkOn, tU8 u8HiSpeedPress)
{
    tU32 clockValue;
#if 0
//Initialization of clock module
    if(u8UsbClkOn == 1)
    {
        //use REFO for FLL and ACLK
        UCSCTL3 = (UCSCTL3 & ~(SELREF_7)) | (SELREF__REFOCLK);
        UCSCTL4 = (UCSCTL4 & ~(SELA_7)) | (SELA__REFOCLK);      
        XT2_Start(XT2DRIVE_0);          //constant USB_MCLK_FREQ, Start the "USB crystal"
    }
    else
    {
        UCS_setExternalClockSource(
            __MSP430_BASEADDRESS_UCS__,
            UCS_XT1_CRYSTAL_FREQUENCY,
            0);

        PMM_setVCore(
            __MSP430_BASEADDRESS_PMM__,
            PMMCOREV_1);   // reference page 137 in user manual

        UCS_LFXT1Start(
            __MSP430_BASEADDRESS_UCS__,
            UCS_XT1_DRIVE0, //UCS_XT1_DRIVE0 was DRIVE3,
            UCS_XCAP_0);    //Was _3
    }
    
    if(u8HiSpeedPress == 1)
    {
        SetVCore(3);              // was 1
        // Disable oscillator fault before configuring FLL because of DCOFFG
        SFRIE1 &= ~OFIE;
        // Set system clock to max (25MHz)
        //UCS_initFLLSettle(__MSP430_BASEADDRESS_UCS__,
        // 1MHz  -> 1000,  31
        // 4MHz  -> 4000,  122
        // 8MHz  -> 8000,  244
        // 12MHz -> 12000, 366
        // 16MHz -> 16000, 488
        // 20MHz -> 20000, 610
        // 25MHz -> 25000, 762  
        Init_FLL_Settle(16000, 488); //(8000, 244); //(16000, 488)
        SFRIFG1 = 0;
        SFRIE1 |= OFIE;
    }
    else
    {
        //disable oscillator fault before configuring FLL because of DCOFFG
        SFRIE1 &= ~OFIE;
        Init_FLL_Settle(8000, 244);    //was -> (1000,  31), it works at 1MHz
        SFRIFG1 = 0;
        SFRIE1 |= OFIE;      
    }
#else
    PMM_setVCore(PMM_BASE, PMM_CORE_LEVEL_2);

    initClocks(8000000);   // Config clocks. MCLK=SMCLK=FLL=8MHz; ACLK=REFO=32kHz
//    USB_setup(TRUE,TRUE);  // Init USB; if a USB host (PC) is present, connect
#endif
    //SVS Low side is turned off
    PMM_disableSvsL(__MSP430_BASEADDRESS_PMM__);

    //Monitor low side is turned off
    PMM_disableSvmL(__MSP430_BASEADDRESS_PMM__);

    //Monitor high side is turned off
    PMM_disableSvmH(__MSP430_BASEADDRESS_PMM__);

    //SVS High side is turned on
    PMM_enableSvsH(__MSP430_BASEADDRESS_PMM__);

    //Enable POR on SVS Event
    PMM_enableSvsHReset(__MSP430_BASEADDRESS_PMM__);

    //SVS high side Full perf mode,
    PMM_SvsHEnabledInLPMFullPerf(__MSP430_BASEADDRESS_PMM__);

    //stays on in LPM3,enhanced protect
    //Wait until high side, low side settled
    while ( 0 == PMM_getInterruptStatus(__MSP430_BASEADDRESS_PMM__,
              SVSMLDLYIFG + SVSMHDLYIFG )
          ) ;

    PMM_clearPMMIFGS(__MSP430_BASEADDRESS_PMM__);

    // SMCLK is enabled, even in LPM3. so that USCI has workable clock source.
    UCS_SMCLKOn(__MSP430_BASEADDRESS_UCS__);

    UCS_enableClockRequest(
        __MSP430_BASEADDRESS_UCS__,
        UCS_SMCLK);

    //Verify if the Clock settings are as expected
    clockValue = UCS_getMCLK(__MSP430_BASEADDRESS_UCS__);
    clockValue = clockValue + 1;
    clockValue = UCS_getACLK(__MSP430_BASEADDRESS_UCS__);
    clockValue = clockValue + 1;
    clockValue = UCS_getSMCLK(__MSP430_BASEADDRESS_UCS__);
    clockValue++;  // for look the get clock value set break poin here
}

void fbPortInit(void)
{
    //=================Port 1 init=============================================
    GPIO_setAsInputPin(
        __MSP430_BASEADDRESS_PORT1_R__,
        GPIO_PORT_P1,
        MSP_CS_ALL_PINS);

    GPIO_setOutputLowOnPin(
        __MSP430_BASEADDRESS_PORT1_R__,
        GPIO_PORT_P1,
        P1_7_NOT_USED_OUT);

    GPIO_setAsOutputPin(
        __MSP430_BASEADDRESS_PORT1_R__,
        GPIO_PORT_P1,
        P1_7_NOT_USED_OUT);

    GPIO_disbleInterrupt (
        __MSP430_BASEADDRESS_PORT1_R__,
        GPIO_PORT_P1,
        MSP_CS_ALL_PINS);

    GPIO_clearInterruptFlag (
        __MSP430_BASEADDRESS_PORT1_R__,
        GPIO_PORT_P1,
        MSP_CS_ALL_PINS);

    GPIO_interruptEdgeSelect (
        __MSP430_BASEADDRESS_PORT1_R__,
        GPIO_PORT_P1,
        MSP_CS_ALL_PINS,
        GPIO_LOW_TO_HIGH_TRANSITION);

    GPIO_enableInterrupt(
        __MSP430_BASEADDRESS_PORT1_R__,
        GPIO_PORT_P1,
        MSP_CS_ALL_PINS);

    GPIO_setAsInputPinWithPullDownresistor(
        __MSP430_BASEADDRESS_PORT1_R__,
        GPIO_PORT_P1,
        P1_4_5438A_ACK_FLASH_REQ_IN);
    
    GPIO_disbleInterrupt (
        __MSP430_BASEADDRESS_PORT1_R__,
        GPIO_PORT_P1,
        P1_7_NOT_USED_OUT);

    //=================Port 2 init=============================================
    GPIO_setAsInputPinWithPullUpresistor(
        __MSP430_BASEADDRESS_PORT2_R__,
        GPIO_PORT_P2,
        P2_6_RADIO_CD_NI);

    GPIO_setOutputLowOnPin(
        __MSP430_BASEADDRESS_PORT2_R__,
        GPIO_PORT_P2,
        P2_OUT_LOW);

    GPIO_setAsOutputPin(
        __MSP430_BASEADDRESS_PORT2_R__,
        GPIO_PORT_P2,
        P2_OUT_LOW);

    GPIO_setAsInputPinWithPullUpresistor (
        __MSP430_BASEADDRESS_PORT2_R__,
        GPIO_PORT_P2,
        PT2_INPUT_PULLUP);

    GPIO_setAsPeripheralModuleFunctionInputPin(
        __MSP430_BASEADDRESS_PORT2_R__,
        GPIO_PORT_P2,
        PT2_FUNC_INPUT);

    GPIO_setAsPeripheralModuleFunctionOutputPin(
        __MSP430_BASEADDRESS_PORT2_R__,
        GPIO_PORT_P2,
        PT2_FUNC_OUTPUT);

    //=================Port 3 init=============================================
    GPIO_setAsInputPinWithPullUpresistor (
        __MSP430_BASEADDRESS_PORT3_R__,
        GPIO_PORT_P3,
        P3IN_PULLUP);

    GPIO_setOutputLowOnPin(
        __MSP430_BASEADDRESS_PORT3_R__,
        GPIO_PORT_P3,
        P3OUT_PINS);

    GPIO_setAsOutputPin(
        __MSP430_BASEADDRESS_PORT3_R__,
        GPIO_PORT_P3,
        P3OUT_PINS);

   GPIO_setAsPeripheralModuleFunctionInputPin(
        __MSP430_BASEADDRESS_PORT3_R__,
        GPIO_PORT_P3,
        P3_FUNC_IN_PINS);

    // for run and debug pin output
    GPIO_setOutputLowOnPin(
        __MSP430_BASEADDRESS_PORT3_R__,
        GPIO_PORT_P3,
        P3_4_SMCLK_DEBUG);

     GPIO_setAsOutputPin(
        __MSP430_BASEADDRESS_PORT3_R__,
        GPIO_PORT_P3,
        P3_4_SMCLK_DEBUG);    

    //=================Port 4 init=============================================
    GPIO_setOutputLowOnPin(
        __MSP430_BASEADDRESS_PORT4_R__,
        GPIO_PORT_P4,
        P4OUT_PINS);

    GPIO_setAsOutputPin(
        __MSP430_BASEADDRESS_PORT4_R__,
        GPIO_PORT_P4,
        P4OUT_PINS);

    GPIO_setAsInputPin(
        __MSP430_BASEADDRESS_PORT4_R__,
        GPIO_PORT_P4,
        P4IN_PINS);

    //=================Port 5 init=============================================
    GPIO_setAsPeripheralModuleFunctionInputPin(
        __MSP430_BASEADDRESS_PORT5_R__,
        GPIO_PORT_P5,
        P5_1_ADC_REF_MINUS_FUNC + P5_0_ADC_REF_PLUSE_FUNC);

    GPIO_setOutputLowOnPin(
        __MSP430_BASEADDRESS_PORT5_R__,
        GPIO_PORT_P5,
        P5OUT_PINS);

    GPIO_setAsOutputPin(
        __MSP430_BASEADDRESS_PORT5_R__,
        GPIO_PORT_P5,
        P5OUT_PINS);

    //=================Port 6 init=============================================
    GPIO_setOutputLowOnPin(
        __MSP430_BASEADDRESS_PORT6_R__,
        GPIO_PORT_P6,
        P6OUT_PINS_LOW);

    GPIO_setOutputHighOnPin(
        __MSP430_BASEADDRESS_PORT6_R__,
        GPIO_PORT_P6,
        P6OUT_PINS_HIGH);

    GPIO_setAsOutputPin(
        __MSP430_BASEADDRESS_PORT6_R__,
        GPIO_PORT_P6,
        P6OUT_PINS_LOW + P6OUT_PINS_HIGH);

    GPIO_setAsPeripheralModuleFunctionInputPin(
        __MSP430_BASEADDRESS_PORT6_R__,
        GPIO_PORT_P6,
        P6_FUNC_IN);

    // for run and debug pin output
    GPIO_setOutputLowOnPin(
        __MSP430_BASEADDRESS_PORT6_R__,
        GPIO_PORT_P6,
        P6_2_ACLK_DEBUG);

    GPIO_setAsOutputPin(
        __MSP430_BASEADDRESS_PORT6_R__,
        GPIO_PORT_P6,
        P6_2_ACLK_DEBUG);    

    //=================Port 7 init=============================================
    GPIO_setOutputLowOnPin(
        __MSP430_BASEADDRESS_PORT7_R__,
        GPIO_PORT_P7,
        P7OUT_PINS_LOW +BIT0+BIT1);

    GPIO_setOutputHighOnPin(
        __MSP430_BASEADDRESS_PORT7_R__,
        GPIO_PORT_P7,
        P7_4_EN_HS_AI_OUT);

    GPIO_setAsOutputPin(
        __MSP430_BASEADDRESS_PORT7_R__,
        GPIO_PORT_P7,
        P7OUT_PINS_LOW+BIT0+BIT1+P7_4_EN_HS_AI_OUT);

    GPIO_setAsPeripheralModuleFunctionInputPin(
        __MSP430_BASEADDRESS_PORT7_R__,
        GPIO_PORT_P7,
        BIT2 + P7_5_A13_VCM_IN);
    
    GPIO_setAsPeripheralModuleFunctionOutputPin(
        __MSP430_BASEADDRESS_PORT7_R__,
        GPIO_PORT_P7,
        BIT3);

    //=================Port 8 init=============================================
    GPIO_setAsInputPinWithPullUpresistor (
        __MSP430_BASEADDRESS_PORT8_R__,
        GPIO_PORT_P8,
        P8IN_PULLUP);

    GPIO_setOutputLowOnPin(
        __MSP430_BASEADDRESS_PORT8_R__,
        GPIO_PORT_P8,
        P8OUT_PINS_LOW);

    GPIO_setOutputHighOnPin(
        __MSP430_BASEADDRESS_PORT8_R__,
        GPIO_PORT_P8,
        P8_7_LCD_PWR_OUT);

    GPIO_setAsOutputPin(
        __MSP430_BASEADDRESS_PORT8_R__,
        GPIO_PORT_P8,
        P8OUT_PINS_LOW + P8_7_LCD_PWR_OUT);

    // init port for LCD control
    GPIO_setAsPeripheralModuleFunctionOutputPin(
        __MSP430_BASEADDRESS_PORT8_R__,
        GPIO_PORT_P8,
        P8OUT_FUNC);
#if 0
    GPIO_setDriveStrength(
        __MSP430_BASEADDRESS_PORT8_R__,
        GPIO_PORT_P8,
        P8_3_UCA1_SPI_RAM_SOMI_FUNC,
        GPIO_FULL_OUTPUT_DRIVE_STRENGTH);
#endif
    //=================Port 9 init=============================================
    GPIO_setAsInputPin(
        __MSP430_BASEADDRESS_PORT9_R__,
        GPIO_PORT_P9,
        MSP_CS_ALL_PINS);
    
    //=================Port JTAG init=============================================
    // do not set JTAG to output Low state, 
    // it damages the board
    // keep JTAG as default state
}

static void I2CReinit(void)
{
    I2C_masterInit(__MSP430_BASEADDRESS_USCI_B1__,
        I2C_CLOCKSOURCE_SMCLK,
        UCS_getSMCLK(__MSP430_BASEADDRESS_UCS__),
        I2C_SET_DATA_RATE_400KBPS); 
    
    //Specify slave address
    I2C_setSlaveAddress(__MSP430_BASEADDRESS_USCI_B1__,
        IIC_SLAVE_ADRS);

    //Set Transmit mode
    I2C_setMode(__MSP430_BASEADDRESS_USCI_B1__,
        I2C_TRANSMIT_MODE);

    //Enable I2C Module to start operations
    I2C_enable(__MSP430_BASEADDRESS_USCI_B1__);

    // display not connected, no need process next message
    I2C_enableInterrupt(__MSP430_BASEADDRESS_USCI_B1__,
        I2C_NAK_INTERRUPT);
}


void fbFuncPortInit(void)
{
    //=================Port 1 init=============================================
    // all pin are input

    //=================Port 2 init=============================================
    // Radio USCI_A0 UART init, 9600 default,
    // no parity, 8 bits data, LSB bit Tx first, one stop bit, UART mode, Asynch Mode
    if (STATUS_FAIL == UART_init(__MSP430_BASEADDRESS_USCI_A0__,
             UART_CLOCKSOURCE_ACLK, //UART_CLOCKSOURCE_SMCLK,
             UCS_getACLK(__MSP430_BASEADDRESS_UCS__),
             BAUD_RATE,
             UART_NO_PARITY,
             UART_LSB_FIRST, //UART_LSB_FIRST, UART_MSB_FIRST, // tx, in the Byte, LSB first
             UART_ONE_STOP_BIT,
             /*UART_AUTOMATIC_BAUDRATE_DETECTION_MODE,*/ UART_MODE,
             UART_LOW_FREQUENCY_BAUDRATE_GENERATION ))
    {
        // set status bit, TDB, can not communicate on Radio port
        // loop here foreve to fix problem, FIXME
      __no_operation();  // debug, set break point here

    }

    //Enable UART module for operation
    UART_enable(__MSP430_BASEADDRESS_USCI_A0__);

    //Disable Rx Interrupt, Radio only Tx message
    // note: interrutp cannot enable, if enable the LCD resets
    UART_disableInterrupt(__MSP430_BASEADDRESS_USCI_A0__,
        UART_RECEIVE_INTERRUPT); //UART_disableInterrupt

    __no_operation();  // debug, set break point here

    //=================Port 3 init=============================================
    //=================Port 4 init=============================================
    //=================Port 5 init=============================================
    //=================Port 6 init=============================================
    //=================Port 7 init=============================================
    //=================Port 8 init=============================================
    //Initialize Master
    I2CReinit();

    //=================Port 9 init=============================================
    // get this MSP430 die information
}

//==============================================================================
//
// FUNCTION:        initMspAdc
//
// DESCRIPTION:     copied from ti\msp430ware_xx_xx\example\driverlib\asc12.
//                  file adc12_ex4_repeatedSeq.c
//  ADC12 - Sample A0-1,10,11 Input, AVcc = Ref, Repeated Sequence of Conversions
//
//  It repeats sequence of conversions using "repeat sequence-of-channels" mode.
//  AVcc is used for the reference and repeated sequence of conversions is
//  performed on Channels A0, A1, A10, and A11. Each conversion result is
//  stored in ADC12MEM0, ADC12MEM1, ADC12MEM2, and ADC12MEM3 respectively.
//  After each sequence, the 4 conversion results. Test by applying voltages to
//  channels A0 - A1. Open a watch window in debugger and view the results.
//  Set Breakpoint1 in the index increment line to see the array values change
//  sequentially and Breakpoint2 to see the entire array of conversion results
//
//  Note that a sequence has no restrictions on which channels are converted.
//  For example, a valid sequence could be A0, A3, A2, A4, A2, A1, A0, and A7.
//  See the MSP430x5xx User's Guide for instructions on using the ADC12.
//
//                MSP430F552x
//             -----------------
//         /|\|                 |
//          | |          P6.0/A0|<- Vin0
//          --|RST       P6.1/A1|<- Vin1
//            |          P6.2/A2|    // A2memory save the MSP temperature
//            |          P6.3/A3|    // A3memory save the MSP battery V
//            |                 |Vref is Vcc in all cases
//
//
//
// The following interrupt handlers used.
// - ADC12_VECTOR
//
//==============================================================================
void initMspAdc(void)
{
    //Initialize the ADC12 Module
    //  Base address of ADC12 Module
    //  Use internal ADC12 bit as sample/hold signal to start conversion
    //  USE MODOSC 5MHZ Digital Oscillator as clock source
    //  Use default clock divider of 1
    ADC12_init(__MSP430_BASEADDRESS_ADC12_PLUS__,
        ADC12_SAMPLEHOLDSOURCE_SC,
        ADC12_CLOCKSOURCE_ADC12OSC,
        ADC12_CLOCKDIVIDER_1);

    ADC12_enable(__MSP430_BASEADDRESS_ADC12_PLUS__);

    //  Base address of ADC12 Module
    //  For memory buffers 0-7 sample/hold for 256 clock cycles
    //  For memory buffers 8-15 sample/hold for 4 clock cycles (default)
    //  Enable Multiple Sampling
    // only ADC12_CYCLEHOLD_32_CYCLES, temperature data close to the result
    // without read calibration data
    ADC12_setupSamplingTimer(__MSP430_BASEADDRESS_ADC12_PLUS__,
        ADC12_CYCLEHOLD_256_CYCLES, 
        ADC12_CYCLEHOLD_4_CYCLES,
        ADC12_MULTIPLESAMPLESENABLE); 

    // MSP430F5638 connects
    // A0 = MSP temperature
    // A1 = Solar Voltage   = SP_VOLTS    = memory 2
    // A3 = Battery voltage = BAT_VOLTS   = memory 3
    // A7 = High Speed AI   = HS_AI       = memory 4
    // A13 = VCM                          = memory 1
    // ATemp = msp temerpatuer = MspTempC = memory 0
    ADC12_memoryConfigure(__MSP430_BASEADDRESS_ADC12_PLUS__,
        ADC12_MEMORY_0,
        ADC12_INPUT_TEMPSENSOR, 
        //ADC12_VREFPOS_AVCC, //ADC12_VREFPOS_AVCC, ADC12_VREFPOS_EXT,
        ADC12_VREFPOS_INT, //ADC12_VREFPOS_AVCC, ADC12_VREFPOS_EXT,   RTG: Jan16
        ADC12_VREFNEG_AVSS, //ADC12_VREFNEG_AVSS, ADC12_VREFNEG_EXT,
        ADC12_NOTENDOFSEQUENCE);

    ADC12_memoryConfigure(__MSP430_BASEADDRESS_ADC12_PLUS__,
        ADC12_MEMORY_1,
        ADC12_INPUT_A12,    // change to coin_cell battery volts //VCM
        ADC12_VREFPOS_AVCC, //ADC12_VREFPOS_AVCC, ADC12_VREFPOS_EXT,
        ADC12_VREFNEG_AVSS, //ADC12_VREFNEG_AVSS, ADC12_VREFNEG_EXT,
        ADC12_NOTENDOFSEQUENCE);

    ADC12_memoryConfigure(__MSP430_BASEADDRESS_ADC12_PLUS__,
        ADC12_MEMORY_2,
        ADC12_INPUT_A1,     // solar power volts
        ADC12_VREFPOS_AVCC, //ADC12_VREFPOS_AVCC, ADC12_VREFPOS_EXT,
        ADC12_VREFNEG_AVSS, //ADC12_VREFNEG_AVSS, ADC12_VREFNEG_EXT,
        ADC12_NOTENDOFSEQUENCE);

    ADC12_memoryConfigure(__MSP430_BASEADDRESS_ADC12_PLUS__,
        ADC12_MEMORY_3,
        ADC12_INPUT_A3,     // battery volt
        ADC12_VREFPOS_AVCC, //ADC12_VREFPOS_AVCC, ADC12_VREFPOS_EXT,
        ADC12_VREFNEG_AVSS, //ADC12_VREFNEG_AVSS, ADC12_VREFNEG_EXT,
        ADC12_NOTENDOFSEQUENCE);

    ADC12_memoryConfigure(__MSP430_BASEADDRESS_ADC12_PLUS__,
        ADC12_MEMORY_4,
        ADC12_INPUT_A7,     //HS_AI
        ADC12_VREFPOS_AVCC, //ADC12_VREFPOS_AVCC, ADC12_VREFPOS_EXT,
        ADC12_VREFNEG_AVSS, //ADC12_VREFNEG_AVSS, ADC12_VREFNEG_EXT,
        ADC12_ENDOFSEQUENCE);

    //Enable memory buffer 4 interrupt
    ADC12_enableInterrupt(__MSP430_BASEADDRESS_ADC12_PLUS__,
        ADC12IE4);  
    
    waste_time(30);   // make 2st ADC right
    
    //**************start for temperatuer conversion must have***************
    //Configure internal reference
    //If ref generator busy, WAIT
    while ( REF_ACTIVE == REF_isRefGenBusy(__MSP430_BASEADDRESS_REF__) ) ;
    //Select internal ref = 1.5V
    REF_setReferenceVoltage(__MSP430_BASEADDRESS_REF__,
        REF_VREF1_5V);
    //Internal Reference ON
    REF_enableReferenceVoltage(__MSP430_BASEADDRESS_REF__);
    //**************end for temperatuer conversion must have***************
    //Delay (~75us) for Ref to settle
    __delay_cycles(75);

    // init offset, when it write flash read from flash
    //initCalOffset();
}

Calendar lastSec;
void iniItsRtcTime(void)
{
  currentTime.Seconds    = 0x01;
  currentTime.Minutes    = 0x01;
  currentTime.Hours      = 0x01;
  currentTime.DayOfWeek  = 0x01;
  currentTime.DayOfMonth = 0x25;
  currentTime.Month      = 0x04;
  currentTime.Year       = 0x2016;  
}
void enableRtcTime(void)
{
  RTC_holdClock(__MSP430_BASEADDRESS_RTC__);

  // Initialize Calendar Mode of RTC
  // Base Address of the RTC_A
  // Pass in current time, intialized above
  // Use BCD as Calendar Register Format
  RTC_calendarInit(
      __MSP430_BASEADDRESS_RTC__,
      currentTime,
      RTC_FORMAT_BCD);
  // clear all interrupts
  RTC_clearInterrupt (
      __MSP430_BASEADDRESS_RTC__,
      (RTC_TIME_EVENT_INTERRUPT + 
       RTC_CLOCK_ALARM_INTERRUPT +
       RTC_CLOCK_READ_READY_INTERRUPT +
       RTC_PRESCALE_TIMER0_INTERRUPT +
       RTC_PRESCALE_TIMER1_INTERRUPT));  
          
  //Enable interrupt for RTC Ready Status, which asserts when the RTC
  //Calendar registers are ready to read.
  RTC_enableInterrupt(
      __MSP430_BASEADDRESS_RTC__,
      RTCRDYIE + RTCAIE);  //RTCRDYIE + RTCTEVIE + RTCAIE);

  //Start RTC Clock
  RTC_startClock(__MSP430_BASEADDRESS_RTC__);
  lastSec = RTC_getCalendarTime(__MSP430_BASEADDRESS_RTC__);
}

void sendJ6RtcToJ4(void)
{
  lastSec = RTC_getCalendarTime(__MSP430_BASEADDRESS_RTC__);
  currentTime.Seconds    = lastSec.Seconds;
  currentTime.Minutes    = lastSec.Minutes;
  currentTime.Hours      = lastSec.Hours;
  currentTime.DayOfWeek  = lastSec.DayOfWeek;
  currentTime.DayOfMonth = lastSec.DayOfMonth;
  currentTime.Month      = lastSec.Month;
  currentTime.Year       = lastSec.Year;
  addOneTypeExchg(TYPE_CHART_MSP_RTC);  // 5638 send RTC to 5438A 
}

tU8 setCalRtcResult(ACCESS_VER_INFO *rwVarInfo)
{
  union {
    tU8  u8ToU8[2];
    tU16 u16Data;
  }formatU16;
  
  formatU16.u16Data = *((tU16 *)rwVarInfo->eepVarAddr);

  if((formatU16.u8ToU8[0] & BIT7) == BIT7)
  {
    //adjusted up
    formatU16.u8ToU8[0] &= ~BIT7;
    
    RTC_setCalibrationData(
         __MSP430_BASEADDRESS_RTC__,
         RTC_CALIBRATION_UP4PPM,
         formatU16.u8ToU8[0]);
  }
  else
  {
    //adjusted down
    RTC_setCalibrationData(
           __MSP430_BASEADDRESS_RTC__,
           RTC_CALIBRATION_DOWN2PPM,
           formatU16.u8ToU8[0]);      
  }

  GPIO_setOutputLowOnPin(
        __MSP430_BASEADDRESS_PORT6_R__,
        GPIO_PORT_P6,
        P6_2_ACLK_DEBUG);

  GPIO_setAsOutputPin(
        __MSP430_BASEADDRESS_PORT6_R__,
        GPIO_PORT_P6,
        P6_2_ACLK_DEBUG);    
   
  return rwVarInfo->u8RspBufPtr; 
}

//=============================================================================
// end file by xuedong
//=============================================================================
