//=============================================================================
// Header: Join Technology Instrument Multivaribale transmitter firmware Main.
// Date Time: 1/15/2013 11:00 AM
// Author: Xuedong.Liu
//
// Description: This is JT808 firmware start point or Main. JT808 firmware supports
//     MSP430F5438A processor. The code develop, debug, and build from IRA tool
//     revision 5.51.1
//
//   1.Constant definitions are most in h file
//   2.Type definitions are most in h file
//   3.Global variables defined in main.c other c file use externGlobalVar.h
//   4.Changes only make when nessaery for the function.  no spelling check, etc.
//   5.Protocol layer up, the code are good on MSP430F4538A and MSP430F5638.
//   6.MODBUS protocol supports RTU mode, not support ASCII mode etc.
//   7.MSP430F5438A is in LPM3 most time,
//      CPU, MCLK are disabled.
//      ACLK is active. SMCLK is enabled (add UCS_SMCLKOn, UCS_enableClockRequest)
//      DCO is enabled, its sources is ACLK.
//      FLL is disabled.
//      in LPM3 -> This MSP430 current max at 85C is 13 to 14uA
//      in running mode -> this MSP430 current at 85C is 800uA
//   8.All comm ports on this MSP are half duplex, one buffere for two
//      direction -> Rx, and Tx, transmitter is slave device, Rx 1st than Tx
//   9. each c file may has following section
//         a) constant definitions, type definitions
//         b) global volatile variables
//         c) local static variables
//         d) global function prototypes definitions, interrupt func as global
//         e) local static function prototypes definitions
//         f) global function implementation, interrupt service as global
//         g) local static function implementation
//         h) c file end with "end file by xuedong", h file end with "#endif"
//  10. do not seperate BSAP or Modbus or any other protocol address, change to
//      trasnmitter address, it is one, if it changes, all protocol address changes
//      there is a exception for HART.  HART use different method to assgen short
//      address.
//  11. MSP430F5638 has 6 DMA channel, channel = 0, 1, 2 used for USB,
//      channel = 3 for LCD Tx,
//      channel = 4 for Radio Tx
//=============================================================================
#include "masterHeader.h"
#include "externFunc.h"
#pragma pack(1)

// global variables
ramData sysRamData;
ram5638Data sysRam56D;
INFOA_STRUC infoA;
INFOB_STRUC infoB;
INFOC_STRUC infoC;
INFOD_STRUC infoD;
INFO56A_STRUC info5638A;
INFO56B_STRUC info5638B;
INFO56C_STRUC info5638C;
INFO56D_STRUC info5638D;  // D is free 
__MFG_SET__ sysBuf;
tU16  u8UserLcdLab[9][4];
tU16  u8UserLcdUnit[9][3];

// debug trace
tU8 u8DebugTrace[TRACE_BUFFER_SIZE], TracePtr;

// following are not pass in from build script
// build info for prom
const FWVersionInfor BuildFwInfo @ "BuildFwInfo" =
{
  BUILDDAY,
  BUILDMNTH,
  BUILDYEARH,
  BUILDYEARL,
  {"J6M"},
  BUILDMAJOR,
  BUILDMINOR,
  BUILDBETA,
  JTI_PRODUCT_ID,
  0,
};

//__no_init FLASH_SECTION sectionInfor @ "FLASH_SPI_CS";

// half duplex, one buffere forv two direction -> RX, and TX
tU8 u8CommInbuf[EMV_NUM_COMM][RX_BUF_SIZE],     // interrupt input buffer
    u8MDRxTxTempBuf[EMV_NUM_COMM][MAX_MSG_SIZE],          // Modbus RTU mode hex char buff
    u8BASPRxTxTempBuf[EMV_NUM_COMM][MAX_MSG_SIZE];        // BASP hex char buff
    //u8HARTRxTxTempBuf[EMV_NUM_COMM][MAX_MSG_SIZE];        // HAART hex char buff

// task scheduler
tU8 u8UsedPort[TOTAL_FLAGE_ARRAY],            // bit0 = 1 USB MSP430F5438A, bit3 = 1 USB MSP430F5638
    u8Layer2TaskScheduler,                    // process flag, these flag happen in timer interval
    u8Layer1TaskScheduler,                    // interface flag, need interface to do the work when flag is set
    u8OtherTaskScheduler,                     // interface flag, communication has complete request, or process need data is ready
    u8DoDiagErrorProcess;                     // interface flag, timer related, start timer or timeout flags;
tU8 u8MdReplyAddress;

tU16 u16FlashTest,
     u16FlashTestStop;

tF32 f3FskActualRtsDelay;   
tF32 f32StackEndVal;

tReturnStatus EraseStatus;
MSG_CRC16 flashSecInfoCrc;                      // write firmware to flash and end to calculate CRC for information block and save in flash for read

const COMM_DAM_TX commTxDma[EMV_NUM_COMM] =
{
  // for MSP430F5438A
  {USB_PORTID, 0, initDmaTxCtrl},    // portIn = USB,  in MSP430F5638
  {USB_PORTID, 0, initDmaTxCtrl},    // portIn = RADIO, only Tx, not use in here
  {USB_PORTID, 0, initDmaTxCtrl},    // portIn = Free  in MSP430F5638
};

// for LCD display
tU8 I2cStateReg;
tU8 u8FlashStatus;   // W25Q80 status

tU8 u8NumTimeInt;
// the last char is not support, should display default char '*'
const tU8 u8LcdChar[EMV_NUM_CHARS] =
{
  'A','B','C','D','E','F','G','H','I','J',
  'K','L','M','N','O','P','Q','R','S','T',
  'U','V','W','X','Y','Z','0','1','2','3',
  '4','5','6','7','8','9',' ','/','%','-',
  '*','a',
};
// the last char is not support, should display default numerical ' '
const tU8 u8LcdNum[EMV_NUM_NUMERICAL] =
{
  '0','1','2','3','4','5','6','7','8','9',
  '-','E',' ','A',
};
const tU8 u8MonthChar[NUMBER_MONTH_ANNUAL][EACH_MONTH_CHARS] =
{
  " JAN ",
  " FEB ",
  "MARCH",
  "APRIL",
  " MAY ",
  " JUNE",
  " JULY",
  " AUG ",
  " SEPT",
  " OCT ",
  " NOV ",
  " DEC ",
};

WirelessEnv WLPro;

// for MSP430F5438A internal ADC converter
tU16 u16MspAdcCnt[6];

// BASP define
tU8 bEBaspOn, bBaspGlobalOn, u8BaspHeaderCnt;

// for chart replacement
tU8 u8WtPreRecordBytes[A_RECORD_LENGTH];   // max length of bytes for once record, if it is 4 PVs is MAX
tU8 u8M6toM4Temp[64];
Calendar currentTime;
Calendar recordIntervalTime;
CHART_PROCESS_STRUC chartRecEnv;
CHART_A_RECORD showCurrent, curentRecord, showDaily, dailyRecord;
tU16  u16PassOverChartEnvt;

// for radio
//RADIO_ENV_STRUC RadioProcEnv;
WirelessApiStruc  WirelessApiMsg;

// static variables
// NA

// function prototypes definitions:
void main(void);
// for copy to other debug place          __no_operation();
//==============================================================================
//
// FUNCTION:        main
//
// DESCRIPTION:     Firmware starts execution from main.  tranmitter Power up,
//                  reset MSP, or when command "run user application" from
//                  the field upgrade frimware BootLoader, the control set to here.
//
//==============================================================================
#pragma location="START"
void main(void)
{
  __disable_interrupt();
  WDTCTL = WDTPW+WDTHOLD;      // Stop watchdog timer
  sysRamData.diag.u16XmtStatus[4] = SYS_NORMAL_START;
  while(BAKCTL & LOCKIO) // Unlock XT1 pins for operation 
  {
    BAKCTL &= ~(LOCKIO); 
  }
    
  useFeatureBoard();
}

void  waste_time(tU16 count)
{ 
  tU16 i;

  for (i = 0; i < count; i++)
  {
    __no_operation();
    __no_operation();
    __no_operation();      // after init USB add in 
    __no_operation();      // after init USB add in 
    __no_operation();      // after init USB add in 
    __no_operation();      // after init USB add in 
    __no_operation();      // after init USB add in 
    __no_operation();      // after init USB add in 
    __no_operation();      // after init USB add in 
    __no_operation();      // after init USB add in 
  }
}
// when code is at 8MHz clcok:
//  tU16 i;
//  for (i = 0; i < count; i++)
//  {
//    __no_operation();
//    __no_operation();
//  }
// count vs delay time        after USB init add in
// count  delay 
//  6      9.600 uSec         7.860  uSec
//  7     10.600 uSec
//  8     11.600 usec
//  9     12.600
// 10     13.600              11.8  uSec
// 20     23.600
// 30     33.600              31.8  uSec
// 40     43.600
// 50     53.600
// 100    103.00              102
// 200    204.00
// 800    802.00              800  uSec
// 1000                       1000 uSec
// 3000  3.010   mSeconds     3    mSec
// 25000 25.04   mSeconds
// 60000 60.00   mSeconds    59.90 mSec

//=============================================================================
// end file by xuedong
//=============================================================================

