//=============================================================================
// process firmware field update command, called from processModbusMsg
//         or processBaspCmd or processHartCmd when they are supported
// Date Time: 1/20/2013 1:59:34 AM
// Author: Xuedong.Liu
//
// Description: This is JT808 field updte firmware support. it is in application
//     flash. sync with host, process request and generates repsonse.
//
//==============================================================
//constant definitions, type definitions
#include "masterHeader.h"

//global volatile variables
#include "externGlobalVar.h"

//global function prototypes definitions
#include "externFunc.h"

// function prototype
tReturnStatus UpdateFwMain( BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr);
tReturnStatus FW_Dummy(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr);
tReturnStatus BslSyncAck(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr);
tReturnStatus compPassword(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr);
tReturnStatus sendUnitId(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr);
tReturnStatus startEraseFlash(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr);
tReturnStatus sendEraseNumBlk(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr);
tReturnStatus writeStartSection(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr);
tReturnStatus writeSecNextBlock(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr);
tReturnStatus writeEndFwFile(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr);
tReturnStatus sendSectionInfo(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr);
tReturnStatus progFlash2Msp(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr);
tReturnStatus notUseFwInFlash(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr);
tReturnStatus CopyFirstBlock2Ram(void);
void eraseMoreFlash(void);

void sendByte(char data);
void PI_sendData(tU8 *data, tS16 size);
tU32 nextBlockAdd;
tU32 fixFlashAdd;

const BSL_FUNC_PROCESS BslCmsFunc[] =
{
  {RX_DATA_BLOCK,       writeStartSection},  //0x10  CMD - 0x10 = 0x0 -> index -> BslCmsFunc[0]
  {RX_PASSWORD,         compPassword},       //0x11
  {ERASE_SEGMENT,       startEraseFlash},    //0x12
  {TOGGLE_INFO,         FW_Dummy},              //0x13  not implement
  {ERASE_BLOCK,         FW_Dummy},              //0x14  don't need
  {MASS_ERASE,          FW_Dummy},              //0x15  don't need
  {CRC_CHECK,           FW_Dummy},              //0x16  don't need
  {LOAD_PC,             FW_Dummy},              //0x17  don't need
  {TX_DATA_BLOCK,       FW_Dummy},              //0x18  don't need
  {TX_BSL_VERSION,      sendUnitId},         //0x19
  {TX_BUFFER_SIZE,      FW_Dummy},              //0x1A  not implement
  {RX_DATA_BLOCK_FAST,  FW_Dummy},              //0x1B  not implement
  {RX_NEXT_BLOCK,       writeSecNextBlock},  //0x1C
  {RX_END_FILE,         writeEndFwFile},     //0x1D
  {SPACE_ONE,           FW_Dummy},              //0x1E  anything can add in
  {BSL_TXSECTION_INFO,  sendSectionInfo},    //0x1F
  {FLASH_TO_MSP,        progFlash2Msp},      //0x20
  {CANCEL_FLASH_TO_MSP, notUseFwInFlash},    //0x21
  {ERASE_STATUS_CHECK,  sendEraseNumBlk},    //0x22
};

tU32 eraseSection,
     u32LastWriteAddress;
FLASH_SECTION sectionInfor;
EMV_PASSWORD emvFwPassword,
                    fwDefPw = {0xff, 0xff};
PRODUCT_ID emvProductId;
#if 0
//===============================
//  CRC modifier table.
//===============================
const tU8 u8crctbl[] =
{
#include "crctable.h"
};
tU16 u16BaspCCIT(tU8 *u8BuffPtr, tS16 s16Length, MSG_CRC16 *u16inCrc)
{
  tS16 i;                     // Counts down # characters in buffer, length = 1 do one byte
  tU8 *pBuffer = u8BuffPtr;   // Local copy of buffer pointer
  tU8 *pTbl;                  // Current character from modifier table

  // Initial CRC to starting value; then, look through all chars.
  u16inCrc->crc_l = ~u16inCrc->crc.byte[0];
  u16inCrc->crc_h = u16inCrc->crc.byte[1];
  // loop all chars
  for (i = s16Length; i > 0; i--)
  {
    // following line was pTbl = (tU8 *)&((tU16 *)u8crctbl)[(tU8)(*pBuffer++) ^ (tU8) crc.byte[0]];
    pTbl = (tU8 *)&((tU16 *)u8crctbl)[(tU8)(*pBuffer++) ^ (tU8)u16inCrc->crc_l];
    u16inCrc->crc_l = u16inCrc->crc_h  ^ (*pTbl++);
    u16inCrc->crc_h  = *pTbl;
  }
  //  Looping done, invert low byte, then,
  u16inCrc->crc_l = ~u16inCrc->crc_l;
  // load bytes into a word.
  u16inCrc->crc.byte[0] = u16inCrc->crc_l;
  u16inCrc->crc.byte[1] = u16inCrc->crc_h;
  // return current 16bits-crc
  return u16inCrc->crc.word;
} // u16BaspCCIT
#endif
/*******************************************************************************
*Function:    main
*Description: Initializes the BSL Command Interpreter and begins listening for
*             incoming packets
*******************************************************************************/
tReturnStatus UpdateFwMain(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr)
{
  tReturnStatus errCode = RS_good;
  tU8 indexfunc = cmdInPtr->u8CmdCode - RX_DATA_BLOCK;

  // init password for this board
  emvFwPassword.HwBoardId = infoD.xmt.u8HwRev;
  emvFwPassword.ProductCode = BuildFwInfo.u8ProductIDCode;

  // init product ID info, the host may ask them
  emvProductId.HwProdectCode.HwBoardId = infoD.xmt.u8HwRev;
  emvProductId.HwProdectCode.ProductCode = BuildFwInfo.u8ProductIDCode;
  emvProductId.FwMajorCode = BuildFwInfo.u8VerMajor;
  emvProductId.FwMinorCode = BuildFwInfo.u8VerMinor;
  emvProductId.FwBetaCode  = BuildFwInfo.u8VerBeta;

  // break out the CMD process, generate the repsone
  if (cmdInPtr->u8CmdCode == HOST_SYNC_CMD)  // normal sync
  {
    // this is host sync CMD process
    errCode = BslSyncAck(cmdInPtr, rspOutPtr);
  }
  else if (indexfunc > ERASE_STATUS_CHECK)
  {
    // error request
    errCode = BslSyncAck(cmdInPtr, rspOutPtr);
  }
  else
  {
    // The host other CMD process
    errCode = BslCmsFunc[indexfunc].BslFuncPtr(cmdInPtr, rspOutPtr);
  }
  return (errCode);
}

tReturnStatus FW_Dummy(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr)
{
  rspOutPtr->u8BslRspID      = BSL_MESSAGE_REPLY;
  rspOutPtr->u8BslRspCode    = UNKNOWN_COMMAND;
  rspOutPtr->u8BslRspLength  = BSL_RSP_MINI_SIZE;        // don't count CRC in Modbus Response, Meet with BSL Spec
  rspOutPtr->u8BslRspDataPtr = cmdInPtr->u8CmdDataPtr;
  return (RS_good);
}

tReturnStatus BslSyncAck(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr)
{
  tReturnStatus errCode       = RS_good;
  rspOutPtr->u8BslRspID       = BSL_MESSAGE_REPLY;
  rspOutPtr->u8BslRspCode     = BSL_SYNC_ACK;
  rspOutPtr->u8BslRspLength   = BSL_SYNC_RSP_SIZE;        // don't count CRC in Modbus Response, Meet with BSL Spec
  rspOutPtr->u8BslRspDataPtr  = cmdInPtr->u8CmdDataPtr;
  waste_time(100);
  return (errCode);
}

tReturnStatus sendUnitId(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr)
{
  tReturnStatus errCode      = RS_good;
  rspOutPtr->u8BslRspID      = BSL_MESSAGE_REPLY;
  rspOutPtr->u8BslRspCode    = EMV_ID_INFOR_FOLLOWS;
  rspOutPtr->u8BslRspLength  = EMV_ID_SIZE + BSL_RSP_MINI_SIZE;        // don't count CRC in Modbus Response, Meet with BSL Spec
  memmove(rspOutPtr->u8BslRspDataPtr,(tU8 *)&emvProductId, EMV_ID_SIZE);
  return (errCode);
}

tReturnStatus compPassword(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr)
{
  tReturnStatus errCode = BSL_PASSWORD_ERROR;
  tS16 CompResult[2];
  tU32 i, u32StopLoop = (cmdInPtr->u8CmdLength - 1);
  // compare with data field, -1 is remove 1 byte of the CMD code
  for (i = PASSWORD_START_AT; i < u32StopLoop;  i += PASSWORD_SIZE)
  {
    CompResult[0] = memcmp(cmdInPtr->u8CmdDataPtr, &emvFwPassword, PASSWORD_SIZE);
    CompResult[1] = memcmp(cmdInPtr->u8CmdDataPtr, &fwDefPw, PASSWORD_SIZE);
    // paswword match with this unit signature
    if ((CompResult[0] == PASSWORD_MATCH) || (CompResult[1]== PASSWORD_MATCH))
    {
      errCode = SUCCESSFUL_OPERATION;
//      BSL430_unlock_flash();
      break;
    }
    else
    {
      _NOP();
      LockedStatus = LOCKED;
      // point to next passwrod group
      cmdInPtr->u8CmdDataPtr += PASSWORD_SIZE;
    }
  }
  rspOutPtr->u8BslRspID      = BSL_MESSAGE_REPLY;
  rspOutPtr->u8BslRspCode    = errCode;
  rspOutPtr->u8BslRspLength  = BSL_RSP_MINI_SIZE;        // don't count CRC in Modbus Response, Meet with BSL Spec
  rspOutPtr->u8BslRspDataPtr = cmdInPtr->u8CmdDataPtr;
  return (errCode);
}

tReturnStatus startEraseFlash(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr)
{
    tReturnStatus errCode = CMD_FAILED;
    sectionInfor.newFwInStatus = NO_NEW_FW_STATUS;

    EraseStatus = CMD_FAILED;
#if 1
    // use MSP internal Flash
//    errCode = BSL430_openMemory();
    eraseSection = 0;
    if (errCode == SUCCESSFUL_OPERATION)
    {
//        errCode = BSL430_eraseSection(0, FIX_START_ADDR);   //internal flash, erase storage lower section
        eraseSection++;
    }
#else
    // use W25Q80 chip
    eraseSection = 0;
#endif
    rspOutPtr->u8BslRspID      = BSL_MESSAGE_REPLY;
    rspOutPtr->u8BslRspCode    = errCode;
    rspOutPtr->u8BslRspLength  = BSL_RSP_MINI_SIZE;        // don't count CRC in Modbus Response, Meet with BSL Spec
    rspOutPtr->u8BslRspDataPtr = cmdInPtr->u8CmdDataPtr;
    return (errCode);
}

void eraseMoreFlash(void)
{
    tReturnStatus errCode = RS_good;
    u8DoDiagErrorProcess &= (tU8)~ERASE_FLASH_CAN_START; // eraase another block can start

    if((eraseSection < FLASH_BLOCK_5438A) && (EraseStatus == ERASE_FLASH_DONE_ONESEC))
    {
        // eraseSection == 0 init makes timer work once.
        if (eraseSection != 0)
        {
#if 1
            // use MSP internal Flash
//            errCode = BSL430_openMemory();
            if (errCode == SUCCESSFUL_OPERATION)
            {
//                errCode =
//                  BSL430_eraseSection(0, SEC_INFO_STRAT);   //internal flash, erase storage lower section
                eraseSection++;
            }
#else
            // use W25Q80 chip
            eraseSection++;
#endif
            EraseStatus = errCode;
        }
    }
    else
    {
        u32LastWriteAddress = u8LastSecNum = u8MakeEvenAddr = 0;
        fixFlashAdd = nextBlockAdd = FIX_START_ADDR;
        sectionInfor.totalSection = 0xFF;
        memset(sectionInfor.sectionSize, 0x00000000, TOTAL_FLASH_SECTION);
        EraseStatus = EARSE_FLASH_DONE;
//        errCode = BSL430_closeMemory();
    }
}

tReturnStatus sendEraseNumBlk(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr)
{
  tReturnStatus errCode = RS_good;
  rspOutPtr->u8BslRspID      = BSL_MESSAGE_REPLY;
  rspOutPtr->u8BslRspCode    = EraseStatus;
  rspOutPtr->u8BslRspLength  = BSL_RSP_MINI_SIZE;           // don't count CRC in Modbus Response, Meet with BSL Spec
  rspOutPtr->u8BslRspDataPtr = cmdInPtr->u8CmdDataPtr;
  return (errCode);
}

__no_init tU8 u8DataToFlash[0xff] @ 0x3400;

tReturnStatus writeStartSection(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr)
{
  tU32 u32TempAddr[3];
  tReturnStatus errCode = CMD_FAILED;

//  errCode = BSL430_openMemory();
  if (errCode == SUCCESSFUL_OPERATION)
  {
    // keep lest section number
    u8LastSecNum = sectionInfor.totalSection;
    // update section information
    sectionInfor.totalSection++;
    // this assign designed for initial block and other block in same file
    fixFlashAdd = nextBlockAdd;

    u32TempAddr[0] = *cmdInPtr->u8CmdDataPtr;
    u32TempAddr[1] = *(cmdInPtr->u8CmdDataPtr + 1);
    u32TempAddr[2] = *(cmdInPtr->u8CmdDataPtr + 2);
    u32TempAddr[0] += (u32TempAddr[1] << 8) + (u32TempAddr[2] << 16);

    if (sectionInfor.totalSection >= 1)
    {
      // start section number is 0, more then one section need to see last section ending address
      if ((sectionInfor.sectionSize[u8LastSecNum]&0x00000001) != 0)
      {
        // last section ending address is odd, next section starts with even address, make modify
        u8MakeEvenAddr = 1;
      }
      else
      {
        // last section ending address is even, next section starts with even address, no need modify
        u8MakeEvenAddr = 0;
      }
      sectionInfor.evenModifier[sectionInfor.totalSection] = u8MakeEvenAddr;
    }

    if (u32LastWriteAddress != u32TempAddr[0])
    {
      // this block data has not write to flash, write to flash and do the check sum

      sectionInfor.sectionStartAddr[sectionInfor.totalSection] = u32TempAddr[0];

      // make next block address in this section
      nextBlockAdd += ((cmdInPtr->u8CmdLength - BSL_MODIFY_LENGH) + u8MakeEvenAddr);
      sectionInfor.sectionSize[sectionInfor.totalSection] =
          (cmdInPtr->u8CmdLength - BSL_MODIFY_LENGH);

      memmove(u8DataToFlash,
              cmdInPtr->u8CmdDataPtr + BSL_HEADER_BYTES, // data will write to flash, point to data, skip CMD & address
              cmdInPtr->u8CmdLength - BSL_MODIFY_LENGH); // number byts need to write

      // save data to flash, start address need to add the modifier, so that the start address is even
//     errCode = BSL430_writeMemory(fixFlashAdd + u8MakeEvenAddr,              // write address, internal flash is above 0x20000, external flash is 0
//                                   u8DataToFlash,
//                                   cmdInPtr->u8CmdLength - BSL_MODIFY_LENGH); // number byts need to write

      // remember we did write once, do not rewrite again
      u32LastWriteAddress = u32TempAddr[0];

      if (errCode == SUCCESSFUL_OPERATION)
      {
        // clculate section CRC without CMD & address, only data, save in section info
        sectionInfor.sectionCRC[sectionInfor.totalSection].crc.word = INITIAL_CRC_WORD;
        sectionInfor.sectionCRC[sectionInfor.totalSection].crc.word =
          u16BaspCCIT(cmdInPtr->u8CmdDataPtr + BSL_HEADER_BYTES, // exclude CMD and Address, include data
                      cmdInPtr->u8CmdLength - BSL_MODIFY_LENGH,
                      &sectionInfor.sectionCRC[sectionInfor.totalSection]);
      }
      // else date write error, process need restart
    }
    // else, data already write to flash don't rewrite and cal CRC again
  }
  rspOutPtr->u8BslRspID      = BSL_MESSAGE_REPLY;
  rspOutPtr->u8BslRspCode    = errCode;
  rspOutPtr->u8BslRspLength  = BSL_RSP_MINI_SIZE;        // don't count CRC in Modbus Response, Meet with BSL Spec
  rspOutPtr->u8BslRspDataPtr = cmdInPtr->u8CmdDataPtr;
  return (errCode);
}

tReturnStatus writeSecNextBlock(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr)
{
  tU32 u32TempAddr[3];
  tReturnStatus errCode = CMD_FAILED;

  errCode = BSL430_openMemory();
  if (errCode == SUCCESSFUL_OPERATION)
  {
    u32TempAddr[0] = *cmdInPtr->u8CmdDataPtr;
    u32TempAddr[1] = *(cmdInPtr->u8CmdDataPtr + 1);
    u32TempAddr[2] = *(cmdInPtr->u8CmdDataPtr + 2);
    u32TempAddr[0] = u32TempAddr[0] + ((u32TempAddr[1] << 8) + (u32TempAddr[2] << 16));

    if (u32LastWriteAddress != u32TempAddr[0])
    {
      // this block data has not write to flash, write to flash and do the check sum

      fixFlashAdd = nextBlockAdd;
      nextBlockAdd += (cmdInPtr->u8CmdLength - BSL_MODIFY_LENGH);
      sectionInfor.sectionSize[sectionInfor.totalSection] +=
        (cmdInPtr->u8CmdLength - BSL_MODIFY_LENGH);

      memmove(u8DataToFlash,
              cmdInPtr->u8CmdDataPtr + BSL_HEADER_BYTES, // data will write to flash, point to data, skip CMD & address
              cmdInPtr->u8CmdLength - BSL_MODIFY_LENGH); // number byts need to write

      // save data to flash
      errCode = BSL430_writeMemory(fixFlashAdd,                               // write address, internal flash is above 0x20000, external flash is 0
                                   u8DataToFlash,
                                   cmdInPtr->u8CmdLength - BSL_MODIFY_LENGH); // number byts need to write

      // remember we did write once, do not rewrite again
      u32LastWriteAddress = u32TempAddr[0];

      if (errCode == SUCCESSFUL_OPERATION)
      {
        // clculate section CRC without CMD and address, save in section info
        sectionInfor.sectionCRC[sectionInfor.totalSection].crc.word =
        u16BaspCCIT(cmdInPtr->u8CmdDataPtr + BSL_HEADER_BYTES, // not include CMD, address
                    cmdInPtr->u8CmdLength - BSL_MODIFY_LENGH,
                    &sectionInfor.sectionCRC[sectionInfor.totalSection]);

      }
    }
  }
  rspOutPtr->u8BslRspID      = BSL_MESSAGE_REPLY;
  rspOutPtr->u8BslRspCode    = errCode;
  rspOutPtr->u8BslRspLength  = BSL_RSP_MINI_SIZE;        // don't count CRC in Modbus Response, Meet with BSL Spec
  rspOutPtr->u8BslRspDataPtr = cmdInPtr->u8CmdDataPtr;
  return (errCode);
}

tReturnStatus writeEndFwFile(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr)
{
  tU32 u32TempAddr[3];
  tReturnStatus errCode = CMD_FAILED;

  errCode = BSL430_openMemory();
  if (errCode == SUCCESSFUL_OPERATION)
  {
    u32TempAddr[0] = *cmdInPtr->u8CmdDataPtr;
    u32TempAddr[1] = *(cmdInPtr->u8CmdDataPtr + 1);
    u32TempAddr[2] = *(cmdInPtr->u8CmdDataPtr + 2);
    u32TempAddr[0] += (u32TempAddr[1] << 8) + (u32TempAddr[2] << 16);

    if (u32LastWriteAddress != u32TempAddr[0])
    {
      // this block data has not write to flash, write to flash and do the check sum

      fixFlashAdd = nextBlockAdd;
      // next write to flash is section information block,
      // internal amd external flash about same. all locate on top of flash
      nextBlockAdd = SEC_INFO_STRAT;

      sectionInfor.sectionSize[sectionInfor.totalSection] +=
            (cmdInPtr->u8CmdLength - BSL_MODIFY_LENGH);

      if ((cmdInPtr->u8CmdLength - BSL_MODIFY_LENGH) == 0)
      {
        // not data to write, but it will write section infor to flash
        errCode = SUCCESSFUL_OPERATION;
        //sendMessage( errCode );
      }
      else
      {
        // still has data need to save
        memmove(u8DataToFlash,
              cmdInPtr->u8CmdDataPtr + BSL_HEADER_BYTES, // data will write to flash, point to data, skip CMD & address
              cmdInPtr->u8CmdLength - BSL_MODIFY_LENGH); // number byts need to write

        errCode = BSL430_writeMemory(fixFlashAdd,                               // write address, internal flash is above 0x20000, external flash is 0
                                     u8DataToFlash,
                                     cmdInPtr->u8CmdLength - BSL_MODIFY_LENGH); // number byts need to write

        // remember we did write once, do not rewrite again
        u32LastWriteAddress = u32TempAddr[0];

        if (errCode == SUCCESSFUL_OPERATION)
        {
          // clculate section CRC without CMD and address, save in section info
          sectionInfor.sectionCRC[sectionInfor.totalSection].crc.word =
          u16BaspCCIT(cmdInPtr->u8CmdDataPtr + BSL_HEADER_BYTES, // not include CMD, address
                      cmdInPtr->u8CmdLength - BSL_MODIFY_LENGH,
                      &sectionInfor.sectionCRC[sectionInfor.totalSection]);
        }
      }
      // save section information
      sectionInfor.newFwInStatus = YES_NEW_FW_STATUS;
      flashSecInfoCrc.crc.word = INITIAL_CRC_WORD;
      flashSecInfoCrc.crc.word =
          u16BaspCCIT((tU8 *)&sectionInfor, PROG_INFOR_SIZE, &flashSecInfoCrc);

      errCode = BSL430_openMemory();
      errCode = BSL430_writeMemory(nextBlockAdd,
                                   (tU8 *)&sectionInfor,
                                   PROG_INFOR_SIZE);

      errCode = BSL430_writeMemory(CRC_SEC_INFO_START,
                                   (tU8 *)&flashSecInfoCrc,
                                   CRC_SEC_INFO_SIZE);
    }
  }
  // after write flash is locked
  BSL430_lock_BSL();
  rspOutPtr->u8BslRspID      = BSL_MESSAGE_REPLY;
  rspOutPtr->u8BslRspCode    = errCode;
  rspOutPtr->u8BslRspLength  = BSL_RSP_MINI_SIZE;        // don't count CRC in Modbus Response, Meet with BSL Spec
  rspOutPtr->u8BslRspDataPtr = cmdInPtr->u8CmdDataPtr;

  return (errCode);
}

tReturnStatus sendSectionInfo(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr)
{
  tReturnStatus errCode      = RS_good;
  rspOutPtr->u8BslRspID      = BSL_MESSAGE_REPLY;
  rspOutPtr->u8BslRspCode    = FLASH_SECTION_INFO;
  rspOutPtr->u8BslRspLength  = PROG_INFOR_SIZE + BSL_RSP_MINI_SIZE;        // don't count CRC in Modbus Response, Meet with BSL Spec
  memmove(rspOutPtr->u8BslRspDataPtr,(tU8 *)&sectionInfor, PROG_INFOR_SIZE);
  return (errCode);
}

tReturnStatus progFlash2Msp(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr)
{
  tU8 u8RspData[5];
  tReturnStatus errCode = CMD_FAILED;

  // move 1st block to ram, then run it
  errCode = CopyFirstBlock2Ram();

  if (errCode == SUCCESSFUL_OPERATION)
  {
    // id successful, send repsone to host, excute RAM code
    u8RspData[0]  = infoA.comm.u8ModbusAddr;
    u8RspData[1]  = MD_CMD_FC65;
    u8RspData[2]  = BSL_RSP_MINI_SIZE;
    u8RspData[3]  = BSL_MESSAGE_REPLY;
    u8RspData[4]  = SUCCESSFUL_OPERATION;
    // send status to the host, let host end of process
    PI_sendData(u8RspData, BSL_RSP_MINI_SIZE + 3);
    // run RAM code, update firmware, after that, control jumps to firmware start place
    waste_time(3000); // this delay is improtent for last Tx char send complete right. 75 *30 = 2250uSec = 2.2mSec

    // disable all interrupts
    __disable_interrupt();

    RTCPS0CTL &= (tU16)~RT0PSIE;            // disable faster timer interrupt.
    TA0CTL &= (tU16)~TAIE;                  // stop timer interrupt
    WDTCTL = WDTPW + WDTHOLD;               // Stop watchdog timer

    // excute run code
    main_update();
  }

  // failed read 1st bacl of flash into RAM, the host will get the status, keep application running
  rspOutPtr->u8BslRspID      = BSL_MESSAGE_REPLY;
  rspOutPtr->u8BslRspCode    = errCode;
  rspOutPtr->u8BslRspLength  = BSL_RSP_MINI_SIZE;        // don't count CRC in Modbus Response, Meet with BSL Spec
  rspOutPtr->u8BslRspDataPtr = cmdInPtr->u8CmdDataPtr;
  // this return is for compiler, when Main_update is done, the new firmware starts.
  return (errCode);
}

tReturnStatus notUseFwInFlash(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr)
{
  tReturnStatus errCode      = RS_good;
  rspOutPtr->u8BslRspID      = BSL_MESSAGE_REPLY;
  rspOutPtr->u8BslRspCode    = SUCCESSFUL_OPERATION;
  rspOutPtr->u8BslRspLength  = BSL_RSP_MINI_SIZE;        // don't count CRC in Modbus Response, Meet with BSL Spec
  rspOutPtr->u8BslRspDataPtr = cmdInPtr->u8CmdDataPtr;
  return (errCode);
}

/*******************************************************************************
*Function:    sendByte
*Description: Sends one byte using the timer
*Parameters:
*           char data    the byte to send
*******************************************************************************/
void sendByte(char data)
{
  //while (!(MSP_USB_INT_FLAG&UCTXIFG))             // USCI_A1 TX buffer ready?
  {
    _NOP();
  }
  UCA1TXBUF = data;                       // UCRXIFG  UCTXIFG
}

/*******************************************************************************
*Function:    sendData
*Description: Sends the data in the data buffer
*Parameters:
*           int size    the number of bytes in the buffer
*******************************************************************************/
void PI_sendData(tU8 *data, tS16 size)
{
  tU8 i;
  MSG_CRC16 u16Crc;

  u16Crc.crc_l = u16Crc.crc.byte[0] = u8CLEAR_CRC_CHAR;
  u16Crc.crc_h = u16Crc.crc.byte[1] = u8CLEAR_CRC_CHAR;
//  u16Crc.crc.word = INITIAL_CRC_WORD;
//  u16Crc.crc.word = u16BaspCCIT(data, size, &u16Crc); // puhere has 58misecond to calculate CRC
  for( i = 0; i < size; i++)                          // BSL message
  {
    sendByte(data[i]);
    u16Crc.crc.word = MdCRC16(&data[i], 1, &u16Crc); // puhere has 58misecond to calculate CRC
    //data++;
  }
  sendByte(u16Crc.crc.byte[0]);
  sendByte(u16Crc.crc.byte[1]);
}

tReturnStatus  CopyFirstBlock2Ram(void)
{
  tReturnStatus error;
  tU8  *ramAddr;
  tU32 addr, i, u32StopLoop;
  MSG_CRC16 calCRC;
  // read from storage start place, the RAM code is in there
  addr = FIX_START_ADDR;

  // clear out unused address bits
  sectionInfor.sectionStartAddr[0] = sectionInfor.sectionStartAddr[0] & VOID5438A_ADDR_MASK;
  ramAddr = (tU8 *)sectionInfor.sectionStartAddr[0];

  u32StopLoop = sectionInfor.sectionSize[0];
  for (i = 0; i < u32StopLoop; i++)
  {
    // read from fix storage place, place in RAM
    *ramAddr = __data20_read_char(addr);
    addr++;
    ramAddr++;
  }

  // done reading do the CRC check
  calCRC.crc.word = INITIAL_CRC_WORD;
  calCRC.crc.word = u16BaspCCIT((tU8 *)sectionInfor.sectionStartAddr[0],
                        sectionInfor.sectionSize[0],
                        &calCRC);

  // real CRC check
  if (calCRC.crc.word != sectionInfor.sectionCRC[0].crc.word)
  {
    // for debug
    calCRC.crc.word++;
    error = MEMORY_READ_CHECK_FAILED;
  }
  else
  {
    error = SUCCESSFUL_OPERATION;
  }
  return error;
}

//=============================================================================
// end file by xuedong
//=============================================================================
