//******************************************************************************
// Searl Port Communications Module
//******************************************************************************

//******************************************************************************
//constant definitions, type definitions
#include "masterHeader.h"

//global volatile variables
#include "externGlobalVar.h"

//global function prototypes definitions
#include "externFunc.h"

#ifdef __MSP430F5638__
//******************************************************************************
// local prototype
static void mspTxToRadio(void);
static void setWirelessSendID(void);
static void WirelessWakeUp(void);
static void WirelessSleepMode(void);
static void WirelessInCmdMode(void);
void CalculateSendData(void);     // remove compile warning
static void Wireless_escaped(BYTE *ch, tU8 *buff, tU16 *len);
static void Wireless_process(tU8 *BufPtr, tU16 *len);
void WirelessSendData(void);      // remove compile warning
static void clearRadioTxIfg(void);
static void WirelessCMDInit(void);
static void WirelessReset(void);
static void mspDoneTxRadio(void);
void setupRadioDmaTxCtrl(void);   // remove compile warning
static void waitModemAck(void);
void setReadingstoZero(void);
void sumReadings(void);
//static tF32 correctOrAddVal(tF32 f32OutV, tF32 f32InV);

//******************************************************************************
// local variable
static JT400RadioMessageStruc  JTRadioMsg;
// remove compile warning
//static tU32 u32TxInterval;
// DAM use this gloable to Tx data
tU8 BufPtr[(tU32)WirelessCharSize<<1u]; //, u8MaxInitLp;
tU16 send_length;
//******************************************************************************
static const char hexchars[] = {"0123456789ABCDEF"};
//******************************************************************************
// constant definitions
//static const char hexchars[] = {"0123456789ABCDEF"};
//******************************************************************************
#endif

static tU8 radioSpaceHolder(RADIO_HOST_CMD *cmdInPtr, RADIO_PRO_RESP *rspOutPtr);
static tU8 rdRadioTxMsg(RADIO_HOST_CMD *cmdInPtr, RADIO_PRO_RESP *rspOutPtr);
static tU8 wtRadioStart(RADIO_HOST_CMD *cmdInPtr, RADIO_PRO_RESP *rspOutPtr);
static tU8 wtRadioTxInterval(RADIO_HOST_CMD *cmdInPtr, RADIO_PRO_RESP *rspOutPtr);
static tU8 rdRadioStatus(RADIO_HOST_CMD *cmdInPtr, RADIO_PRO_RESP *rspOutPtr);
static tU8 rdRadioTxInterval(RADIO_HOST_CMD *cmdInPtr, RADIO_PRO_RESP *rspOutPtr);
static tU8 rdRadioRxDEstinatId(RADIO_HOST_CMD *cmdInPtr, RADIO_PRO_RESP *rspOutPtr);
static tU8 doRadioApiInit(RADIO_HOST_CMD *cmdInPtr, RADIO_PRO_RESP *rspOutPtr);

// local function prototype definitions:
const RADIO_FACE_USER defineRadioFunc[] =
{
  {UNUSED_RADIO_CMD,       0,radioSpaceHolder},        // = 0
  {RD_RADIO_TX_MSG,        0,rdRadioTxMsg},            //0x01
  {SET_RADIO_START,        0,wtRadioStart},            //0x02
  {SET_RADIO_TX_TIMER,     0,wtRadioTxInterval},       //0x03, set destination address
  {RD_RADIO_STATUS,        0,rdRadioStatus},           //0x04
  {RD_RADIO_TX_INTERVAL,   0,rdRadioTxInterval},       //0x05, read Tx interval
  {RD_RADIO_RX_DESTINAT_ID,0,rdRadioRxDEstinatId},     //0x06, read Radio destination ID
  {START_RADIO_API_INIT,   0,doRadioApiInit},          //0x07, do the radio API init          
};

#ifdef __MSP430F5638__
void initRadioState(void)
{
  sysRamData.diag.u8RadioStatus |= BAT_POWR_UNINSTALL;     
  sysRamData.diag.u8RadioStatus |= RADIO_CHIP_UNINSTALL; //initial
  sysRamData.diag.u8RadioStatus &= (tU8)~START_INIT_RADIO;
  batoutCtrlOutLow();
}

void batoutCtrlOutLow(void)
{
  // put follow lines output low
  GPIO_setOutputHighOnPin(
        __MSP430_BASEADDRESS_PORT6_R__,
        GPIO_PORT_P6,
        P6_5_RADIO_RTS_OUT);  // set RTS to high
 
  GPIO_setOutputHighOnPin(
        __MSP430_BASEADDRESS_PORT6_R__,
        GPIO_PORT_P6,
        P6_4_RADIO_SLEEP_OUT);  // CMD radio in sleep
   
  GPIO_setOutputLowOnPin(__MSP430_BASEADDRESS_PORT6_R__,
      GPIO_PORT_P6,
      P6_6_RADIO_RST_OUT);  // set low, reset 

  // not init
  sysRamData.diag.u8RadioStatus &= ~RADIO_API_INIT_DONE;
}

void batInCtrlOutDefault(void)
{
  // put line in default state 
  mspDoneTxRadio();
  WirelessSleepMode();
  GPIO_setOutputHighOnPin(__MSP430_BASEADDRESS_PORT6_R__,
      GPIO_PORT_P6,
      P6_6_RADIO_RST_OUT); // set hi, done reset
}

static void setWirelessSendID(void)
{
  tU16 temp = infoA.comm.u8RadioTxChId;
  //if (temp == 0)
  {
    temp = SEND_CH_ID_DEF;   // default to
  }
  WLPro.SChID[3] = hexchars[temp & 0x000fu];
  WLPro.SChID[2] = hexchars[(temp>>4) & 0x000fu];
  temp >>= 8;
  WLPro.SChID[1] = hexchars[temp & 0x0fu];
  WLPro.SChID[0] = hexchars[(temp>>4) & 0x0fu];
}

static void mspTxToRadio(void)
{
    GPIO_setOutputHighOnPin(
        __MSP430_BASEADDRESS_PORT6_R__,
        GPIO_PORT_P6,
        P6_5_RADIO_RTS_OUT);  // set RTS to High
}

static void mspDoneTxRadio(void)
{
    GPIO_setOutputLowOnPin(
        __MSP430_BASEADDRESS_PORT6_R__,
        GPIO_PORT_P6,
        P6_5_RADIO_RTS_OUT);  // set RTS to Low
}

static void WirelessSleepMode(void)
{
  waste_time(800);

  GPIO_setOutputHighOnPin(
        __MSP430_BASEADDRESS_PORT6_R__,
        GPIO_PORT_P6,
        P6_4_RADIO_SLEEP_OUT);  // CMD radio in sleep
}

static void WirelessWakeUp(void)
{
    // readio out sleep
    GPIO_setOutputLowOnPin(__MSP430_BASEADDRESS_PORT6_R__,
        GPIO_PORT_P6,
        P6_4_RADIO_SLEEP_OUT);  // CMD radio out sleep
}

static void WirelessReset(void)
{
    // reset radio once
    GPIO_setOutputLowOnPin(__MSP430_BASEADDRESS_PORT6_R__,
        GPIO_PORT_P6,
        P6_6_RADIO_RST_OUT);  // set low, reset 
    
    __delay_cycles(3000);
    
    GPIO_setOutputHighOnPin(__MSP430_BASEADDRESS_PORT6_R__,
        GPIO_PORT_P6,
        P6_6_RADIO_RST_OUT); // set hi, done reset
}

static void clearRadioTxIfg(void)
{
  UART_clearInterruptFlag(
      __MSP430_BASEADDRESS_USCI_A0__,
      UCTXIFG );    // clear Tx interrupt flag
}

void doneTxRadioMsg(void)
{
    // clear flag
  if((u8Layer2TaskScheduler & DONE_TX_RADIO_MSG) == DONE_TX_RADIO_MSG)
  {
    // operatio ncome here
    u8Layer2TaskScheduler &= (tU8)~DONE_TX_RADIO_MSG;
    addOneTypeExchg(TYPE_RADIO_NOW_MSG);  // 5638 use it
  }
  else
  {
    // kernel init come here, do nothing,sleep radio
    WirelessReset();
  }
  WirelessSleepMode();
  
  mspDoneTxRadio();
  // reset veraible register
  setReadingstoZero();
  // turn off LED, does not matter is on or off, in here off
#if 1
  GPIO_setOutputLowOnPin(
        __MSP430_BASEADDRESS_PORT8_R__,
        GPIO_PORT_P8,
        P8_0_DISP_LED_OUT);    
#endif  
  // Clear interrupt flag for next time
  clearRadioTxIfg();
  // it can start Tx message again
  WLPro.NexState = WL_IDLE_STATE;  

}

/*************************************************************************
*  Function: InitRadio()
*_____________________________________________________________________
*   Description: Initilization for a Radio
*************************************************************************/
void initRadio(void)
{
  // init Radio PRocess status
  sysRamData.diag.u8RadioStatus |= RADIO_CHIP_UNINSTALL; // init start 
  sysRamData.diag.u8RadioStatus &= (tU8)~START_INIT_RADIO;
  
  // weakup radio
  WirelessWakeUp();
  // reset once
  WirelessReset();
  // MSP is ready to send char to Radio
  mspTxToRadio();
  // set Radio transmitter Channel ID
  setWirelessSendID();

  WLPro.u8RxStatus = PASSED;
  WLPro.NexState = WL_IDLE_STATE;
  WLPro.line = 0u;
  WLPro.SleepMode_v = WIRELESS_SLEEPMODE;
  WLPro.API_mode = API_MODE;

  //lower speed into wireless command mode
  WirelessInCmdMode();
  if((sysRamData.diag.u8RadioStatus & RADIO_CHIP_UNINSTALL) != RADIO_CHIP_UNINSTALL)
  {
    // setup radio
    WirelessCMDInit();
    // clear Tx interrupt bit
    clearRadioTxIfg();
    // done set up radio, sleep wait to Tx.
    WirelessSleepMode();
    // set init done
    sysRamData.diag.u8RadioStatus |= RADIO_API_INIT_DONE;
  }
  addOneTypeExchg(TYPE_DIAG);  
} /* initRadio() */

void setBatInstallStatus(tU8 Status)
{
  if(Status == OFF)
  {
    // battery is uninstalled
    sysRamData.diag.u8RadioStatus |= BAT_POWR_UNINSTALL; 
    sysRamData.diag.u8RadioStatus &= ~RADIO_API_INIT_DONE;
  }
  else
  {
    // battery is good and installed
    sysRamData.diag.u8RadioStatus &= ~BAT_POWR_UNINSTALL;
  }
  
  addOneTypeExchg(TYPE_DIAG);  
}

static void WirelessInCmdMode(void)
{
    tU16 i;
    tU32 u32LpCnt = 1;
    // must has delay
    __no_operation();
    //for (i = 0; i < 720; i++)  // 16MHz use this is 1 Second
    //for (i = 0; i < 50; i++)   // 1MHz use this is 1 Second
    // 8MHz i = 50 is 0.150Second, calculate i = 300 is 0.150 x 6 = .900Second, scope check, it is same as calc #
    // i = 350 0.150 x 6.6 = 1.05Second, scope check it is 1.052Second

    // take at least 1 second quiet time
    // send "+++"
    for (i = 0; i < 350; i++)   // 8MHz
    {
      waste_time(3000);         // 3 msec after init USB  
    }
    __no_operation();
    
    // Tx Radio three plus characters (+++), 173msec send 3 '+'
    for (i = 0; i < 3; i++)
    {
      UCA0IFG = 0x00;
      UCA0TXBUF = 0x2b;  // "+" = 0x2B
      
      u32LpCnt = 1;
      while (((UCA0IFG & UCTXIFG) != UCTXIFG) && (u32LpCnt != 0))
      {
        u32LpCnt++;
      }
    }

    __no_operation();
    // quiet for 1 second, Radio send "OK"
    // 330 is about 0.990 Second, scope check is 0.992Second 
    for (i = 0; i < 330; i++)
    {
      waste_time(3000);  
    }    
    __no_operation();
    waitModemAck();
}

static void waitModemAck(void)
{
  tU8 u8temp[2],  j;
  tU16 i, u16debug[2]; 
  i = 0;
  u8temp[0] = u8temp[1] = 0;
  for (j = 0; j <= 1; j++)
  {
    while ((UCA0IFG & UCRXIFG) != UCRXIFG)
    {
      i++;
      if(i > 2000)   //20000
      { 
        // not wait any more, and chip uninstalled still set.
        break;
      }
      
      __delay_cycles(2500); // 491 of (250) befoer 0.992S is 1 seconds, so that 
                           // 491 of(250) is about 8mSecond
                           // Radio UART is 9600, char to char is 1mSecond
                           // 32 or 31 of (250) is about 1mSecond
    }
    u16debug[j] = i;  // [0] = 491, 494, 411, or 407; [1] = 32 or 31
    u16debug[j]++;    // remove compiler warning
    i = 0;
    u8temp[j] = UCA0RXBUF;
    if(j >= 1)
    {
      __no_operation();
      if((u8temp[j - 1] == 0x4F) && (u8temp[j] == 0x4B))
      {
        // O = 0x4F, K = 0x4B
        // radio is intalled, clear uninstall bit
        sysRamData.diag.u8RadioStatus &= ~RADIO_CHIP_UNINSTALL;
        __no_operation();
        break;
      }
    }
  }
  __no_operation();
}

static void WirelessCMDInit(void)
{
    wireless_cmd WL_CMD_String[] =
    {
        //some comment out for debug
        {CMD_RestoreDefaults,{CMD_Enter, 0u,0u,0u,0u}, 5u},
        {CMD_SetMyAddr,{WLPro.SChID[0], WLPro.SChID[1], WLPro.SChID[2], WLPro.SChID[3], CMD_Enter}, 9u},
        {CMD_SleepMode,{WIRELESS_SLEEPMODE, CMD_Enter, 0u,0u,0u}, 6u},
        {CMD_RSSI,     {PULL_UP_DISABLE, CMD_Enter, 0,0,0}, 6},
        {CMD_API_mode, {WLPro.API_mode,     CMD_Enter, 0u,0u,0u}, 6u},
        {CMD_Write,    {CMD_Enter, 0u,0u,0u,0u}, 5u},
        {CND_ModeExit, {CMD_Enter, 0u,0u,0u,0u}, 5u},
    };
    tU8 k, l;

    // how many elminates in WL_CMD_String, compiler set it
    tU8 u8TotalCmds = lengthof(WL_CMD_String);
    for (WLPro.line = 0; WLPro.line < u8TotalCmds; WLPro.line++)
    {
        l = WL_CMD_String[WLPro.line].CMD_LENGTH - 4u; // Parameter size

        for (k = 0; k < 4u; k++)   // alwasy 4 CMD, like "ATWR" and "ATCN"
        {
            while (!UART_getInterruptStatus(__MSP430_BASEADDRESS_USCI_A0__,
                   UCTXIFG)) ;

            UART_transmitData(__MSP430_BASEADDRESS_USCI_A0__,
              WL_CMD_String[WLPro.line].WL_cmd[k]);  // send CMD
        }
        for (k = 0; k < l; k++)
        {
            while (!UART_getInterruptStatus(__MSP430_BASEADDRESS_USCI_A0__,
                   UCTXIFG)) ;

            UART_transmitData(__MSP430_BASEADDRESS_USCI_A0__,
                WL_CMD_String[WLPro.line].Parameter[k]);  // send CMD parameter
        }

        // wait for done send end Char
        while (!UART_getInterruptStatus(__MSP430_BASEADDRESS_USCI_A0__,
           UCTXIFG)) ;

        waitModemAck(); 
    }
}

//==============================================================================
// FUNCTION:  initDmaTxCtrl, use DMA channel 4 to Tx Radio MSG
//==============================================================================
void setupRadioDmaTxCtrl(void)
{
    // trig by UCA0TxIFG = 17
    //wake up wireless device

    //Initialize and Setup DMA Channel 4 -> Radio UART Tx
    // Base Address of the DMA Module
    // Configure DMA channel 4
    // Configure channel for single transfer
    // DMA transfers will be disabled and interrupt flag will be set after every
    //   size transfer
    // Use DMA Trigger Source 17 (UCA0TXIFG), reference data sheet Table 15, DMA trigger assigments
    // Transfer Byte-to-byte
    // Trigger transfer on signal held high
    DMA_init(__MSP430_BASEADDRESS_DMAX_6__,
        DMA_CHANNEL_4,
        DMA_TRANSFER_SINGLE,
        send_length,
        DMA_TRIGGERSOURCE_17,                   // UCA0 Tx IFG
        DMA_SIZE_SRCBYTE_DSTBYTE,               // DMASBDB
        DMA_TRIGGER_HIGH);                      // DMALEVEL

    // Base Address of the DMA Module
    // Configure DMA channel 4
    // Use TxString as source
    // Increment source address after every transfe
    DMA_setSrcAddress(__MSP430_BASEADDRESS_DMAX_6__,
        DMA_CHANNEL_4,          // use BufPtr breacuse it has escaped, and check sum
        (unsigned long)BufPtr, //(unsigned long)BufPtr,(unsigned long)&WirelessApiMsg,
        DMA_DIRECTION_INCREMENT);               // DMASRCINCR_3

     // Base Address of the DMA Module
     // Configure DMA channel 4
     // Use UCSI A0 Tx Buffer as destination
     // Don't move the destination address after every transfer
    DMA_setDstAddress(__MSP430_BASEADDRESS_DMAX_6__,
        DMA_CHANNEL_4,
        UART_getTransmitBufferAddressForDMA(__MSP430_BASEADDRESS_USCI_A0__),
        DMA_DIRECTION_UNCHANGED);

    // enable done DAM interrupt, so that it can sleep Radio again
    DMA_enableInterrupt(__MSP430_BASEADDRESS_DMAX_6__,
        DMA_CHANNEL_4);                         // DMAIE

    // enable to Tx data
    DMA_enableTransfers(__MSP430_BASEADDRESS_DMAX_6__,
        DMA_CHANNEL_4);
            
    __no_operation();    // debug breakpoint
}

void setupRadioDmaRxCtrl(void)
{
    // trig by UCA0TxIFG = 17
    //wake up wireless device

    //Initialize and Setup DMA Channel 4 -> Radio UART Tx
    // Base Address of the DMA Module
    // Configure DMA channel 4
    // Configure channel for single transfer
    // DMA transfers will be disabled and interrupt flag will be set after every
    //   size transfer
    // Use DMA Trigger Source 17 (UCA0RXIFG), reference data sheet Table 15, DMA trigger assigments
    // Transfer Byte-to-byte
    // Trigger transfer on signal held high
    DMA_init(__MSP430_BASEADDRESS_DMAX_6__,
        DMA_CHANNEL_4,
        DMA_TRANSFER_SINGLE,
        10,                                      // was 10, at least 10 bytes
        DMA_TRIGGERSOURCE_16,                   // UCA0 Rx IFG
        DMA_SIZE_SRCBYTE_DSTBYTE,               // DMASBDB
        DMA_TRIGGER_HIGH);                      // DMALEVEL

    // Base Address of the DMA Module
    // Configure DMA channel 4
    // Use TxString as source
    // Increment source address after every transfe
    DMA_setSrcAddress(__MSP430_BASEADDRESS_DMAX_6__,
        DMA_CHANNEL_4,          // use BufPtr breacuse it has escaped, and check sum
        UART_getReceiveBufferAddressForDMA(__MSP430_BASEADDRESS_USCI_A0__),
        DMA_DIRECTION_UNCHANGED);               // DMASRCINCR_4
    
     // Base Address of the DMA Module
     // Configure DMA channel 4
     // Use UCSI A0 Tx Buffer as destination
     // Don't move the destination address after every transfer
    DMA_setDstAddress(__MSP430_BASEADDRESS_DMAX_6__,
        DMA_CHANNEL_4,
        (unsigned long)(u8CommInbuf),  // set Rx address
        DMA_DIRECTION_INCREMENT);

    // enable done DAM interrupt, so that it can sleep Radio again
    DMA_enableInterrupt(__MSP430_BASEADDRESS_DMAX_6__,
        DMA_CHANNEL_4);                         // DMAIE

    // enable to Tx data
    DMA_enableTransfers(__MSP430_BASEADDRESS_DMAX_6__,
        DMA_CHANNEL_4);
    
    //Enable DMA transfers on channel 4
    DMA_enableTransfers(__MSP430_BASEADDRESS_DMAX_6__,
         DMA_CHANNEL_4);
    
    //portEnv->u8IncomePtr = 0;         
    __no_operation();    // debug breakpoint
}


void setReadingstoZero(void)
{
    // use memset to set all to zero, if need
}
#if 0
static tF32 correctOrAddVal(tF32 f32OutV, tF32 f32InV)
{
  // if in F32 vale is NaN or Inf
  if((f32InV == 0xFFFF0000) || (f32InV == 0x7F800000))
  {
    f32InV = 0;
  }
  
  // if out F32 vale is NaN or Inf
  if((f32OutV == 0xFFFF0000) || (f32OutV == 0x7F800000))
  {
    f32OutV = f32InV;
  }
  else
  {
    if(f32OutV == 0)
    {
      f32OutV = f32InV;
    }
    else
    {
      f32OutV += f32InV;
      f32OutV /= 2.0f;
    }
  }
  return f32OutV;
}
#endif
void sumReadings(void)
{
  JTRadioMsg.f32Ai_0_Val = sysRamData.xmt.f32AnalogInCnt[0]; //correctOrAddVal(JTRadioMsg.f32Ai_0_Val, sysRamData.xmt.f32AnalogInCnt[0]);
  JTRadioMsg.f32Ai_1_Val = sysRamData.xmt.f32AnalogInCnt[1]; //correctOrAddVal(JTRadioMsg.f32Ai_1_Val, sysRamData.xmt.f32AnalogInCnt[1]);
  JTRadioMsg.f32VoltBatVal = sysRam56D.exchg6Pv.f32BatV; //correctOrAddVal(JTRadioMsg.f32VoltBatVal, sysRam56D.exchg6Pv.f32BatV);
  JTRadioMsg.f32VoltSolarVal = sysRam56D.exchg6Pv.f32SolarV; //correctOrAddVal(JTRadioMsg.f32VoltSolarVal, sysRam56D.exchg6Pv.f32SolarV);
  JTRadioMsg.f32BdTemperatur = sysRam56D.exchg6Pv.f32FbdTemp; //correctOrAddVal(JTRadioMsg.f32BdTemperatur, sysRam56D.exchg6Pv.f32FbdTemp);

  JTRadioMsg.f32HscVal = sysRam56D.exchg6Pv.u32HsCnts;
  JTRadioMsg.u16Dio_status = sysRamData.diag.u16FramingErr;
  if((chartRecEnv.u32SetResponStatus & DEBUG_CHART_RECORD) == DEBUG_CHART_RECORD)
  {
    JTRadioMsg.u16DevStatus = BIT0;
  }
  else
  {
    JTRadioMsg.u16DevStatus &= ~BIT0;
  }
  JTRadioMsg.u32TxChartRecInterval = chartRecEnv.u32TotalRecord;

}

void CalculateSendData(void)
{
    tU8 *BufPtr;
    tU8 i;
    union
    {
      tU8 u8Data[4];
      tU32 u32serial;
    } BdSer;
    
    JTRadioMsg.u8DeviceAddress = infoA.comm.u8ModbusAddr; 
    JTRadioMsg.u8MessID = RADIO_MESSAGE_REV;
    memmove(&JTRadioMsg.chatMessage.u16YearBcd, &showCurrent.u16YearBcd, A_RECORD_LENGTH);
    JTRadioMsg.u8DpUnitCode = infoD.xmt.u8DpUnits;
    JTRadioMsg.u8SpUnitCode = infoD.xmt.u8SpUnits;
    JTRadioMsg.u8RtdUnitCode = infoD.xmt.u8RtdUnits;
    JTRadioMsg.u8FreeEvenStruc = 0;
    
    BdSer.u8Data[0] = infoD.xmt.u8SerialNumber[0];
    BdSer.u8Data[1] = infoD.xmt.u8SerialNumber[0];
    BdSer.u8Data[2] = infoD.xmt.u8SerialNumber[0];
    BdSer.u8Data[3] = infoD.xmt.u8SerialNumber[0];
    JTRadioMsg.u32RadioSenderID = BdSer.u32serial;
    
    //wake up wireless device
    WirelessWakeUp();
    if((sysRamData.diag.u8RadioStatus & TX_MSG_FLASH_LCD) == TX_MSG_FLASH_LCD)
    {
       GPIO_setOutputHighOnPin(   //GPIO_toggleOutputOnPin(    //GPIO_setOutputHighOnPin(
            __MSP430_BASEADDRESS_PORT8_R__,
            GPIO_PORT_P8,
            P8_0_DISP_LED_OUT);
    }
    // current data add to sum
    sumReadings();

    //wake up wireless device
    //WirelessWakeUp();

    // calculate check sum
    BufPtr = (tU8 *)&JTRadioMsg;
    JTRadioMsg.u8MsgCheckSum = 0u;
    for (i = 0u; i < MessLength - 1u; i++)
    {
        JTRadioMsg.u8MsgCheckSum += BufPtr[i];
    }
}

static void Wireless_escaped(BYTE *ch, tU8 *buff, tU16 *len)
{
  switch(*ch)
  {
    case STARTDELIMITER:
    case ESCAPE:
    case XON:
    case XOFF:
        *(buff++)  = ESCAPE;      // escaped next data
        *len += 1u;
        *buff = *ch ^ XOR_WITH;   // data xor with 0x20
        *len += 1u;
      break;
    default:
        *buff  = *ch;             // data doesn't need to escape
        *len += 1u;
      break;
  }
}

static void Wireless_process(tU8 *BufPtr, tU16 *len)
{
  tU8 i;
  tU16 j;
  tU8 CheckSum;
  union
  {
    tU16 x;
    tU8 byte[2];
  } temp;

  tU8 *buffer;

  buffer = (tU8 *)&WirelessApiMsg.OurMsg;
  j = 0u;
  CheckSum = 0u;

  //add fix portion to output buffer
  BufPtr[j++] = WirelessApiMsg.StartDelimiter;  // Start Delimiter 0x7E

  //add wireless data length = j virable to output buffer
  temp.x = WirelessApiMsg.Length;
  Wireless_escaped(&temp.byte[1], &BufPtr[j], &j);   // length MSB
  Wireless_escaped(&temp.byte[0], &BufPtr[j], &j);   // length LSB

  //API ID
  CheckSum += WirelessApiMsg.ApiID;     // start from API ID to add up check sum
  BufPtr[j++] = WirelessApiMsg.ApiID;  // API Identifier

  //process frame ID, add to output buffer
  CheckSum +=  WirelessApiMsg.FrameID;
  Wireless_escaped(& WirelessApiMsg.FrameID, &BufPtr[j], &j);

  //add destination address
  temp.x =  WirelessApiMsg.Receiv_ch_id;
  CheckSum += temp.byte[1];
  CheckSum += temp.byte[0];
  Wireless_escaped(&temp.byte[1], &BufPtr[j], &j);
  Wireless_escaped(&temp.byte[0], &BufPtr[j], &j);

  //add options
  CheckSum +=  WirelessApiMsg.Options;
  BufPtr[j++]  =  WirelessApiMsg.Options;

  //Escaped our message if need, add to output buffer
  for (i = 0u; i < MessLength; i ++)
  {
    CheckSum += buffer[i];
    Wireless_escaped((BYTE *)&buffer[i], &BufPtr[j], &j);
  }

  //process check sum
  CheckSum = CELLINGSUM - CheckSum;
  WirelessApiMsg.CheckSum = CheckSum;
  Wireless_escaped((BYTE *)& WirelessApiMsg.CheckSum, &BufPtr[j], &j);

  //send out buffer length is j
  *len = j;
}

void WirelessSendData(void)
{
    //wireless API message
    WirelessApiMsg.StartDelimiter = STARTDELIMITER;
    WirelessApiMsg.ApiID = API_ID;
    WirelessApiMsg.Options = OPTIONS;
    WirelessApiMsg.Receiv_ch_id = (tU16)info5638D.u32RadioTxInterval;  //infoA.comm.u16RadioRxChId;(tU16)info5638D.u32RadioTxInterval; 
    WirelessApiMsg.OurMsg = JTRadioMsg;   
    WirelessApiMsg.Length = MessLength + API_EXTRA_CHAR;

    //wireless frame id process
    if (( WirelessApiMsg.FrameID >= START_FRAME_ID) && ( WirelessApiMsg.FrameID < END_FRAME_ID))
    {
        WirelessApiMsg.FrameID++;
    }
    else
    {
        WirelessApiMsg.FrameID = START_FRAME_ID;
    }
    // process entire message structure, it is ready to send
    Wireless_process(BufPtr, &send_length);
}

/*************************************************************************
*  Function: CommunicationDriver()                   Date: 01-Sep-2002   *
*________________________________________________________________________*
*                                                                        *
*   Description:                                                         *
*              If a valid message is received, this task processes it    *
*              and responds.  The slave port can receive local, global,  *
*              and Expanded BSAP messages.                               *
*                                                                        *
*                                                                        *
*   Parameters: none                                                     *
*                                                                        *
*************************************************************************/
void CommunicationDriver(void)
{
  // clear do task flag
  u8Layer2TaskScheduler &= (tU8)~SEND_DATA_2RADIO;
  if(((sysRamData.diag.u8RadioStatus & BAT_POWR_UNINSTALL) != BAT_POWR_UNINSTALL) && 
    (sysRamData.diag.u8RadioStatus & RADIO_API_INIT_DONE) == RADIO_API_INIT_DONE)
    {
      if((sysRamData.diag.u8RadioStatus & USER_OPERATE_RADIO) == USER_OPERATE_RADIO)
      {
#if 0
        if((u32TxInterval >= chartRecEnv.u32TotalRecord) || 
           (u32TxInterval == 0))
        {
          // can Tx message
          u32TxInterval = 1;
          
          if(WLPro.NexState == WL_IDLE_STATE)
          {
            sysRamData.diag.u8RadioStatus |= RADIO_TX_ON;
            // is time to tX data, and readio done send last msg
            // Radio tx this message

            // it is busy, not do it again
            WLPro.NexState = WL_BUSY_STATE;
            // set to Tx direction
            mspTxToRadio();

            //wake up wireless device
            WirelessWakeUp();
            // do the data calculation
            CalculateSendData();

            //if has error, should stop process
            WirelessSendData();
            // set DAM up and start it, the length may change, start address not change
            setupRadioDmaTxCtrl();
            radioTimerStart(350, TX_DMA_START);  
          }
        }
        else
        {
          // calcuate sum
          sumReadings();
          // decrease to send time
          u32TxInterval++;
        }
#else
          if((WLPro.NexState == WL_IDLE_STATE) && 
            ((sysRamData.diag.u8RadioStatus & Tx_RADIO_DATA) == Tx_RADIO_DATA))
          {
            sysRamData.diag.u8RadioStatus &= ~(tU8)Tx_RADIO_DATA;
            // set other transmitter data 
            sumReadings();
            
            sysRamData.diag.u8RadioStatus |= RADIO_TX_ON;
            // is time to tX data, and readio done send last msg
            // Radio tx this message

            // it is busy, not do it again
            WLPro.NexState = WL_BUSY_STATE;
            // set to Tx direction
            mspTxToRadio();

            //wake up wireless device
            WirelessWakeUp();
            // do the data calculation
            CalculateSendData();

            //if has error, should stop process
            WirelessSendData();
            // set DAM up and start it, the length may change, start address not change
            setupRadioDmaTxCtrl();
            radioTimerStart(350, TX_DMA_START);  
          }
#endif
      } //if USER_OPERATE_RADIO       
    addOneTypeExchg(TYPE_INFO5638D);   // 4638 use it 
  } //if BAT_POWR_UNINSTALL
  
  if((sysRamData.diag.u8RadioStatus & START_INIT_RADIO) == START_INIT_RADIO)
  {
    initRadio();                // init radio 
  }
}
#endif

/*************************************************************************
*  Function: Radio interface functions               Date: 24-March-2015 *
*________________________________________________________________________*
*                                                                        *
*************************************************************************/
tU16 radioInterfaceFunc(COMM_ENV *portCtrl)
{
  //tReturnStatus errCode;
  RADIO_HOST_CMD cmdInPtr;
  RADIO_PRO_RESP rspOutPtr;
  tU8 indexfunc;
 
  // modbus structure saem as other function, such as CHART REPLACEMENT
  cmdInPtr.u8CmdLength  = u8MDRequest[portCtrl->u8PortID][MD_CHART_LENGTH_AT];
  cmdInPtr.u8CmdCode    = u8MDRequest[portCtrl->u8PortID][MD_CHART_CMD_AT];
  cmdInPtr.u8CmdDataPtr = &u8MDRequest[portCtrl->u8PortID][MD_CHART_CMD_DATA_ST];
  // Modbus use same buffer for Rx and Tx, Tx data is start from 5th byte, Rx data start from 3rd byte
  // Note: use Rx data first before making reponse data
  rspOutPtr.u8ChartRspDataPtr   = &u8MDResponseBuf[portCtrl->u8PortID][MD_CHART_RSP_DATA_ST];

  indexfunc = cmdInPtr.u8CmdCode;
  
  __no_operation();
   
  //u8MdChangeTx = 1;   // change from comm port for Radio
  // The host other CMD process
  (void)defineRadioFunc[indexfunc].radioFuncPtr(&cmdInPtr, &rspOutPtr);

  // Format Modbus response wrapper BSL response information
  u8MDResponseBuf[portCtrl->u8PortID][MD_CHART_ADDRESS_AT]  = infoA.comm.u8ModbusAddr;
  u8MDResponseBuf[portCtrl->u8PortID][MD_CHART_FUNC_AT]     = MD_CMD_FC67;
  rspOutPtr.u8ChartRspLength++;   // 1 bytes, what CMD processed inside function69
  u8MDResponseBuf[portCtrl->u8PortID][MD_CHART_LENGTH_AT]   = rspOutPtr.u8ChartRspLength;  
  u8MDResponseBuf[portCtrl->u8PortID][MD_CHART_RSP_CMD_AT]  = cmdInPtr.u8CmdCode;
  // return the response total bytes
  return ((tU16)(rspOutPtr.u8ChartRspLength + CHART_OVER_HAND_BYTE));  
}

static tU8 radioSpaceHolder(RADIO_HOST_CMD *cmdInPtr, RADIO_PRO_RESP *rspOutPtr)
{
  tU8 u8ErrCode = PASSED;
    __no_operation();
  return u8ErrCode;
}

static tU8 rdRadioTxMsg(RADIO_HOST_CMD *cmdInPtr, RADIO_PRO_RESP *rspOutPtr)
{
  tU8 u8ErrCode = PASSED;
   
  memmove(rspOutPtr->u8ChartRspDataPtr,  &WirelessApiMsg.StartDelimiter, RADIO_MSG_LENTH);
  rspOutPtr->u8ChartRspDataPtr += RADIO_MSG_LENTH;
  rspOutPtr->u8ChartRspLength = RADIO_MSG_LENTH;

  __no_operation();
  return u8ErrCode;  
}

static tU8 wtRadioStart(RADIO_HOST_CMD *cmdInPtr, RADIO_PRO_RESP *rspOutPtr)
{
  tU8 u8ErrCode = PASSED;
  if(((*cmdInPtr->u8CmdDataPtr) & USER_OPERATE_RADIO) == USER_OPERATE_RADIO)
  {
    sysRamData.diag.u8RadioStatus |= (tU8)USER_OPERATE_RADIO;
  }
  else
  {
    sysRamData.diag.u8RadioStatus &= (tU8)(~USER_OPERATE_RADIO);  
  }
  
  if(((*cmdInPtr->u8CmdDataPtr) & TX_MSG_FLASH_LCD) == TX_MSG_FLASH_LCD)
  {
    sysRamData.diag.u8RadioStatus |= (tU8)TX_MSG_FLASH_LCD;
  }
  else
  {
    sysRamData.diag.u8RadioStatus &= (tU8)(~TX_MSG_FLASH_LCD);  
  }

  rspOutPtr->u8ChartRspLength = 0;
#ifdef __JT808_MSP430F5438A__
  addOneTypeExchg(TYPE_DIAG);  //5438A use it 
#endif
  __no_operation();
  return u8ErrCode;  
}

static tU8 wtRadioTxInterval(RADIO_HOST_CMD *cmdInPtr, RADIO_PRO_RESP *rspOutPtr)
{
  union {
    tU8  u8Data[4];
    tU32 u32Data;
  }u32CvtU8;
  
  tU8 u8ErrCode = PASSED;
  u32CvtU8.u8Data[3] = *cmdInPtr->u8CmdDataPtr++;
  u32CvtU8.u8Data[2] = *cmdInPtr->u8CmdDataPtr++;
  u32CvtU8.u8Data[1] = *cmdInPtr->u8CmdDataPtr++;
  u32CvtU8.u8Data[0] = *cmdInPtr->u8CmdDataPtr++;
  
  info5638D.u32RadioTxInterval = u32CvtU8.u32Data;
  rspOutPtr->u8ChartRspLength = 0;
#ifdef __MSP430F5638__
  //u32TxInterval = info5638D.u32RadioTxInterval;
#endif  

#ifdef __JT808_MSP430F5638__
  u8OtherTaskScheduler |= DYNAMIC_WT_IMFOD;  // do EEP section A write process  
#else
  addOneTypeExchg(TYPE_INFO5638D);  // 5438A use it
#endif  
  __no_operation();
  return u8ErrCode;    
}

static tU8 rdRadioStatus(RADIO_HOST_CMD *cmdInPtr, RADIO_PRO_RESP *rspOutPtr)
{
  tU8 u8ErrCode = PASSED;
  
  *rspOutPtr->u8ChartRspDataPtr = sysRamData.diag.u8RadioStatus;
  rspOutPtr->u8ChartRspDataPtr++;
  rspOutPtr->u8ChartRspLength = 1;
  
  __no_operation();
  return u8ErrCode;    
}

static tU8 rdRadioTxInterval(RADIO_HOST_CMD *cmdInPtr, RADIO_PRO_RESP *rspOutPtr)
{
  tU8 i;
  union 
  {
    tU8  u8Temp[4];
    tU32 u32Temp;
  } U32toU8;
  tU8 u8ErrCode = PASSED;
  
  U32toU8.u32Temp = chartRecEnv.u32TotalRecord; //info5638D.u32RadioTxInterval;
  for(i = 0; i < SIZEOF_U32; i++)
  {
    *rspOutPtr->u8ChartRspDataPtr = U32toU8.u8Temp[i]; // low to hi bytes, bytes index = 0, 1, 2, 3, order
    rspOutPtr->u8ChartRspDataPtr++;
  }
 
  rspOutPtr->u8ChartRspDataPtr++; 
  rspOutPtr->u8ChartRspLength = RD_NUM_REC_LENGTH; // same as Chart Replacement
  __no_operation();
  return u8ErrCode;    
}

static tU8 rdRadioRxDEstinatId(RADIO_HOST_CMD *cmdInPtr, RADIO_PRO_RESP *rspOutPtr)
{
  tU8 i;
  union 
  {
    tU8  u8Temp[4];
    tU32 u32Temp;
  } U32toU8;
  tU8 u8ErrCode = PASSED;
  
  U32toU8.u32Temp = info5638D.u32RadioTxInterval;
  for(i = 0; i < SIZEOF_U32; i++)
  {
    *rspOutPtr->u8ChartRspDataPtr = U32toU8.u8Temp[i]; // low to hi bytes, bytes index = 0, 1, 2, 3, order
    rspOutPtr->u8ChartRspDataPtr++;
  }
 
  rspOutPtr->u8ChartRspDataPtr++; 
  rspOutPtr->u8ChartRspLength = RD_NUM_REC_LENGTH; // same as Chart Replacement
  __no_operation();
  return u8ErrCode;    
}

static tU8 doRadioApiInit(RADIO_HOST_CMD *cmdInPtr, RADIO_PRO_RESP *rspOutPtr)
{
  tU8 u8ErrCode = PASSED;
  if(((*cmdInPtr->u8CmdDataPtr) & START_INIT_RADIO) == START_INIT_RADIO)
  {
    sysRamData.diag.u8RadioStatus |= (tU8)START_INIT_RADIO;
    sysRamData.diag.u8RadioStatus &= (tU8)~RADIO_CHIP_UNINSTALL;
  }
  
#ifdef __JT808_MSP430F5438A__
  addOneTypeExchg(TYPE_DIAG);  //5438A use it 
#endif
  __no_operation();
  return u8ErrCode;      
}

/*************************************************************************
*  end Radio interface functions                                         *
*        Xuedong Liu                                                     *
*************************************************************************/


