//=============================================================================
// Header: startUsbPortCtrl.c
// Date Time: 2/13/2013 1:59 PM
// Author: Xuedong.Liu
//
//
// Description: The feature board set MSP UART for network communication.
//     the network port has driver MAX3471EUA chip.
//     local and network port can active same time. Network port supports Modbus
//     and BASP protocol, it should able to support HART, but it is not required
//
//     USB port after init or reinit, it wait for interrupt come in
//     then it start from detect protocol to layer 2 or 3, then
//     from RTS timer intrrupt ro send response
//=============================================================================
// constant definitions, type definitions
#include "masterHeader.h"

// global volatile variables
#include "externGlobalVar.h"

// global function prototypes definitions:
#include "externFunc.h"

// local static variables
static COMM_ENV usbEnv,
                *portEnv;
// local function prototype definitions:
static void forceUSBPortRestart(void);
static void forceUsbProtocolsInit(void);

// global & local function implementation
COMM_ENV *getUsbPortEnv(void)
{
  return &usbEnv;
}

static void forceUsbProtocolsInit(void)
{
  portEnv = getUsbPortEnv();
  forceUSBPortRestart();
  // reinit protocols
  systemInitMd(portEnv);
  //systemInitHART(portEnv);
  systemInitBSAP(portEnv);
  // char-to-chat timer already off
}

static void forceUSBPortRestart(void)
{
  portEnv = getUsbPortEnv();         // USB on MSP430F5638 use same env control
  portEnv->u8IncomePtr = 0;                                      // incoming char counter set to zero
  portEnv->u8LookCharPtr = 0;                                    // looked char set to zero
  portEnv->u8IncomePtr = portEnv->u8LookCharPtr = 0;
  portEnv->u8RxCharTimeOutStatus = 0;
  portEnv->u8DriverStatus = 0;
  //memset(u8CommInbuf[portEnv->u8PortID], 0x00, RX_BUF_SIZE);     // buffer set to all zero
  memset(u8MDRxTxTempBuf[2], 0x00, MAX_MSG_SIZE);
  portEnv->u8TxStatus = 0;
}

//==============================================================================
// init from kernel
//==============================================================================
void JtUsbInit(void)
{
    portEnv = &usbEnv;
    portEnv->u8PortID = USB_PORTIN;
    forceUsbProtocolsInit();    // init HART, Modbus, BASP protocol commnicaiton
}

static tU8 u8flag;
void setChartFlag(tU8 flag)
{
  u8flag = flag;
}
tU8 readChartDmaFlag(void)
{
  return u8flag;
}
//==============================================================================
// FUNCTION: initDmaTxCtrl, start send response use USB background function
//==============================================================================
void initDmaTxCtrl(tU8 *u8CommTxBuf, tU16 u16TxSize)
{
    tU8 u8retry;
    tU16 usbTxSize;
    tU8  sendState;
    usbTxSize = u16TxSize;
    memmove(u8MDRxTxTempBuf[USB_PORTIN], u8CommTxBuf, u16TxSize);
    __no_operation();             // For debugger only, use for UAB
    do 
    {
      // send modbus response through the USB port
      u8retry++;
      sendState = cdcSendDataInBackground(
        (BYTE*)u8MDRxTxTempBuf[USB_PORTIN],     // modbus response buffer
        usbTxSize,                              // number bytes need to send out
        CDC0_INTFNUM,                           // to which interface number
        0);                                     // what is send timeout time
      if(sendState != 0)
      {
        __no_operation(); 
      }
    } while ((sendState != 0) && (u8retry < 2));
   
    if(u8flag == BIT0)
    {
      // sendState is zero 
      u8flag |= BIT2;                          // done Tx
    }
    else
    {
      forceUsbProtocolsInit();                    // init HART, Modbus, BASP protocol commnicaiton
      __no_operation();                           // For debugger only, use for UAB
      sendState++;
    }
    
    if((sysRamData.diag.u16XmtStatus[3] & ADC5638_START_ON) != ADC5638_START_ON)
    {
      // has request from USB, can start ADC
      //u8Layer1TaskScheduler |= START_MSP_ADC;
    }
}

//=============================================================================
// end file by xuedong
//=============================================================================
