/****************************************************************************************
 * Copyright:  	GoldenMaple Technologies (C) 2016
 * Project:		EECS X497.34 Course Project
 * File Name:	Lab7.c
 * Description:	main entry, device init, app init, and backgraound functions
 * Language:    TMS320F2806xM C
 * Author:		Louis Zhu
 * Created:		12/12/2014
 * Mod History: V1.0: Initial version developed on F28069ControlStick platform
 * 				V1.1: Modified for LaunchXL-F28069M LaunchPad
 ****************************************************************************************/

/****************************************************
 * include header files
 ****************************************************/
//----------------------------------------
// BIOS header files
//----------------------------------------
#include <xdc/std.h>  						// mandatory - have to include first, for BIOS types
#include <ti/sysbios/BIOS.h> 				// mandatory - if you call APIs like BIOS_start()
#include <xdc/runtime/Log.h>				// for Log_info() calls when UIA is added
#include <xdc/cfg/global.h> 				// header file for statically defined objects/handles

#include "F2806x_Device.h"
#include "F2806x_SysCtrl.h"
#include "F2806x_Gpio.h"
#include "LedDrv.h"
#include "F2806x_Flash.h"
#include "F2806x_Adc.h"
#include "TempMonitor.h"

//-----------------------------------------
// Private Function Prototypes
//-----------------------------------------
void InitDevice(void);
void InitApp(void);
void Delay(int count);
void ToggleLED(void);

//-----------------------------------------
// Global Variables
//-----------------------------------------
volatile int toggleCount = 0;

#define MAX_ADC_VALUE	4095

/*******************************************************************************************
 * Function: main
 *
 * Description: This is the C entry function that initializes hardware and application modules.
 *
 * Parameters: None
 *
 * Returns: None
 *
 * Special Notes:
 *
 *******************************************************************************************/
void main(void)
{
	InitDevice();
	InitApp();

	BIOS_start();					// Start BIOS Scheduler
}

/*******************************************************************************************
 * Function: InitDevice
 *
 * Description: This function initializes system clock and the peripheral modules on the device.
 *
 * Parameters: None
 *
 * Returns: None
 *
 * Special Notes:
 *
 *******************************************************************************************/
void InitDevice(void)
{
	InitSystemClock(CPU_80MHz);
	InitGpio();
	InitAdc();

	// Copy time critical code and Flash setup code to RAM
	memcpy(&RamfuncsRunStart, &RamfuncsLoadStart, (unsigned long)&RamfuncsLoadSize);
	// Call Flash Initialization to setup flash wait states
	// This function must reside in RAM
	InitFlash();
}

/*******************************************************************************************
 * Function: InitApp
 *
 * Description: This function initializes application specific functions.
 *
 * Parameters: None
 *
 * Returns: None
 *
 * Special Notes:
 *
 *******************************************************************************************/
void InitApp(void)
{

}

/*******************************************************************************************
 * Function: Delay
 *
 * Description: This function runs a delay loop per input parameter.
 *
 * Parameters: None
 *
 * Returns: None
 *
 * Special Notes:
 *
 *******************************************************************************************/
void Delay(int count)
{
	volatile int i, j;

	for (i = 0; i < count; i++)
	{
		for (j = 0; j < 5000; j++);
	}
}

/*******************************************************************************************
 * Function: ToggleLED
 *
 * Description: This function toggles LED D9 with the frequency per temperature.
 *
 * Parameters: None
 *
 * Returns: None
 *
 * Special Notes:
 *
 *******************************************************************************************/
void ToggleLED(void)
{
	Uint16 tempCount;

	ConvertTemp();
	DisplayD9(LED_BLINK);				// toggle D9
	tempCount = GetTempRawData();
	Delay(MAX_ADC_VALUE - tempCount);		// LED brink frequency depends on temperature

	toggleCount += 1;										// keep track of #toggles

	Log_info1("LED TOGGLED [%u] TIMES", toggleCount);		// send #toggles to Log display
}
