/****************************************************************************************
 * Copyright:  	GoldenMaple Technologies (C) 2016
 * Project:		EECS X497.34 Course Project
 * File Name:	F2806x_Flash.c
 * Description:	F2806x Device Flash Driver Functions
 * Language:    TI TMS320F2806x C
 * Author:		Louis Zhu
 * Created:		9/15/2013
 * Notes:
 * Mod History: V1.0: Initial version developed on F28069ControlStick platform
 * 				V1.1: Modified for LaunchXL-F28069M LaunchPad
 ****************************************************************************************/

#include "F2806x_Flash.h"

/****************************************************
 * #pragma section
 ****************************************************/

#pragma CODE_SECTION(InitFlash, "ramFuncs")
#pragma DATA_SECTION(FlashRegs, "FlashRegsFile");

/****************************************************
 * variable declaration
 ****************************************************/
volatile struct FLASH_REGS FlashRegs;

/**********************************************************************
 * Function: InitFlash()
 *
 * Description: Initializes the F2806x flash timing registers
 *
 * Parameters: None
 *
 * Returns: None
 *
 * Notes:
 *  1) This function MUST be executed out of RAM.  Executing it out of
 *     OTP/FLASH will produce unpredictable results.
 *  2) The flash registers are code security module protected.  Therefore,
 *     you must either run this function from secure RAM (L0),
 *     or you must first unlock the CSM.  Note that unlocking the CSM as
 *     part of the program flow can compromise the code security.
 *  3) The wait-states configured below are for 80 MHz operation.  The
 *     latest datasheet for the particular device of interest should
 *     be consulted to confirm the flash timing specifications.
 **********************************************************************/
void InitFlash(void)
{
	EALLOW;													// Enable EALLOW protected register access
	FlashRegs.FPWR.bit.PWR = FPWR_ACTIVE_MODE;				// Pump and bank set to active mode
	FlashRegs.FSTATUS.bit.V3STAT = 1;						// Clear the 3VSTAT bit
	FlashRegs.FBANKWAIT.bit.RANDWAIT = RANDWAIT_INIT;		// Random access waitstates
	FlashRegs.FBANKWAIT.bit.PAGEWAIT = PAGEWAIT_INIT;		// Paged access waitstates
	FlashRegs.FOTPWAIT.bit.OTPWAIT = OTPWAIT_INIT;			// OTP waitstates
	FlashRegs.FOPT.bit.ENPIPE = 1;							// Enable the flash pipeline
	EDIS;													// Disable EALLOW protected register access

	// Force a complete pipeline flush to ensure that the write to the last register
	// configured occurs before returning.  Safest thing is to wait 8 full cycles.
    asm(" RPT #8 || NOP");
}

//--- end of file -----------------------------------------------------
