


#include "cpu1_board.h"
#include <string.h>

/**
 * main.c
 */
uint32_t main(void)
{

    Device_init();

#ifdef _FLASH
    Device_bootCM(BOOTMODE_BOOT_TO_FLASH_SECTOR0);
#endif

    Interrupt_initModule();
    Interrupt_initVectorTable();

    Board_init();

    GPIO_writePin(mGPIO_PIN_LED4, 1);
    DEVICE_DELAY_US(1000000);
    GPIO_writePin(mGPIO_PIN_LED4, 0);
    DEVICE_DELAY_US(1000000);
    GPIO_writePin(mGPIO_PIN_LED4, 1);
    DEVICE_DELAY_US(1000000);
    GPIO_writePin(mGPIO_PIN_LED4, 0);
    DEVICE_DELAY_US(1000000);
    GPIO_writePin(mGPIO_PIN_LED4, 1);
    DEVICE_DELAY_US(1000000);
    GPIO_writePin(mGPIO_PIN_LED4, 0);

    EINT;
    ERTM;

    IPC_clearFlagLtoR(IPC_CPU1_L_CM_R, IPC_FLAG_ALL);

    // jump to CPU1_APP
    GPIO_writePin(mGPIO_PIN_LED4, 1);
    asm("    LB 0x088000");

//  return 0;
    while(1)
    {

        GPIO_writePin(mGPIO_PIN_LED4, 1);
        DEVICE_DELAY_US(500000);
        GPIO_writePin(mGPIO_PIN_LED4, 0);
        DEVICE_DELAY_US(500000);
    }
}




