
#include "cpu1_board.h"

//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules.
// Call this function in your application if you wish to do all module
// initialization.
// If you wish to not use some of the initializations, instead of the
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
    EALLOW;

    PinMux_init();
    GPIO_init();
    IPC_SYSCFG_init();

    EDIS;
}

//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{
    // GPIO145 -> LED5 Pinmux
    GPIO_setPinConfig(mGPIO_LED5_GPIO_PIN_CONFIG);
    // GPIO146 -> LED4 Pinmux
    GPIO_setPinConfig(mGPIO_LED4_GPIO_PIN_CONFIG);
    // GPIO147 -> LED12 Pinmux
    GPIO_setPinConfig(mGPIO_LED12_GPIO_PIN_CONFIG);
}


//*****************************************************************************
//
// GPIO Configurations
//
//*****************************************************************************
void GPIO_init(){
    mGPIO145_init();
    mGPIO146_init();
    mGPIO147_init();
}

void mGPIO145_init(){
    GPIO_setPadConfig(mGPIO_PIN_LED5, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(mGPIO_PIN_LED5, GPIO_QUAL_SYNC);
    GPIO_setDirectionMode(mGPIO_PIN_LED5, GPIO_DIR_MODE_OUT);
//    GPIO_setControllerCore(mGPIO_PIN_LED5, GPIO_CORE_CPU1_CLA1);
//    GPIO_setControllerCore(mGPIO_PIN_LED5, GPIO_CORE_CPU2);
    GPIO_setControllerCore(mGPIO_PIN_LED5, GPIO_CORE_CM);

//    GPIO_writePin(mGPIO_PIN_LED5, 0);
}
void mGPIO146_init(){
    GPIO_setPadConfig(mGPIO_PIN_LED4, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(mGPIO_PIN_LED4, GPIO_QUAL_SYNC);
    GPIO_setDirectionMode(mGPIO_PIN_LED4, GPIO_DIR_MODE_OUT);
    GPIO_setControllerCore(mGPIO_PIN_LED4, GPIO_CORE_CPU1);
//    GPIO_setControllerCore(mGPIO_PIN_LED4, GPIO_CORE_CPU1);
//    GPIO_setControllerCore(mGPIO_PIN_LED4, GPIO_CORE_CPU2);
//    GPIO_setControllerCore(mGPIO_PIN_LED4, GPIO_CORE_CPU1_CLA1);

//    GPIO_writePin(mGPIO_PIN_LED4, 0);
}
void mGPIO147_init(){
    GPIO_setPadConfig(mGPIO_PIN_LED12, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(mGPIO_PIN_LED12, GPIO_QUAL_SYNC);
    GPIO_setDirectionMode(mGPIO_PIN_LED12, GPIO_DIR_MODE_OUT);
    GPIO_writePin(mGPIO_PIN_LED12, 0);  		// led12Ϊ͵ƽЧ
    GPIO_setControllerCore(mGPIO_PIN_LED12, GPIO_CORE_CPU1);
}

void ETHERNET_init(){
    myETHERNET0_init();
}

void myETHERNET0_init(){
    //--------------------------------controlCARD--------------------------------------//
    //
    //Power down pin to bring the external PHY out of Power down
    //
    GPIO_setDirectionMode(108, GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(108, GPIO_PIN_TYPE_PULLUP);
    GPIO_writePin(108,1);

    //
    //PHY Reset Pin to be driven High to bring external PHY out of Reset
    //

    GPIO_setDirectionMode(119, GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(119, GPIO_PIN_TYPE_PULLUP);
    GPIO_writePin(119,1);

    //---------------------------------------------------------------------------------//
}

//*****************************************************************************
//
// IPC Configurations
//
//*****************************************************************************
void IPC_SYSCFG_init(){
    //
    // Paste the following line in your main() function after device_init, if you would like CPU2 to boot
    // Device_bootCPU2(BOOT_MODE_CPU2);
    //
}

//void IPC





