/* 
 *  28x specific Task example.
 *  
 *  This example:
 * 
 *  1) prints "Hello world" in main().
 *  
 *  2) increments a counter within a timer interrupt.
 * 
 *  3) every 10 timer interrupts, the timer interrupt handler
 *     posts a semaphore to awaken a task to perform additional
 *     work. 
 * 
 *  4) prints "10 ticks" from within the task function awakened 
 *     each time 10 interrupts have been serviced.
 * 
 *  All output is routed to a log buffer which can be viewed
 *  using the RTA "Raw Logs" viewer. After loading and running
 *  the application, launch the Tools->RTA->Raw Logs tool to
 *  view the logs.
 */

#include "driverlib.h"
#include "device.h"
//#include <xdc/std.h>
//#include <xdc/runtime/Log.h>
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/knl/Semaphore.h>
#include <ti/sysbios/family/c28/Hwi.h>

//#include "cpsFIFO.h"
//#include <xdc/runtime/Error.h>
//#include <xdc/runtime/System.h>

// Prototype statements for functions found within this file.
interrupt void sciaTxFifoIsr(void);
interrupt void sciaRxFifoIsr(void);
void scia_fifo_init(void);

static uint16_t tickCount = 0;
/*
 *  ======== main ========
 */
Int main()
{
    /*
     * Print "Hello world" to a log buffer. 
     */
    //Log_info0("Hello world\n");
    // Step 2. Initialize GPIO:
    // This example function is found in the F2837xD_Gpio.c file and
    // illustrates how to set the GPIO to it's default state.
    //SysCtl_disableWatchdog();
    Device_enableAllPeripherals();

    //
    // Interrupts that are used in this example are re-mapped to
    // ISR functions found within this file.

    //
    // GPIO43 is the SCI Rx pin.
    //
    GPIO_setMasterCore(43, GPIO_CORE_CPU1);
    GPIO_setPinConfig(GPIO_43_SCIRXDA);
    GPIO_setDirectionMode(43, GPIO_DIR_MODE_IN);
    GPIO_setPadConfig(43, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(43, GPIO_QUAL_ASYNC);

    //
    // GPIO42 is the SCI Tx pin.
    //
    GPIO_setMasterCore(42, GPIO_CORE_CPU1);
    GPIO_setPinConfig(GPIO_42_SCITXDA);
    GPIO_setDirectionMode(42, GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(42, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(42, GPIO_QUAL_ASYNC);
    scia_fifo_init();
    //Interrupt_enable(INT_SCIA_RX);
    //Interrupt_enable(INT_SCIA_TX);
    Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP9);

    /* 
     * Start BIOS.
     * Begins task scheduling.
     */
    BIOS_start();    /* does not return */
    return(0);
}

void myTickFxn(void)
{
    tickCount++;
}

void delay(Uint32 n)
{
    while(n--)
        __asm("nop");
}

void sciaTaskFnx()
{
    int len = 4;
    Uint16 data[4];
    //hwSerialPortInit(SCIA_COM0);
    while(1)
    {
        DEVICE_DELAY_US(1000*2);
    }
}

interrupt void sciaTxFifoIsr(void)
{
    //UARTTxISR(SCIA_COM0);
    Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP9);
}

interrupt void sciaRxFifoIsr(void)
{
    uint16_t rDataA = 0;
    //UARTRxISR(SCIA_COM0);
    if(SCI_isDataAvailableNonFIFO(SCIA_BASE))
    {
        SCI_readCharArray(SCIA_BASE, &rDataA, 1);
    }
    SCI_clearOverflowStatus(SCIA_BASE);
    SCI_clearInterruptStatus(SCIA_BASE, SCI_INT_RXRDY_BRKDT);
    Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP9);
}

void scia_fifo_init()
{
    //
    // 8 char bits, 1 stop bit, no parity. Baud rate is 115200.
    //
    SCI_setConfig(SCIA_BASE, DEVICE_LSPCLK_FREQ, 115200, (SCI_CONFIG_WLEN_8 |
                                                        SCI_CONFIG_STOP_ONE |
                                                        SCI_CONFIG_PAR_NONE));
    SCI_enableModule(SCIA_BASE);
    SCI_resetChannels(SCIA_BASE);
    SCI_enableInterrupt(SCIA_BASE, (SCI_INT_RXRDY_BRKDT | SCI_INT_TXRDY));
    SCI_disableInterrupt(SCIA_BASE, SCI_INT_RXERR);
    SCI_performSoftwareReset(SCIA_BASE);
}
