/*
 * S2E_Packet.h
 *
 *  Created on: 2014. 3. 20.
 *      Author: Raphael
 */

#ifndef __CONFIGDATA_H__
#define __CONFIGDATA_H__

#include <stdint.h>
#include "wizchip_conf.h"

#define TCP_CLIENT_MODE		0
#define TCP_SERVER_MODE		1
#define TCP_MIXED_MODE		2
#define UDP_MODE			3
#define PASS_LEN 			10
#define NAME_LEN 			25

#define MAJOR_VER           1
#define MINOR_VER           2
#define MAINTENANCE_VER     3

enum baud {
	baud_300 = 300,
	baud_600 = 600,
	baud_1200 = 1200,
	baud_2400 = 2400,
	baud_4800 = 4800,
	baud_9600 = 9600,
	baud_19200 = 19200,
	baud_38400 = 38400,
	baud_57600 = 57600,
	baud_115200 = 115200,
	baud_230400 = 230400
};

enum word_len {
	word_len7 = 7,
	word_len8 = 8,
	word_len9 = 9
};

enum stop_bit {
	stop_bit1 = 1,
	stop_bit2 = 2
};

enum parity {
	parity_none = 0,
	parity_odd = 1,
	parity_even = 2
};

enum flow_ctrl {
	flow_none = 0,
	flow_rts_cts = 1,
	flow_rs422 = 2,
	flow_rs485 = 3,
};

enum net_state {
	net_disconnect = 0,
	net_connect = 1,
	net_udp = 2
};

struct __network_info_common {
	uint8_t mac[6];
	uint8_t local_ip[4];
	uint8_t gateway[4];
	uint8_t subnet[4];
};

struct __network_info {
	uint8_t working_mode;
	uint8_t state;	// TCP Not Connected, Connected, UDP
	uint8_t remote_ip[4];			// Must Be 4byte Alignment
	uint32_t local_port;
	uint32_t remote_port;

	uint32_t inactivity;
	uint32_t reconnection;

	uint32_t packing_time;	// 0~65535
	uint8_t packing_size;		// 0~255
	uint8_t packing_delimiter[4];
	uint8_t packing_delimiter_length;	// 0~4
	uint8_t packing_data_appendix;	// 0~2
};

struct __serial_info {
    int32_t baud_rate;	// Baud Rate
	uint8_t data_bits;	// 7, 8, 9 and more?
	uint8_t parity;			// None, odd, even
	uint8_t stop_bits;	// 1, 1.5, 2
	uint8_t flow_control;	// None, RTS/CTS, XON/XOFF, DST/DTR, RTS Only for RS422/485
};

struct __options {
	char pw_setting[PASS_LEN];
	char pw_connect[PASS_LEN];

	uint8_t dhcp_use;

	uint8_t dns_use;
	uint8_t dns_server_ip[4];
	char dns_domain_name[50];

	uint8_t serial_command;			// Serial Command Mode
	uint8_t serial_trigger[3];		// Serial Command Mode Trigger
};

typedef struct __S2E_Packet {
	uint32_t packet_size; // 2byte
	uint8_t module_type[3]; // 3byte
	uint8_t module_name[NAME_LEN]; // 25byte
	uint8_t fw_ver[3];			// Major Version . Minor Version . Maintenance Version // 3byte
	struct __network_info_common network_info_common; // 18byte
	struct __network_info network_info[1]; // 23byte
	struct __serial_info serial_info[1]; // 6byte
	struct __options options; // 80byte
} S2E_Packet;

/////////////////////////////////////////////////////////////////////////////////
// GetInfo
struct __network_info2 {
    uint8_t working_mode;
    uint8_t state;  // TCP Not Connected, Connected, UDP
    uint8_t remote_ip[4];           // Must Be 4byte Alignment
    uint8_t local_port[2];
    uint8_t remote_port[2];

    uint8_t inactivity[2];
    uint8_t reconnection[2];

    uint8_t packing_time[2];  // 0~65535
    uint8_t packing_size;       // 0~255
    uint8_t packing_delimiter[4];
    uint8_t packing_delimiter_length;   // 0~4
    uint8_t packing_data_appendix;  // 0~2
};

struct __serial_info2 {
    uint8_t baud_rate[4]; // Baud Rate
    uint8_t data_bits;  // 7, 8, 9 and more?
    uint8_t parity;         // None, odd, even
    uint8_t stop_bits;  // 1, 1.5, 2
    uint8_t flow_control;   // None, RTS/CTS, XON/XOFF, DST/DTR, RTS Only for RS422/485
};

typedef struct __S2E_Packet2 {
    uint8_t packet_size[2]; // 2byte
    uint8_t module_type[3]; // 3byte
    uint8_t module_name[NAME_LEN]; // 25byte
    uint8_t fw_ver[3];          // Major Version . Minor Version . Maintenance Version // 3byte
    struct __network_info_common network_info_common; // 18byte
    struct __network_info2 network_info[1]; // 23byte
    struct __serial_info2 serial_info[1]; // 6byte
    struct __options options; // 80byte
} S2E_Packet2;

S2E_Packet* get_S2E_Packet_pointer();
void set_S2E_Packet_to_getinfo_value();
void set_S2E_Packet_to_factory_value();
void load_S2E_Packet_from_storage();
void save_S2E_Packet_to_storage();
void get_S2E_Packet_value(void *dest, const void *src, uint16_t size);
void set_S2E_Packet_value(void *dest, const void *value, const uint16_t size);
void set_S2E_Packet(wiz_NetInfo *net);
void get_S2E_Packet(wiz_NetInfo *net);

void display_Net_Info();
void Mac_Conf();
void Net_Conf();
void set_dhcp_mode();
void set_static_mode();
void set_mac(uint8_t *mac);
void check_mac_address();

#endif /* S2E_PACKET_H_ */
