/*
 * PhoenixonControls_AD5293.h
 *
 *  Created on: 2018. 5. 20.
 *      Author: BGKim
 */

#ifndef PHOENIXON_CONTROLS_CPU_INCLUDE_PHOENIXONCONTROLS_AD5293_H_
#define PHOENIXON_CONTROLS_CPU_INCLUDE_PHOENIXONCONTROLS_AD5293_H_

#define AD5293_DIGIT		1024
#define AD5293_RESOLUTION	(97)//(100000 / AD5293_DIGIT)
#define AD5293_MAX_VLAUE	(1023)

#define AD5293_MASTER_RADY 			DSP_GPIO14_I_MASTER_RDAC_RDY()
#define AD5293_SLAVE_RADY			DSP_GPIO15_I_SLAVE_RDAC_RDY()

#define AD5293_MASTER_RESET_SET 	DSP_GPIO89_O_MASTER_RDAC_N_RESET_SET()
#define AD5293_MASTER_CS_SET	 	DSP_GPIO90_O_MASTER_RDAC_N_CS_SET()
#define AD5293_SLAVE_RESET_SET  	DSP_GPIO91_O_SLAVE_RDAC_N_RESET_SET()
#define AD5293_SLAVE_CS_SET	 		DSP_GPIO93_O_SLAVE_RDAC_N_CS_SET()
#define AD5293_MASTER_RESET_CLEAR  	DSP_GPIO89_O_MASTER_RDAC_N_RESET_CLEAR()
#define AD5293_MASTER_CS_CLEAR	 	DSP_GPIO90_O_MASTER_RDAC_N_CS_CLEAR()
#define AD5293_SLAVE_RESET_CLEAR	DSP_GPIO91_O_SLAVE_RDAC_N_RESET_CLEAR()
#define AD5293_SLAVE_CS_CLEAR	  	DSP_GPIO93_O_SLAVE_RDAC_N_CS_CLEAR()

#define AD5293_COMMMAND_NOP					0
#define AD5293_COMMMAND_WRITE_DATA			1
#define AD5293_COMMMAND_READ_DATA			2
#define AD5293_COMMMAND_RESET				4
#define AD5293_COMMMAND_WRITE_CONTROL		6
#define AD5293_COMMMAND_READ_CONTROL		7
#define AD5293_COMMMAND_POWER_DOWN	 		8

#define AD5293_CONTROL_REGISTER_BASE		0x0
#define AD5293_CONTROL_REGISTER_D1			0x2
#define AD5293_CONTROL_REGISTER_D2			0x4
#define AD5293_CONTROL_REGISTER_D0			0x0
#define AD5293_WRITE(X)				{DSP_SpiWrite(X);}
#define AD5293_READ(X)				{DSP_SpiRead(X);}
typedef enum
{
	AD5293_MASTER,
	AD5293_SLAVE,
	AD5293_ALL,
}E_AD5293_CHANNEL_SELECT;

void AD5293_Init(void);
void AD5293_Reset(E_AD5293_CHANNEL_SELECT Channel);
Uint16 AD5293_BusyCheck(E_AD5293_CHANNEL_SELECT Channel);
Uint16 AD5293_Write(E_AD5293_CHANNEL_SELECT Channel, Uint16 Command, Uint16 Data);
Uint16 AD5293_Read(E_AD5293_CHANNEL_SELECT Channel, Uint16 *Command, Uint16 *Data);

#endif /* PHOENIXON_CONTROLS_CPU_INCLUDE_PHOENIXONCONTROLS_AD5293_H_ */
