/*
 * PhoenixonControls_SCI.h
 *
 *  Created on: 2018. 5. 20.
 *      Author: BGKim
 */

#ifndef PHOENIXON_CONTROLS_CPU_INCLUDE_PHOENIXONCONTROLS_SCI_H_
#define PHOENIXON_CONTROLS_CPU_INCLUDE_PHOENIXONCONTROLS_SCI_H_

//#define DSP_SCIA_BAUD  5921600 // bps
#define DSP_SCIA_BAUD  115200 // bps
// SCI Asynchronous Baud = LSPCLK / ((BRR + 1) *8)
// BRR = LSPCLK / (SCI Asynchronous Baud * 8) - 1


#define DSP_SCIA_MAX_FIFO_LENGTH				(16)
#define DSP_SCIA_START_FLAG						(0xAAAA)
#define DSP_SCIA_START_FLAG_LENGTH 				(3)
#define DSP_SCIA_START_CHEANNEL_INDEX_LENGTH 	(2)
#define DSP_SCIA_HEADER_LENGTH					(DSP_SCIA_START_FLAG_LENGTH + DSP_SCIA_START_CHEANNEL_INDEX_LENGTH)
#define DSP_SCIA_CRC16_LENGTH 					(1)

#ifdef	INTERFACE_CPU1
#define DSP_SCIA_TX_DATA_LENGTH					(sizeof(S_COMMUNICATION_GSRAM_CPU1))
#define DSP_SCIA_RX_DATA_LENGTH					(sizeof(S_COMMUNICATION_GSRAM_CPU2))
#endif

#ifdef	INTERFACE_CPU2
#define DSP_SCIA_TX_DATA_LENGTH					(sizeof(S_COMMUNICATION_GSRAM_CPU1))
#define DSP_SCIA_RX_DATA_LENGTH					(sizeof(S_COMMUNICATION_GSRAM_CPU2))
#endif

#ifdef	DEVICE_CPU1
#define DSP_SCIA_TX_DATA_LENGTH					(sizeof(S_COMMUNICATION_GSRAM_CPU2))
#define DSP_SCIA_RX_DATA_LENGTH					(sizeof(S_COMMUNICATION_GSRAM_CPU1))
#endif

#ifdef	DEVICE_CPU2
#define DSP_SCIA_TX_DATA_LENGTH					(sizeof(S_COMMUNICATION_GSRAM_CPU2))
#define DSP_SCIA_RX_DATA_LENGTH					(sizeof(S_COMMUNICATION_GSRAM_CPU1))
#endif

#define DSP_SCIA_TX_TOTAL_LENGTH				(DSP_SCIA_HEADER_LENGTH + DSP_SCIA_TX_DATA_LENGTH + DSP_SCIA_CRC16_LENGTH)
#define DSP_SCIA_RX_TOTAL_LENGTH				(DSP_SCIA_HEADER_LENGTH + DSP_SCIA_RX_DATA_LENGTH + DSP_SCIA_CRC16_LENGTH)

#define DSP_SCIA_TX_DUMY						(0xBBBB)
#define DSP_SCIA_TX_DUMY_LENGTH					((DSP_SCIA_TX_TOTAL_LENGTH % DSP_SCIA_MAX_FIFO_LENGTH) + DSP_SCIA_MAX_FIFO_LENGTH)
#define DSP_SCIA_RX_DUMY_LENGTH					((DSP_SCIA_RX_TOTAL_LENGTH % DSP_SCIA_MAX_FIFO_LENGTH) + DSP_SCIA_MAX_FIFO_LENGTH)

#define DSP_SCIA_TX_MAX_DATA_LENGTH	 			(DSP_SCIA_TX_TOTAL_LENGTH + DSP_SCIA_TX_DUMY_LENGTH)
#define DSP_SCIA_RX_MAX_DATA_LENGTH 			(DSP_SCIA_RX_TOTAL_LENGTH + DSP_SCIA_RX_DUMY_LENGTH)

#define DSP_SCIA_TX_MAX_BUFFER_LENGTH 			(DSP_SCIA_TX_MAX_DATA_LENGTH * 2)
#define DSP_SCIA_RX_MAX_BUFFER_LENGTH			(DSP_SCIA_RX_MAX_DATA_LENGTH * 2)

#define DSP_SCIA_MAX_RETRY_COUNT 				(2)


typedef enum
{
	SCIA_CHANNEL1,
	SCIA_CHANNEL2,
	SCIA_CHANNEL3,
	SCIA_CHANNEL4,
	SCIA_NULL,
}E_DSP_SCIA_CHANNEL;

typedef enum
{
	SCIA_INIT,
	SCIA_ERROR_DATA,
	SCIA_ERROR_CRC16,
	SCIA_ERROR_CHANNEL,
	SCIA_SUCCESS,

}E_DSP_SCIA_FLAG;

typedef struct
{
	Uint16 Head;
	Uint16 Tail;
	Uint16 Count;
}S_DSP_SCIA_RINGBUFFER_FILE;

void DSP_SCIA_Init(void);
void DSP_SCIA_Put(volatile Uint16 Data);
void DSP_SCIA_TX_Enable(void);
void DSP_SCIA_TX_Disable(void);
void DSP_SCIA_Write(volatile Uint16 *Data, Uint32 Length);
Uint16 DSP_SCIA_Get(void);
void DSP_SCIA_Read(Uint16 *Data, Uint32 Length);
void DSP_SCIA_TxStart(void);

void DSP_SCIABufferClear(S_DSP_SCIA_RINGBUFFER_FILE *s_File);
Uint32 DSP_SCIABufferGetSize(S_DSP_SCIA_RINGBUFFER_FILE *s_File, Uint32 MaxBufferLength);
Uint32 DSP_SCIABufferPut(S_DSP_SCIA_RINGBUFFER_FILE *s_File, Uint32 MaxBufferLength);
Uint32 DSP_SCIABufferGet(S_DSP_SCIA_RINGBUFFER_FILE *s_File, Uint32 MaxBufferLength);
E_DSP_SCIA_FLAG DSP_SCIA_RxUpDate(volatile Uint16 *Data, volatile Uint16 *Buff, volatile Uint16 *Count, volatile Uint16 *Channel);

__interrupt void DSP_SCIA_RX_ISR(void);
__interrupt void DSP_SCIA_TX_ISR(void);

#endif /* PHOENIXON_CONTROLS_CPU_INCLUDE_PHOENIXONCONTROLS_SCI_H_ */
