/*
 * PhoenixonControls_SENSING.h
 *
 *  Created on: 2018. 5. 20.
 *      Author: BGKim
 */

#ifndef PHOENIXON_CONTROLS_CPU_INCLUDE_PHOENIXONCONTROLS_SENSING_H_
#define PHOENIXON_CONTROLS_CPU_INCLUDE_PHOENIXONCONTROLS_SENSING_H_

#define SENSING_TEMPERATUER_SLOPE		(float)(0.01)
#define SENSING_TEMPERATURE_AD8226_GAIN (float)(2.717)

#define HIGH_BIAS_GAIN			(float)(2.0)
#define LOW_BIAS_GAIN			(float)(2.0)


#define	SENSING_VOLTAGE_GAIN						(float)((float)(1.0) / CONTROL_VOLTAGE_GAIN)
#define	SENSING_CURRENT_GAIN						(float)((float)(1.0) / CONTROL_CURRENT_GAIN)
#define	SENSING_FINE_CURRENT_GAIN					(float)((float)(1.0) / CONTROL_FINE_CURRENT_GAIN)
#define	SENSING_NEGATIVE_15V_POWER_GAIN				(float)(-10.0)
#define	SENSING_MASTER_REFERENCE_CURRENT_GAIN		(float)(SENSING_CURRENT_GAIN * (float)(2.0))
#define	SENSING_SLAVE_REFERENCE_CURRENT_GAIN		(float)(SENSING_CURRENT_GAIN * (float)(2.0))
#define	SENSING_TEMPERATURE_GAIN					(float)((float)(1.0) / (SENSING_TEMPERATUER_SLOPE * SENSING_TEMPERATURE_AD8226_GAIN))
#define	SENSING_GROUND_POWER_GAIN					(float)(2.0)
#define	SENSING_NEGATIVE_02V_POWER_GAIN				(float)(2.0)
#define	SENSING_POSITIVE_07V_POWER_GAIN				(float)(3.35)//((float)(1.0) /(float)(0.2985074626)) //Vin = 7V, R1 = 470k, R2 = 200k, R2/(R1+R2) * Vin = Vout
#define	SENSING_POSITIVE_05V_POWER_GAIN				(float)(2.0)
#define	SENSING_POSITIVE_15V_POWER_GAIN				(float)(10.0)//((float)(1.0) /(float)(0.1)) //Vin = 15V, R1 = 90k, R2 = 10k, R2/(R1+R2) * Vin = Vout

typedef enum
{
	SENSING_EMERGENCY_ON,
	SENSING_EMERGENCY_OFF,
}E_SENSING_EMERGENCY;

typedef struct
{
	float ADC[9];
	float ExternalADC[8];

}S_SENSING_ADC_RESULT_ARRAY_DATA;

typedef struct
{
	float SENSING_BatteryVoltage;
	float SENSING_Current;
	float SENSING_CurrentMaster;
	float SENSING_MASTERCurrentA;
	float SENSING_MASTERCurrentB;
	float SENSING_CurrentSlave;
	float SENSING_SLAVECurrent_A;
	float SENSING_SLAVECurrent_B;
	float SENSING_ReferenceVoltage;
	float SENSING_MasterReferenceFineCurrent;
	float SENSING_SlaveReferenceFineCurrent;
	float SENSING_Negative15VPower;
	float SENSING_MasterReferenceCurrent;
	float SENSING_SlaveReferenceCurrent;
	float SENSING_Temperature;
	float SENSING_InnerBatteryVoltage;
	float SENSING_Negative02VPower;
	float SENSING_Positive07VPower;
	float SENSING_Positive_05V_POWER;
	float SENSING_Positive_15V_POWER;




}S_SENSING_ADC_RESULT_DATA;

typedef enum
{
	SENSING_BATTERY_VOLTAGE,
	SENSING_MASTER_CURRENT_A,
	SENSING_MASTER_CURRENT_B,
	SENSING_SLAVE_CURRENT_A,
	SENSING_SLAVE_CURRENT_B,
	SENSING_REFERENCE_VOLTAGE,
	SENSING_MASTER_REFERENCE_FINE_CURRENT,
	SENSING_SLAVE_REFERENCE_FINE_CURRENT,
}E_SENSING_EXTERNAL_ADC;

typedef enum
{
	SENSING_NEGATIVE_15V_POWER,
	SENSING_MASTER_REFERENCE_CURRENT,
	SENSING_SLAVE_REFERENCE_CURRENT,
	SENSING_TEMPERATURE,
	SENSING_GROUND_POWER,
	SENSING_NEGATIVE_02V_POWER,
	SENSING_POSITIVE_07V_POWER,
	SENSING_POSITIVE_05V_POWER,
	SENSING_POSITIVE_15V_POWER,
}E_SENSING_ADC;



void SENSING_Init(void);
E_SENSING_EMERGENCY SENSING_Emergency(void);
Uint16 SENSING_ADC(S_SENSING_ADC_RESULT_ARRAY_DATA *s_ResultData);
Uint16 SENSING_ADCResultData(S_SENSING_ADC_RESULT_DATA *s_ResultData);

#endif /* PHOENIXON_CONTROLS_CPU_INCLUDE_PHOENIXONCONTROLS_SENSING_H_ */
