/*
 * NewFile.c
 *
 *  Created on: 2018. 5. 28.
 *      Author: BGKim
 */
#include "../../../common/include/F28x_Project.h"
#include "../../../common/include/driverlib.h"
#include "../../../common/include/device.h"
#include "../include/PhoenixonControls_FPU.h"
#include "socket.h"
#include "wizchip_conf.h"
#include "W5300_types.h"

extern volatile S_COMMUNICATION_GSRAM_CPU1 s_CPU_1_GSRAM[];
extern volatile S_COMMUNICATION_GSRAM_CPU2 s_CPU_2_GSRAM[];
extern volatile S_COMMUNICATION_DRAM *s_SDRAMp[];
extern volatile Uint16 ui_Updateflag;
Uint16 tx_mem_conf[8] = {16,4,4,8,8,8,8,8};          // for setting TMSR regsiter
Uint16 rx_mem_conf[8] = {16,4,4,8,8,8,8,8};          // for setting RMSR regsiter

Uint16 mem_pause[20] = {16464,10,1,1,2,16464,10,2,1,2,16464,10,4,1,2,16464,10,8,1,2};

uint8_t *ETHERNET_RxBuffer = (uint8_t *)ETHERNET_RX_BUFFER_ADDRESS;         // buffer for EthernetRx data
uint8_t *ETHERNET_TxBuffer = (uint8_t *)ETHERNET_TX_BUFFER_ADDRESS;         // buffer for EthernetRx data
Uint16 ip[4] = {192,168,1,50};                   // for setting SIP register
Uint16 gw[4] = {192,168,0,1};                     // for setting GAR register
Uint16 sn[4] = {255,255,255,0};                     // for setting SUBR register
Uint16 mac[6] = {0x00,0x08,0xDC,0x00,111,COMMUNICATION_ETHERNET_MAC};      // for setting SHAR register

Uint16 serverip[4] = {192,168,0,112};              // "TCP SERVER" IP address for loopback_tcpc()
extern volatile Uint16 ui_TimerFlag500ms;

#ifdef _DEBUG
Uint16 DEBUG_EthernetState = 0;
#endif//_DEBUG END

wiz_NetInfo gWIZNETINFO = {
  { 0x00, 0x08, 0xdc, 0x11, 0x22, 0x33 },             // Mac address
  { 192, 168, 0, 2 },                               // IP address
  { 192, 168, 0, 1},                                  // Gateway
  { 255, 255, 255, 0},                                // Subnet mask
  { 8, 8, 8, 8},                                      // DNS Server
};

static void ETHERNET_Net_Info(void);

void ETHERNET_Init(void)
{
    uint8_t memsize[2][8] = { { 8, 8, 8, 8, 8, 8, 8, 8 }, { 8, 8, 8, 8, 8, 8, 8, 8 } };

    // HW RESET
    GpioDataRegs.GPACLEAR.bit.GPIO14 = 1;
    DELAY_US(2);
    GpioDataRegs.GPASET.bit.GPIO14 = 1;
    DELAY_US(100000);

    /* wizchip initialize*/
    if (ctlwizchip(CW_INIT_WIZCHIP, (void*) memsize) == -1)
    {
        while (1)
            ;
    }

    if (ctlnetwork(CN_SET_NETINFO, (void*) &gWIZNETINFO) == -1)
    {
        while (1)
            ;
    }

    ETHERNET_Net_Info();
}

void ETHERNET_Net_Info(void)
{
    static wiz_NetInfo g_net_info;

    ctlnetwork(CN_GET_NETINFO, (void*) &g_net_info);
}


/**
 * "TCP SERVER" loopback program.
 */
Uint16 ETHERNET_TCPs(uint8_t s, Uint16 port, Uint16 mode, uint8_t* rxbuf, uint8_t* txbuf,
        volatile S_COMMUNICATION_DRAM **sp_IF, volatile S_COMMUNICATION_GSRAM_CPU1 *sp_GSRAM_CPU1,
          volatile S_COMMUNICATION_GSRAM_CPU2 *sp_GSRAM_CPU2)
{
#if 1
   volatile static Uint16 HeaderFlag    = 0;
//   volatile static Uint16 *p_SDRAM;
   volatile static Uint16 DATACount     = 0;
   volatile static Uint16 RXCount       = 0;
   volatile static Uint16 CHANNEL       = 0;
   volatile static Uint16 HEADER        = 0;

   volatile static Uint16 ui_Pauseflag  = CLEAR;

   uint32_t len;
   int i;

   switch(getSn_SR(s))                // check SOCKET status
   {                                   // ------------
      case SOCK_ESTABLISHED:           // ESTABLISHED?

         ui_Pauseflag = CLEAR;

         if(getSn_IR(s) & Sn_IR_CON)   // check Sn_IR_CON bit
         {
            //printf("%d : Connect OK\r\n",s);
#ifdef _DEBUG
             DEBUG_EthernetState = SET;
#endif//_DEBUG END
             setSn_IR(s,Sn_IR_CON);     // clear Sn_IR_CON
         }

         if((len=getSn_RX_RSR(s)) > 0) // check the size of received data
         {
             //Ÿ  κ (from PC)
            len = recv(s,rxbuf, len);     // recv

            if((rxbuf[0] == HEADER_DATA  || rxbuf[0] == HEADER_JUMP || rxbuf[0] == HEADER_COMMAND ||
               rxbuf[0] == HEADER_START || rxbuf[0] == HEADER_END  || rxbuf[0] == HEADER_PAUSE   ||
               rxbuf[0] == HEADER_ALARM) && HEADER == CLEAR) HEADER = rxbuf[0];

            switch(HEADER)
            {
            case HEADER_DATA    : HEADER = COMMUNICATION_Ethernet_STEPRead(sp_IF, (Uint16*)rxbuf, len); // @D
                break;
            case HEADER_JUMP    : HEADER = COMMUNICATION_Ethernet_JUMPRead(sp_GSRAM_CPU1, sp_GSRAM_CPU2, (Uint16*)rxbuf, len); // @J
            send(s,rxbuf,len);// send
                break;
            case HEADER_COMMAND : HEADER = COMMUNICATION_Ethernet_COMMANDRead(sp_GSRAM_CPU1, sp_GSRAM_CPU2, (Uint16*)rxbuf, len); // @C
            send(s,rxbuf,len);// send
                break;
            case HEADER_START   : HEADER = COMMUNICATION_Ethernet_STARTRead(sp_GSRAM_CPU1, sp_GSRAM_CPU2, (Uint16*)rxbuf, len); // @S
            send(s,rxbuf,len);// send
                break;
            case HEADER_PAUSE   : HEADER = COMMUNICATION_Ethernet_PAUSERead(sp_GSRAM_CPU1, sp_GSRAM_CPU2, (Uint16*)rxbuf, len); // @P
            send(s,rxbuf,len);// send
                break;
            }
            len = 0;
         }
         //Ÿ ۽ κ (to PC)
         // Ϸ ǰ ð 500ms̸̻ ۽.
         if(HEADER == CLEAR && ui_Updateflag == SET)// && ui_TimerFlag500ms)
         {
            ui_TimerFlag500ms = CLEAR;
            len = COMMUNICATION_Ethernet_DATAWrite(sp_IF, (Uint16*)txbuf); // @D TO ETHERNET
//            f_mount(0, &g_sFatFs1); // Mount check
//            f_open(&g_sFileObject1, "0:/1.txt", FA_CREATE_ALWAYS | FA_WRITE); // create Example.txt file
//            f_write(&g_sFileObject1, txbuf, sizeof(txbuf)*2, (void *) &byteswrite); // Write message
//            for(i=0;i<sizeof(txbuf);i++)
//            {
//                f_printf(&g_sFileObject1,"%x,",txbuf[i]);
//            }
//            f_close(&g_sFileObject1);
            if(len)send(s,txbuf,len);// DATA send

            len = COMMUNICATION_Ethernet_ENDWrite(sp_GSRAM_CPU1, sp_GSRAM_CPU2, (Uint16*)txbuf); // @E TO ETHERNET
            if(len)send(s,txbuf,len);// END send

            len = COMMUNICATION_Ethernet_ALARMWrite(sp_GSRAM_CPU1, sp_GSRAM_CPU2, (Uint16*)txbuf); // @A TO ETHERNET
            if(len)send(s,txbuf,len);// ALARM send
            ui_Updateflag = CLEAR;
         }
         break;
                                       // ---------------
   case SOCK_CLOSE_WAIT:               // PASSIVE CLOSED
       disconnect(s);                // disconnect
         break;
                                       // --------------
   case SOCK_CLOSED:                   // CLOSED
       close(s);                        // close the SOCKET
       socket(s,Sn_MR_TCP,port,mode);   // open the SOCKET
#ifdef _DEBUG
       DEBUG_EthernetState = CLEAR;
#endif//_DEBUG END
      break;
                                       // ------------------------------
   case SOCK_INIT:                     // The SOCKET opened with TCP mode
       listen(s);                       // listen to any connection request from "TCP CLIENT"
      break;

   case SOCK_LISTEN:
       if(ui_Pauseflag == CLEAR){
           COMMUNICATION_Ethernet_PAUSERead(sp_GSRAM_CPU1, sp_GSRAM_CPU2, mem_pause, 40);
           ui_Pauseflag = SET;
       }
       break;
   default:
      break;
   }
   return (HEADER);
#endif
}

//
// End of file
//
