
MEMORY
{
PAGE 0 :
   /* BEGIN is used for the "boot to SARAM" bootloader mode   */

   BEGIN           	: origin = 0x080000, length = 0x000002
   RAMM0           	: origin = 0x000080, length = 0x000380
   /*RAMD0           	: origin = 0x00B000, length = 0x000800*/
   RAMLS0_S5          	: origin = 0x008000, length = 0x004000
   /*RAMLS1          	: origin = 0x008800, length = 0x000800*/
  /* RAMLS2      		: origin = 0x009000, length = 0x000800*/
   /*RAMLS3      		: origin = 0x009800, length = 0x000800*/
   /*RAMLS4      		: origin = 0x00A000, length = 0x000800*/
   /*RAMGS8_12          : origin = 0x014000, length = 0x005000*/
   /*RAMGS14          : origin = 0x01A000, length = 0x001000*/     /* Only Available on F28379D, F28377D, F28375D devices. Remove line on other devices. */
   RAMGS15          : origin = 0x01B000, length = 0x001000     /* Only Available on F28379D, F28377D, F28375D devices. Remove line on other devices. */
   RESET       		: origin = 0x3FFFC0, length = 0x000002

   /* Flash sectors */
   FLASHA           : origin = 0x080002, length = 0x001FFE	/* on-chip Flash */
   FLASHB           : origin = 0x082000, length = 0x002000	/* on-chip Flash */
   FLASHC           : origin = 0x084000, length = 0x002000	/* on-chip Flash */
   FLASHD           : origin = 0x086000, length = 0x002000	/* on-chip Flash */
   FLASHE           : origin = 0x088000, length = 0x008000	/* on-chip Flash */
   FLASHF           : origin = 0x090000, length = 0x008000	/* on-chip Flash */
   FLASHG           : origin = 0x098000, length = 0x008000	/* on-chip Flash */
   FLASHH           : origin = 0x0A0000, length = 0x008000	/* on-chip Flash */
   FLASHI           : origin = 0x0A8000, length = 0x008000	/* on-chip Flash */
   FLASHJ           : origin = 0x0B0000, length = 0x008000	/* on-chip Flash */
   FLASHK           : origin = 0x0B8000, length = 0x002000	/* on-chip Flash */
   FLASHL           : origin = 0x0BA000, length = 0x002000	/* on-chip Flash */
   FLASHM           : origin = 0x0BC000, length = 0x002000	/* on-chip Flash */
   FLASHN           : origin = 0x0BE000, length = 0x002000	/* on-chip Flash */

PAGE 1 :

   BOOT_RSVD       : origin = 0x000002, length = 0x00007E     /* Part of M0, BOOT rom will use this for stack */
   RAMM1           : origin = 0x000400, length = 0x000400     /* on-chip RAM block M1 */
   /*RAMD0D1           : origin = 0x00B000, length = 0x001000*/

   /*RAMLS345          : origin = 0x009800, length = 0x001800*/
   RAMGS8_10          : origin = 0x014000, length = 0x003000
   RAMGS11_12          : origin = 0x017000, length = 0x002000
   RAMGS13_14      : origin = 0x019000, length = 0x002000
   RAMGS0          : origin = 0x00C000, length = 0x001000
   RAMGS1          : origin = 0x00D000, length = 0x001000
   CPU2TOCPU1RAM   : origin = 0x03F800, length = 0x000400
   CPU1TOCPU2RAM   : origin = 0x03FC00, length = 0x000400
}

SECTIONS
{
   /* Allocate program areas: */
   .cinit              : > FLASHB ,    PAGE = 0, ALIGN(4)
   .pinit              : > FLASHB,     PAGE = 0, ALIGN(4)
   .text               : > FLASHF       PAGE = 0, ALIGN(4)
   codestart           : > BEGIN       PAGE = 0, ALIGN(4)
   /* wddisable		: > FLASHA,		PAGE = 0*/		/* Used by file CodeStartBranch.asm */
  	/*copysections	: > FLASHA,		PAGE = 0*/		/* Used by file SectionCopy.asm */

   /* Allocate uninitalized data sections: */
   .stack              : > RAMM1        PAGE = 1
   .ebss               : >RAMGS8_10,       PAGE = 1
   .esysmem            : > RAMGS11_12       PAGE = 1
   .sysmem             : > RAMGS13_14       PAGE = 1
   /* Initalized sections go in Flash */
   .econst             : > FLASHC      PAGE = 0, ALIGN(4)
   .switch             : > FLASHB      PAGE = 0, ALIGN(4)


   .reset           : > RESET,     PAGE = 0, TYPE = DSECT /* not used, */

   SHARERAMGS0		: > CPU2TOCPU1RAM,		PAGE = 1
   SHARERAMGS1		: > CPU1TOCPU2RAM,		PAGE = 1


  GROUP
    {
        ramfuncs
        { -l F021_API_F2837xD_FPU32.lib}

    } LOAD = FLASHF,
      RUN  = RAMLS0_S5 ,
      LOAD_START(_RamfuncsLoadStart),
      LOAD_SIZE(_RamfuncsLoadSize),
      LOAD_END(_RamfuncsLoadEnd),
      RUN_START(_RamfuncsRunStart),
      RUN_SIZE(_RamfuncsRunSize),
      RUN_END(_RamfuncsRunEnd),
      PAGE = 0

}

/*
//===========================================================================
// End of file.
//===========================================================================
*/
