//###########################################################################
// FILE:   emif1_16bit_asram.c
// TITLE:  EMIF1 module accessing 16bit ASRAM.
//
//! \addtogroup cpu01_example_list
//! <h1> EMIF ASYNC module (emif1_16bit_asram)</h1>
//!
//! This example configures EMIF1 in 16bit ASYNC mode
//! This example uses CS2 as chip enable.
//!
//! \b Watch \b Variables: \n
//! - \b TEST_STATUS - Equivalent to \b TEST_PASS if test finished correctly,
//!                    else the value is set to \b TEST_FAIL
//! - \b ErrCount - Error counter
//!
//
//
//###########################################################################
// $TI Release: F2837xD Support Library v190 $
// $Release Date: Mon Feb  1 16:51:57 CST 2016 $
// $Copyright: Copyright (C) 2013-2016 Texas Instruments Incorporated -
//             http://www.ti.com/ ALL RIGHTS RESERVED $
//###########################################################################

#include "F28x_Project.h"     // Device Headerfile and Examples Include File
#include "F2837xD_Ipc_drivers.h"
#include "F2837xD_SWPrioritizedIsrLevels.h"

#include "ecat_def.h"
#include "mailbox.h"
#include "ecatslv.h"
//#include "GQY_user_define.h"
//#include "modbus.h"
#define    _EL9800HW_ 1
#include "el9800hw.h"
#undef    _EL9800HW_
#define    _EL9800HW_ 0

#include "ecatappl.h"
#include "coeappl.h"//ӣ0x2200,0x2210

#define TEST_PASS 0xABCDABCD
#define TEST_FAIL 0xDEADDEAD

#define ASRAM_CS2_START_ADDR  0x100000
#define ASRAM_CS2_SIZE 0x014//0x8000

//extern void setup_emif1_pinmux_async_16bit(Uint16);
__interrupt void xint2_ET1100_IRQ_isr(void);
__interrupt void xint3_ET1100_SYNC0_isr(void);
__interrupt void cpu_timer0_isr(void);
//##########EMIF1-32bit ASRAM test ######################

#define EMIF1 0
#define EMIF2 1

#define MEM_D_WIDTH 		0//1 			// 16Bit Memory Interface //8bit data
#define TURN_AROUND_TIME 	1//0			// Turn Around time of 2 Emif Clock
#define RD_SETUP_TIME 		0			// Read Setup time of 1 Emif Clock
#define RD_STROBE_TIME 		3			// Read Strobe time of 4 Emif Clock
#define RD_HOLD_TIME 		0			// Read Hold time of 1 Emif Clock
#define WR_SETUP_TIME 		0			// Write Hold time of 1 Emif Clock
#define WR_STROBE_TIME 		0			// Write Setup time of 1 Emif Clock
#define WR_HOLD_TIME 		0			// Write Hold time of 1 Emif Clock
#define EXTEND_WAIT 		0			// Disable Extended Wait
#define STROBE_SEL 			0			// Disable Strobe Mode.
#define WAIT_POLAR_INV 		0
#define WAIT_COUNT 			0

//uint16_t c2_r_w_array[256];   // mapped to GS1 of shared RAM owned by CPU02
//uint16_t c2_r_array[256];     // mapped to GS0 of shared RAM owned by CPU01
//#pragma DATA_SECTION(c2_r_array,"SHARERAMGS1");
//#pragma DATA_SECTION(c2_r_w_array,"SHARERAMGS0");
//extern uint16_t isrfuncLoadStart;
//extern uint16_t isrfuncLoadEnd;
//extern uint16_t isrfuncRunStart;
//extern uint16_t isrfuncLoadSize;
#if(1)
 //===========ramfuns===============//
//    extern Uint16 RamfuncsLoadStart;
//    extern Uint16 RamfuncsLoadEnd;
//    extern Uint16 RamfuncsRunStart;
//    extern Uint16 RamfuncsLoadSize;
  //===========.econst===============//
//    extern Uint16 econst_loadstart;//ƺcmdļͬȥcmdļеĿͷ_»߼ɡ
//    extern Uint16 econst_size;
//    extern Uint16 econst_runstart;
    //===========.switch===============//
//    extern Uint16 switch_loadstart;
//    extern Uint16 switch_size;
//    extern Uint16 switch_runstart;
    //===========.cinit===============//
//    extern Uint16 cinit_loadstart;
//    extern Uint16 cinit_size;
//    extern Uint16 cinit_runstart;
    //===========.text===============//
    extern Uint16 text_loadstart;
    extern Uint16 text_size;
    extern Uint16 text_runstart;
//    //===========.codestart===============//
//    extern Uint16 CodestartLoadStart;
//    extern Uint16 CodestartLoadSize;
//    extern Uint16 CodestartRunStart;
#endif
// Prototype statements for functions found within this file.


//__interrupt void cpu_timer0_isr(void);
#if(FLASH)
#pragma CODE_SECTION(cpu_timer0_isr,"ramfuncs");
#pragma CODE_SECTION(xint2_ET1100_IRQ_isr,"ramfuncs");
#pragma CODE_SECTION(xint3_ET1100_SYNC0_isr,"ramfuncs");
#pragma CODE_SECTION(HW_EscReadIsrDummy,"ramfuncs");
#pragma CODE_SECTION(HW_EscWriteIsrDummy,"ramfuncs");
#pragma CODE_SECTION(HW_EscReadIsr,"ramfuncs");
#pragma CODE_SECTION(HW_EscWriteIsr,"ramfuncs");
#pragma CODE_SECTION(ISR_GetInterruptRegister,"ramfuncs");
#pragma CODE_SECTION(HW_GetALEventRegister_Isr,"ramfuncs");

#pragma CODE_SECTION(HW_EscRead,"ramfuncs");
#pragma CODE_SECTION(HW_EscWrite,"ramfuncs");
#pragma CODE_SECTION(HW_ResetALEventMask,"ramfuncs");
#pragma CODE_SECTION(HW_SetALEventMask,"ramfuncs");
#pragma CODE_SECTION(HW_DisableSyncManChannel,"ramfuncs");
#pragma CODE_SECTION(HW_EnableSyncManChannel,"ramfuncs");
#pragma CODE_SECTION(HW_GetSyncMan,"ramfuncs");
#pragma CODE_SECTION(GetInterruptRegister,"ramfuncs");
#pragma CODE_SECTION(HW_GetALEventRegister,"ramfuncs");
//#pragma CODE_SECTION(HW_Init,"ramfuncs");
#endif

Uint16  ErrCount = 0;
Uint32  TEST_STATUS;
UINT16         EscALEvent;            //contains the content of the ALEvent register (0x220), this variable is updated on each Access to the Esc
UINT16            nAlEventMask;        //current ALEventMask (content of register 0x204:0x205)
UINT16 EscALEventRXdata[2];

TSYNCMAN        TmpSyncMan;

int i;


void HW_ResetALEventMask(UINT16 intMask)
{
    UINT16 mask;

    HW_EscReadWord(mask, ESC_AL_EVENTMASK_OFFSET);

/*Slave Stack Code Tool :(#if BIG_ENDIAN_FORMAT) lines 701 to 703 deleted*/
    mask &= intMask;
   // DISABLE_AL_EVENT_INT;
    DINT;
/*Slave Stack Code Tool :(#if BIG_ENDIAN_FORMAT) lines 708 to 710 deleted*/
    HW_EscWriteWord(mask, ESC_AL_EVENTMASK_OFFSET);
    HW_EscReadWord(nAlEventMask, ESC_AL_EVENTMASK_OFFSET);
    //ENABLE_AL_EVENT_INT;
    EINT;
}

/////////////////////////////////////////////////////////////////////////////////////////
/**
 \param    intMask        interrupt mask (enabled interrupt shall be one)

  \brief    This function makes an logical or with the AL Event Mask register (0x204)
*////////////////////////////////////////////////////////////////////////////////////////
void HW_SetALEventMask(UINT16 intMask)
{
    UINT16 mask;

    HW_EscReadWord(mask, ESC_AL_EVENTMASK_OFFSET);

/*Slave Stack Code Tool :(#if BIG_ENDIAN_FORMAT) lines 730 to 732 deleted*/
    mask |=intMask;
    //DISABLE_AL_EVENT_INT;
    DINT;
/*Slave Stack Code Tool :(#if BIG_ENDIAN_FORMAT) lines 737 to 739 deleted*/
    HW_EscWriteWord(mask, ESC_AL_EVENTMASK_OFFSET);
    HW_EscReadWord(nAlEventMask, ESC_AL_EVENTMASK_OFFSET);
    //ENABLE_AL_EVENT_INT;
    EINT;
}
#if 0
static void AddressingEsc( UINT16 Address, UINT8 Command )
   {

   }
static void ISR_AddressingEsc( UINT16 Address, UINT8 Command )
{

}
#endif
//*****************************************************************************
//
// This function performs simple read/write word accesses to memory.
//
//*****************************************************************************
void HW_EscRead(MEM_ADDR *pRxData, UINT16 start_addr, UINT16 len)
{
    Uint16 *pTmpData = (Uint16 *)pRxData;
    Uint16 *XMEM_ps;
    Uint16 Dummydata;
    Uint16 i=0;

    for(i=0;i<len/2;i++)
    {
    	XMEM_ps = (Uint16 *)(start_addr/2+i+ASRAM_CS2_START_ADDR);//28377EMIFʼַ0x100000
        Dummydata = *XMEM_ps;
//        Dummydata = *XMEM_ps;
        *pTmpData++ = Dummydata;//SWAP_WORD
    }

}
#if 0
void HW_EscReadWord1(MEM_ADDR *pRXData, UINT16 start_addr)
{
	Uint16 valueL=0;
	Uint16 valueH=0;
	Uint16* pDummy= (Uint16 *)pRXData;
//	Uint16  tempdata;
	HW_EscRead(((MEM_ADDR *)&(valueL)), ((UINT16)(start_addr)), 2);
	HW_EscRead(((MEM_ADDR *)&(valueH)), ((UINT16)(start_addr+1)), 2);
	*pDummy= (valueL&0xff)+ (valueH<<8);
}
#endif

void HW_EscReadIsr( MEM_ADDR *pRXData, UINT16 Address, UINT16 Len )
{
    Uint16 *pTmpData = (Uint16 *)pRXData;
    Uint16 *XMEM_ps;
    Uint16 Dummydata;
    Uint16 i=0;
   DINT;
    for(i=0;i<Len/2;i++)
    {
		XMEM_ps = (Uint16 *)(Address/2+i+ASRAM_CS2_START_ADDR);//28377EMIFʼַ0x100000
		Dummydata = *XMEM_ps;
//		Dummydata = *XMEM_ps;
		*pTmpData++ = Dummydata;//SWAP_WORD()
    }
    EINT;
}

//===============Ĵ=============//
void HW_EscReadIsrDummy( MEM_ADDR *pRXData, UINT16 Address, UINT16 Len )
{
    Uint16 *pTmpData = (Uint16 *)pRXData;
    volatile Uint16 *XMEM_ps;
    Uint16 Dummydata[60]={0};
    Uint16 i=0;
    Uint16 j=0;

    XMEM_ps = (volatile Uint16 *)(Address/2+ASRAM_CS2_START_ADDR);//28377EMIFʼַ0x100000
    for(i=0;i<Len/2;i++)
    {
//		XMEM_ps= (volatile char *)(Address/2+i+ASRAM_CS2_START_ADDR);
//		Dummydata[j++] = *(XMEM_ps+i);
		Dummydata[j] =   *(XMEM_ps+i);

		*pTmpData++ = (Dummydata[j] & 0x00ff);
		*pTmpData++ = ((Dummydata[j]>>8 )&0x00ff);
    }
	Dummydata[j] =   *(XMEM_ps+i);

	*pTmpData++ = (Dummydata[j] & 0x00ff);
	*pTmpData++ = ((Dummydata[j]>>8 )&0x00ff);
}
void HW_EscWrite(MEM_ADDR *pTxData, UINT16 start_addr, UINT16 len)
{
    Uint16 *XMEM_ps;
    Uint16 i=0;

    for(i=0;i<len/2;i++)
    {
    	XMEM_ps = (Uint16 *)(start_addr/2+i+ASRAM_CS2_START_ADDR);//28377EMIFʼַ0x100000
//    	SET_IO2;
        *XMEM_ps++ = *pTxData++;
//        RESET_IO2;
    }

}

void HW_EscWriteIsr( MEM_ADDR *pTXData, UINT16 Address, UINT16 Len )
{
    Uint16 *XMEM_ps;
    Uint16 i=0;
  DINT;
    for(i=0;i<Len/2;i++)
    {
    	XMEM_ps = (Uint16 *)(Address/2+i+ASRAM_CS2_START_ADDR);//28377EMIFʼַ0x100000
        *XMEM_ps++ = *pTXData++;
    }
   EINT;
}

void HW_EscWriteIsrDummy( MEM_ADDR *pTXData, UINT16 Address, UINT16 Len )
{
	volatile Uint16 *XMEM_ps;
    Uint16 DummyH;
    Uint16 DummyL;
    Uint16 i=0;

    XMEM_ps = (volatile Uint16 *)(Address/2+ASRAM_CS2_START_ADDR);//28377EMIFʼַ0x100000
    for(i=0;i<(Len+1)/2;i++)
    {
    	DummyL = (*pTXData++ & 0x00ff);
    	DummyH = *pTXData<<8;
//    	SET_IO2;
        *(XMEM_ps + i) = DummyL+DummyH;
//        RESET_IO2;
        pTXData++;
    }

}

void HW_DisableSyncManChannel(UINT8 channel)
   {
    Uint16 Offset;
    volatile Uint16 smStatus;
/*Slave Stack Code Tool :(#if ESC_32BIT_ACCESS) lines 984 to 1002 deleted*/
    //The register 0x806 is only readable from PDI => writing 0 is valid
/*ECATCHANGE_START(V5.10) HW4*/
    Offset = (ESC_SYNCMAN_ACTIVE_OFFSET + (SIZEOF_SM_REGISTER*channel));//0x807ͷļĴд01ֹ8SMͨ
    do
    {
    smStatus = SM_SETTING_PDI_DISABLE;
    smStatus = SWAPWORD(smStatus);
/*ECATCHANGE_END(V5.10) HW4*/


    HW_EscWriteWord(smStatus,Offset);

    /*wait until SyncManager is disabled*/

        HW_EscReadWord(smStatus, Offset);
/*ECATCHANGE_START(V5.10) HW4*/
        smStatus = SWAPWORD(smStatus);
/*ECATCHANGE_END(V5.10) HW4*/
    }while(!(smStatus & SM_SETTING_PDI_DISABLE));//ȷ1Ƿд뵽Ĵ
   }

/////////////////////////////////////////////////////////////////////////////////////////
/**
 \param     channel        Sync Manager channel

 \brief    This function enables a Sync Manager channel
*////////////////////////////////////////////////////////////////////////////////////////
void HW_EnableSyncManChannel(UINT8 channel)
{
    UINT16 Offset;
/*Slave Stack Code Tool :(#if ESC_32BIT_ACCESS) lines 1045 to 1062 deleted*/
    //The register 0x806 is only readable from PDI => writing 0 is valid
/*ECATCHANGE_START(V5.10) HW4*/
    volatile UINT16 smStatus = 0x0000;
/*ECATCHANGE_END(V5.10) HW4*/
    Offset = (ESC_SYNCMAN_ACTIVE_OFFSET + (SIZEOF_SM_REGISTER*channel));

    HW_EscWriteWord(smStatus,Offset);

    /*wait until SyncManager is enabled*/
    do
    {
        HW_EscReadWord(smStatus,Offset);
        //HW_EscReadWord(dummy,0x0120);
/*ECATCHANGE_START(V5.10) HW4*/
        smStatus = SWAPWORD(smStatus);
/*ECATCHANGE_END(V5.10) HW4*/
    }while((smStatus & SM_SETTING_PDI_DISABLE));
/*Slave Stack Code Tool :( #else) lines 1079 to 1092 deleted*/
}

TSYNCMAN ESCMEM * HW_GetSyncMan(UINT8 channel)
{

// ------ַͬЧһУΪļԭ÷
    // get a temporary structure of the Sync Manager:
    //HW_EscRead( (MEM_ADDR *) &TmpSyncMan, ESC_SYNCMAN_REG_OFFSET + (channel * SIZEOF_SM_REGISTER), 8 );
   /// HW_EscReadWord( TmpSyncMan, ESC_SYNCMAN_REG_OFFSET + (channel * SIZEOF_SM_REGISTER) );
    ///HW_EscRead(((MEM_ADDR *)&(TmpSyncMan)+1),ESC_SYNCMAN_REG_OFFSET +2+ (channel *SIZEOF_SM_REGISTER),2);
   /// HW_EscRead(((MEM_ADDR *)&(TmpSyncMan)+2),ESC_SYNCMAN_REG_OFFSET  +4+ (channel *SIZEOF_SM_REGISTER),2);
   /// HW_EscRead(((MEM_ADDR *)&(TmpSyncMan)+3),ESC_SYNCMAN_REG_OFFSET +6+ (channel *SIZEOF_SM_REGISTER),2);

    HW_EscReadWord( TmpSyncMan.PhysicalStartAddress, ESC_SYNCMAN_REG_OFFSET + (channel *SIZEOF_SM_REGISTER) );
    HW_EscReadWord( TmpSyncMan.Length, ESC_SYNCMAN_REG_OFFSET+2 + (channel * SIZEOF_SM_REGISTER) );
    HW_EscReadWord( TmpSyncMan.Settings[0], ESC_SYNCMAN_REG_OFFSET +4+ (channel * SIZEOF_SM_REGISTER) );
    HW_EscReadWord( TmpSyncMan.Settings[1], ESC_SYNCMAN_REG_OFFSET +6+ (channel * SIZEOF_SM_REGISTER) );


    return &TmpSyncMan;
}

static void GetInterruptRegister(void)
 {
	HW_EscReadWord(EscALEvent,ESC_AL_EVENT_OFFSET);
 }

static void ISR_GetInterruptRegister(void)
{
	HW_EscReadWordIsr(EscALEvent,ESC_AL_EVENT_OFFSET);
}

UINT16 HW_GetALEventRegister(void)
{
    GetInterruptRegister();
    return EscALEvent;
}
/////////////////////////////////////////////////////////////////////////////////////////
/**
 \return    first two Bytes of ALEvent register (0x220)

 \brief  The SPI PDI requires an extra ESC read access functions from interrupts service routines.
        The behaviour is equal to "HW_GetALEventRegister()"
*////////////////////////////////////////////////////////////////////////////////////////
/*Slave Stack Code Tool :(#if _PIC18 && AL_EVENT_ENABLED) lines 676 to 680 deleted*/
UINT16 HW_GetALEventRegister_Isr(void)
{
     ISR_GetInterruptRegister();
    return EscALEvent;
}

/////////////////////////////////////////////////////////////////////////////////////////
/**
 \brief    This function shall be implemented if hardware resources need to be release
        when the sample application stops
*////////////////////////////////////////////////////////////////////////////////////////
void HW_Release(void)
{

}

UINT8 HW_Init(void)
{
//	char ErrCount_local;
	// Copy time critical code and Flash setup code to RAM
	// This includes InitFlash(), Flash API functions and any functions that are
	// assigned to ramfuncs section.
	// The  RamfuncsLoadStart, RamfuncsLoadEnd, and RamfuncsRunStart
	// symbols are created by the linker. Refer to the device .cmd file.

	// Step 1. Initialize System Control:
	// PLL, WatchDog, enable Peripheral Clocks
	// This example function is found in the F2837xD_SysCtrl.c file.
	   InitSysCtrl();

#if(0)
    //  memcpy(&CodestartRunStart, &CodestartLoadStart, (UINT32)&CodestartLoadSize);
     // memcpy(&RamfuncsRunStart, &RamfuncsLoadStart, (UINT32)&RamfuncsLoadSize);
     // memcpy(&econst_runstart, &econst_loadstart, (UINT32)&econst_size);
//      memcpy(&switch_runstart, &switch_loadstart, (UINT32)&switch_size);
     // memcpy(&cinit_runstart, &cinit_loadstart, (UINT32)&cinit_size);
      memcpy(&text_runstart, &text_loadstart, (UINT32)&text_size);
   InitFlash();
#endif
	   // Call Flash Initialization to setup flash waitstates
	   // This function must reside in RAM
//    #ifdef _FLASH
//	   InitFlash();
//    #endif
	// Step 2. Initialize GPIO:
	// This example function is found in the F2837xD_Gpio.c file and
	// illustrates how to set the GPIO to it's default state.
	// InitGpio();  // Skipped for this example

	// Step 3. Clear all interrupts and initialize PIE vector table:
	// Disable CPU interrupts
	   DINT;

	// Initialize the PIE control registers to their default state.
	// The default state is all PIE interrupts disabled and flags
	// are cleared.
	// This function is found in the F2837xD_PieCtrl.c file.
	   InitPieCtrl();

	// Disable CPU interrupts and clear all CPU interrupt flags:
	   IER = 0x0000;
	   IFR = 0x0000;

	// Initialize the PIE vector table with pointers to the shell Interrupt
	// Service Routines (ISR).
	// This will populate the entire table, even if the interrupt
	// is not used in this example.  This is useful for debug purposes.
	// The shell ISR routines are found in F2837xD_DefaultIsr.c.
	// This function is found in F2837xD_PieVect.c.
	   InitPieVectTable();

	// Wait until Shared RAM is available.
	   while(!( MemCfgRegs.GSxMSEL.bit.MSEL_GS8 & MemCfgRegs.GSxMSEL.bit.MSEL_GS10 &
			    MemCfgRegs.GSxMSEL.bit.MSEL_GS14 ) )
	   {


	   }
	//  Copy ISR routine to a specified RAM location to determine the size
//		memcpy(&isrfuncRunStart, &isrfuncLoadStart, (uint32_t)&isrfuncLoadSize);//dest,src,size
	// Wait until
	// Interrupts that are used in this example are re-mapped to
	// ISR functions found within this file.
//	   EALLOW;  // This is needed to write to EALLOW protected registers
//	   PieVectTable.TIMER0_INT = &cpu_timer0_isr;
//	   EDIS;    // This is needed to disable write to EALLOW protected registers

	   EALLOW;
	     ClkCfgRegs.PERCLKDIVSEL.bit.EMIF1CLKDIV = 0x1;
	     EDIS;

	     EALLOW;
	   //
	   // Grab EMIF1 For CPU2
	   //
	     Emif1ConfigRegs.EMIF1MSEL.all = 0x93A5CE72;//0x93A5CE71//ĩβ1 for CPU1 2for CPU2
	     if(Emif1ConfigRegs.EMIF1MSEL.all != 0x2)//1 //1 for CPU1 2for CPU2
	     {
	         ErrCount++;
	     }

	   //
	   //Disable Access Protection (CPU_FETCH/CPU_WR/DMA_WR)
	   //
	     Emif1ConfigRegs.EMIF1ACCPROT0.all = 0x0;
	     if(Emif1ConfigRegs.EMIF1ACCPROT0.all != 0x0)
	     {
	         ErrCount++;
	     }

	   //
	   // Commit the configuration related to protection. Till this bit remains set
	   // content of EMIF1ACCPROT0 register can't be changed.
	   //
	     Emif1ConfigRegs.EMIF1COMMIT.all = 0x1;
	     if(Emif1ConfigRegs.EMIF1COMMIT.all != 0x1)
	     {
	        ErrCount++;
	     }

	   //
	   // Lock the configuration so that EMIF1COMMIT register can't be
	   // changed any more.
	   //
	     Emif1ConfigRegs.EMIF1LOCK.all = 0x1;
	     if(Emif1ConfigRegs.EMIF1LOCK.all != 1)
	     {
	         ErrCount++;
	     }

	     EDIS;

	   //
	   //Configure GPIO pins for EMIF1
	   //
	//     setup_emif1_pinmux_async_16bit(0);//ת뵽CPU1

	   //
	   //Configure the access timing for CS2 space
	   //
	     EALLOW;
	     Emif1Regs.ASYNC_CS2_CR.all =  (EMIF_ASYNC_ASIZE_8    | // 16Bit Memory
	                                                             // Interface
	                                    EMIF_ASYNC_TA_1        | // Turn Around time
	                                                             // of 2 Emif Clock
	                                    EMIF_ASYNC_RHOLD_2     | // Read Hold time
	                                                             // of 1 Emif Clock
	                                    EMIF_ASYNC_RSTROBE_8   | // Read Strobe time
	                                                             // of 4 Emif Clock
	                                    EMIF_ASYNC_RSETUP_4    | // Read Setup time
	                                                             // of 1 Emif Clock
	                                    EMIF_ASYNC_WHOLD_2     | // Write Hold time
	                                                             // of 1 Emif Clock
	                                    EMIF_ASYNC_WSTROBE_8   | // Write Strobe time
	                                                             // of 1 Emif Clock
	                                    EMIF_ASYNC_WSETUP_4    | // Write Setup time
	                                                             // of 1 Emif Clock
	                                    EMIF_ASYNC_EW_ENABLE  | // Extended Wait
	                                                             // Disable.
	                                    EMIF_ASYNC_SS_DISABLE    // Strobe Select Mode
	                                                             // Disable.
	                                   );
	     Emif1Regs.ASYNC_WCCR.bit.WP0 = 0;             // Active-high Wait Polarity for EM1WAIT.
	     Emif1Regs.ASYNC_WCCR.bit.MAX_EXT_WAIT = 0x1;
         EDIS;

         	   InitCpuTimers();   // For this example, only initialize the Cpu Timers
         	   ConfigCpuTimer(&CpuTimer0, 200, 1000);//ʱ1us//100usһж
         	   CpuTimer0Regs.TCR.all = 0x4000; // Use write-only instruction to set TSS bit = 0

                /*---------------˾ҪͬʱCPU1CPU2ʹܷ----------------*/
                EALLOW;
                      XintRegs.XINT2CR.bit.POLARITY=2; //XIntruptRegs //=0,2:falling edge =1: rising edge =3: both edge
         	          XintRegs.XINT2CR.bit.ENABLE  = 1;//ʹܸж

         	          XintRegs.XINT3CR.bit.POLARITY=2; //XIntruptRegs //=0,2:falling edge =1: rising edge =3: both edge
         	          XintRegs.XINT3CR.bit.ENABLE  = 1;         //ʹܸж
         	    EDIS;
         	    /*------------------------------------------------------*/

		          EALLOW;  // This is needed to write to EALLOW protected registers
		          PieVectTable.XINT2_INT = &xint2_ET1100_IRQ_isr;//.XINT2
		          PieVectTable.TIMER0_INT = &cpu_timer0_isr;
		          PieVectTable.XINT3_INT = &xint3_ET1100_SYNC0_isr;
		          EDIS;

		          PieCtrlRegs.PIECTRL.bit.ENPIE = 1;          // Enable the PIE block//IRQ
		          PieCtrlRegs.PIEIER1.bit.INTx5 = 1;          // Enable PIE Group 1 INT5, IRQжϣxint2
		          PieCtrlRegs.PIEIER12.bit.INTx1 = 1;       // xint3//SYNC0ж
		          PieCtrlRegs.PIEIER1.bit.INTx7 = 1;   // Enable TINT0 in the PIE: Group 1 interrupt 7


		          IER |= M_INT9; // Enable CPU INT //group 9
		          IER |= M_INT1;
		          IER |= M_INT12;//sync0
		          EINT;
		          ERTM;

  Uint16 intMask204=0;
//  Uint16 readAddr=0;
//  Uint16 testdata[200];
//  Uint16 i=0;
//  while (i<10)
//	  {
//	  	  HW_EscReadWord(testdata[i], i*2);
//	  	  i++;
//	  }

//  HW_EscReadWord(testdata[100], 0x100);
//  HW_EscReadWord(testdata[101], 0x102);
//  HW_EscReadWord(testdata[102], 0x110);
//  HW_EscReadWord(testdata[103], 0x140);
//  HW_EscReadWord(testdata[104], 0x150);
  HW_EscReadWord(intMask204, ESC_AL_EVENTMASK_OFFSET);
  while (intMask204 != 0x93)
  {
      intMask204 = 0x93;
      HW_EscWriteWord(intMask204, ESC_AL_EVENTMASK_OFFSET);
      intMask204 = 0;
      HW_EscReadWord(intMask204, ESC_AL_EVENTMASK_OFFSET);
  }
  intMask204 = 0x0;//ʼɺ0x204д0
  HW_EscWriteWord(intMask204, ESC_AL_EVENTMASK_OFFSET);

return 0;
}

//-----------------MODBUSʱж-------Ϊʱдվʹ------------//
__interrupt void cpu_timer0_isr(void)
    {

	// Set interrupt priority:
	volatile Uint16 TempPIEIER = PieCtrlRegs.PIEIER1.all;
	IER |= M_INT1;
	IER	&= MINT1;	  	               // Set "global" priority
	PieCtrlRegs.PIEIER1.all &= MG1_7;   // Set "group"  priority
	PieCtrlRegs.PIEACK.all = 0xFFFF;   // Enable PIE interrupts
	__asm("  NOP");
	EINT;
//    // Set interrupt priority:
//      volatile Uint16 TempPIEIER = PieCtrlRegs.PIEIER1.all;
//      IER |= M_INT1;
//      IER &= M_INT1;                      // Set "global" priority
//     // PieCtrlRegs.PIEIER1.all &= MG17;   // Set "group"  priority
//      PieCtrlRegs.PIEACK.all = 0xFFFF;   // Enable PIE interrupts
//      EINT;
        //DISABLE_ESC_INT();
                //PortAcounter++;
//                PortBcounter++;
                CpuTimer0.InterruptCount++;


     // Restore registers saved:
        DINT;
       	PieCtrlRegs.PIEIER1.all = TempPIEIER;

    }

__interrupt void xint2_ET1100_IRQ_isr(void)
{
	// Set interrupt priority:
	volatile Uint16 TempPIEIER = PieCtrlRegs.PIEIER1.all;
	IER |= M_INT1;
	IER	&= MINT1;	  	               // Set "global" priority
	PieCtrlRegs.PIEIER1.all &= MG1_5;   // Set "group"  priority
	PieCtrlRegs.PIEACK.all = 0xFFFF;   // Enable PIE interrupts
	__asm("  NOP");
	EINT;


    PDI_Isr();
//    RESET_IO2;
     DINT;
//     PieCtrlRegs.PIEACK.all|=M_INT1;      // Issue PIE ACK
//     PieCtrlRegs.PIEACK.bit.ACK5 = 1;  //ȷϸж
     PieCtrlRegs.PIEIER1.all = TempPIEIER;
}

__interrupt void xint3_ET1100_SYNC0_isr(void)
{
	// Set interrupt priority:
	volatile Uint16 TempPIEIER = PieCtrlRegs.PIEIER12.all;
	IER |= M_INT12;
	IER	&= MINT12;	  	                // Set "global" priority
	PieCtrlRegs.PIEIER12.all &= MG12_1;   // Set "group"  priority
	PieCtrlRegs.PIEACK.all = 0xFFFF;   // Enable PIE interrupts
	__asm("  NOP");
	EINT;
//	SET_IO2;
    Sync0_Isr();
//    RESET_IO2;
	// Restore registers saved:
	DINT;
	PieCtrlRegs.PIEIER12.all = TempPIEIER;
}//end
