/**
\addtogroup ESM EtherCAT State Machine
@{
*/

/**
\file bootmode.c
\author EthercatSSC@beckhoff.com
\brief Implementation

\version 4.20

<br>Changes to version - :<br>
V4.20: File created
*/

/*--------------------------------------------------------------------------------------
------
------    Includes
------
--------------------------------------------------------------------------------------*/

#include "ecat_def.h"
#include "el9800hw.h"
#include "ecat_def.h"
#include "ecatfoe.h"
#include "flash_programming_c28.h"//"Example_Flash2806x_API.h"  //,flashд
#include "F021_F2837xD_C28x.h"//"Flash2806x_API_Library.h"
//#include "F2806x_Device.h"     // Device Headerfile and Examples Include File
#if BOOTSTRAPMODE_SUPPORTED

#define    _BOOTMODE_ 1
#include "bootmode.h"
#undef _BOOTMODE_

//Lenght of the programming buffer
#define PROG_BUFFER_LENGTH 0x400


#define  EINT   __asm(" clrc INTM")
#define  DINT   __asm(" setc INTM")

#if FLASH
#pragma CODE_SECTION(Asci2Int, "ramfuncs");
#pragma CODE_SECTION(Download2Flash, "ramfuncs");
#pragma CODE_SECTION(BL_Start, "ramfuncs");
#pragma CODE_SECTION(BL_StartDownload, "ramfuncs");
#pragma CODE_SECTION(BL_Data, "ramfuncs");
#endif
/////////////////////////////////////////////////////////////////////////////////////////
/**
 \param    State        Current state

 \brief Dummy BL_Start function
*////////////////////////////////////////////////////////////////////////////////////////
//==========ȫֱ================//
UINT16 ReturnStatus;
UINT16  MBXsum=0;
UINT16 AddrFlag=0;
UINT16 NextWRlen=0;
UINT16 newStartFlag=0;
UINT16 LongBLKoffset=0;
UINT16 OffsetFlag = 0;
struct HEADER {
  Uint16 BlockSize;
  Uint32 DestAddr;
  Uint32 ProgBuffAddr;
} BlockHeader;


//UINT16 MBXMEM     aFileData[(MAX_FILE_SIZE >> 1)]={0};//2byteлΪ16bit顣ӳʼ
//=================================//
 UINT16 Asci2Int(UINT16 Data)
 {
     UINT16 AscData;
     UINT16 IntData;

     AscData=Data;
     if((AscData>=0x30)&&(AscData<=0x39))
            {
                IntData= AscData-0x30;
                return IntData;
            }
     else if((AscData>=0x41)&&(AscData<=0x46))
            {
                IntData= AscData-55;
                return IntData;
            }
     else if((AscData>=0x61)&&(AscData<=0x66))
            {
                IntData= AscData-87;
                return IntData;
            }
     else
         return 0xffff;
 }


UINT16 Download2Flash(UINT16 *pFileData, UINT16 MBXlen)
 {
     UINT32 ADDR_H=0;
     UINT32 ADDR_L=0;
     UINT16 i=0;
     UINT16 SmallBLKLen[6]={0};//6չ15
     UINT16 ActualLen=0;

     Uint16 miniBuffer[2];
     Fapi_StatusType oReturnCheck;
     Fapi_FlashStatusWordType oFlashStatusWord;


     if(AddrFlag== 0)//ڿʼִһ
     {
         BlockHeader.BlockSize = *(pFileData++);//+(*(pFileData++)<<8);//aFileData[AddrInd];//BlockLen[k++];//aFileData[0];//(*GetOnlyWordData)();
         //Block is to big to fit into our buffer so we must program it in chunks
         ADDR_H= ((UINT32)*(pFileData++))<<16;//+(*(pFileData++)<<8));
         ADDR_L= (UINT32)*(pFileData++);//+(*(pFileData++)<<8));
         BlockHeader.DestAddr =  ADDR_H +ADDR_L;//GetLongData();BlockAddr[kk++];
         //AddrFlag=1;//Ϊ˱֤һƫƵԣ
     }


     if(BlockHeader.BlockSize > 0)
        {
            if(BlockHeader.BlockSize > (MBXlen+MBXsum+LongBLKoffset))//üӷ滻µĳΧС
            {
                ActualLen= MBXlen-3*(1-AddrFlag);//3
                //====================д벢УflashǷȷ======================//
                 //ַƫвٰNextWRlen,ѾMBXsumУ൱ҲnewoffsetӰ뵽ifж
                if((BlockHeader.DestAddr>=0x080000)&(BlockHeader.DestAddr<=0x0A0000))
                   {
                            AddrFlag=1;//ͬʱĿĵַҲΪһƶĿʼַҲҪ3
                            OffsetFlag = 1;
                            Uint16 k1;
                            for(k1 = 0; k1 < (ActualLen); k1++)//۵γỵ̄ͳһBUFERSIZEλλأһ2wordµٶصflash
                                      {
                                               //program 4 words at once, 64-bits
                                               ////ôƫƽڵһҪַͳɵ3ƫ
                            	               miniBuffer[0] = pFileData[k1];//+(pFileData[k * 2 + 1]<<8);//Ӵм飬صڶξʾincorrectdatabuffer
                            	              // miniBuffer[1] = pFileData[k * 2 + 1];//+(pFileData[k * 4 + 3]<<8);
                            	              // miniBuffer[2] = pFileData[k * 4 + 2];
                            	              // miniBuffer[3] = pFileData[k * 4 + 3];
                            	               EALLOW;
                                               oReturnCheck = Fapi_issueProgrammingCommand((uint32 *)(BlockHeader.DestAddr),
                                            		                               miniBuffer,
																				  1,/*word*/
                                                                                  0,
                                                                                  0,
																				  Fapi_DataOnly);
                                               while(Fapi_checkFsmForReady() == Fapi_Status_FsmBusy);
                                               if(oReturnCheck != Fapi_Status_Success)
                                               {
                                            	   return ECAT_FOE_ERRCODE_FLASH_PROBLEM;
                                               }
                                               if((BlockHeader.DestAddr%2==1)&&(k1>2))
                                               {
                                            	   miniBuffer[0] = pFileData[k1-1];
                                            	   miniBuffer[1] = pFileData[k1];
                                            	   uint32   *Buffer32 = (uint32 *)miniBuffer;
                                                   oReturnCheck = Fapi_doVerify((uint32 *)(BlockHeader.DestAddr-1),
                                                                  1,
                                                                  (Buffer32),
                                                                  &oFlashStatusWord);
                                                      if(oReturnCheck != Fapi_Status_Success)
                                                      {
                                                    	  return ECAT_FOE_ERRCODE_FLASH_PROBLEM;
                                                      }
                                               }
                                               EDIS;
                                          //} //check if miniBuffer does not contain all already erased data
                                          BlockHeader.DestAddr += 1;//0x4;
                                      } //for(int k); loads miniBuffer with Buffer elements

                   }

                        MBXsum+=ActualLen;


                //===============================================================//
            }

            else
            {
                SmallBLKLen[0]= BlockHeader.BlockSize-MBXsum+3*AddrFlag;//
//                AddrFlag=2;//
                /*===Ϊ˱֤һƫƵԣ==,˴newoffsetͬҪϲMBXsumУͬʱҲҪnewstartɵʼƫƲ=*/
                //====================д벢УflashǷȷ======================//
                i=0;
                while((BlockHeader.BlockSize+SmallBLKLen[0]+3*(i+1)) < MBXlen)//üӷȽϣӦµ޷СµBlockHeader.BlockSize < MBXlen-SmallBLKLen[0]-3*(i+1))
                  {
                     AddrFlag=1;//
                     LongBLKoffset=0;
                     Uint16 j;
                     if((BlockHeader.DestAddr>=0x080000)&(BlockHeader.DestAddr<=0x0A0000))
                      {
                         for(j = 0; j < (SmallBLKLen[i]); j++)//۵γỵ̄ͳһBUFERSIZEλλأһ2wordµٶصflash
                                   {
                                            //program 2 words at once, 32-bits
                                            ////ôƫƽڵһҪַͳɵ3ƫ
                         	               miniBuffer[0] = pFileData[(SmallBLKLen[0]-SmallBLKLen[i]+3*i)+j];//Ӵм飬صڶξʾincorrectdatabuffer
                         	               //miniBuffer[1] = pFileData[(SmallBLKLen[0]-SmallBLKLen[i]+3*i)+j * 4 + 2]+(pFileData[(SmallBLKLen[0]-SmallBLKLen[i]+3*i)+j * 4 + 3]<<8);
                         	               EALLOW;
                                            oReturnCheck = Fapi_issueProgrammingCommand((uint32 *)(BlockHeader.DestAddr),
                                         		                              miniBuffer,
																				  sizeof(miniBuffer),/*bytes*/
                                                                               0,
                                                                               0,
																				  Fapi_DataOnly);
                                            while(Fapi_checkFsmForReady() == Fapi_Status_FsmBusy);
                                            if(oReturnCheck != Fapi_Status_Success)
                                            {
                                         	   return ECAT_FOE_ERRCODE_FLASH_PROBLEM;
                                            }

                                            if((BlockHeader.DestAddr%2==1)&&(j>2))
                                            {
                                         	   miniBuffer[0] = pFileData[(SmallBLKLen[0]-SmallBLKLen[i]+3*i)+j-1];
                                         	   miniBuffer[1] = pFileData[(SmallBLKLen[0]-SmallBLKLen[i]+3*i)+j];
                                         	   uint32   *Buffer32 = (uint32 *)miniBuffer;
                                                oReturnCheck = Fapi_doVerify((uint32 *)(BlockHeader.DestAddr-1),
                                                               1,
                                                               (Buffer32),
                                                               &oFlashStatusWord);
                                                   if(oReturnCheck != Fapi_Status_Success)
                                                   {
                                                 	  return ECAT_FOE_ERRCODE_FLASH_PROBLEM;
                                                   }
                                            }

                                            EDIS;
                                       //} //check if miniBuffer does not contain all already erased data
                                       BlockHeader.DestAddr += 1;//0x4;
                                   } //for(int k); loads miniBuffer with Buffer elements
                      }
                        //===============================================================//

                      BlockHeader.BlockSize = *(pFileData+SmallBLKLen[0]+3*i);//һ鳤
                      //Block is to big to fit into our buffer so we must program it in chunks
                      ADDR_H= ((UINT32)*(pFileData+SmallBLKLen[0]+3*i+1))<<16;
                      ADDR_L= (UINT32)*(pFileData+SmallBLKLen[0]+3*i+1+1);
                      BlockHeader.DestAddr =  ADDR_H+ADDR_L;//һַ

                        i=i+1;
                        SmallBLKLen[i]=BlockHeader.BlockSize;
                        SmallBLKLen[0]+= SmallBLKLen[i];

                  }
#if 1
                //------ʣһĲҲصһ-ĳȲҪѡʣ೤---//
                //====================д벢УflashǷȷ======================//
                       Uint16 LenWR=0;
                       Uint16 Offseted=0;
                       Uint16 j1;
                       Offseted= MBXlen+MBXsum+LongBLKoffset;
                       if((OffsetFlag==1)&&(BlockHeader.BlockSize>MBXsum))
                           LenWR= BlockHeader.BlockSize-MBXsum-LongBLKoffset;
                       else
                           LenWR =MBXlen+SmallBLKLen[i]-(SmallBLKLen[0]+3*i+3);
                       if((BlockHeader.DestAddr>=0x080000)&(BlockHeader.DestAddr<=0x0a0000))
                        {
                           //status = Flash_Program((Uint16 *) (BlockHeader.DestAddr+MBXsum+LongBLKoffset), (Uint16 *)(pFileData+SmallBLKLen[0]-SmallBLKLen[i]+3*i), (LenWR), &FlashStatus);
                           for(j1 = 0; j1 < (LenWR/4); j1++)//۵γỵ̄ͳһBUFERSIZEλλأһ1wordµٶصflash
                                     {
                                              //program 2 words at once, 64-bits
                                              ////ôƫƽڵһҪַͳɵ3ƫ
                           	               miniBuffer[0] = pFileData[(SmallBLKLen[0]-SmallBLKLen[i]+3*i)+j1];//Ӵм飬صڶξʾincorrectdatabuffer
                           	               //miniBuffer[1] = pFileData[(SmallBLKLen[0]-SmallBLKLen[i]+3*i)+j1 * 4 + 2]+(pFileData[(SmallBLKLen[0]-SmallBLKLen[i]+3*i)+j1 * 4 + 3]<<8);
                           	               EALLOW;
                                              oReturnCheck = Fapi_issueProgrammingCommand((uint32 *)(BlockHeader.DestAddr),
                                           		                              miniBuffer,
  																				  1,/*word*/
                                                                                 0,
                                                                                 0,
  																				  Fapi_DataOnly);
                                              while(Fapi_checkFsmForReady() == Fapi_Status_FsmBusy);
                                              if(oReturnCheck != Fapi_Status_Success)
                                              {
                                           	   return ECAT_FOE_ERRCODE_FLASH_PROBLEM;
                                              }

                                              if((BlockHeader.DestAddr%2==1)&&(j1>2))
                                              {
                                           	   miniBuffer[0] = pFileData[(SmallBLKLen[0]-SmallBLKLen[i]+3*i)+j1-1];
                                           	   miniBuffer[1] = pFileData[(SmallBLKLen[0]-SmallBLKLen[i]+3*i)+j1];
                                           	   uint32   *Buffer32 = (uint32 *)miniBuffer;
                                                  oReturnCheck = Fapi_doVerify((uint32 *)(BlockHeader.DestAddr-1),
                                                                 1,
                                                                 (Buffer32),
                                                                 &oFlashStatusWord);
                                                     if(oReturnCheck != Fapi_Status_Success)
                                                     {
                                                   	  return ECAT_FOE_ERRCODE_FLASH_PROBLEM;
                                                     }
                                              }

                                              EDIS;
                                         //} //check if miniBuffer does not contain all already erased data
                                         BlockHeader.DestAddr += 1;//0x4;
                                     } //for(int k); loads miniBuffer with Buffer elements
                        }

                        if(BlockHeader.BlockSize>MBXlen)
                            LongBLKoffset= MBXlen+SmallBLKLen[i]-(SmallBLKLen[0]+3*i+3);
                        if((BlockHeader.BlockSize+3) < Offseted)
                           {
                        	    Uint16 j2=0;
                                LongBLKoffset= Offseted- BlockHeader.BlockSize-3;
                                BlockHeader.BlockSize = *(pFileData+LenWR);//һ鳤
                                //Block is to big to fit into our buffer so we must program it in chunks
                                ADDR_H= ((UINT32)*(pFileData+LenWR+1))<<16;
                                ADDR_L= (UINT32)*(pFileData+LenWR+1+1);
                                BlockHeader.DestAddr =  ADDR_H+ADDR_L;//һַ

                                OffsetFlag=0;
                             if((BlockHeader.DestAddr>=0x080000)&(BlockHeader.DestAddr<=0x0a0000))
                                {   //status = Flash_Program((Uint16 *) (BlockHeader.DestAddr), (Uint16 *)(pFileData+LenWR+3), (LongBLKoffset), &FlashStatus);
                                for(j2 = 0; j2 < (LongBLKoffset/4); j2++)//۵γỵ̄ͳһBUFERSIZEλλأһ1wordµٶصflash
                                          {
                                                   //program 4 words at once, 64-bits
                                                   ////ôƫƽڵһҪַͳɵ3ƫ
                                	               miniBuffer[0] = pFileData[LenWR+3+j2];//Ӵм飬صڶξʾincorrectdatabuffer
                                	              // miniBuffer[1] = pFileData[LenWR+3+j2 * 4 + 2]+(pFileData[LenWR+3+j2 * 4 + 3]<<8);
                                	               EALLOW;
                                                   oReturnCheck = Fapi_issueProgrammingCommand((uint32 *)(BlockHeader.DestAddr),
                                                		                              miniBuffer,
       																				  1,/*word*/
                                                                                      0,
                                                                                      0,
       																				  Fapi_DataOnly);
                                                   while(Fapi_checkFsmForReady() == Fapi_Status_FsmBusy);
                                                   if(oReturnCheck != Fapi_Status_Success)
                                                   {
                                                	   return ECAT_FOE_ERRCODE_FLASH_PROBLEM;
                                                   }
                                                   if((BlockHeader.DestAddr%2==1)&&(j2>2))
                                                   {
                                                	   miniBuffer[0] = pFileData[LenWR+3+j2-1];
                                                	   miniBuffer[1] = pFileData[LenWR+3+j2];
                                                	   uint32   *Buffer32 = (uint32 *)miniBuffer;
                                                       oReturnCheck = Fapi_doVerify((uint32 *)(BlockHeader.DestAddr-1),
                                                                      1,
                                                                      (Buffer32),
                                                                      &oFlashStatusWord);
                                                          if(oReturnCheck != Fapi_Status_Success)
                                                          {
                                                        	  return ECAT_FOE_ERRCODE_FLASH_PROBLEM;
                                                          }
                                                   }

                                                   EDIS;
                                              //} //check if miniBuffer does not contain all already erased data
                                              BlockHeader.DestAddr += 1;//0x4;
                                          } //for(int k); loads miniBuffer with Buffer elements
                                }
                           }
                 MBXsum=0;
                 return 0;

#endif
            }
        }
     return 0;
 }

UINT16 BL_Start( UINT8 State)
{

    Fapi_StatusType            oReturnCheck;
    volatile Fapi_FlashStatusType       oFlashStatus;
    Fapi_FlashStatusWordType   oFlashStatusWord;

    //
    //Unlock the device
    //
    DcsmZ2Regs.Z2_CSMKEY0 = 0xffffffff;
    DcsmZ2Regs.Z2_CSMKEY1 = 0xffffffff;
    DcsmZ2Regs.Z2_CSMKEY2 = 0xffffffff;
    DcsmZ2Regs.Z2_CSMKEY3 = 0xffffffff;

    if(DcsmZ2Regs.Z2_CR.bit.UNSECURE == 0) //0 = Locked
    {
    	return ECAT_FOE_ERRCODE_FLASH_PROBLEM;
    }

//  Gain pump semaphore
    SeizeFlashPump();
    // Disable ECC.  ECC does not have to be disabled to do FSM operations like
    // program and erase.
    // However, on Sonata Rev. 0 silicon, due to an OTP ECC errata,
    // disable ECC to avoid ECC errors while using Flash API functions that
    // read TI-OTP
    EALLOW;
    Flash0EccRegs.ECC_ENABLE.bit.ENABLE = 0x0;
    EDIS;

    EALLOW;

    // This function is required to initialize the Flash API based on System
    // frequency before any other Flash API operation can be performed

	oReturnCheck = Fapi_initializeAPI(F021_CPU0_BASE_ADDRESS, 200);//for now keeping it out

    if(oReturnCheck != Fapi_Status_Success)
    {
        // Check Flash API documentation for possible errors
    	return ECAT_FOE_ERRCODE_FLASH_PROBLEM;
    }

    // Fapi_setActiveFlashBank function sets the Flash bank and FMC for further
    // Flash operations to be performed on the bank
    oReturnCheck = Fapi_setActiveFlashBank(Fapi_FlashBank0);
    if(oReturnCheck != Fapi_Status_Success)
    {
        // Check Flash API documentation for possible errors
    	return ECAT_FOE_ERRCODE_FLASH_PROBLEM;
    }
    EDIS;

    EALLOW;
    // Erase Sector A
    oReturnCheck = Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector,
                   (uint32 *)Bzero_SectorA_start);

    // Wait until FSM is done with erase sector operation
    while (Fapi_checkFsmForReady() != Fapi_Status_FsmReady){}
    // Verify that SectorA is erased.  The Erase step itself does a verify as
    // it goes.  This verify is a 2nd verification that can be done.
    oReturnCheck = Fapi_doBlankCheck((uint32 *)Bzero_SectorA_start,
                   Bzero_16KSector_u32length,
                   &oFlashStatusWord);

    if(oReturnCheck != Fapi_Status_Success)
    {
        // Check Flash API documentation for possible errors
        // If Erase command fails, use Fapi_getFsmStatus() function
        // to get the FMSTAT register contents
        // to see if any of the EV bit, ESUSP bit, CSTAT bit or VOLTSTAT
        // bit is set (Refer to API documentation for more details)
        return ECAT_FOE_ERRCODE_FLASH_PROBLEM;
    }
    // Erase Sector B
    oReturnCheck = Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector,
                   (uint32 *)Bzero_SectorB_start);

    // Wait until FSM is done with erase sector operation
    while (Fapi_checkFsmForReady() != Fapi_Status_FsmReady){}
    // Verify that SectorB is erased.  The Erase step itself does a verify as
    // it goes.  This verify is a 2nd verification that can be done.
    oReturnCheck = Fapi_doBlankCheck((uint32 *)Bzero_SectorB_start,
                   Bzero_16KSector_u32length,
                   &oFlashStatusWord);

    if(oReturnCheck != Fapi_Status_Success)
    {
        // Check Flash API documentation for possible errors
        // If Erase command fails, use Fapi_getFsmStatus() function
        // to get the FMSTAT register contents
        // to see if any of the EV bit, ESUSP bit, CSTAT bit or VOLTSTAT
        // bit is set (Refer to API documentation for more details)
    	return ECAT_FOE_ERRCODE_FLASH_PROBLEM;
    }
    // Erase Sector C
    oReturnCheck = Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector,
                   (uint32 *)Bzero_SectorC_start);

    // Wait until FSM is done with erase sector operation
    while (Fapi_checkFsmForReady() != Fapi_Status_FsmReady){}
    // Verify that SectorC is erased.  The Erase step itself does a verify as
    // it goes.  This verify is a 2nd verification that can be done.
    oReturnCheck = Fapi_doBlankCheck((uint32 *)Bzero_SectorC_start,
                   Bzero_16KSector_u32length,
                   &oFlashStatusWord);

    if(oReturnCheck != Fapi_Status_Success)
    {
        // Check Flash API documentation for possible errors
        // If Erase command fails, use Fapi_getFsmStatus() function
        // to get the FMSTAT register contents
        // to see if any of the EV bit, ESUSP bit, CSTAT bit or VOLTSTAT
        // bit is set (Refer to API documentation for more details)
        return ECAT_FOE_ERRCODE_FLASH_PROBLEM;
    }
    EDIS;
    EALLOW;
#if 1
    // Erase the sectors that we have programmed above
    // Erase Sector E
    oReturnCheck = Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector,
                   (uint32 *)Bzero_SectorE_start);

    // Wait until FSM is done with erase sector operation
    while (Fapi_checkFsmForReady() != Fapi_Status_FsmReady){}

    // Verify that SectorC is erased.  The Erase step itself does a verify as
    // it goes.
    // This verify is a 2nd verification that can be done.
    oReturnCheck = Fapi_doBlankCheck((uint32 *)Bzero_SectorE_start,
                   Bzero_64KSector_u32length,
                   &oFlashStatusWord);

    if(oReturnCheck != Fapi_Status_Success)
    {
        // Check Flash API documentation for possible errors
        // If Erase command fails, use Fapi_getFsmStatus() function to get the
        // FMSTAT register contents
        // to see if any of the EV bit, ESUSP bit, CSTAT bit or VOLTSTAT bit is
        // set (Refer to API documentation for more details)
    	return ECAT_FOE_ERRCODE_FLASH_PROBLEM;
    }
#endif
    EDIS;

    // Leave control over flash pump
   // ReleaseFlashPump();

  return 0;
}

/////////////////////////////////////////////////////////////////////////////////////////
/**
 \param    password    download password

 \brief Dummy BL_StartDownload function
*////////////////////////////////////////////////////////////////////////////////////////
UINT16 BL_StartDownload(UINT32 password)
{
    //-------ǰ׼flashĳʼ

    nFileWriteOffset=0;
    nFileSize=0;
    ReturnStatus=0;//ʼ״̬뵼FOE״̬
    BlockHeader.BlockSize=0;
    AddrFlag=0;
    MBXsum=0;
    LongBLKoffset=0;
//    NextWRlen= 0;
    newStartFlag=0;
    OffsetFlag = 0;
//    aFileName[MAX_FILE_NAME_SIZE]={0};
//    aFileData[(MAX_FILE_SIZE >> 1)]={0};
    if(password==00)//룬ǰΪ0
         {

                return 0;
        }
    else
        return ECAT_FOE_ERRCODE_NORIGHTS;

}
/////////////////////////////////////////////////////////////////////////////////////////
/**
 \param    pData    Data pointer
 \param    Size    Data Length


 \return    FoE error code

 \brief Dummy BL_Data function
*////////////////////////////////////////////////////////////////////////////////////////
UINT16 DummyData[1500];//500չ1500FOEزٳܷɣǰӦ鳤ȳ
UINT16 k=0;
UINT16 BL_Data(UINT16 *pData,UINT16 Size)
{
    UINT16 i=0;
    UINT16 AscDataL;
    UINT16 AscDataH;
    UINT16 IntDataL;
    UINT16 IntDataH;


    UINT16 n=0;
    UINT16 m=0;
    UINT16 data4;
    UINT16 data8;
    UINT16 data12;
    UINT16 data16;


    DINT;
    //if ( Size )
    for(i=0;i<Size/2;i++)//sizeΪsize/2Ϊsize8byteĳȣָ16λ
    {//atoi
        //˵ǰFOEļһݲΪ2charݼĿոҲΪһchar롣
        DummyData[k]=0;
        DummyData[k+1]=0;//Ƚߵλȫ0
        AscDataL=*(pData+i)&0x00ff;
         AscDataH=*(pData+i)>>8;
         IntDataL=Asci2Int(AscDataL);
         IntDataH=Asci2Int(AscDataH);
        if(IntDataL!=0xffff)
            DummyData[k++]=IntDataL;
        if(IntDataH!=0xffff)
            DummyData[k++]=IntDataH;
            //MBXMEMCPY(&aFileData[(nFileWriteOffset >> 1)], pData, Size);
            //WriteFlash((Uint16*)aPdInputData1,20);
    }


    if ( Size == (u16ReceiveMbxSize - MBX_HEADER_SIZE - FOE_HEADER_SIZE) )//׼һͨƫƴ洢ڵһַ
    {
        /* FoE-Data services will follow */
       if(k%8==0)//ֻе۵4󣬷ɽкϲÿĩβļַңպװ72Чַ4
       {
            for(n=0;n<k/4;n++)//kΪѹոַÿڴݵЧֽĿ,4һwordռ416ַ//k/4
            {
                data16=DummyData[m+3]<<8;
                data12=DummyData[m+2]<<12;
                data8=DummyData[m+1];
                data4=DummyData[m]<<4;
                aFileData[n]=data4+data8+data12+data16;//мǼ
                m=m+4;//4
            }
            ReturnStatus=Download2Flash(((UINT16 *) aFileData),n);//afileDataصflash
            k=0;//λK
       }
        nFileWriteOffset += n;//Size;һword

        EINT;
        return ReturnStatus;
    }
    else
    {
        /* last part of the file is written */

        //----------Ӵһݺϲ------------//
        for(n=0;n<k/4;n++)//kΪѹոַÿڴݵЧֽĿ//k/4
            {
                data16=DummyData[m+3]<<8;
                data12=DummyData[m+2]<<12;
                data8=DummyData[m+1];
                data4=DummyData[m]<<4;
                aFileData[n]=data4+data8+data12+data16;//мǼ, ȥԭƫƣֻn
                m=m+4;//4
            }
        nFileSize = nFileWriteOffset + n;//Size/2;//λword,˴ȻnЧȣųַ
        ReturnStatus=Download2Flash((UINT16 *) aFileData, n);//afileDataصflash
        k=0;//λK

        nFileWriteOffset = 0;
         EINT;
         if(ReturnStatus==ECAT_FOE_ERRCODE_FLASH_PROBLEM)
             return ReturnStatus;//FOE_ACKFINISHED;
         else
             return FOE_ACKFINISHED;
    }

}
#endif //BOOTSTRAPMODE_SUPPORTED
/** @} */
