/*
 * Peripheral.c
 *
 *  Created on: 202454
 *      Author:
 */


#include"Peripheral.h"
void Setup_GPIO(void)
{

    /*!
        Each pin output can be controlled by either a peripheral or one of the
        four CPU masters (CPU1, CPU1.CLA, CPU2, or CPU2.CLA).
        There are six I/O ports:
         Port A GPIO0   - GPIO31
         Port B GPIO32  - GPIO63
         Port C GPIO64  - GPIO95
         Port D GPIO96  - GPIO127
         Port E GPIO128 - GPIO159
         Port F GPIO160 - GPIO168

        GPyPUD  Pull-Up Disable Register
                    1 = Pull-Up Disabled        (Default)
                    0 = Pull-Up Enabled
        GPyCTRL Selects the input qualification sampling period (group of 8)
                    0x00,QUALPRDx = PLLSYSCLK   (Default)
                    0x01,QUALPRDx = PLLSYSCLK/2
                    0x02,QUALPRDx = PLLSYSCLK/3
                    ...
        GPyQSELx    Type of qualification
                    0 = Synchronous             (Default)
                    2 = 3-Sample Qualification
                    3 = 6-Sample Qualification
                    4 = Asynchronous
        GPySET  Load the output latch (by default all output latch are 0)
        GPyODR  Open Drain Output Register
                    0 = Normal Output           (Default)
                    1 = Open Drain Output
        GPyGMUX Peripheral group mux
        GPyMUX  Peripheral mux
        GPyDIR  Pin direction
                    0 = Input   (default)
                    1 = Output
        GPyCSELx    Core Select Register, Selects which master's GPIODAT/SET/CLEAR/TOGGLE registers control this GPIO pin
                    xx00: CPU1 selected
                    xx01: CPU1.CLA1 selected
                    xx10: CPU2 selected
                    xx11: CPU2.CLA1 selected
        GPyLOCK Lock Configuration Register
        GPyCR       Lock Commit Register

    */
    EALLOW;
        //PWM
       GpioCtrlRegs.GPAPUD.bit.GPIO0 = 1;   // disable pullup on GPIO0
       GpioCtrlRegs.GPAPUD.bit.GPIO1 = 1;   // disable pullup on GPIO1, 0-Enables the Pull-Up, 1: Disables the Pull-Up. Reset 1,

       GpioCtrlRegs.GPAPUD.bit.GPIO2 = 0;   // Enable pullup on GPIO2
       GpioCtrlRegs.GPAPUD.bit.GPIO3 = 0;   // Enable pullup on GPIO3
       GpioCtrlRegs.GPAPUD.bit.GPIO4 = 0;   // Enable pullup on GPIO4
       GpioCtrlRegs.GPAPUD.bit.GPIO5 = 0;   // Enable pullup on GPIO5
       //PWM
       GpioCtrlRegs.GPAMUX1.bit.GPIO0 = 1;  // GPIO0 = PWM1A
       GpioCtrlRegs.GPAMUX1.bit.GPIO1 = 1;  // GPIO1 = PWM1B

       GpioCtrlRegs.GPAMUX1.bit.GPIO2 = 1;  // GPIO2 = PWM2A
       GpioCtrlRegs.GPAMUX1.bit.GPIO3 = 1;  // GPIO3 = PWM2B

       GpioCtrlRegs.GPAMUX1.bit.GPIO4 = 1;  // GPIO4 = PWM3A
       GpioCtrlRegs.GPAMUX1.bit.GPIO5 = 1;  // GPIO5 = PWM3B
       //LAB5
       GpioCtrlRegs.GPEMUX2.bit.GPIO157 = 1;  // GPIO157 = PWM7A
       GpioCtrlRegs.GPEPUD.bit.GPIO157 = 1;

       GpioCtrlRegs.GPEMUX2.bit.GPIO159 = 1;  //  GPIO159 = PWM8A
       GpioCtrlRegs.GPEPUD.bit.GPIO159 = 1;
       //LAB 5

       GpioCtrlRegs.GPAPUD.bit.GPIO31=1;     // Disable pullup on GPIO31
       GpioCtrlRegs.GPBPUD.bit.GPIO34=1;    // Disable pullup on GPIO34
       GpioCtrlRegs.GPADIR.bit.GPIO31 = 1;//GPIO is configured to output
       GpioCtrlRegs.GPBDIR.bit.GPIO34 = 1;//GPIO is configured to output

       GpioCtrlRegs.GPAGMUX2.bit.GPIO31 =0;
       GpioCtrlRegs.GPAMUX2.bit.GPIO31=0;

       GpioCtrlRegs.GPADIR.bit.GPIO10 = 1; //DEBUG, //1 OUTPUT, 0-INPUT.
       GpioDataRegs.GPADAT.bit.GPIO11=1;//GPIO11=1;

       //trip
       GpioCtrlRegs.GPBPUD.bit.GPIO41=0;//Enable the pull-up on GPIO41;
       GpioCtrlRegs.GPBQSEL1.bit.GPIO41=3;//async input GPIO41(tz1);

       InputXbarRegs.INPUT1SELECT=41;

       //GPIO 14 OUTPUTXBAR3 (O)
        GpioCtrlRegs.GPAGMUX1.bit.GPIO14 = 1;
        GpioCtrlRegs.GPAMUX1.bit.GPIO14 = 2;
        GpioCtrlRegs.GPACSEL2.bit.GPIO14 = GPIO_MUX_CPU1;

           //GPIO 14 OUTPUTXBAR3 (O)
       GpioCtrlRegs.GPAGMUX1.bit.GPIO15 = 1;
       GpioCtrlRegs.GPAMUX1.bit.GPIO15 = 2;
       GpioCtrlRegs.GPACSEL2.bit.GPIO15 = GPIO_MUX_CPU1;


       GpioCtrlRegs.GPAGMUX1.bit.GPIO15 = 0;
        GpioCtrlRegs.GPAMUX1.bit.GPIO15 = 0;
       GpioCtrlRegs.GPAPUD.bit.GPIO15 = 1;
       GpioCtrlRegs.GPADIR.bit.GPIO15 = 1;
      GpioCtrlRegs.GPACSEL2.bit.GPIO15 = GPIO_MUX_CPU1CLA;


    EDIS;
}
// lab 4
void Setup_ePWM(void)
{
    EALLOW;
    CpuSysRegs.PCLKCR2.bit.EPWM1=1;//EPWM1 CLOCK ENABLE,
    //LAB 5
    CpuSysRegs.PCLKCR2.bit.EPWM7=1;//EPWM7 CLOCK ENABLE,//LAB 5
    CpuSysRegs.PCLKCR2.bit.EPWM8=1;//EPWM8 CLOCK ENABLE,//LAB 5
    //LAB5

    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC=0;//see ppt, disable the counter
     //EPWM1A
    EPwm1Regs.TBPRD=5000;// Set the timer period; //epwm period=10Khz.
    EPwm1Regs.CMPA.bit.CMPA=EPwm1Regs.TBPRD >> 1;//Duty 50%
    EPwm1Regs.TBPHS.bit.TBPHS=0;//phase is 0;
    EPwm1Regs.TBCTL.bit.SYNCOSEL=TB_CTR_ZERO;//LAB 5
    EPwm1Regs.TBCTR=0x0000;//clear the counter
    EPwm1Regs.TBCTL.bit.CTRMODE=TB_COUNT_UPDOWN;//counter up down;
    EPwm1Regs.TBCTL.bit.PHSEN=TB_DISABLE;//Disable the phase loading;
    EPwm1Regs.TBCTL.bit.HSPCLKDIV=TB_DIV1;//Clock ratio to sysclkout
    EPwm1Regs.TBCTL.bit.CLKDIV=TB_DIV1;//TBCLK = EPWMCLK / (HSPCLKDIV x CLKDIV).EPWMCLK is SYSCLKOUT/2,reset. EPWMCLK=100Mhz

    EPwm1Regs.CMPCTL.bit.SHDWAMODE=CC_SHADOW;//Shadow mode
    EPwm1Regs.CMPCTL.bit.LOADAMODE=CC_CTR_ZERO_PRD;
    //EPwm1Regs.CMPCTL.bit.SHDWBMODE=CC_SHADOW;
   // EPwm1Regs.CMPCTL.bit.LOADBMODE=CC_CTR_ZERO;

    EPwm1Regs.AQCTLA.bit.PRD=AQ_NO_ACTION;
    EPwm1Regs.AQCTLA.bit.ZRO=AQ_NO_ACTION;
    EPwm1Regs.AQCTLA.bit.CAU=AQ_CLEAR;
    EPwm1Regs.AQCTLA.bit.CAD=AQ_SET;

    //DB MODULE
    EPwm1Regs.DBCTL.bit.OUT_MODE=DB_FULL_ENABLE;//0x3, enable the db.
    EPwm1Regs.DBCTL.bit.IN_MODE=DBA_ALL;//00, epwma as input
    EPwm1Regs.DBCTL.bit.POLSEL=DB_ACTV_HIC;// ACTIVE HIGH_COMPLEMENTARY;
    EPwm1Regs.DBRED.bit.DBRED=80;//80*TBCLK;
    EPwm1Regs.DBFED.bit.DBFED=80;

    //ET Module
    EPwm1Regs.ETSEL.bit.SOCAEN=1;//Enable the SOC on A group
    EPwm1Regs.ETSEL.bit.SOCASEL=ET_CTR_PRDZERO;//(Event Trigger Select)
    EPwm1Regs.ETPS.bit.SOCAPRD=ET_1ST;//Trigger on every event

    //TZ Module
    EPwm1Regs.TZSEL.bit.OSHT1=1;// enables TZ1 as a one-shot event source for ePWM1
    //EPwm2Regs.TZSEL.bit.OSHT1=1; PHASE a,b,c
    //EPwm5Regs.TZSEL.bit.OSHT1=1;
    //what do we want TZ1 to do
    EPwm1Regs.TZCTL.bit.TZA=TZ_FORCE_LO;
    EPwm1Regs.TZCTL.bit.TZB=TZ_FORCE_LO;
    //Enable the trip interrupt
    EPwm1Regs.TZEINT.bit.OST=1;


    //EPWM7A
    EPwm7Regs.TBPRD=5000;// Set the timer period; //epwm period=10Khz.
    EPwm7Regs.CMPA.bit.CMPA=0;//Duty 50%
    EPwm7Regs.TBPHS.bit.TBPHS=2000;//phase is 0;
    EPwm7Regs.TBCTL.bit.SYNCOSEL=TB_SYNC_IN;//TB_SYNC_DISABLE;//TB_SYNC_IN;//LAB 5
    EPwm7Regs.TBCTR=0x0000;//clear the counter
    EPwm7Regs.TBCTL.bit.CTRMODE=TB_COUNT_UPDOWN;//counter up down;
    EPwm7Regs.TBCTL.bit.PHSEN=TB_ENABLE;//Enable the phase loading;
    EPwm7Regs.TBCTL.bit.HSPCLKDIV=TB_DIV1;//Clock ratio to sysclkout
    EPwm7Regs.TBCTL.bit.CLKDIV=TB_DIV1;//TBCLK = EPWMCLK / (HSPCLKDIV x CLKDIV).EPWMCLK is SYSCLKOUT/2,reset. EPWMCLK=100Mhz

    EPwm7Regs.CMPCTL.bit.SHDWAMODE=CC_SHADOW;//Shadow mode
    EPwm7Regs.CMPCTL.bit.LOADAMODE=CC_CTR_ZERO_PRD;


    EPwm7Regs.AQCTLA.bit.PRD=AQ_NO_ACTION;
    EPwm7Regs.AQCTLA.bit.ZRO=AQ_NO_ACTION;
    EPwm7Regs.AQCTLA.bit.CAU=AQ_CLEAR;
    EPwm7Regs.AQCTLA.bit.CAD=AQ_SET;

        //DB MODULE
    EPwm7Regs.DBCTL.bit.OUT_MODE=DB_FULL_ENABLE;//0x3, enable the db.
    EPwm7Regs.DBCTL.bit.IN_MODE=DBA_ALL;//00, epwma as input
    EPwm7Regs.DBCTL.bit.POLSEL=DB_ACTV_HIC;// ACTIVE HIGH_COMPLEMENTARY;
    EPwm7Regs.DBRED.bit.DBRED=80;//80*TBCLK;
    EPwm7Regs.DBFED.bit.DBFED=80;

    //EPWM8A

    EPwm8Regs.TBPRD=5000;// Set the timer period; //epwm period=10Khz.
    EPwm8Regs.CMPA.bit.CMPA=0;//
    EPwm8Regs.TBPHS.bit.TBPHS=1000;//phase is 0;
    EPwm8Regs.TBCTL.bit.SYNCOSEL=TB_SYNC_IN;//LAB 5
    EPwm8Regs.TBCTR=0x0000;//clear the counter
    EPwm8Regs.TBCTL.bit.CTRMODE=TB_COUNT_UPDOWN;//counter up down;
    EPwm8Regs.TBCTL.bit.PHSEN=TB_ENABLE;//Enable the phase loading;
    EPwm8Regs.TBCTL.bit.HSPCLKDIV=TB_DIV1;//Clock ratio to sysclkout
    EPwm8Regs.TBCTL.bit.CLKDIV=TB_DIV1;//TBCLK = EPWMCLK / (HSPCLKDIV x CLKDIV).EPWMCLK is SYSCLKOUT/2,reset. EPWMCLK=100Mhz

    EPwm8Regs.CMPCTL.bit.SHDWAMODE=CC_SHADOW;//Shadow mode
    EPwm8Regs.CMPCTL.bit.LOADAMODE=CC_CTR_ZERO_PRD;


    EPwm8Regs.AQCTLA.bit.PRD=AQ_NO_ACTION;
    EPwm8Regs.AQCTLA.bit.ZRO=AQ_NO_ACTION;
    EPwm8Regs.AQCTLA.bit.CAU=AQ_CLEAR;
    EPwm8Regs.AQCTLA.bit.CAD=AQ_SET;

        //DB MODULE
    EPwm8Regs.DBCTL.bit.OUT_MODE=DB_FULL_ENABLE;//0x3, enable the db.
    EPwm8Regs.DBCTL.bit.IN_MODE=DBA_ALL;//00, epwma as input
    EPwm8Regs.DBCTL.bit.POLSEL=DB_ACTV_HIC;// ACTIVE HIGH_COMPLEMENTARY;
    EPwm8Regs.DBRED.bit.DBRED=80;//80*TBCLK;
    EPwm7Regs.DBFED.bit.DBFED=80;


    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 1;
    EDIS;


}

void Setup_ADC(void)
{
    uint16_t acqps = 14;                             // 75ns  (14+1)*1/200M=75ns
    EALLOW;
    CpuSysRegs.PCLKCR13.bit.ADC_A = 1;
    AdcaRegs.ADCCTL2.bit.PRESCALE = 6;          // set ADCCLK as SYSCLK divider to /4 50MHZ
    AdcSetMode(ADC_ADCA, ADC_RESOLUTION_12BIT, ADC_SIGNALMODE_SINGLE);
    AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;       // Set Interrupt pulse generation occurs at the end of the conversion. Results will latch 1 or more cycles later
     AdcaRegs.ADCCTL1.bit.ADCPWDNZ = 1;          // power up the ADC
     DELAY_US(1000);                             // delay for 1ms to allow ADC time to power up
     AdcaRegs.ADCSOC0CTL.bit.CHSEL = 3;    //ADCIN3
     AdcaRegs.ADCSOC0CTL.bit.ACQPS = acqps;          //sample window is 15 SYSCLK cycles
     AdcaRegs.ADCSOC0CTL.bit.TRIGSEL = TRIG_SEL_ePWM1_SOCA; //trigger on ePWM1 SOCA

     AdcaRegs.ADCSOC1CTL.bit.CHSEL = 4;     //ADCIN4
     AdcaRegs.ADCSOC1CTL.bit.ACQPS = acqps;
     AdcaRegs.ADCSOC1CTL.bit.TRIGSEL = TRIG_SEL_ePWM1_SOCA;

     AdcaRegs.ADCINTSEL1N2.bit.INT1SEL = 0x01;       // end of SOC1 will set INT1 flag
     AdcaRegs.ADCINTSEL1N2.bit.INT1E = 1;            // enable INT1 flag
     AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;          // make sure INT1 flag is cleared
     AdcaRegs.ADCINTSEL1N2.bit.INT1CONT=1;


     EDIS;

}

void Setup_DAC(void)
{

        EALLOW;
        CpuSysRegs.PCLKCR16.bit.DAC_A = 1;//Enable the DAC CLOCK
        DacaRegs.DACCTL.bit.SYNCSEL =       0x00;//DAC EPWMSYNCPER 0 select. Determines which EPWMSYNCPER signal will update the DACVALA register.
        DacaRegs.DACCTL.bit.LOADMODE =      0x01;//1 Load on next EPWMSYNCPER specified by SYNCSEL
        DacaRegs.DACCTL.bit.DACREFSEL =     0x01; //ADC VREFHI/VSSA are the reference voltages
        DacaRegs.DACVALS.bit.DACVALS =      0; //12 bits DAC, DACVALS to be zero initially// 0-4095vd
        DacaRegs.DACOUTEN.bit.DACOUTEN =    1;//enable the dac,
        DacaRegs.DACLOCK.all =              0x00;//unlock
        EDIS;
        /////

}

void Setup_CMPSS(void)
{
    EALLOW;
    CpuSysRegs.PCLKCR14.bit.CMPSS3=1;//Enable the clock
    Cmpss3Regs.COMPCTL.bit.COMPDACE=1;//Enable the Cmpss 3.DAC

    //high comparator
    Cmpss3Regs.COMPCTL.bit.COMPHSOURCE=0;//0 Inverting input of comparator driven by internal DAC
    Cmpss3Regs.COMPDACCTL.bit.SELREF=0;//VDDA is the voltage reference for the DAC.
    Cmpss3Regs.COMPDACCTL.bit.DACSOURCE=0;//DACHVALS as the DAC source
    Cmpss3Regs.DACHVALS.bit.DACVAL=3000;
    Cmpss3Regs.COMPCTL.bit.COMPHINV=0;//output is not invertered.

    //low comparator
    Cmpss3Regs.COMPCTL.bit.COMPLSOURCE=0;//0 Inverting input of comparator driven by internal DAC
    Cmpss3Regs.DACHVALS.bit.DACVAL=1000;
    Cmpss3Regs.COMPCTL.bit.COMPHINV=1;//output is  invertered.

    //
    Cmpss3Regs.COMPCTL.bit.CTRIPHSEL=0;//0 Asynchronous comparator output drives CTRIPH
    Cmpss3Regs.COMPCTL.bit.CTRIPOUTHSEL=0;//0 Asynchronous comparator output drives CTRIPOUTH

    Cmpss3Regs.COMPCTL.bit.CTRIPLSEL=0;//0 Asynchronous comparator output drives CTRIPL
    Cmpss3Regs.COMPCTL.bit.CTRIPOUTLSEL=0;//0 Asynchronous comparator output drives CTRIPOUTL

    OutputXbarRegs.OUTPUT4MUX0TO15CFG.bit.MUX4 = 0;//OUTPUT X BAR 4(GPIO 15, )mux 4 Connect to  CMPSS3.CTRIPOUTH
    OutputXbarRegs.OUTPUT3MUX0TO15CFG.bit.MUX5 = 0;//OUTPUT X BAR 3(GPIO 14) MUX 5 connect to the CMPSS3.CTRIPOUTL

    OutputXbarRegs.OUTPUT4MUXENABLE.bit.MUX4 = 1;   // Enable OUTPUTXBAR4 Mux for Output
   OutputXbarRegs.OUTPUT3MUXENABLE.bit.MUX5 = 1;   // Enable OUTPUTXBAR3 Mux for Output
}
