/*
 * isr.c
 *
 *  Created on: 2024528
 *      Author:
 */

//#include"isr.h"
#include "Global.h"
#include "math.h"
__interrupt void isr_cpu_timer0(void)
{
   count_general++;
   if(1==CMD_RESET_PWM)
   {
      count_general = (count_general > 50) ? 0 : count_general;
              if(count_general == 50){

                  CMD_RESET_PWM = 0;

                  EALLOW;
                  EPwm1Regs.TZCLR.bit.OST = 1;//Clear Flag for One-Shot Trip (OST) Latch
                  EPwm1Regs.TZCLR.bit.INT = 1;//interrupt flag clear
                  EPwm1Regs.TZOSTCLR.all = 0xFFFF;//one shot flag interrupt
                  EDIS;


                  GpioDataRegs.GPADAT.bit.GPIO10 = 0;
              }
   }
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
}

__interrupt void isr_adc(void)
{
       GpioDataRegs.GPADAT.bit.GPIO14 = 1;

        adc1 =  vrede =  0.0005*((int)AdcaResultRegs.ADCRESULT0 - 0x7FF);

        v_pll.u[0] = vrede;
        vsync = v_pll.sin_;
        SPLL_SOGI_CALC(&v_pll);

        EPwm7Regs.CMPA.bit.CMPA = (uint16_t) (2500 * (1.0 + ampl *__sin( v_pll.theta[0] + phase)));
        EALLOW;
        DacaRegs.DACVALS.bit.DACVALS = (uint16_t) (2047.0 * (1.0 + ampl * __sin( v_pll.theta[1] + phase)));
      // DacaRegs.DACVALS.bit.DACVALS = (uint16_t) (2047.0 * (1.0 + ampl * sin( v_pll.theta[1] + phase)));
       EDIS;

       plot1[index] = *padc1;
        plot2[index] = *padc2;
       index = (index == 400) ? 0 : (index+1);


        AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;      //clear INT1 flag
        PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
        GpioDataRegs.GPADAT.bit.GPIO14 = 0;
}


__interrupt void isr_epwm_trip(void)
{
    GpioDataRegs.GPADAT.bit.GPIO10=1;
    tripevent++;
    PieCtrlRegs.PIEACK.all=PIEACK_GROUP2;
}

//CLA interrupt
__interrupt void CLA1_isr1(void){
    //count_task++;
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP11;
}

__interrupt void CLA1_isr2(void){
    asm(" ESTOP0");
}

__interrupt void CLA1_isr3(void){
    asm(" ESTOP0");
}

__interrupt void CLA1_isr4(void){
    asm(" ESTOP0");
}

__interrupt void CLA1_isr5(void){
    asm(" ESTOP0");
}

__interrupt void CLA1_isr6(void){
    asm(" ESTOP0");
}

__interrupt void CLA1_isr7(void){
    //asm(" ESTOP0");
    asm(" ESTOP0");
}

__interrupt void CLA1_isr8(void){
    // Acknowledge the end-of-task interrupt for task 8
    PieCtrlRegs.PIEACK.all = M_INT11;
    // Uncomment to halt debugger and stop here
    //    asm(" ESTOP0");
}
