/*
 * Init_pwm.c
 *
 *  Created on: 2023�?�?�?
 *      Author: anker
 */
#include "f28x_project.h"
#include "inc/hw_types.h"
#include "driverlib.h"
#include "device.h"
#include "ctrl.h"
#include "Init_pwm.h"
#include "FunState.h"



//==================================================================================================
//
//==================================================================================================
//
// Array of pointers to EPwm register structures:
// *ePWM[0] is defined as dummy value not used in the example
//
volatile struct EPWM_REGS *ePWM[PWM_CH] = {0, &EPwm1Regs, &EPwm2Regs,
                                           &EPwm3Regs, &EPwm4Regs};


//==================================================================================================
//
//==================================================================================================
//
// HRPWM_Config - Configures all ePWM channels and sets up HRPWM
//                on ePWMxA / ePWMxB  channels
//
void HRPWM_Config( int period)
{
	EALLOW;
	CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 0;
	EDIS;
	
	EALLOW;
	// force all PWM to low
	
	EPwm1Regs.AQSFRC.bit.RLDCSF = 3;
	EPwm2Regs.AQSFRC.bit.RLDCSF = 3;
	EPwm3Regs.AQSFRC.bit.RLDCSF = 3;

    EPwm1Regs.AQCSFRC.all = 0x05;		//PWM1A,PWM1B force low
	EPwm2Regs.AQCSFRC.all = 0x05;		//PWM2A,PWM2B force low�?
	EPwm3Regs.AQCSFRC.all = 0x05;		//PWM3A,PWM3B force low�?

//        EPwm1Regs.TBCTL.bit.FREE_SOFT = 3;  // Count up/dn
//        EPwm2Regs.TBCTL.bit.FREE_SOFT = 3;  // Count up/dn
//        EPwm3Regs.TBCTL.bit.FREE_SOFT = 3;  // Count up/dn

		// Config Epwm1 for HV
		EPwm1Regs.TBPRD = period;
		EPwm1Regs.TBPHS.bit.TBPHS = 0;
		EPwm1Regs.TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN;	// Count up/dn
		EPwm1Regs.TBCTL.bit.PRDLD = TB_SHADOW;
		EPwm1Regs.TBCTL.bit.PHSEN = TB_DISABLE;			//master module

        EPwm1Regs.TBCTL2.bit.PRDLDSYNC = 0;
        
//        SyncSocRegs.SYNCSELECT.bit.SYNCOUT = 0;

		EPwm1Regs.EPWMSYNCINSEL.all = SYNC_IN_SRC_DISABLE_ALL;
        EPwm1Regs.EPWMSYNCOUTEN.bit.ZEROEN = 1;

		//TBCLK=SYSCLKOUT/(HSPCLKDIV * CLKDIV)=SYSCLKOUT
		EPwm1Regs.TBCTL.bit.CLKDIV    = TB_DIV1;				//Timebase clock pre-scale
		EPwm1Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;			//High speed time pre-scale

		// for PWM  wave
		EPwm1Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;
	    EPwm1Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
		EPwm1Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;
		EPwm1Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;
		
	    //
	    // to start don't configure the PWM to do anything

//		EPwm1Regs.AQCTLA.bit.CAU = AQ_CLEAR;			// Set PWM1A on event : ctr = zero
//		EPwm1Regs.AQCTLA.bit.CAD = AQ_SET;			// Clear PWM1A on ctr = cmpa(up)		
//		EPwm1Regs.AQCTLB.bit.CBD = AQ_CLEAR;			
//		EPwm1Regs.AQCTLB.bit.CBU = AQ_SET;			


        EPwm1Regs.AQCTLA.bit.CAU = AQ_CLEAR;             // Set PWM1A on event : ctr = zero
        EPwm1Regs.AQCTLA.bit.ZRO = AQ_SET;          // Clear PWM1A on ctr = cmpa(up)   
        
        EPwm1Regs.AQCTLB.bit.CBD = AQ_CLEAR;            
        EPwm1Regs.AQCTLB.bit.PRD = AQ_SET;          
	
		EPwm1Regs.DBCTL.bit.OUT_MODE = 0x00;
		EPwm1Regs.DBCTL.bit.POLSEL   = 0x00;
        EPwm1Regs.DBCTL.bit.OUTSWAP  = 0x00;
		EPwm1Regs.CMPA.bit.CMPA = 0;
        EPwm1Regs.CMPB.bit.CMPB = period;
        EPwm1Regs.TBCTR = 0;	

        EPwm1Regs.HRCNFG.bit.EDGMODE = 0;       
        EPwm1Regs.HRCNFG2.bit.EDGMODEDB = 0;
////    dc����ģ��
        EPwm1Regs.DCAHTRIPSEL.bit.TRIPINPUT4   = 1;
        EPwm1Regs.DCTRIPSEL.bit.DCAHCOMPSEL    = 15;//�����������?

//      tz����
        EPwm1Regs.TZDCSEL.bit.DCAEVT1          = 2;//���� DCAEVT��������������

        EPwm1Regs.TZSEL.bit.DCAEVT1            = 1;//1��ost 2��cbc
        EPwm1Regs.TZCTL.bit.TZA                = 2;
        EPwm1Regs.TZCTL.bit.TZB                = 2;
        
       

////    re _charge �ж�����
		EPwm1Regs.ETSEL.bit.INTSEL = ET_CTR_ZERO;			// Select INT on Zero event
		EPwm1Regs.ETSEL.bit.INTEN = 1;		// Enable INT
		EPwm1Regs.ETPS.bit.INTPRD = ET_1ST;				// Generate INT on 1st event
//////////	

		// Config Epwm2 for HV
		EPwm2Regs.TBPRD = period;
		EPwm2Regs.TBPHS.bit.TBPHS = 2;
		EPwm2Regs.TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN;	// Count up/dn
		EPwm2Regs.TBCTL.bit.PRDLD = TB_SHADOW;
		EPwm2Regs.TBCTL.bit.PHSEN = TB_ENABLE;
		EPwm2Regs.TBCTL2.bit.PRDLDSYNC = 0;
        EPwm2Regs.EPWMSYNCINSEL.bit.SEL = SYNC_IN_SRC_SYNCOUT_EPWM1;
        EPwm2Regs.EPWMSYNCOUTEN.all = SYNC_OUT_SRC_DISABLE_ALL;
//        EPwm2Regs.EPWMSYNCINSEL.bit.SEL    = SYNC_IN_SRC_DISABLE_ALL;
//        EPwm2Regs.EPWMSYNCOUTEN.bit.ZEROEN = SYNC_OUT_SRC_ENABLE;

		EPwm2Regs.TBCTL.bit.PHSDIR = TB_UP;				//Phase Direction
		//TBCLK=SYSCLKOUT/(HSPCLKDIV * CLKDIV)=SYSCLKOUT
		EPwm2Regs.TBCTL.bit.CLKDIV = TB_DIV1;				//Timebase clock pre-scale
		EPwm2Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;			//High speed time pre-scale

		// for PWM  wave
		//EPwm2Regs.CMPCTL.bit.SHDWAMODE = CC_IMMEDIATE;
		EPwm2Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;
	    EPwm2Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
		EPwm2Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;
		EPwm2Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;
//		EPwm2Regs.AQCTLA.bit.CAU = AQ_CLEAR;			// Set PWM1A on event : ctr = zero
//		EPwm2Regs.AQCTLA.bit.CAD = AQ_SET;			// Clear PWM1A on ctr = cmpa(up)		
//		EPwm2Regs.AQCTLB.bit.CBD = AQ_CLEAR;			
//		EPwm2Regs.AQCTLB.bit.CBU = AQ_SET;	

        EPwm2Regs.AQCTLA.bit.CAU = AQ_CLEAR;           // Set PWM1A on event : ctr = zero
        EPwm2Regs.AQCTLA.bit.ZRO = AQ_SET;          // Clear PWM1A on ctr = cmpa(up)        
        EPwm2Regs.AQCTLB.bit.CBD = AQ_CLEAR;            
        EPwm2Regs.AQCTLB.bit.PRD = AQ_SET;          

			
		EPwm2Regs.DBCTL.bit.OUT_MODE = 0x00;
		EPwm2Regs.DBCTL.bit.POLSEL = 0x00;           //2A----2B  CHANGE IN PCB   MXH 2010/12/15
        EPwm2Regs.DBCTL.bit.OUTSWAP = 0x00;
		EPwm2Regs.CMPA.bit.CMPA = 0;
        EPwm2Regs.CMPB.bit.CMPB = period;

        EPwm2Regs.HRCNFG.bit.EDGMODE = 0;       
        EPwm2Regs.HRCNFG2.bit.EDGMODEDB = 0;

        EPwm2Regs.TBCTR = 0;
        ////    dc����ģ��
                EPwm2Regs.DCAHTRIPSEL.bit.TRIPINPUT4   = 1;
                EPwm2Regs.DCTRIPSEL.bit.DCAHCOMPSEL    = 15;//�����������?
        
        //      tz����
                EPwm2Regs.TZDCSEL.bit.DCAEVT1          = 2;//���� DCAEVT��������������
        
                EPwm2Regs.TZSEL.bit.DCAEVT1            = 1;//1��ost 2��cbc
                EPwm2Regs.TZCTL.bit.TZA                = 2;
                EPwm2Regs.TZCTL.bit.TZB                = 2;
                

        ////    charge �ж�����
                EPwm2Regs.ETSEL.bit.INTSEL = ET_CTR_ZERO;           // Select INT on Zero event
                EPwm2Regs.ETSEL.bit.INTEN = 1;      // Enable INT
                EPwm2Regs.ETPS.bit.INTPRD = ET_1ST;             // Generate INT on 1st event
        //////////
         

		// Config Epwm3 for HV
		EPwm3Regs.TBPRD = period;
		EPwm3Regs.TBPHS.bit.TBPHS = 2;
		EPwm3Regs.TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN;	// Count up/dn
		EPwm3Regs.TBCTL.bit.PRDLD = TB_SHADOW;
		EPwm3Regs.TBCTL.bit.PHSEN = TB_ENABLE;//TB_ENABLE;
		
        EPwm3Regs.TBCTL2.bit.PRDLDSYNC = 0;
//        EPwm3Regs.EPWMSYNCINSEL.bit.SEL = SYNC_IN_SRC_SYNCOUT_EPWM1;
//        EPwm3Regs.EPWMSYNCOUTEN.all = SYNC_OUT_SRC_DISABLE_ALL;
        EPwm3Regs.EPWMSYNCINSEL.bit.SEL = SYNC_IN_SRC_SYNCOUT_EPWM1;
        EPwm3Regs.EPWMSYNCOUTEN.all = SYNC_OUT_SRC_DISABLE_ALL;

		EPwm3Regs.TBCTL.bit.PHSDIR = TB_UP;				//Phase Direction
		//TBCLK=SYSCLKOUT/(HSPCLKDIV * CLKDIV)=SYSCLKOUT
		EPwm3Regs.TBCTL.bit.CLKDIV = TB_DIV1;				//Timebase clock pre-scale
		EPwm3Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;			//High speed time pre-scale

        EPwm3Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;
	    EPwm3Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
		EPwm3Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;
        EPwm3Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;

//		EPwm3Regs.AQCTLB.bit.CAU = AQ_CLEAR;			// Set PWM1A on event : ctr = zero
//		EPwm3Regs.AQCTLB.bit.CAD = AQ_SET;			// Clear PWM1A on ctr = cmpa(up)
//		EPwm3Regs.AQCTLA.bit.CBD = AQ_CLEAR;
//		EPwm3Regs.AQCTLA.bit.CBU = AQ_SET;

        EPwm3Regs.AQCTLB.bit.CAU = AQ_CLEAR;            // Set PWM1A on event : ctr = zero
        EPwm3Regs.AQCTLB.bit.ZRO = AQ_SET;          // Clear PWM1A on ctr = cmpa(up)   
        
        EPwm3Regs.AQCTLA.bit.CBD = AQ_CLEAR;            
        EPwm3Regs.AQCTLA.bit.PRD = AQ_SET;          
		
		EPwm3Regs.DBCTL.bit.OUT_MODE = 0x00;
		EPwm3Regs.DBCTL.bit.POLSEL   = 0x00;
		EPwm3Regs.DBCTL.bit.OUTSWAP  = 0x00;
		EPwm3Regs.CMPA.bit.CMPA      = 0;
        EPwm3Regs.CMPB.bit.CMPB      = period;
        EPwm3Regs.TBCTR              = 0;

        
        EPwm3Regs.HRCNFG.bit.EDGMODE    = 0;       
        EPwm3Regs.HRCNFG2.bit.EDGMODEDB = 0;
        ////    dc����ģ��
                EPwm3Regs.DCAHTRIPSEL.bit.TRIPINPUT4   = 1;
                EPwm3Regs.DCTRIPSEL.bit.DCAHCOMPSEL    = 15;//�����������?
        
        //      tz����
                EPwm3Regs.TZDCSEL.bit.DCAEVT1          = 2;//���� DCAEVT��������������
        
                EPwm3Regs.TZSEL.bit.DCAEVT1            = 1;//1��ost 2��cbc
                EPwm3Regs.TZCTL.bit.TZA                = 2;
                EPwm3Regs.TZCTL.bit.TZB                = 2;
        EDIS;
		
		
        EALLOW;
        ////  ���ñȽ�������
            EPwmXbarRegs.TRIP4MUX0TO15CFG.bit.MUX2 = 1;//epwmxbar ѡ��cmpss2 trip����h/l
            EPwmXbarRegs.TRIP4MUXENABLE.bit.MUX2   = 0;//��ʹ��
        // 
        EDIS;
        
    	EALLOW;
    	CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 1;         // Start all the timers synced
    	EDIS; 



         EALLOW;
            EPwm3Regs.TZCLR.bit.DCAEVT1 = 1;
            EPwm3Regs.TZCLR.bit.OST     = 1;

            EPwm2Regs.TZCLR.bit.DCAEVT1 = 1;
            EPwm2Regs.TZCLR.bit.OST     = 1;

            EPwm1Regs.TZCLR.bit.DCAEVT1 = 1;
            EPwm1Regs.TZCLR.bit.OST     = 1;
        EDIS;  

        
	EPwm2Regs.TBCTL.bit.SWFSYNC = 1;             // Sync for high resolution period
	EPwm3Regs.TBCTL.bit.SWFSYNC = 1;             // Sync for high resolution period

}



//==================================================================================================
//
//==================================================================================================
//#pragma CODE_SECTION(HRPWM_Config_PRD, ".TI.ramfunc");
//
//void HRPWM_Config_PRD( int period)
//{
//    Uint16 j;
//
//    //
//    // ePWM channel register configuration with HRPWM
//    // ePWMxA / ePWMxB toggle low/high with MEP control on Rising edge
//    //
//    EALLOW;
//    EPwm1Regs.TBPRD = period;             // PWM frequency = 1 / period
//    EPwm2Regs.TBPRD = period;             // PWM frequency = 1 / period
//    EPwm3Regs.TBPRD = period;             // PWM frequency = 1 / period
//
////    EPwm1Regs.CMPA.bit.CMPA = 0;   // set duty 50% initially
////    EPwm1Regs.CMPB.bit.CMPB = period;   // set duty 50% initially
//    EPwm1Regs.CMPA.bit.CMPA = ((period/2)-20);   // set duty 50% initially
//    EPwm1Regs.CMPB.bit.CMPB = ((period/2)+20);   // set duty 50% initially
//	
//    EPwm2Regs.CMPA.bit.CMPA = ((period/2)-20);   // set duty 50% initially
//    EPwm2Regs.CMPB.bit.CMPB = ((period/2)+20);   // set duty 50% initially
//
//    EPwm3Regs.CMPA.bit.CMPA = ((period/2)-20);   // set duty 50% initially
//    EPwm3Regs.CMPB.bit.CMPB = ((period/2)+20);   // set duty 50% initially    
//    
//    EDIS;
//}
#pragma CODE_SECTION(HRPWM_Config_PRD_cmpa, ".TI.ramfunc");

static inline void HRPWM_Config_PRD_cmpa( int period,Uint16 dead)
{
//    Uint16 j;

    //
    // ePWM channel register configuration with HRPWM
    // ePWMxA / ePWMxB toggle low/high with MEP control on Rising edge
    //
    EALLOW;
    EPwm1Regs.TBPRD = period;             // PWM frequency = 1 / period
    EPwm2Regs.TBPRD = period;             // PWM frequency = 1 / period
    EPwm3Regs.TBPRD = period;             // PWM frequency = 1 / period

//    EPwm1Regs.CMPA.bit.CMPA = 0;   // set duty 50% initially
//    EPwm1Regs.CMPB.bit.CMPB = period;   // set duty 50% initially
    EPwm1Regs.CMPA.bit.CMPA = (period-dead);   // set duty 50% initially
    EPwm1Regs.CMPB.bit.CMPB = (dead);   // set duty 50% initially
	
    EPwm2Regs.CMPA.bit.CMPA = (period-dead);   // set duty 50% initially
    EPwm2Regs.CMPB.bit.CMPB = (dead);   // set duty 50% initially

    EPwm3Regs.CMPA.bit.CMPA = (period-dead);   // set duty 50% initially
    EPwm3Regs.CMPB.bit.CMPB = (dead);   // set duty 50% initially
    
    EDIS;
}

#pragma CODE_SECTION(HRPWM_Config_pri_sec, ".TI.ramfunc");
static inline void HRPWM_Config_pri_sec(int period,Uint16 dead,Uint16 sycdead)
{
    Uint16 utemp,utemp1;

    //
    // ePWM channel register configuration with HRPWM
    // ePWMxA / ePWMxB toggle low/high with MEP control on Rising edge
    //
//    EALLOW;
    EPwm1Regs.TBPRD = period;             // PWM frequency = 1 / period
    EPwm2Regs.TBPRD = period;             // PWM frequency = 1 / period
    EPwm3Regs.TBPRD = period;             // PWM frequency = 1 / period

    utemp  = (period-sycdead);
    utemp1 = (period-dead);

    if(SysCmd.bit.CharDcdcOn)
    {
//        if(CtrlMess.uSycEnable)
        {
        }
//        else
//        {
//            EPwm1Regs.CMPA.bit.CMPA = (0);   // set duty 50% initially
//            EPwm1Regs.CMPB.bit.CMPB = (period);   // set duty 50% initially
//        }


        EPwm1Regs.CMPA.bit.CMPA = utemp;//(period-sycdead);   // set duty 50% initially
        EPwm1Regs.CMPB.bit.CMPB = (sycdead);   // set duty 50% initially
    	
        EPwm2Regs.CMPA.bit.CMPA = utemp1;//(period-dead);   // set duty 50% initially
        EPwm2Regs.CMPB.bit.CMPB = (dead);   // set duty 50% initially

        EPwm3Regs.CMPA.bit.CMPA = utemp1;//(period-dead);   // set duty 50% initially
        EPwm3Regs.CMPB.bit.CMPB = (dead);   // set duty 50% initially
        
//        EPwm1Regs.CMPA.bit.CMPA = utemp;//(period-sycdead);   // set duty 50% initially
//        EPwm1Regs.CMPB.bit.CMPB = (sycdead);   // set duty 50% initially
    }
    else
    {
        EPwm1Regs.CMPA.bit.CMPA = utemp1;//(period-dead);   // set duty 50% initially
        EPwm1Regs.CMPB.bit.CMPB = (dead);   // set duty 50% initially

//        if(CtrlMess.uSycEnable)
        {
            EPwm2Regs.CMPA.bit.CMPA = utemp;//(period-sycdead);   // set duty 50% initially
            EPwm2Regs.CMPB.bit.CMPB = (sycdead);   // set duty 50% initially
            
            EPwm3Regs.CMPA.bit.CMPA = utemp;//(period-sycdead);   // set duty 50% initially
            EPwm3Regs.CMPB.bit.CMPB = (sycdead);   // set duty 50% initially
        }

//        EPwm1Regs.CMPA.bit.CMPA = utemp1;//(period-dead);   // set duty 50% initially
//        EPwm1Regs.CMPB.bit.CMPB = (dead);   // set duty 50% initially
        
//        else
//        {
//            EPwm2Regs.CMPA.bit.CMPA = 0;   // set duty 50% initially
//            EPwm2Regs.CMPB.bit.CMPB = (period);   // set duty 50% initially
//            
//            EPwm3Regs.CMPA.bit.CMPA = 0;   // set duty 50% initially
//            EPwm3Regs.CMPB.bit.CMPB = (period);   // set duty 50% initially
//        }    	
    }    
    
//    EDIS;
}

//==================================================================================================
//
//==================================================================================================
#pragma CODE_SECTION(HRPWM_Config_stop, ".TI.ramfunc");
void HRPWM_Config_stop(void)
{
//    EALLOW;
	EPwm1Regs.AQSFRC.bit.RLDCSF = 3;
	EPwm2Regs.AQSFRC.bit.RLDCSF = 3;
	EPwm3Regs.AQSFRC.bit.RLDCSF = 3;
	
    EPwm1Regs.AQCSFRC.all = 0x05;		//PWM1A,PWM1B force low
	EPwm2Regs.AQCSFRC.all = 0x05;		//PWM2A,PWM2B force low�?
	EPwm3Regs.AQCSFRC.all = 0x05;		//PWM3A,PWM3B force low�?

    EPwm1Regs.TBPRD = 160;             // PWM frequency = 1 / period
    EPwm2Regs.TBPRD = 160;             // PWM frequency = 1 / period
    EPwm3Regs.TBPRD = 160;             // PWM frequency = 1 / period

    EPwm1Regs.CMPA.bit.CMPA = 0;   // set duty 50% initially
    EPwm1Regs.CMPB.bit.CMPB = 160;   // set duty 50% initially
	
    EPwm2Regs.CMPA.bit.CMPA = 0;   // set duty 50% initially
    EPwm2Regs.CMPB.bit.CMPB = 160;   // set duty 50% initially

    EPwm3Regs.CMPA.bit.CMPA = 0;   // set duty 50% initially
    EPwm3Regs.CMPB.bit.CMPB = 160;   // set duty 50% initially

//    EDIS;
}
//
//#pragma CODE_SECTION(HRPWM_AQ_stop, ".TI.ramfunc");
//void HRPWM_AQ_stop(void)
//{
////    EALLOW;
//	EPwm1Regs.AQSFRC.bit.RLDCSF = 3;
//	EPwm2Regs.AQSFRC.bit.RLDCSF = 3;
//	EPwm3Regs.AQSFRC.bit.RLDCSF = 3;
//	
//    EPwm1Regs.AQCSFRC.all = 0x05;		//PWM1A,PWM1B force low
//	EPwm2Regs.AQCSFRC.all = 0x05;		//PWM2A,PWM2B force low�?
//	EPwm3Regs.AQCSFRC.all = 0x05;		//PWM3A,PWM3B force low�?
////    EDIS;
//}

//#pragma CODE_SECTION(HRPWM_Config_Start, ".TI.ramfunc");
//
//void HRPWM_Config_Start(void)
//{
//    Uint16 j;
//
//    //
//    // ePWM channel register configuration with HRPWM
//    // ePWMxA / ePWMxB toggle low/high with MEP control on Rising edge
//    //
////    
//      EALLOW;
//    for (j = 1;j < PWM_CH;j++)
//    {
//    
//        (*ePWM[j]).AQCSFRC.all = 0;  // set Shadow load
//    }
//
//    EDIS;
//}
#pragma CODE_SECTION(HRPWM_Config_Start_Pri, ".TI.ramfunc");
static inline void HRPWM_Config_Start_Pri(void)
{
//    Uint16 j;

    //
    // ePWM channel register configuration with HRPWM
    // ePWMxA / ePWMxB toggle low/high with MEP control on Rising edge
    //
//    
//    EALLOW;
	EPwm1Regs.AQSFRC.bit.RLDCSF = 0;
	EPwm2Regs.AQSFRC.bit.RLDCSF = 0;
	EPwm3Regs.AQSFRC.bit.RLDCSF = 0;

    EPwm2Regs.AQCSFRC.all = 0; 
    EPwm3Regs.AQCSFRC.all = 0; 
    
//    EDIS;
}
#pragma CODE_SECTION(HRPWM_Config_Start_SEC, ".TI.ramfunc");

static inline void HRPWM_Config_Start_SEC(void)
{
//    Uint16 j;

    //
    // ePWM channel register configuration with HRPWM
    // ePWMxA / ePWMxB toggle low/high with MEP control on Rising edge
    //
//    
//    EALLOW;
    EPwm1Regs.AQSFRC.bit.RLDCSF = 0;
    
    EPwm1Regs.AQCSFRC.all = 0; 
    
//    EDIS;
}

#pragma CODE_SECTION(HRPWM_stop_all, ".TI.ramfunc");
void HRPWM_stop_all(void)
{
//    EALLOW;
    EPwm1Regs.AQSFRC.bit.RLDCSF = 3;
	EPwm2Regs.AQSFRC.bit.RLDCSF = 3;
	EPwm3Regs.AQSFRC.bit.RLDCSF = 3;
	
    EPwm1Regs.AQCSFRC.all = 0x05;		//PWM1A,PWM1B force low
	EPwm2Regs.AQCSFRC.all = 0x05;		//PWM2A,PWM2B force low�?
	EPwm3Regs.AQCSFRC.all = 0x05;		//PWM3A,PWM3B force low�?

//    EDIS;
}


#pragma CODE_SECTION(HRPWM_stop_pri, ".TI.ramfunc");
static inline void HRPWM_stop_pri(void)
{
//    EALLOW;
	EPwm2Regs.AQSFRC.bit.RLDCSF = 3;
	EPwm3Regs.AQSFRC.bit.RLDCSF = 3;
	
//    EPwm1Regs.AQCSFRC.all = 0x05;		//PWM1A,PWM1B force low
	EPwm2Regs.AQCSFRC.all = 0x05;		//PWM2A,PWM2B force low�?
	EPwm3Regs.AQCSFRC.all = 0x05;		//PWM3A,PWM3B force low�?
//    EDIS;
}

#pragma CODE_SECTION(HRPWM_stop_sec, ".TI.ramfunc");
static inline void HRPWM_stop_sec(void)
{
//    EALLOW;
	EPwm1Regs.AQSFRC.bit.RLDCSF = 3;	
    EPwm1Regs.AQCSFRC.all = 0x05;		//PWM1A,PWM1B force low
//    EDIS;
}

//
// adcA1ISR - ADC A Interrupt 1 ISR
//
#pragma CODE_SECTION(epwm1ReCharISR, ".TI.ramfunc");

__interrupt void epwm1ReCharISR(void)
{
    GPIO_WritePin(39, 1);

    PieCtrlRegs.PIEIER3.bit.INTx1 = 0;
    
    if((RunState.RunStaFlag==softer)||(SysCmd.bit.openTest==1))
    {    
        if((SysCmd.bit.openTest==0))
        {           
//            HRPWM_Config_PRD_cmpa(CtrlMess.fprd,CtrlMess.fdb);
            HRPWM_Config_pri_sec(CtrlMess.fprd,CtrlMess.fdb,CtrlMess.fSyc_db);
            
            if(SysCmd.bit.CharDcdcOn)
            {
                HRPWM_Config_Start_Pri();
                
                if(CtrlMess.uSycEnable)
                {
                    HRPWM_Config_Start_SEC();
                }
                else
                {
                    HRPWM_stop_sec();
                }
            }
            else
            {
                HRPWM_Config_Start_SEC();
                
                if(CtrlMess.uSycEnable)
                {
                    HRPWM_Config_Start_Pri();
                } 
                else
                {
                    HRPWM_stop_pri();
                }
            }            
        }
        else
        {            
        	if(CtrlMess.uEnableFlag==0)
        	{
                EPwm1Regs.TBPRD = 357;             // PWM frequency = 1 / period
                EPwm2Regs.TBPRD = 357;             // PWM frequency = 1 / period
                EPwm3Regs.TBPRD = 357;             // PWM frequency = 1 / period
                
                EPwm1Regs.CMPA.bit.CMPA = 0;   // set duty 50% initially
                EPwm1Regs.CMPB.bit.CMPB = 357;   // set duty 50% initially
                
                EPwm2Regs.CMPA.bit.CMPA = 0;   // set duty 50% initially
                EPwm2Regs.CMPB.bit.CMPB = 357;   // set duty 50% initially
                
                EPwm3Regs.CMPA.bit.CMPA = 0;   // set duty 50% initially
                EPwm3Regs.CMPB.bit.CMPB = 357;   // set duty 50% initially
        	}
        	else
        	{
//                HRPWM_Config_PRD_cmpa(CtrlMess.fprd,CtrlMess.fdb);
                HRPWM_Config_pri_sec(CtrlMess.fprd,CtrlMess.fdb,CtrlMess.fSyc_db);
        	} 
            if(SysCmd.bit.CharDcdcOn)
            {
                HRPWM_Config_Start_Pri();
                
                if(CtrlMess.uSycEnable)
                {
                    HRPWM_Config_Start_SEC();
                }
                else
                {
                    HRPWM_stop_sec();
                }
            }
            else
            {
                HRPWM_Config_Start_SEC();
                
                if(CtrlMess.uSycEnable)
                {
                    HRPWM_Config_Start_Pri();
                } 
                else
                {
                    HRPWM_stop_pri();
                }
            }         	
        }
    }
    else
    {
    	if(CtrlMess.uEnableFlag==0)
    	{
            EPwm1Regs.TBPRD = 357;             // PWM frequency = 1 / period
            EPwm2Regs.TBPRD = 357;             // PWM frequency = 1 / period
            EPwm3Regs.TBPRD = 357;             // PWM frequency = 1 / period
            
            EPwm1Regs.CMPA.bit.CMPA = 0;   // set duty 50% initially
            EPwm1Regs.CMPB.bit.CMPB = 357;   // set duty 50% initially
            
            EPwm2Regs.CMPA.bit.CMPA = 0;   // set duty 50% initially
            EPwm2Regs.CMPB.bit.CMPB = 357;   // set duty 50% initially
            
            EPwm3Regs.CMPA.bit.CMPA = 0;   // set duty 50% initially
            EPwm3Regs.CMPB.bit.CMPB = 357;   // set duty 50% initially
        }
    	else
    	{
//            HRPWM_Config_PRD_cmpa(CtrlMess.fprd,CtrlMess.fdb);
            HRPWM_Config_pri_sec(CtrlMess.fprd,CtrlMess.fdb,CtrlMess.fSyc_db);

    	}

        if(SysCmd.bit.CharDcdcOn)
        {
            HRPWM_Config_Start_Pri();
            
            if(CtrlMess.uSycEnable)
            {
                HRPWM_Config_Start_SEC();
            }
            else
            {
                HRPWM_stop_sec();
            }
        }
        else
        {
            HRPWM_Config_Start_SEC();
            
            if(CtrlMess.uSycEnable)
            {
                HRPWM_Config_Start_Pri();
            } 
            else
            {
                HRPWM_stop_pri();
            }
        }     	
    }
    //
    // Acknowledge the interrupt
    //
    EPwm1Regs.ETCLR.bit.INT = 1;
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;
    GpioDataRegs.GPASET.bit.GPIO11 = 1;

    GPIO_WritePin(39, 0);

}

#pragma CODE_SECTION(epwm2CharISR, ".TI.ramfunc");

__interrupt void epwm2CharISR(void)
{

    PieCtrlRegs.PIEIER3.bit.INTx2 = 0;
//    GpioDataRegs.GPATOGGLE.bit.GPIO11 = 1;

    //
    // Acknowledge the interrupt
    //

    EPwm2Regs.ETCLR.bit.INT = 1;
    PieCtrlRegs.PIEACK.all  = PIEACK_GROUP3;
}


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================

