/******************************************************************************
* Copyright (c)
* Original Author	:
* Last rev by		:
* Last rev date		:
* Last change list	:
* Overview			:
* Description		:
* NOTE				:
*******************************************************************************/

//-----------------------------------------------------------------------------
// Include
//-----------------------------------------------------------------------------
//#include "sys_protect.h"

#include "mdb_Init.h"
#include "mdb_sci_RX.h"
#include "mdb_sci_TX.h"
#include "f28002x_device.h"
#include "f28002x_examples.h"
#include "MonitorSci.h"
#include "Protocol.h"
//-----------------------------------------------------------------------------
// Adding Conditional Definitions Stuff
//-----------------------------------------------------------------------------


//==================================================================================================
//
//==================================================================================================
Uint16      uiSciBufferDataID;

Uint16      uiSciComID;

Uint16 uiMonitorSciErrorCntNum;

Uint16      uiUpgradeAckFlag;

Uint16  uiMonitorSciRxDataBuff[RECEIVE_DATA_LENGTH+1]; //uiMonitorSciRxDataBuff

Uint16  uiMonitorSciTxDataBuff[SEND_DATA_LENGTH+1]; 

Uint16  uiMonitorSciRxDataBuff_lin[RECEIVE_DATA_LENGTH+1]; //uiMonitorSciRxDataBuff

Uint16  uiMonitorSciTxDataBuff_lin[SEND_DATA_LENGTH+1]; 

Uint16      uiSciBufferDataLength;

st_abcd    strCmdParaTable[ ];

st_abcd    strSetParaTable[ ];

Uint16  uiSetDataBag[eFirmwarDataLen+2];    //

Uint16  uBatSetDataBag[eBatSetDataLen+2];    //BAT 
Uint16  uBmsSetDataBag[eBmsSetDataLen+2];    //BAT 

Uint16  uBusSetDataBag[eBUSSetDataLen+2];    //BUS 
Uint16  uRegSetDataBag[eREGSetDataLen+2];    //reg

//02/04ָ

Uint16  uBATWarmDataBag[BAT_Warm_DataLen+2];  
Uint16  uBmsStaDataBag[Bms_staDataLen+2];  //bms 

Uint16  uBATFaultDataBag[BAT_Fault_DataLen+2];     
Uint16  uDCDCCharMesDataBag[DCDC_Char_Mes_DataLen+2];     
Uint16  uDCDCReCharMesDataBag[DCDC_ReChar_Mes_DataLen+2];    
Uint16  uMiscDataBag[Misc_DataLen+2];    
Uint16  uTempDataBag[Temp_DataLen+2];    
Uint16  uStaDataBag[Sta_DataLen+2]; 

//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: SciProtocol_Sci_CommandIdentify
-----------------------------------
Function Descriptions:ʶ
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
void MonitorSci_CommandIdentify(void)
{
    Uint16 Addr1,Addr2,Addr3;
    if( uiMonitorSciRxDataBuff[0] == uiModbusSlaveAddr )   //ӻַƥ
    {
        MonitorSci_CrcCheck();
        if( unMonitorSciFlag.bit.bCrcCheckError == FALSE )
        {

            if     (uiMonitorSciRxDataBuff[1] == 0x02)     uiSciComID = eComUpRealStatusMonitorSci;
            else if(uiMonitorSciRxDataBuff[1] == 0x03)     uiSciComID = eComUpSetDataMonitorSci;
            else if(uiMonitorSciRxDataBuff[1] == 0x04)     uiSciComID = eComUpRealAnalogMonitorSci;
            else if(uiMonitorSciRxDataBuff[1] == 0x06)
                uiSciComID = eWriteSetSingleDataMonitorSci;
            else if(uiMonitorSciRxDataBuff[1] == 0x10)     uiSciComID = eWriteSetMultipleDataMonitorSci;
            else if(uiMonitorSciRxDataBuff[1] == 0x45)
            {
                uiSciComID = eUpdateProgramMonitorSci;
                return;
            }
            else
                uiSciComID = eInvalidMonitorSci;



            //жݲѯǷ
            if(uiSciComID != eInvalidMonitorSci)
            {
                uiSciBufferDataID     = ( uiMonitorSciRxDataBuff[2] << 8 ) + uiMonitorSciRxDataBuff[3];
                uiSciBufferDataLength = ( uiMonitorSciRxDataBuff[4] << 8 ) + uiMonitorSciRxDataBuff[5];
                
                Addr1 = uiSciBufferDataID;
                
//                Addr2 = uiSciBufferDataID % 16; //old
//                Addr3 = uiSciBufferDataID + uiSciBufferDataLength-1;  //old                
//                Addr2 = (uiSciBufferDataID + (uiSciBufferDataLength >>4));

                Addr3 = uiSciBufferDataID + uiSciBufferDataLength;


                if(
//                        ((uiSciComID == eComUpRealStatusMonitorSci)  &&(Addr2 > (DSPFAULT_NUMByBit>> 4)))  //02h
                       ((uiSciComID == eComUpRealAnalogMonitorSci)  //04h
                         && (!(
                                ((Addr1 >= Bms_sta_BeginID)&&(Addr1 <= Bms_sta_EndID))
                                ||((Addr1 >= Temp_BeginID)&&(Addr1 <= Temp_EndID))                                
                                ||((Addr1 >= DCDC_ReChar_Mes_BeginID)&&(Addr1 <= DCDC_ReChar_Mes_EndID))
                             )
                           )
                        )
                    || ((uiSciComID == eComUpSetDataMonitorSci)  //03h 
                         &&(!(
                                ((Addr1 >= AnalogFirmwareBeginID)&&(Addr1 <= AnalogFirmwareEndID))
                                ||((Addr1 >= Bms_SetMesAddrBegin)&&(Addr1 <= Bms_SetMesAddrEnd))
                             )
                           )
                       )
                   || ((uiSciComID == eWriteSetSingleDataMonitorSci)  //06 ´ﵥ     Addr3 Ϊ
                        && (!(
                                ((Addr1 >= AnalogFirmwareBeginID)&&(Addr1 <= AnalogFirmwareEndID))
                                ||((Addr1 >= Bms_SetMesAddrBegin)&&(Addr1 <= Bms_SetMesAddrEnd))
                                ||((Addr1 >= DCDC_Char_Mes_BeginID)&&(Addr1 <= DCDC_Char_Mes_EndID))
                             )
                           )
                      )


                      || (    (uiSciComID == eWriteSetMultipleDataMonitorSci)  //´  0x10
                           && (!(
                                ((Addr1 >= AnalogFirmwareBeginID)&&(Addr1 <= AnalogFirmwareEndID))
                                ||((Addr1 >= Bms_SetMesAddrBegin)&&(Addr1 <= Bms_SetMesAddrEnd))
                                ||((Addr1 >= DCDC_Char_Mes_BeginID)&&(Addr1 <= DCDC_Char_Mes_EndID))
                             )
                           )
                         )

                     || (     (uiSciComID == eComUpRealStatusMonitorSci)  //02h ϴʵʱ澯͹
                           && ( (Addr1 < FaultBeginID)|| (Addr1 > FaultEndID) || ( Addr2 > FaultEndID)
                              )
                        )

                )
                {
                    uiSciComID = eInvalidMonitorSci;
                     uiMonitorSciErrorCntNum++;
                }

            }



        }
        else
        {
            uiSciComID = eInvalidMonitorSci;
            uiMonitorSciErrorCntNum++;
        }



    }
    else
    {
        uiSciComID   = eSlaveAddressMismatchMonitorSci;//ӻַƥ
    }
}


//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: MonitorSci_CrcCheck
--------------------------------------
Function Descriptions   :
Parameter Name list :
ReturnTyp           :
Refer doctuments        :
 ******************************************************************************/
void MonitorSci_CrcCheck(void)
{
    static Uint16 uiCrcReciveTemp,uiCrcCheckTemp;
    if(uiReceiveDataLengthCnt < 3)
    {
        unMonitorSciFlag.bit.bCrcCheckError = FALSE;
    }
    else
    {
        uiCrcCheckTemp = MonitorSci_CrcCaculate( &uiMonitorSciRxDataBuff[0],uiReceiveDataLengthCnt - 2 );

        uiCrcReciveTemp = (uiMonitorSciRxDataBuff[uiReceiveDataLengthCnt - 1] << 8) + uiMonitorSciRxDataBuff[uiReceiveDataLengthCnt - 2];

        if( uiCrcReciveTemp == uiCrcCheckTemp ) unMonitorSciFlag.bit.bCrcCheckError = FALSE;
        else unMonitorSciFlag.bit.bCrcCheckError = TRUE;
    }
}


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: MonitorSci_CommandDeal
-----------------------------------
Function Descriptions:
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
void MonitorSci_CommandDeal(void)
{
    int16 iReceiveDataTemp,iReceiveDataError;
    switch( uiSciComID )
    {
    case eUpdateProgramMonitorSci:   //  8 ָ
    {
        Uint16 uiAckLen = 0;
//        uiUpgradeAckFlag = Upgrade_Parse(&uiMonitorSciRxDataBuff[0], &uiMonitorSciTxDataBuff[0]);
        if(uiUpgradeAckFlag == TRUE)
        {
            if(uiMonitorSciTxDataBuff[1] == 0xC5)   //쳣Ӧ
            {
                //쳣Ӧֽڳ=ַ(1)+(1)+(1)+(1)+CRCУ(2) = 6
                uiAckLen = 6;
                MonitorSci_RenewTxBuffer(eInvalidMonitorSci,0,uiAckLen);
                uiMonitorSciErrorCntNum++;
            }
            else
            {
                //Ӧֽڳ=ַ(1)+(1)+(1)+Чֽڳ(2)+(N)+CRCУ(2) = N+7
                uiAckLen = (uiMonitorSciTxDataBuff[3]<<8) + uiMonitorSciTxDataBuff[4] + 7;
                MonitorSci_RenewTxBuffer(eUpdateProgramMonitorSci,0, uiAckLen);
            }
        }
        break;
    }
    case eComUpSlaveAddressMonitorSci: //0 ϴӻַ
    {
        uiBuffLength = 1;
        uiMonitorSciTxDataBuff[0] = uiModbusSlaveAddr;
        break;
    }
    case eComUpRealStatusMonitorSci:  //1 ϴʵʱ澯͹
    {
        MonitorSci_RenewTxBuffer(eComUpRealStatusMonitorSci,uiSciBufferDataID,uiSciBufferDataLength);
        break;
    }
    case eComUpRealAnalogMonitorSci: //2 ϴʵʱģ
    {
        MonitorSci_RenewTxBuffer(eComUpRealAnalogMonitorSci,uiSciBufferDataID,uiSciBufferDataLength);
        break;
    }
    case eComUpSetDataMonitorSci: //3 ϴ
    {
        MonitorSci_RenewTxBuffer(eComUpSetDataMonitorSci,uiSciBufferDataID,uiSciBufferDataLength);
        break;
    }
    case eWriteSetSingleDataMonitorSci: // 06´ﵥ
    {
        iReceiveDataError = 0;

        if((uiSciBufferDataID <= AnalogFirmwareEndID)  && (uiSciBufferDataID >= AnalogFirmwareBeginID))
        {
            iReceiveDataTemp = (uiMonitorSciRxDataBuff[4]<<8) + uiMonitorSciRxDataBuff[5];
            
            uiSetDataBag[uiSciBufferDataID-AnalogFirmwareBeginID] = iReceiveDataTemp;
        }
        else if((uiSciBufferDataID <= DCDC_Char_Mes_EndID)&&(uiSciBufferDataID >= DCDC_Char_Mes_BeginID))
        {
            iReceiveDataTemp = (uiMonitorSciRxDataBuff[4]<<8) + uiMonitorSciRxDataBuff[5];
            uDCDCCharMesDataBag[uiSciBufferDataID - DCDC_Char_Mes_BeginID] = iReceiveDataTemp;           
        }
        else if((uiSciBufferDataID <= Bms_SetMesAddrEnd)&&(uiSciBufferDataID >= Bms_SetMesAddrBegin))
        {
            iReceiveDataTemp = (uiMonitorSciRxDataBuff[4]<<8) + uiMonitorSciRxDataBuff[5];
            uBmsSetDataBag[uiSciBufferDataID - Bms_SetMesAddrBegin] = iReceiveDataTemp;
        }
        
        if(iReceiveDataError == 0)
        {
            MonitorSci_RenewTxBuffer(eWriteSetSingleDataMonitorSci,0, 8 - 2);
        }
        else
        {
            MonitorSci_RenewTxBuffer(eInvalidMonitorSci,0,3);
            uiMonitorSciErrorCntNum++;
        }
        break;
    }
    case eWriteSetMultipleDataMonitorSci://10
    {
        Uint16 usLoop,pSciBuffAddr = 7;




        iReceiveDataError = 0;
        if( ((uiSciBufferDataID <= AnalogFirmwareEndID)  && (uiSciBufferDataID >= AnalogFirmwareBeginID))
           && ((uiSciBufferDataID + uiSciBufferDataLength) <= AnalogFirmwareEndID)
          )
        {
            for(usLoop = uiSciBufferDataID; usLoop < (uiSciBufferDataID + uiSciBufferDataLength); usLoop++)
            {
                iReceiveDataTemp = (uiMonitorSciRxDataBuff[pSciBuffAddr]<<8) + uiMonitorSciRxDataBuff[pSciBuffAddr+1];
                
                uiSetDataBag[uiSciBufferDataID-AnalogFirmwareBeginID] = iReceiveDataTemp;

                pSciBuffAddr = pSciBuffAddr + 2;
           }
        }
        else if(   uiSciBufferDataID < DCDC_Char_Mes_EndID
                && uiSciBufferDataID >= DCDC_Char_Mes_BeginID
                && ((uiSciBufferDataID + uiSciBufferDataLength) <= DCDC_Char_Mes_EndID)
        )
        {
            for(usLoop = uiSciBufferDataID; usLoop < (uiSciBufferDataID + uiSciBufferDataLength); usLoop++)
            {
                iReceiveDataTemp = (uiMonitorSciRxDataBuff[pSciBuffAddr]<<8) + uiMonitorSciRxDataBuff[pSciBuffAddr+1];
//                    uDCDCCharMesDataBag[uiSciBufferDataID - DCDC_Char_Mes_BeginID] = iReceiveDataTemp;           
                uDCDCCharMesDataBag[usLoop - DCDC_Char_Mes_BeginID] = iReceiveDataTemp;
   
                pSciBuffAddr = pSciBuffAddr + 2;
            }
        }
        else if(   uiSciBufferDataID < Bms_SetMesAddrEnd
                && uiSciBufferDataID >= Bms_SetMesAddrEnd
                && ((uiSciBufferDataID + uiSciBufferDataLength) <= Bms_SetMesAddrEnd)
        )
        {
            for(usLoop = uiSciBufferDataID; usLoop < (uiSciBufferDataID + uiSciBufferDataLength); usLoop++)
            {
                iReceiveDataTemp = (uiMonitorSciRxDataBuff[pSciBuffAddr]<<8) + uiMonitorSciRxDataBuff[pSciBuffAddr+1];
//uBmsSetDataBag[uiSciBufferDataID - Bms_SetMesAddrBegin] = iReceiveDataTemp;
                uBmsSetDataBag[usLoop - Bms_SetMesAddrBegin] = iReceiveDataTemp;
   
                pSciBuffAddr = pSciBuffAddr + 2;
            }
        }


        if( iReceiveDataError == 0 )
        {
            MonitorSci_RenewTxBuffer(eWriteSetMultipleDataMonitorSci,0,8 - 2);
        }
        else
        {
            MonitorSci_RenewTxBuffer(eInvalidMonitorSci,0,3);
            uiMonitorSciErrorCntNum++;
        }
        break;
    }
    case eInvalidMonitorSci:
    {
        uiBuffLength = 1;
        MonitorSci_RenewTxBuffer(eInvalidMonitorSci,0,3);
        uiMonitorSciErrorCntNum++;
        break;
    }
    case eSlaveAddressMismatchMonitorSci:
    {
        unMonitorSciFlag.bit.bCmdDealFinish = 1;
        uiBuffLength                    = 0;//ӻַƥҪ鳤
        break;
    }
    default:
        break;
    }
}
/******************************************************************************
Function Name: MonitorSci_RenewTxBuffer
--------------------------------
Function Descriptions:
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
Uint16  uiRenewTxBufferTemp;
Uint16  uiRenewTxBufferCnt;
Uint16  uiUpLoadDataFrameLength;
Uint16  uiUpLoadDataFinish;
Uint16  uiUpLoadDataID;
Uint16  *ptrRenewTxBufferBaseAddr;
Uint16  uiRenewTxBufferLength;
Uint16  *uiAddressEndLimit;
void MonitorSci_RenewTxBuffer(Uint16 uiUpLoadDataType,Uint16 uiUpLoadDataFirstAddr,Uint16 uiUpLoadDataLength)
{
#define SciUploadBufferNumOnce 5

    Uint16  uiRenewBufferLenTemp;
    Uint16 i;

    if( unMonitorSciFlag.bit.bToCmdDealFinish == FALSE )
    {
        switch(uiUpLoadDataType)
        {
            case eUpdateProgramMonitorSci:
            {
                ptrRenewTxBufferBaseAddr = &uiMonitorSciTxDataBuff[0];
                uiRenewTxBufferLength    = 0;
                uiUpLoadDataID           = 0;
                uiUpLoadDataFrameLength  = 0;
                uiAddressEndLimit        = &uiMonitorSciTxDataBuff[SEND_DATA_LENGTH-1];
                uiBuffLength             = uiUpLoadDataLength;
                unMonitorSciFlag.bit.bCmdDealFinish = 1;
                return;
            }
            case eComUpRealAnalogMonitorSci:  // 04 ϴʵʱģ
            {
                if((uiUpLoadDataFirstAddr >= Bms_sta_BeginID)&&(uiUpLoadDataFirstAddr <= Bms_sta_EndID))
                {
                    ptrRenewTxBufferBaseAddr = &uBmsStaDataBag[0];
                    uiMonitorSciTxDataBuff[2]    = uiUpLoadDataLength*2;//ϴݵֽ
                    uiRenewTxBufferLength    = 3;
                    uiUpLoadDataID           = uiUpLoadDataFirstAddr - Bms_sta_BeginID;
                    uiUpLoadDataFrameLength  = uiUpLoadDataLength;                    
                    uiAddressEndLimit        = &uBmsStaDataBag[Bms_staDataLen];
                }
                else if((uiUpLoadDataFirstAddr >= Temp_BeginID)&&(uiUpLoadDataFirstAddr <= Temp_EndID))
                {
                    ptrRenewTxBufferBaseAddr = &uTempDataBag[0];
                    uiMonitorSciTxDataBuff[2]    = uiUpLoadDataLength*2;//ϴݵֽ
                    uiRenewTxBufferLength    = 3;
                    uiUpLoadDataID           = uiUpLoadDataFirstAddr - Temp_BeginID;
                    uiUpLoadDataFrameLength  = uiUpLoadDataLength;
                    uiAddressEndLimit        = &uTempDataBag[Temp_DataLen];
                } 
                else if((uiUpLoadDataFirstAddr >= DCDC_ReChar_Mes_BeginID)&&(uiUpLoadDataFirstAddr <= DCDC_ReChar_Mes_EndID))
                {
                   ptrRenewTxBufferBaseAddr = &uDCDCReCharMesDataBag[0];
                   uiMonitorSciTxDataBuff[2]    = uiUpLoadDataLength*2;//ϴݵֽ
                   uiRenewTxBufferLength    = 3;
                   uiUpLoadDataID          = uiUpLoadDataFirstAddr - DCDC_ReChar_Mes_BeginID;
                   uiUpLoadDataFrameLength  = uiUpLoadDataLength;
                   uiAddressEndLimit        = &uDCDCReCharMesDataBag[DCDC_ReChar_Mes_DataLen];
                } 
                
                break;
            }
            case eComUpRealStatusMonitorSci:   // 0x2    1 ϴʵʱ澯͹
            {
                ptrRenewTxBufferBaseAddr = &UserAdminFault.uiDigital[0];

                if(uiUpLoadDataLength%8 == 0)
                    uiMonitorSciTxDataBuff[2] = (uiUpLoadDataLength>>3);  //ϴݵֽ
                else
                    uiMonitorSciTxDataBuff[2] = (uiUpLoadDataLength>>3) + 1;

                uiRenewTxBufferLength   = 3;
                uiUpLoadDataID           = uiUpLoadDataFirstAddr - FaultBeginID;
                uiUpLoadDataFrameLength = uiUpLoadDataLength    >> 4;//ݳ16λΪһλ  // ϴٸ16λ
                uiAddressEndLimit       = &UserAdminFault.uiDigital[(DIGITAL_NUM>>4) + 1];

                break;

    //            ptrRenewTxBufferBaseAddr = &strFaultFlag.unFault.uiFaultArray[0];
    //            if(uiUpLoadDataLength%8 == 0)uiMonitorSciTxDataBuff[2] = (uiUpLoadDataLength>>3);
    //            else                         uiMonitorSciTxDataBuff[2] = (uiUpLoadDataLength>>3) + 1;
    //            uiRenewTxBufferLength   = 3;
    //            uiUpLoadDataID          = uiUpLoadDataFirstAddr >> 4;//ɢ16Ϊһλ
    //            uiUpLoadDataFrameLength = uiUpLoadDataLength    >> 4;//ݳ16λΪһλ
    //            uiAddressEndLimit       = &strFaultFlag.unFault.uiFaultArray[DSPFAULT_NUM];
    //            break;
            }
            case eComUpSetDataMonitorSci:  //03 ϴ
            {
                if((uiUpLoadDataFirstAddr<=AnalogFirmwareEndID)&&(uiUpLoadDataFirstAddr>=AnalogFirmwareBeginID))
                {
                   ptrRenewTxBufferBaseAddr = &uiSetDataBag[0];
                   uiMonitorSciTxDataBuff[2]= uiUpLoadDataLength*2;                 //ϴݵֽ
                   uiRenewTxBufferLength    = 3;
                   uiUpLoadDataID           = uiUpLoadDataFirstAddr-AnalogFirmwareBeginID;
                   uiUpLoadDataFrameLength  = uiUpLoadDataLength;
                   uiAddressEndLimit        = &uiSetDataBag[eFirmwarDataLen];
                }
                else if((uiUpLoadDataFirstAddr <= Bms_SetMesAddrEnd)&&(uiUpLoadDataFirstAddr >= Bms_SetMesAddrBegin))
                {
                     ptrRenewTxBufferBaseAddr = &uBmsSetDataBag[0];
                     uiMonitorSciTxDataBuff[2]    = uiUpLoadDataLength*2;  //ϴݵֽ
                     uiRenewTxBufferLength    = 3;
                     uiUpLoadDataID           = uiUpLoadDataFirstAddr-Bms_SetMesAddrBegin;
                     uiUpLoadDataFrameLength  = uiUpLoadDataLength;
                     uiAddressEndLimit        = &uBmsSetDataBag[eBmsSetDataLen];
                }               
                else
                {
                      ptrRenewTxBufferBaseAddr = &uiMonitorSciRxDataBuff[0];
                      uiRenewTxBufferLength    = 0;
                      uiUpLoadDataID           = 0;
                      uiUpLoadDataFrameLength  = uiUpLoadDataLength;
                      uiAddressEndLimit        = &uiMonitorSciRxDataBuff[RECEIVE_DATA_LENGTH-1];
                }
                break;
            }
            case eWriteSetSingleDataMonitorSci://06
            {
                ptrRenewTxBufferBaseAddr = &uiMonitorSciRxDataBuff[0];
                uiRenewTxBufferLength    = 0;
                uiUpLoadDataID           = 0;
                uiUpLoadDataFrameLength  = uiUpLoadDataLength;
                uiAddressEndLimit        = &uiMonitorSciRxDataBuff[RECEIVE_DATA_LENGTH-1];
                break;
            }
            case eWriteSetMultipleDataMonitorSci://10
            {
                ptrRenewTxBufferBaseAddr = &uiMonitorSciRxDataBuff[0];
                uiRenewTxBufferLength    = 0;
                uiUpLoadDataID           = 0;
                uiUpLoadDataFrameLength  = uiUpLoadDataLength;
                uiAddressEndLimit        = &uiMonitorSciRxDataBuff[RECEIVE_DATA_LENGTH-1];
                break;
            }
            case eInvalidMonitorSci:
            {
                ptrRenewTxBufferBaseAddr = &uiMonitorSciRxDataBuff[0];
                uiRenewTxBufferLength    = 0;
                uiUpLoadDataID           = 0;
                uiUpLoadDataFrameLength  = uiUpLoadDataLength;
                uiAddressEndLimit        = &uiMonitorSciRxDataBuff[RECEIVE_DATA_LENGTH-1];
                break;
            }
        }
        uiMonitorSciTxDataBuff[0] = uiMonitorSciRxDataBuff[0];
        uiMonitorSciTxDataBuff[1] = uiMonitorSciRxDataBuff[1];
        //-----------------------------------------------------
        //µݳ
        //-----------------------------------------------------
        uiUpLoadDataFinish = 0;
        uiRenewTxBufferCnt = 0;
        unMonitorSciFlag.bit.bToCmdDealFinish = TRUE;
    }
    
    if(uiUpLoadDataFrameLength > SCI_UPLOAD_FRAME_WORDS )
    {
        uiUpLoadDataFrameLength = SCI_UPLOAD_FRAME_WORDS;
    }
    //-----------------------------------------------------
    //·ͻ,ÿһSciUploadBufferNumOnce
    //-----------------------------------------------------
    if(uiUpLoadDataFrameLength <= SciUploadBufferNumOnce)
    {
        uiRenewBufferLenTemp    = uiUpLoadDataFrameLength;
        uiUpLoadDataFrameLength = 0;
        uiUpLoadDataFinish      = 1;
    }
    else
    {
        uiRenewBufferLenTemp    = SciUploadBufferNumOnce;
        uiUpLoadDataFrameLength = uiUpLoadDataFrameLength - SciUploadBufferNumOnce;
    }

    for(uiRenewTxBufferCnt=0;uiRenewTxBufferCnt<uiRenewBufferLenTemp;uiRenewTxBufferCnt++)
    {
        //forѭ̫󣬷жӦforһ䡣
        if((ptrRenewTxBufferBaseAddr + uiUpLoadDataID)>uiAddressEndLimit)
        {
            uiUpLoadDataFinish  = 1;
            uiRenewTxBufferTemp = 0xFFFF;
            break;
        }
        else 
        {
            uiRenewTxBufferTemp = *(ptrRenewTxBufferBaseAddr + uiUpLoadDataID);
        }
        
        if(uiUpLoadDataType == eComUpRealAnalogMonitorSci||uiUpLoadDataType == eComUpSetDataMonitorSci) 
        //дݵӦ:ԭݷ
        {
            uiMonitorSciTxDataBuff[uiRenewTxBufferLength ++] = uiRenewTxBufferTemp >> 8;    //ȴݵĸֽ
            uiMonitorSciTxDataBuff[uiRenewTxBufferLength ++] = uiRenewTxBufferTemp & 0xFF;  //ٴݵĵֽ
            uiUpLoadDataID ++;
        }
        else if(uiUpLoadDataType == eComUpRealStatusMonitorSci)
        {
            uiMonitorSciTxDataBuff[uiRenewTxBufferLength ++] = uiRenewTxBufferTemp & 0xFF;  //ȴݵĸֽ
            uiMonitorSciTxDataBuff[uiRenewTxBufferLength ++] = uiRenewTxBufferTemp >> 8;    //ݵĵֽ
            uiUpLoadDataID ++;
        }
        else// if(uiUpLoadDataType == eWriteSetSingleDataID)||(uiUpLoadDataType == eWriteSetMultipleDataID)
        {
            uiMonitorSciTxDataBuff[uiRenewTxBufferLength ++] = uiRenewTxBufferTemp & 0xFF;  //ٴݵĵֽ
            uiUpLoadDataID ++;
        }       
    }

    //---------------------------------------------------------
    //쳣ָЧʱضӦ
    //---------------------------------------------------------
    if( uiUpLoadDataType == eInvalidMonitorSci )
    {
        uiMonitorSciTxDataBuff[uiRenewTxBufferLength] = UartFunCodeError;
    }
    //-----------------------------------------------------
    //Ƿ귢ͻCRC
    //-----------------------------------------------------
    if( uiUpLoadDataFinish )
    {
        uiRenewTxBufferTemp = MonitorSci_CrcCaculate( &uiMonitorSciTxDataBuff[0], uiRenewTxBufferLength );
        uiMonitorSciTxDataBuff[uiRenewTxBufferLength ++] = uiRenewTxBufferTemp & 0xFF; //ȴУĵֽ
        uiMonitorSciTxDataBuff[uiRenewTxBufferLength ++] = uiRenewTxBufferTemp >> 8;   //ٴУĸֽ
        uiBuffLength = uiRenewTxBufferLength;
        unMonitorSciFlag.bit.bCmdDealFinish = 1;
    }
}


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================

