/******************************************************************************
* Copyright (c)
* Original Author	:
* Last rev by		:
* Last rev date		:
* Last change list	:
* Overview			:
* Description		:
* NOTE				:
*******************************************************************************/

//-----------------------------------------------------------------------------
// Include
//-----------------------------------------------------------------------------
//#include "sys_protect.h"

#include "mdb_Init.h"
#include "mdb_sci_RX.h"
#include "mdb_sci_TX.h"
#include "f28002x_device.h"
#include "f28002x_examples.h"
#include "MonitorSci.h"
#include "Protocol.h"
#include "mdb_lin_RX.h"// DSP2803x CLA Type definitions
#include "mdb_lin_TX.h"

//-----------------------------------------------------------------------------
// Adding Conditional Definitions Stuff
//-----------------------------------------------------------------------------


//==================================================================================================
//
//==================================================================================================
Uint16      uiSciBufferDataID_lin;

Uint16      uiSciComID_lin;

Uint16 uiMonitorSciErrorCntNum_lin;

Uint16      uiUpgradeAckFlag_lin;


Uint16      uiSciBufferDataLength_lin;



//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: SciProtocol_Sci_CommandIdentify
-----------------------------------
Function Descriptions:ʶ
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
void MonitorSci_CommandIdentify_lin(void)
{
    Uint16 Addr1,Addr2,Addr3;
    if( uiMonitorSciRxDataBuff_lin[0] == uiModbusSlaveAddr_lin )   //ӻַƥ
    {
        MonitorSci_CrcCheck_lin();
        if( unMonitorSciFlag_lin.bit.bCrcCheckError == FALSE )
        {

            if     (uiMonitorSciRxDataBuff_lin[1] == 0x02)     uiSciComID_lin = eComUpRealStatusMonitorSci;
            else if(uiMonitorSciRxDataBuff_lin[1] == 0x03)     uiSciComID_lin = eComUpSetDataMonitorSci;
            else if(uiMonitorSciRxDataBuff_lin[1] == 0x04)     uiSciComID_lin = eComUpRealAnalogMonitorSci;
            else if(uiMonitorSciRxDataBuff_lin[1] == 0x06)
                uiSciComID_lin = eWriteSetSingleDataMonitorSci;
            else if(uiMonitorSciRxDataBuff_lin[1] == 0x10)     uiSciComID_lin = eWriteSetMultipleDataMonitorSci;
            else if(uiMonitorSciRxDataBuff_lin[1] == 0x45)
            {
                uiSciComID_lin = eUpdateProgramMonitorSci;
                return;
            }
            else
                uiSciComID_lin = eInvalidMonitorSci;



            //жݲѯǷ
            if(uiSciComID_lin != eInvalidMonitorSci)
            {
                uiSciBufferDataID_lin     = ( uiMonitorSciRxDataBuff_lin[2] << 8 ) + uiMonitorSciRxDataBuff_lin[3];
                uiSciBufferDataLength_lin = ( uiMonitorSciRxDataBuff_lin[4] << 8 ) + uiMonitorSciRxDataBuff_lin[5];
                
                Addr1 = uiSciBufferDataID_lin;
                
                Addr3 = uiSciBufferDataID_lin + uiSciBufferDataLength_lin;


                if(
                       ((uiSciComID_lin == eComUpRealAnalogMonitorSci)  //04h
                         && (!(
                                ((Addr1 >= BAT_Warm_BeginID)&&(Addr1 <= BAT_Warm_EndID))
                                ||((Addr1 >= BAT_Fault_BeginID)&&(Addr1 <= BAT_Fault_EndID))
                                ||((Addr1 >= DCDC_ReChar_Mes_BeginID)&&(Addr1 <= DCDC_ReChar_Mes_EndID))
                                ||((Addr1 >= Misc_BeginID)&&(Addr1 <= Misc_EndID))
                                ||((Addr1 >= Temp_BeginID)&&(Addr1 <= Temp_EndID))
                                ||((Addr1 >= Sta_BeginID)&&(Addr1 <= Sta_EndID))
                             )
                           )
                        )
                    || ((uiSciComID_lin == eComUpSetDataMonitorSci)  //03h 
                         &&(!(
                                ((Addr1 >= AnalogFirmwareBeginID)&&(Addr1 <= AnalogFirmwareEndID))
                                ||((Addr1 >= BAT_SetMesAddrBegin)&&(Addr1 <= BAT_SetMesAddrEnd))
                                ||((Addr1 >= BUS_SetMesAddrBegin)&&(Addr1 <= BUS_SetMesAddrEnd))
                                ||((Addr1 >= REG_SetMesAddrBegin)&&(Addr1 <= REG_SetMesAddrEnd))
                             )
                           )
                       )
                   || ((uiSciComID_lin == eWriteSetSingleDataMonitorSci)  //06 ´ﵥ     Addr3 Ϊ
                        && (!(
                                ((Addr1 >= AnalogFirmwareBeginID)&&(Addr1 <= AnalogFirmwareEndID))
                                ||((Addr1 >= BAT_SetMesAddrBegin)&&(Addr1 <= BAT_SetMesAddrEnd))
                                ||((Addr1 >= BUS_SetMesAddrBegin)&&(Addr1 <= BUS_SetMesAddrEnd))
                                ||((Addr1 >= REG_SetMesAddrBegin)&&(Addr1 <= REG_SetMesAddrEnd))                                
                                ||((Addr1 >= DCDC_Char_Mes_BeginID)&&(Addr1 <= DCDC_Char_Mes_EndID))
                             )
                           )
                      )


                      || (    (uiSciComID_lin == eWriteSetMultipleDataMonitorSci)  //´  0x10
                           && (!(((Addr1 >= AnalogFirmwareBeginID)&&(Addr1 <= AnalogFirmwareEndID))
                            ||((Addr1 >= BAT_SetMesAddrBegin)&&(Addr1 <= BAT_SetMesAddrEnd))
                            ||((Addr1 >= BUS_SetMesAddrBegin)&&(Addr1 <= BUS_SetMesAddrEnd)))
                            )
                         )

                     || (     (uiSciComID_lin == eComUpRealStatusMonitorSci)  //02h ϴʵʱ澯͹
                           && ( (Addr1 < FaultBeginID)|| (Addr1 > FaultEndID) || ( Addr2 > FaultEndID)
                              )
                        )

                )
                {
                    uiSciComID_lin = eInvalidMonitorSci;
                     uiMonitorSciErrorCntNum_lin++;
                }

            }



        }
        else
        {
            uiSciComID_lin = eInvalidMonitorSci;
            uiMonitorSciErrorCntNum_lin++;
        }



    }
    else
    {
        uiSciComID_lin   = eSlaveAddressMismatchMonitorSci;//ӻַƥ
    }
}


//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: MonitorSci_CrcCheck
--------------------------------------
Function Descriptions   :
Parameter Name list :
ReturnTyp           :
Refer doctuments        :
 ******************************************************************************/
void MonitorSci_CrcCheck_lin(void)
{
    static Uint16 uiCrcReciveTemp,uiCrcCheckTemp;
    if(uiReceiveDataLengthCnt_lin < 3)
    {
        unMonitorSciFlag_lin.bit.bCrcCheckError = FALSE;
    }
    else
    {
        uiCrcCheckTemp = MonitorSci_CrcCaculate_lin( &uiMonitorSciRxDataBuff_lin[0],uiReceiveDataLengthCnt_lin - 2 );

        uiCrcReciveTemp = (uiMonitorSciRxDataBuff_lin[uiReceiveDataLengthCnt_lin - 1] << 8) + uiMonitorSciRxDataBuff_lin[uiReceiveDataLengthCnt_lin - 2];

        if( uiCrcReciveTemp == uiCrcCheckTemp ) unMonitorSciFlag_lin.bit.bCrcCheckError = FALSE;
        else unMonitorSciFlag_lin.bit.bCrcCheckError = TRUE;
    }
}


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: MonitorSci_CommandDeal
-----------------------------------
Function Descriptions:
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
void MonitorSci_CommandDeal_lin(void)
{
    int16 iReceiveDataTemp,iReceiveDataError;
    switch( uiSciComID_lin )
    {
    case eUpdateProgramMonitorSci:   //  8 ָ
    {
        Uint16 uiAckLen = 0;
        if(uiUpgradeAckFlag_lin == TRUE)
        {
            if(uiMonitorSciTxDataBuff_lin[1] == 0xC5)   //쳣Ӧ
            {
                //쳣Ӧֽڳ=ַ(1)+(1)+(1)+(1)+CRCУ(2) = 6
                uiAckLen = 6;
                MonitorSci_RenewTxBuffer_lin(eInvalidMonitorSci,0,uiAckLen);
                uiMonitorSciErrorCntNum_lin++;
            }
            else
            {
                //Ӧֽڳ=ַ(1)+(1)+(1)+Чֽڳ(2)+(N)+CRCУ(2) = N+7
                uiAckLen = (uiMonitorSciTxDataBuff_lin[3]<<8) + uiMonitorSciTxDataBuff_lin[4] + 7;
                MonitorSci_RenewTxBuffer_lin(eUpdateProgramMonitorSci,0, uiAckLen);
            }
        }
        break;
    }
    case eComUpSlaveAddressMonitorSci: //0 ϴӻַ
    {
        uiBuffLength_lin = 1;
        uiMonitorSciTxDataBuff_lin[0] = uiModbusSlaveAddr_lin;
        break;
    }
    case eComUpRealStatusMonitorSci:  //1 ϴʵʱ澯͹
    {
        MonitorSci_RenewTxBuffer_lin(eComUpRealStatusMonitorSci,uiSciBufferDataID_lin,uiSciBufferDataLength_lin);
        break;
    }
    case eComUpRealAnalogMonitorSci: //2 ϴʵʱģ
    {
        MonitorSci_RenewTxBuffer_lin(eComUpRealAnalogMonitorSci,uiSciBufferDataID_lin,uiSciBufferDataLength_lin);
        break;
    }
    case eComUpSetDataMonitorSci: //3 ϴ
    {
        MonitorSci_RenewTxBuffer_lin(eComUpSetDataMonitorSci,uiSciBufferDataID_lin,uiSciBufferDataLength_lin);
        break;
    }
    case eWriteSetSingleDataMonitorSci: //4 ´ﵥ
    {
        iReceiveDataError = 0;

        if((uiSciBufferDataID_lin <= AnalogFirmwareEndID)  && (uiSciBufferDataID_lin >= AnalogFirmwareBeginID))
        {
            iReceiveDataTemp = (uiMonitorSciRxDataBuff_lin[4]<<8) + uiMonitorSciRxDataBuff_lin[5];
            
            uiSetDataBag[uiSciBufferDataID_lin-AnalogFirmwareBeginID] = iReceiveDataTemp;
        }
        else if((uiSciBufferDataID_lin <= BUS_SetMesAddrEnd)&&(uiSciBufferDataID_lin >= BUS_SetMesAddrBegin))
        {
            iReceiveDataTemp = (uiMonitorSciRxDataBuff_lin[4]<<8) + uiMonitorSciRxDataBuff_lin[5];

            if(1)
            {
                uBusSetDataBag[uiSciBufferDataID_lin - BUS_SetMesAddrBegin] = iReceiveDataTemp;
            }
            else
            {
                iReceiveDataError = 1;
            }
        }
        else if((uiSciBufferDataID_lin <= DCDC_Char_Mes_EndID)&&(uiSciBufferDataID_lin >= DCDC_Char_Mes_BeginID))
        {
            iReceiveDataTemp = (uiMonitorSciRxDataBuff_lin[4]<<8) + uiMonitorSciRxDataBuff_lin[5];
            uDCDCCharMesDataBag[uiSciBufferDataID_lin - DCDC_Char_Mes_BeginID] = iReceiveDataTemp;
        }        
        else if((uiSciBufferDataID_lin <= BAT_SetMesAddrEnd)&&(uiSciBufferDataID_lin >= BAT_SetMesAddrBegin))
        {
            iReceiveDataTemp = (uiMonitorSciRxDataBuff_lin[4]<<8) + uiMonitorSciRxDataBuff_lin[5];
            if(1)
            {
                uBatSetDataBag[uiSciBufferDataID_lin - BAT_SetMesAddrBegin] = iReceiveDataTemp;
            }
            else
            {
                iReceiveDataError = 1;
            }
        }
        else
        {
            iReceiveDataTemp = (uiMonitorSciRxDataBuff_lin[4]<<8) + uiMonitorSciRxDataBuff_lin[5];
            uRegSetDataBag[uiSciBufferDataID_lin - REG_SetMesAddrBegin] = iReceiveDataTemp;           
        }
        
        if(iReceiveDataError == 0)
        {
            MonitorSci_RenewTxBuffer_lin(eWriteSetSingleDataMonitorSci,0, 8 - 2);
        }
        else
        {
            MonitorSci_RenewTxBuffer_lin(eInvalidMonitorSci,0,3);
            uiMonitorSciErrorCntNum_lin++;
        }
        break;
    }
    case eWriteSetMultipleDataMonitorSci:
    {
        Uint16 usLoop,pSciBuffAddr = 7;

        iReceiveDataError = 0;
        if(   uiSciBufferDataID_lin < SetDataEndID
           && (uiSciBufferDataID_lin + uiSciBufferDataLength_lin) <= SetDataEndID
          )
        {
            for(usLoop = uiSciBufferDataID_lin; usLoop < (uiSciBufferDataID_lin + uiSciBufferDataLength_lin); usLoop++)
            {
                iReceiveDataTemp = (uiMonitorSciRxDataBuff_lin[pSciBuffAddr]<<8) + uiMonitorSciRxDataBuff_lin[pSciBuffAddr+1];
                if(1)
                {
                    uiSetDataBag[usLoop-SetDataBeginID] = iReceiveDataTemp;
                }
                else
                {
                    iReceiveDataError = 1;
                }
                pSciBuffAddr = pSciBuffAddr + 2;
           }
        }
        else if(   uiSciBufferDataID_lin < CommandDataEndID
                && uiSciBufferDataID_lin >= CommandDataBeginID
                && ((uiSciBufferDataID_lin + uiSciBufferDataLength_lin) <= CommandDataEndID)
        )
        {
            for(usLoop = uiSciBufferDataID_lin; usLoop < (uiSciBufferDataID_lin + uiSciBufferDataLength_lin); usLoop++)
            {
                iReceiveDataTemp = (uiMonitorSciRxDataBuff_lin[pSciBuffAddr]<<8) + uiMonitorSciRxDataBuff_lin[pSciBuffAddr+1];
                if(1)
                {
                    uiCommandDataBag[usLoop - CommandDataBeginID] = iReceiveDataTemp;
                }
                else
                {
                    iReceiveDataError = 1;
                }
                pSciBuffAddr = pSciBuffAddr + 2;
            }
        }
        if( iReceiveDataError == 0 )
        {
            MonitorSci_RenewTxBuffer_lin(eWriteSetMultipleDataMonitorSci,0,8 - 2);
        }
        else
        {
            MonitorSci_RenewTxBuffer_lin(eInvalidMonitorSci,0,3);
            uiMonitorSciErrorCntNum_lin++;
        }
        break;
    }
    case eInvalidMonitorSci:
    {
        uiBuffLength_lin = 1;
        MonitorSci_RenewTxBuffer_lin(eInvalidMonitorSci,0,3);
        uiMonitorSciErrorCntNum_lin++;
        break;
    }
    case eSlaveAddressMismatchMonitorSci:
    {
        unMonitorSciFlag_lin.bit.bCmdDealFinish = 1;
        uiBuffLength_lin                    = 0;//ӻַƥҪ鳤
        break;
    }
    default:
        break;
    }
}
/******************************************************************************
Function Name: MonitorSci_RenewTxBuffer
--------------------------------
Function Descriptions:
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
Uint16  uiRenewTxBufferTemp_lin;
Uint16  uiRenewTxBufferCnt_lin;
Uint16  uiUpLoadDataFrameLength_lin;
Uint16  uiUpLoadDataFinish_lin;
Uint16  uiUpLoadDataID_lin;
Uint16  *ptrRenewTxBufferBaseAddr_lin;
Uint16  uiRenewTxBufferLength_lin;
Uint16  *uiAddressEndLimit_lin;
void MonitorSci_RenewTxBuffer_lin(Uint16 uiUpLoadDataType,Uint16 uiUpLoadDataFirstAddr,Uint16 uiUpLoadDataLength)
{
#define SciUploadBufferNumOnce 5

    Uint16  uiRenewBufferLenTemp;
    Uint16 i;

    if( unMonitorSciFlag_lin.bit.bToCmdDealFinish == FALSE )
    {
        switch(uiUpLoadDataType)
        {
            case eUpdateProgramMonitorSci:
            {
                ptrRenewTxBufferBaseAddr_lin = &uiMonitorSciTxDataBuff_lin[0];
                uiRenewTxBufferLength_lin    = 0;
                uiUpLoadDataID_lin           = 0;
                uiUpLoadDataFrameLength_lin  = 0;
                uiAddressEndLimit_lin        = &uiMonitorSciTxDataBuff_lin[SEND_DATA_LENGTH-1];
                uiBuffLength_lin             = uiUpLoadDataLength;
                unMonitorSciFlag_lin.bit.bCmdDealFinish = 1;
                return;
            }
            case eComUpRealAnalogMonitorSci:  // 2 ϴʵʱģ
            {
                if((uiUpLoadDataFirstAddr >= BAT_Warm_BeginID)&&(uiUpLoadDataFirstAddr <= BAT_Warm_EndID))
                {
                    
                    ptrRenewTxBufferBaseAddr_lin = &uBATWarmDataBag[0];
                    uiMonitorSciTxDataBuff_lin[2]    = uiUpLoadDataLength*2;//ϴݵֽ
                    uiRenewTxBufferLength_lin    = 3;
                    uiUpLoadDataID_lin           = uiUpLoadDataFirstAddr - BAT_Warm_BeginID;
                    uiUpLoadDataFrameLength_lin  = uiUpLoadDataLength;                    
                    uiAddressEndLimit_lin        = &uBATWarmDataBag[BAT_Warm_DataLen];
                }
                else if((uiUpLoadDataFirstAddr >= BAT_Fault_BeginID)&&(uiUpLoadDataFirstAddr <= BAT_Fault_EndID))
                {
                   ptrRenewTxBufferBaseAddr_lin = &uBATFaultDataBag[0];
                   uiMonitorSciTxDataBuff_lin[2]    = uiUpLoadDataLength*2;//ϴݵֽ
                   uiRenewTxBufferLength_lin    = 3;
                   uiUpLoadDataID_lin           = uiUpLoadDataFirstAddr - BAT_Fault_BeginID;
                   uiUpLoadDataFrameLength_lin  = uiUpLoadDataLength;                  
                    uiAddressEndLimit_lin        = &uBATFaultDataBag[BAT_Fault_DataLen];
                }
                else if((uiUpLoadDataFirstAddr >= DCDC_ReChar_Mes_BeginID)&&(uiUpLoadDataFirstAddr <= DCDC_ReChar_Mes_EndID))
                {
 
                   ptrRenewTxBufferBaseAddr_lin = &uDCDCReCharMesDataBag[0];
                   uiMonitorSciTxDataBuff_lin[2]    = uiUpLoadDataLength*2;//ϴݵֽ
                   uiRenewTxBufferLength_lin    = 3;
                   uiUpLoadDataID_lin           = uiUpLoadDataFirstAddr - DCDC_ReChar_Mes_BeginID;
                   uiUpLoadDataFrameLength_lin  = uiUpLoadDataLength;
                   uiAddressEndLimit_lin        = &uDCDCReCharMesDataBag[DCDC_ReChar_Mes_DataLen];
                } 
                else if((uiUpLoadDataFirstAddr >= Misc_BeginID)&&(uiUpLoadDataFirstAddr <= Misc_EndID))
                {

                    ptrRenewTxBufferBaseAddr_lin = &uMiscDataBag[0];
                    uiMonitorSciTxDataBuff_lin[2]    = uiUpLoadDataLength*2;//ϴݵֽ
                    uiRenewTxBufferLength_lin    = 3;
                    uiUpLoadDataID_lin           = uiUpLoadDataFirstAddr - Misc_BeginID;
                    uiUpLoadDataFrameLength_lin  = uiUpLoadDataLength;
                    uiAddressEndLimit_lin        = &uMiscDataBag[Misc_DataLen];
                }
                else if((uiUpLoadDataFirstAddr >= Temp_BeginID)&&(uiUpLoadDataFirstAddr <= Temp_EndID))
                {
 
                    ptrRenewTxBufferBaseAddr_lin = &uTempDataBag[0];
                    uiMonitorSciTxDataBuff_lin[2]    = uiUpLoadDataLength*2;//ϴݵֽ
                    uiRenewTxBufferLength_lin    = 3;
                    uiUpLoadDataID_lin           = uiUpLoadDataFirstAddr - Temp_BeginID;
                    uiUpLoadDataFrameLength_lin  = uiUpLoadDataLength;
                    uiAddressEndLimit_lin        = &uTempDataBag[Temp_DataLen];
                } 
                else if((uiUpLoadDataFirstAddr >= Sta_BeginID)&&(uiUpLoadDataFirstAddr <= Sta_EndID))
                {
 
                    ptrRenewTxBufferBaseAddr_lin = &uStaDataBag[0];
                    uiMonitorSciTxDataBuff_lin[2]    = uiUpLoadDataLength*2;//ϴݵֽ
                    uiRenewTxBufferLength_lin    = 3;
                    uiUpLoadDataID_lin           = uiUpLoadDataFirstAddr - Sta_BeginID;
                    uiUpLoadDataFrameLength_lin  = uiUpLoadDataLength;
                    uiAddressEndLimit_lin        = &uTempDataBag[Sta_DataLen];
                }                
                else 
                {
                    ptrRenewTxBufferBaseAddr_lin = &uiMonitorSciRxDataBuff[0];
                    uiRenewTxBufferLength_lin    = 0;
                    uiUpLoadDataID_lin           = 0;
                    uiUpLoadDataFrameLength_lin  = uiUpLoadDataLength;
                }
//                uiAddressEndLimit_lin = &uiAnalogDataBag[eSciAnalogDataEndID];
                break;
            }
            case eComUpRealStatusMonitorSci:   // 0x2    1 ϴʵʱ澯͹
            {
                ptrRenewTxBufferBaseAddr_lin = &UserAdminFault.uiDigital[0];

                if(uiUpLoadDataLength%8 == 0)
                    uiMonitorSciTxDataBuff_lin[2] = (uiUpLoadDataLength>>3);  //ϴݵֽ
                else
                    uiMonitorSciTxDataBuff_lin[2] = (uiUpLoadDataLength>>3) + 1;

                uiRenewTxBufferLength_lin   = 3;
                uiUpLoadDataID_lin           = uiUpLoadDataFirstAddr - FaultBeginID;
                uiUpLoadDataFrameLength_lin = uiUpLoadDataLength    >> 4;//ݳ16λΪһλ  // ϴٸ16λ
                uiAddressEndLimit_lin       = &UserAdminFault.uiDigital[(DIGITAL_NUM>>4) + 1];

                break;
            }
            case eComUpSetDataMonitorSci:  //3 ϴ
            {
                if((uiUpLoadDataFirstAddr<=AnalogFirmwareEndID)&&(uiUpLoadDataFirstAddr>=AnalogFirmwareBeginID))
                {
                   ptrRenewTxBufferBaseAddr_lin = &uiSetDataBag[0];
                   uiMonitorSciTxDataBuff_lin[2]= uiUpLoadDataLength*2;                 //ϴݵֽ
                   uiRenewTxBufferLength_lin    = 3;
                   uiUpLoadDataID_lin           = uiUpLoadDataFirstAddr-AnalogFirmwareBeginID;
                   uiUpLoadDataFrameLength_lin  = uiUpLoadDataLength;
                   uiAddressEndLimit_lin        = &uiSetDataBag[eFirmwarDataLen];
                }
                else if((uiUpLoadDataFirstAddr <= BAT_SetMesAddrEnd)&&(uiUpLoadDataFirstAddr >= BAT_SetMesAddrBegin))
                {
                     ptrRenewTxBufferBaseAddr_lin = &uBatSetDataBag[0];
                     uiMonitorSciTxDataBuff_lin[2]    = uiUpLoadDataLength*2;  //ϴݵֽ
                     uiRenewTxBufferLength_lin    = 3;
                     uiUpLoadDataID_lin           = uiUpLoadDataFirstAddr-BAT_SetMesAddrBegin;
                     uiUpLoadDataFrameLength_lin  = uiUpLoadDataLength;
                     uiAddressEndLimit_lin        = &uiSetDataBag[eBatSetDataLen];
                }
                else if((uiUpLoadDataFirstAddr <= BUS_SetMesAddrEnd)&&(uiUpLoadDataFirstAddr>=BUS_SetMesAddrBegin))
                {
                      ptrRenewTxBufferBaseAddr_lin = &uBusSetDataBag[0];
                      uiMonitorSciTxDataBuff_lin[2]= uiUpLoadDataLength*2;  //ϴݵֽ
                      uiRenewTxBufferLength_lin    = 3;
                      uiUpLoadDataID_lin           = uiUpLoadDataFirstAddr - BUS_SetMesAddrBegin;
                      uiUpLoadDataFrameLength_lin  = uiUpLoadDataLength;
                      uiAddressEndLimit_lin        = &uBusSetDataBag[eBUSSetDataLen];
                }
                else if((uiUpLoadDataFirstAddr <= REG_SetMesAddrEnd)&&(uiUpLoadDataFirstAddr>=REG_SetMesAddrBegin))
                {
                      ptrRenewTxBufferBaseAddr_lin = &uRegSetDataBag[0];
                      uiMonitorSciTxDataBuff_lin[2]= uiUpLoadDataLength*2;  //ϴݵֽ
                      uiRenewTxBufferLength_lin    = 3;
                      uiUpLoadDataID_lin           = uiUpLoadDataFirstAddr - REG_SetMesAddrBegin;
                      uiUpLoadDataFrameLength_lin  = uiUpLoadDataLength;
                      uiAddressEndLimit_lin        = &uRegSetDataBag[eREGSetDataLen];
                }   
                else if((uiUpLoadDataFirstAddr >= DCDC_Char_Mes_BeginID)&&(uiUpLoadDataFirstAddr <= DCDC_Char_Mes_EndID))
                {
                   ptrRenewTxBufferBaseAddr_lin = &uDCDCCharMesDataBag[0];
                   uiMonitorSciTxDataBuff_lin[2]    = uiUpLoadDataLength*2;//ϴݵֽ
                   uiRenewTxBufferLength_lin    = 3;
                   uiUpLoadDataID_lin           = uiUpLoadDataFirstAddr - DCDC_Char_Mes_BeginID;
                   uiUpLoadDataFrameLength_lin  = uiUpLoadDataLength;
                   uiAddressEndLimit_lin        = &uDCDCCharMesDataBag[DCDC_Char_Mes_DataLen];
                }                
                else
                {
                      ptrRenewTxBufferBaseAddr_lin = &uiMonitorSciRxDataBuff_lin[0];
                      uiRenewTxBufferLength_lin    = 0;
                      uiUpLoadDataID_lin           = 0;
                      uiUpLoadDataFrameLength_lin  = uiUpLoadDataLength;
                      uiAddressEndLimit_lin        = &uiMonitorSciRxDataBuff[RECEIVE_DATA_LENGTH-1];
                }
                break;
            }
            case eWriteSetSingleDataMonitorSci:
            {
                ptrRenewTxBufferBaseAddr_lin = &uiMonitorSciRxDataBuff_lin[0];
                uiRenewTxBufferLength_lin    = 0;
                uiUpLoadDataID_lin           = 0;
                uiUpLoadDataFrameLength_lin  = uiUpLoadDataLength;
                uiAddressEndLimit_lin        = &uiMonitorSciRxDataBuff_lin[RECEIVE_DATA_LENGTH-1];
                break;
            }
            case eWriteSetMultipleDataMonitorSci:
            {
                ptrRenewTxBufferBaseAddr_lin = &uiMonitorSciRxDataBuff_lin[0];
                uiRenewTxBufferLength_lin    = 0;
                uiUpLoadDataID_lin           = 0;
                uiUpLoadDataFrameLength_lin  = uiUpLoadDataLength;
                uiAddressEndLimit_lin        = &uiMonitorSciRxDataBuff_lin[RECEIVE_DATA_LENGTH-1];
                break;
            }
            case eInvalidMonitorSci:
            {
                ptrRenewTxBufferBaseAddr_lin = &uiMonitorSciRxDataBuff_lin[0];
                uiRenewTxBufferLength_lin    = 0;
                uiUpLoadDataID_lin           = 0;
                uiUpLoadDataFrameLength_lin  = uiUpLoadDataLength;
                uiAddressEndLimit_lin        = &uiMonitorSciRxDataBuff_lin[RECEIVE_DATA_LENGTH-1];
                break;
            }
        }
        uiMonitorSciTxDataBuff_lin[0] = uiMonitorSciRxDataBuff_lin[0];
        uiMonitorSciTxDataBuff_lin[1] = uiMonitorSciRxDataBuff_lin[1];
        //-----------------------------------------------------
        //µݳ
        //-----------------------------------------------------
        uiUpLoadDataFinish_lin = 0;
        uiRenewTxBufferCnt_lin = 0;
        unMonitorSciFlag_lin.bit.bToCmdDealFinish = TRUE;
    }
    
    if(uiUpLoadDataFrameLength_lin > SCI_UPLOAD_FRAME_WORDS )
    {
        uiUpLoadDataFrameLength_lin = SCI_UPLOAD_FRAME_WORDS;
    }
    //-----------------------------------------------------
    //·ͻ,ÿһSciUploadBufferNumOnce
    //-----------------------------------------------------
    if(uiUpLoadDataFrameLength_lin <= SciUploadBufferNumOnce)
    {
        uiRenewBufferLenTemp    = uiUpLoadDataFrameLength_lin;
        uiUpLoadDataFrameLength_lin = 0;
        uiUpLoadDataFinish_lin      = 1;
    }
    else
    {
        uiRenewBufferLenTemp    = SciUploadBufferNumOnce;
        uiUpLoadDataFrameLength_lin = uiUpLoadDataFrameLength_lin - SciUploadBufferNumOnce;
    }


//    if(uiRenewTxBufferLength_lin>=6)
//    {
//        uiRenewTxBufferLength_lin = 6;
//    }
    for(uiRenewTxBufferCnt_lin=0;uiRenewTxBufferCnt_lin<uiRenewBufferLenTemp;uiRenewTxBufferCnt_lin++)
    {
        //forѭ̫󣬷жӦforһ䡣
        if((ptrRenewTxBufferBaseAddr_lin + uiUpLoadDataID_lin)>uiAddressEndLimit_lin)
        {
            uiUpLoadDataFinish_lin  = 1;
            uiRenewTxBufferTemp_lin = 0xFFFF;
            break;
        }
        else 
        {
            uiRenewTxBufferTemp_lin = *(ptrRenewTxBufferBaseAddr_lin + uiUpLoadDataID_lin);
        }
        
        if(uiUpLoadDataType == eComUpRealAnalogMonitorSci||uiUpLoadDataType == eComUpSetDataMonitorSci) 
        //дݵӦ:ԭݷ
        {
            uiMonitorSciTxDataBuff_lin[uiRenewTxBufferLength_lin ++] = uiRenewTxBufferTemp_lin >> 8;    //ȴݵĸֽ
            uiMonitorSciTxDataBuff_lin[uiRenewTxBufferLength_lin ++] = uiRenewTxBufferTemp_lin & 0xFF;  //ٴݵĵֽ
            uiUpLoadDataID_lin ++;
        }
        else if(uiUpLoadDataType == eComUpRealStatusMonitorSci)
        {
            uiMonitorSciTxDataBuff_lin[uiRenewTxBufferLength_lin ++] = uiRenewTxBufferTemp_lin & 0xFF;  //ȴݵĸֽ
            uiMonitorSciTxDataBuff_lin[uiRenewTxBufferLength_lin ++] = uiRenewTxBufferTemp_lin >> 8;    //ݵĵֽ
            uiUpLoadDataID_lin ++;
        }
        else// if(uiUpLoadDataType == eWriteSetSingleDataID)||(uiUpLoadDataType == eWriteSetMultipleDataID)
        {
            uiMonitorSciTxDataBuff_lin[uiRenewTxBufferLength_lin ++] = uiRenewTxBufferTemp_lin & 0xFF;  //ٴݵĵֽ
            uiUpLoadDataID_lin ++;
        }       
    }

    //---------------------------------------------------------
    //쳣ָЧʱضӦ
    //---------------------------------------------------------
    if( uiUpLoadDataType == eInvalidMonitorSci )
    {
        uiMonitorSciTxDataBuff_lin[uiRenewTxBufferLength_lin] = UartFunCodeError;
    }
    //-----------------------------------------------------
    //Ƿ귢ͻCRC
    //-----------------------------------------------------
    if( uiUpLoadDataFinish_lin )
    {
        uiRenewTxBufferTemp_lin = MonitorSci_CrcCaculate_lin( &uiMonitorSciTxDataBuff_lin[0], uiRenewTxBufferLength_lin );
        uiMonitorSciTxDataBuff_lin[uiRenewTxBufferLength_lin ++] = uiRenewTxBufferTemp_lin & 0xFF; //ȴУĵֽ
        uiMonitorSciTxDataBuff_lin[uiRenewTxBufferLength_lin ++] = uiRenewTxBufferTemp_lin >> 8;   //ٴУĸֽ
        uiBuffLength_lin = uiRenewTxBufferLength_lin;
        unMonitorSciFlag_lin.bit.bCmdDealFinish = 1;
    }

}


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================

