/******************************************************************************


*******************************************************************************/
#ifndef PROTOCOL_H
#define PROTOCOL_H


#include "f28002x_device.h"
//-----------------------------------------------------------------------------
// Conditional Definitions
//-----------------------------------------------------------------------------
#ifdef Protocol_C
	#define Protocol_PUBLIC
	#define Protocol_CONST
#else
	#define Protocol_PUBLIC	extern
	#define Protocol_CONST 	const
#endif

//-----------------------------------------------------------------------------
// Public Constants and Macro Definitions
//-----------------------------------------------------------------------------





////#define     BmsAnalogBeginID1              ((Uint16)4096 )




























// Public Constants and Macro Definitions
#define DIGITAL_NUM              128                     //
#define GBMSStartAddr           BmsAnalogBeginID1        //  GBMSϢ                0x1000
#define CBMSStartAddr           BmsAnalogBeginID2        //  CBMSϢ                0x2000
#define DCDCStartAddr           BmsAnalogBeginID3        //  DCDCϢ                0x7530
#define DCDCSetStartAddr        BmsSetDataBeginID1       //  DCDC         0x0000
#define BMSSetStartAddr         BmsSetDataBeginID2       //  BMS           0x4000

//-----------------------------------------------------------------------------

// Analog Table List 
enum
{
    eAnalogDataBeginID=0x10                            ,
    eAnalogDataFirmwareBeginID= eAnalogDataBeginID     ,
    eInvSN1CodeAnalogID  = eAnalogDataFirmwareBeginID  , // 0   SN1
    eInvSN2CodeAnalogID                                , // 1   SN2
    eInvSN3CodeAnalogID                                , // 2   SN3
    eInvSN4CodeAnalogID                                , // 3   SN4
    AnalogDataRES0                                                , // 4   B
    AnalogDataRES1                                , // 5   B
    AnalogDataRES2                                , // 6   B
    AnalogDataRES3                                , // 7   B
    eHardVersionID1                               , // 0x18   汾
    eHardVersionID2                               , // 0x19   Ӳ汾
    eHardVersionID3                               , // 0x1A  Ԥ110
    AnalogDataRES4                               , // 1B  Ԥ111
    AnalogDataRES5                               , // 1C  Ԥ112
    AnalogDataRES6                               , // 1D  Ԥ113
    AnalogDataRES7                               , // 1E  Ԥ114
    AnalogDataRES8                                    , // 1F
    eFirmwareVer1                          , // 20 ̼汾1
    eFirmwareVer2                          , // 21 ̼汾2
    eFirmwareVer3                          , // 22 ̼汾3
    AnalogDataRES9                                  , // 23
    AnalogDataRES10                                  , // 24
    AnalogDataRES11                                  , // 25
    eBootVer1                                    , // 26 
    eBootVer2                                    , // 27 
    eBootVer3                                    , // 28 
    AnalogDataRES12                                  , // 29
    AnalogDataRES13                                  , // 2a
    AnalogDataRES14                                  , // 2b
    eFirwADDR1                                    , // 2c
    eFirwADDR2                                    , // 2d
    AnalogDataRES15                                  , // 2e
    RESID                                  , // 2f 
    eAnalogDataFirmwareEndID =  RESID      , // 30
    
};

//-----------------------------------------------------------------------------
// Set Table List
enum
{
    eSetDataBeginID                                , // 0  (2000)
    eSetDataFirmwareBeginID= eSetDataBeginID      , // 0  (2000)
    eInvSN1CodeSetID=eSetDataFirmwareBeginID      , // 0  ƷSN1
    eInvSN2CodeSetID                               , // 1  ƷSN2
    eInvSN3CodeSetID                               , // 2  ƷSN3
    eInvSN4CodeSetID                               , // 3  ƷSN4
    eInvSN5CodeSetID                               , // 4  ƷSN5
    eInvSN6CodeSetID                               , // 5  ƷSN6
    eInvSN7CodeSetID                               , // 6  ƷSN7
    eInvSN8CodeSetID                               , // 7  ƷSN8
    eSoftVersionSetID                              , // 8  Ӳ汾
    eHardVersionSetID                              , // 9  汾
    eReserved2010SetID                             , // 10 Ԥ2010
    eReserved2011SetID                             , // 11 Ԥ2011
    eReserved2012SetID                             , // 12 Ԥ2012
    eReserved2013SetID                             , // 13 Ԥ2013
    eReserved2014SetID                             , // 14 Ԥ2014
    eSetDataFirmwareEndID = eReserved2014SetID     , // 14

    eAdjustBeginSetID                             , // 15
    eBatVoltRatioSetID = eAdjustBeginSetID        , // 15 صѹУ׼ϵ
    eBatVoltOffSetID                             , // 16 صѹƫУ׼ϵ
    eDCCurrRatioSetID                            , // 17 ֱУ׼ϵ
    eDCCurrOffSetID                              , // 18 ֱƫУ׼ϵ
    eBusPosVoltRatioSetID                        , // 19 ĸߵѹУ׼ϵ
    eBusPosVoltOffSetID                          , // 20 ĸߵѹƫУ׼ϵ
    eBusNegVoltRatioSetID                        , // 21 ĸߵѹУ׼ϵ
    eBusNegVoltOffSetID                          , // 22 ĸߵѹƫУ׼ϵ
    eBlanceCurrRatioSetID                        , // 23 ƽ·еУ׼ϵ
    eBlanceCurrOffSetID                          , // 24 ƽ·еƫУ׼ϵ
    eGrideVaRatioSetID                           , // 25 AѹУ׼ϵ
    eGrideVaOffSetID                             , // 26 AAѹƫУ׼ϵ
    eGrideVbRatioSetID                           , // 27 BѹУ׼ϵ
    eGrideVbOffSetID                             , // 28 BѹƫУ׼ϵ
    eGrideVcRatioSetID                           , // 29 Ԥ/CѹУ׼ϵ
    eGrideVcOffSetID                             , // 30 Ԥ/CѹƫУ׼ϵ
    eInvVaRatioSetID                             , // 31 AѹУ׼ϵ
    eInvVaOffSetID                               , // 32 AѹƫУ׼ϵ
    eInvVbRatioSetID                             , // 33 BѹУ׼ϵ
    eInvVbOffSetID                               , // 34 BѹƫУ׼ϵ
    eInvVcRatioSetID                             , // 35 Ԥ/CѹУ׼ϵ
    eInvVcOffSetID                               , // 36 Ԥ/CѹƫУ׼ϵ
    eInvIaRatioSetID                             , // 37 AеУ׼ϵ
    eInvIaOffSetID                               , // 38 AеƫУ׼ϵ
    eInvIbRatioSetID                             , // 39 BеУ׼ϵ
    eInvIbOffSetID                               , // 40 BеƫУ׼ϵ
    eInvIcRatioSetID                             , // 41 Ԥ/CеУ׼ϵ
    eInvIcOffSetID                               , // 42 Ԥ/CеƫУ׼ϵ
    eInvIaDcCompRatioSetID                       , // 43 AֱУ׼ϵ
    eInvIaDcCompOffSetID                         , // 44 AֱƫУ׼ϵ
    eInvIbDcCompRatioSetID                       , // 45 BֱУ׼ϵ
    eInvIbDcCompOffSetID                         , // 46 BֱƫУ׼ϵ
    eInvIcDcCompRatioSetID                       , // 47 Ԥ/CֱУ׼ϵ
    eInvIcDcCompOffSetID                         , // 48 Ԥ/CֱƫУ׼ϵ
    eInvVaDcCompRatioSetID                       , // 49 AѹֱУ׼ϵ
    eInvVaDcCompOffSetID                         , // 50 AѹֱƫУ׼ϵ
    eInvVbDcCompRatioSetID                       , // 51 BѹֱУ׼ϵ
    eInvVbDcCompOffSetID                         , // 52 BѹֱƫУ׼ϵ
    eInvVcDcCompRatioSetID                       , // 53 ԤCѹֱУ׼ϵ
    eInvVcDcCompOffSetID                         , // 54 ԤCѹֱƫУ׼ϵ
    eInvTempRatioSetID                           , // 55 ɢ¶ȲУ׼ϵ
    eInvTempOffSetID                             , // 56 ɢ¶ȲƫУ׼ϵ
    eAmbientTempRatioSetID                       , // 57 ڲ¶ȲУ׼ϵ
    eAmbientTempOffSetID                         , // 58 ڲ¶ȲƫУ׼ϵ
    eLeakageCurrRatioSetID                       , // 59 ©У׼ϵ
    eLeakageCurrOffSetID                         , // 60 ©ƫУ׼ϵ
    eZeroGroundVoltRatioSetID                    , // 61 صѹУ׼ϵ
    eZeroGroundVoltOffSetID                      , // 62 صѹƫУ׼ϵ
    eLoadOutPutVaRatioSetID                      , // 63 AѹУ׼ϵ
    eLoadOutPutVaOffSetID                        , // 64 AѹƫУ׼ϵ
    eLoadOutPutVbRatioSetID                      , // 65 BѹУ׼ϵ
    eLoadOutPutVbOffSetID                        , // 66 BѹƫУ׼ϵ
    eLoadOutPutVcRatioSetID                      , // 67 Ԥ/CѹУ׼ϵ
    eLoadOutPutVcOffSetID                        , // 68 Ԥ/CѹƫУ׼ϵ
    eLoadOutPutIaRatioSetID                      , // 69 AУ׼ϵ
    eLoadOutPutIaOffSetID                        , // 70 AƫУ׼ϵ
    eLoadOutPutIbRatioSetID                      , // 71 Ԥ/BУ׼ϵ
    eLoadOutPutIbOffSetID                        , // 72 Ԥ/BƫУ׼ϵ
    eLoadOutPutIcRatioSetID                      , // 73 Ԥ/CУ׼ϵ
    eLoadOutPutIcOffSetID                        , // 74 Ԥ/CƫУ׼ϵ
    eGrideIaRatioSetID                           , // 75 Ԥ/AУ׼ϵ
    eGrideIaOffSetID                             , // 76 Ԥ/AƫУ׼ϵ
    eGrideIbRatioSetID                           , // 77 Ԥ/BУ׼ϵ
    eGrideIbOffSetID                             , // 78 Ԥ/BƫУ׼ϵ
    eGrideIcRatioSetID                           , // 79 Ԥ/CУ׼ϵ
    eGrideIcOffSetID                             , // 80 Ԥ/CƫУ׼ϵ
    eReserved2081SetID                           , // 81 Ԥ2081
    eReserved2082SetID                           , // 82 Ԥ2082
    eReserved2083SetID                           , // 83 Ԥ2083
    eReserved2084SetID                           , // 84 Ԥ2084
    eAdjustEndSetID=eReserved2084SetID             , // 89

    eSetDataControlDebugBeginSetID                 , // 85
    eBusVoltLoopKpSetID=eSetDataControlDebugBeginSetID    ,// 85  ĸߵѹϵ
    eBusVoltLoopKiSetID                            , // 86  ĸߵѹϵ
    eInvILCurrLoopKpSetID                          , // 87  еϵ
    eInvILCurrLoopKiSetID                          , // 88  еϵ
    eVFLoopKpSetID                                 , // 89  VFѹϵ
    eVFLoopKiSetID                                 , // 90  VFѹϵ
    eDroopKpSetID                                  , // 91  Droopϵ
    eDroopKiSetID                                  , // 92  Droopϵ
    eDroopCoeff_MSetID                             , // 93  Droopй´ϵm
    eDroopCoeff_NSetID                             , // 94  Droop޹´ϵn
    eVirtResCoeffSetID                             , // 95  迹ϵ
    eInvVoltDCCompLoopKpSetID                      , // 96  ѹֱѹϵ
    eInvVoltDCCompLoopKiSetID                      , // 97  ѹֱѹϵ
    eInvCurrDCCompLoopKpSetID                      , // 98  ֱϵ
    eInvCurrDCCompLoopKiSetID                      , // 99  ֱϵ
    eReserved2105SetID                             , // 100 Ԥ2105
    eReserved2106SetID                             , // 101 Ԥ2106
    eReserved2107SetID                             , // 102 Ԥ2107
    eReserved2108SetID                             , // 103 Ԥ2108
    eReserved2109SetID                             , // 104 Ԥ2109
    eReserved2110SetID                             , // 105 Ԥ2110
    eReserved2111SetID                             , // 106 Ԥ2111
    eReserved2112SetID                             , // 107 Ԥ2112
    eReserved2113SetID                             , // 108 Ԥ2113
    eReserved2114SetID                             , // 109 Ԥ2114
    eReserved2115SetID                             , // 110 Ԥ2115
    eSetDataControlDebugEndSetID=eReserved2115SetID, //


    eSetDataUserParamBeginSetID                             , // 111  ( 2500 )
    ePowerChangeModeSetID =eSetDataUserParamBeginSetID   , // 111 ʵģʽѡ
    eLVRTEnableSetID                               , // 112 LVRT ͵ѹԽʹ
    eHVRTEnableSetID                               , // 118 HVRT ߵѹԽʹ
    eIslandCheckEnableSetID                        , // 119 µʹ
    eRemotShutdownSetID                            , // 120 DRED/Զ̹ػʹ
    eReserved2505SetID                             , // 121 Ԥ2505
    eReserved2506SetID                             , // 122 Ԥ2506
    eReserved2507SetID                             , // 123 Ԥ2507
    eReserved2508SetID                             , // 124 Ԥ2508
    eLocalPowerOnOrOffSetID                        , // 125 ؿػ
    eFaultClearSetID                               , // 126 
    eCountryCodeSetID                              , // 127 
    eLimitPowerEnableSetID                         , // 128 ޹ʹ
    eLimitPowerValueSetID                          , // 129 ޷ٷֱȣ
    eHardLimitPowerEnableSetID                     , // 130 Ԥ/DREDӲַʹ
    eActivePowerPerSetID                           , // 131 й趨ٷֱȣ
    eReactPowerPerSetID                            , // 132 ޹趨ٷֱȣ
    eReserved2517SetID                             , // 133 Ԥ2517
    eOverVoltProtectSetID                          , // 134 ѹֵ
    eUnderVoltProtectSetID                         , // 135 Ƿѹֵ
    eOverFreqProtectSetID                          , // 136 Ƶֵ
    eUnderFreqProtectSetID                         , // 137 ǷƵֵ
    eWaitGridConnectTimeSetID                      , // 138 ȴӵʱ
    eRecovOverVoltSetID                            , // 139 ָѹֵ
    eRecovUnderVoltSetID                           , // 140 ָǷѹֵ
    eRecovOverFreqSetID                            , // 141 ָƵֵ
    eRecovUnderFreqSetID                           , // 142 ָǷƵֵ
    eRecovFaultTimeSetID                           , // 143 ϻָʱ
    OutOnGridePowerSlopeEnableSetID                , // 144 б¶ʹ
    OutOnGridePowerSlopeTimeSetID                  , // 145 ʵ¶
    eRecovFaultPowerSlopeTimeSetID                 , // 146 ϻָ¶
    eAntiCounterCurrEnableSetID                    , // 147 ʹ
    eReserved2532SetID                             , // 148 Ԥ2532
    eReserved2533SetID                             , // 149 Ԥ2533
    eCVTBusVoltSetID                               , // 150 ֱĸߵѹ趨
    eRateGrideVoltSetID                            , // 151 ѹ
    eRateGrideFreqSetID                            , // 152 Ƶ
    eRateOutVoltSetID                              , // 153 ѹ
    eRateOutFreqSetID                              , // 154 Ƶ
    eRatePowerSetID                                , // 155 
    eWorkModeSetID                                 , // 156 ģʽ
    eOffGrideWorkModeSetID                         , // 157 ģʽ
    eOnOrOffGrideEnableSetID                       , // 158 лʹ
    eDebugModeEnableSetID                          , // 159 ģʽʹ
    eActiveIslandStepSetID                         , // 160 µŶ
    eReserved2545SetID                             , // 161 Ԥ2545
    eReserved2546SetID                             , // 162 Ԥ2546
    eReserved2547SetID                             , // 163 Ԥ2547
    eReserved2548SetID                             , // 164 Ԥ2548
    eReserved2549SetID                             , // 165 Ԥ2549
    eReserved2550SetID                             , // 166 Ԥ2550
    eOver1VoltProtectSetID                         , // 167 һιѹֵ
    eOver1VoltTimeSetID                            , // 168 һιѹʱ
    eOver2VoltProtectSetID                         , // 169 ιѹֵ
    eOver2VoltTimeSetID                            , // 170 ιѹʱ
    eOver3VoltProtectSetID                         , // 171 ιѹֵԤ
    eOver3VoltTimeSetID                            , // 172 ιѹʱ䣨Ԥ
    eUnder1VoltProtectSetID                        , // 173 һǷѹֵ
    eUnder1VoltTimeSetID                           , // 174 һǷѹʱ
    eUnder2VoltProtectSetID                        , // 175 Ƿѹֵ
    eUnder2VoltTimeSetID                           , // 176 Ƿѹʱ
    eUnder3VoltProtectSetID                        , // 177 ǷѹֵԤ
    eUnder3VoltTimeSetID                           , // 178 Ƿѹʱ䣨Ԥ
    e10MinRmsOverVoltSetID                         , // 179 10min Rms ѹֵ
    eOver1FreqProtectSetID                         , // 180 һιƵֵ
    eOver1FreqTimeSetID                            , // 181 һιƵʱ
    eOver2FreqProtectSetID                         , // 182 ιƵֵ
    eOver2FreqTimeSetID                            , // 183 ιƵʱ
    eUnder1FreqProtectSetID                        , // 184 һǷƵֵ
    eUnder1FreqTimeSetID                           , // 185 һǷƵʱ
    eUnder2FreqProtectSetID                        , // 186 ǷƵֵ
    eUnder2FreqTimeSetID                           , // 187 ǷƵʱ
    ePowerModeSetID                                , // 188 ʵģʽѡ
    ePowerFactorCurveEnableSetID                   , // 189 ʹùCos (P)߹ʹ
    eActivePowerAPerSetID                          , // 190 Aйʰٷֱ
    eFactorCosASetID                               , // 191 A๦
    eActivePowerBPerSetID                          , // 192 Bйʰٷֱ
    eFactorCosBSetID                               , // 193 B๦
    eActivePowerCPerSetID                          , // 194 Ԥ/Cйʰٷֱ
    eFactorCosCSetID                               , // 195/C๦
    eLowerLimitVoltOfFactorSetID                   , // 196 Cos ѹ
    eUpperLimitVoltOfFactorSetID                   , // 197 Cos ѹ
    eLowerLimitActivePowerOfFactorSetID            , // 198 Cos (P)йʰٷֱ
    eQ_UCurveEnableSetID                           , // 199 Q(U)߹ʹ
    eVoltRefSetID                                  , // 200 VRef
    eQ_U2SetID                                     , // 201 V2 ѹõ
    eReacPowerPerAtV2SetID                         , // 202 V2 ޹ʰٷֱ
    eQ_U1SetID                                     , // 203 V1 ѹõ
    eReacPowerPerAtV1SetID                         , // 204 V1 ޹ʰٷֱ
    eQ_U3SetID                                     , // 205 V3 ѹõ
    eReacPowerPerAtV3SetID                         , // 206 V3 ޹ʰٷֱ
    eQ_U4SetID                                     , // 207 V4 ѹõ
    eReacPowerPerAtV4SetID                         , // 208 V4 ޹ʰٷֱ
    eQ_URespondTimeSetID                           , // 209 Ӧʱ
    eP_UCurveEnableSetID                           , // 210 P(U) Curve߹ʹ
    eP_U1SetID                                     , // 211 V1 ѹõ
    esendActPowerPerAtV1SetID                      , // 212 P1 V1йʰٷֱ
    eabsorbActPowerPerAtV1SetID                    , // 213 P1` V1йʰٷֱ
    eP_U2SetID                                     , // 214 V2 ѹõ
    esendActPowerPerAtV2SetID                      , // 215 P2 V2йʰٷֱ
    eabsorbActPowerPerAtV2SetID                    , // 216 P2` V2йʰٷֱ
    eP_URespondTimeSetID                           , // 217 Ӧʱ
    eP_FCurveEnableSetID                           , // 218 FP Curve߹ʹ
    eOverFreqStartPointSetID                       , // 219 ƵʴƵʼ㣨½)
    eOverFreqEndPointSetID                         , // 220 ƵʴƵʽ㣨½
    ePowerReduceSlopeTimeSetID                     , // 221 ½б
    eLowerFreqStartPointSetID                      , // 222 ƵСƵʼ㣨
    eLowerFreqEndPointSetID                        , // 223 ƵСƵʽ㣨
    ePowerAddSlopeTimeSetID                        , // 224 б
    eP_FRespondTimeSetID                           , // 225 ʱ
    eRecovFreqAfterOverFreqSetID                   , // 226 Ƶ½Ƶʻֵָ
    eRecovFreqAfterUnderFreqSetID                  , // 227 ǷƵƵʻֵָ
    eP_FRecovTimeSetID                             , // 228 ָʱ
    eP_FPowerRecovSlopeTimeSetID                   , // 229 ʻָб
    ePQCurveEnableSetID                            , // 230 PQ߹ʹ
    eDischarPowerPerAtP3SetID                      , // 231 P3ŵйʰٷֱ
    eDischarPowerPerAtP2SetID                      , // 232 P2ŵйʰٷֱ
    eDischarPowerPerAtP1SetID                      , // 233 P1ŵйʰٷֱ
    eChargPowerPerAtP1SetID                        , // 234 P`1йʰٷֱ
    eChargPowerPerAtP2SetID                        , // 235 P`2йʰٷֱ
    eChargPowerPerAtP3SetID                        , // 236 P`3йʰٷֱ
    eRecPowerPerAtQ3SetID                          , // 237 Q3޹ʰٷֱ(send)
    eRecPowerPerAtQ2SetID                          , // 238 Q2޹ʰٷֱ
    eRecPowerPerAtQ1SetID                          , // 239 Q1޹ʰٷֱ
    eAbsorbRecPowerPerAtQ1SetID                    , // 240 Q`1޹ʰٷֱ(գ
    eAbsorbRecPowerPerAtQ2SetID                    , // 241 Q`2޹ʰٷֱ
    eAbsorbRecPowerPerAtQ3SetID                    , // 242 Q`3޹ʰٷֱ
    eLVRTStartPointSetID                           , // 243 ͵ѹԽ
    eLVRTEndPointSetID                             , // 244 ͵ѹԽյ
    eLVRTStartPointMaxConnectTimeSetID             , // 245 ͵ѹӱʱ
    eLVRTEndPointMaxConnectTimeSetID               , // 246 ͵ѹյӱʱ
    eStartLVRTVoltSetID                            , // 247 LVRTԽѹֵ
    eHVRTStartPointSetID                           , // 248 ߵѹԽ
    eHVRTEndPointSetID                             , // 249 ߵѹԽյ
    eHVRTStartPointMaxConnectTimeSetID             , // 250 ߵѹӱʱ
    eHVRTEndPointMaxConnectTimeSetID               , // 251 ߵѹյӱʱ
    eStartHVRTVoltSetID                            , // 252 HVRTԽѹֵ
    eReserved2637SetID                             , // 253 Ԥ2637
    eReserved2638SetID                             , // 254 Ԥ2638
    eReserved2639SetID                             , // 255 Ԥ2639
    eReserved2640SetID                             , // 256 Ԥ2640
    eReserved2641SetID                             , // 257 Ԥ2641
    eReserved2642SetID                             , // 258 Ԥ2642
    eReserved2643SetID                             , // 259 Ԥ2643
    eReserved2644SetID                             , // 260 Ԥ2644
    eReserved2645SetID                             , // 261 Ԥ2645
    eArmToDspHostFlagSetID                         , // 262 ARMDSP·־

    eDateTime0SetID                                , //  130  ʱ0
    eDateTime1SetID                                , //  131  ʱ1
    eDateTime2SetID                                , //  132  ʱ2
    eMachineTypeNumSetID                           , //  133 ͺ       1
    eDefaultVersionSetID                           , //  134 Ĭֵ汾       1
    eSetDataEnd                                    , //  135
    eFaultRecordAllowTranPfcSetID                  , //  136    ϼ¼־
    eReceiveRecordIDPfcSetID                       , //  137 յļ¼ID

    eSetDataUserParamEndSetID=eReceiveRecordIDPfcSetID    , // 252
    eSciSetDataEndID=eSetDataUserParamEndSetID,


};

//-----------------------------------------------------------------
//----------------------ID---------------------------------
//һԤλҪ16λΪһλ
//-----------------------------------------------------------------
//---------------------------------------------------------------------------//
//***************************************************************************//
//---------------------------------------------------------------------------//



union UnionUserFault {
       Uint16 UnionUserFault[2];            // ,ÿ1bitһ
       struct
       {
           Uint16   bInvRunState                       :1;// 0   Bit0  ״̬
           Uint16   bInvILCurrOverFault                :1;// 1   Bit1  й
           Uint16   bInvBalanceCurrOverFault           :1;// 2   Bit2  ƽŵй
           Uint16   bDCCurrOverFault                   :1;// 3   Bit3  ֱ
           Uint16   bBusVoltOverFault                  :1;// 4   Bit4  ĸ߹ѹ
           Uint16   bBusVoltLowFault                   :1;// 5   Bit5  ĸǷѹ
           Uint16   bBusVoltUnbalanceFault             :1;// 6   Bit6  ĸ߲ƽ
           Uint16   bBusReverseConnectFault            :1;// 7   Bit7  ĸ߽ӷ
           Uint16   bGridVoltOverFault                 :1;// 8   Bit8  ѹ
           Uint16   bGridVoltLowFault                  :1;// 9   Bit9  Ƿѹ
           Uint16   bGridFreqOverFault                 :1;// 10  Bit10 Ƶ
           Uint16   bGridFreqLowFault                  :1;// 11  Bit11 ǷƵ
           Uint16   bOutIRmsCurrOverFault              :1;// 12  Bit12 
           Uint16   bOutPutLoadOverFault               :1;// 13  Bit13 
           Uint16   bOutPutShortFault                  :1;// 14  Bit14 ·
           Uint16   bRelayFault                        :1;// 15  Bit15 ̵
           Uint16   bGridCurrDCCompFault               :1;// 16  Bit16 ֱ
           Uint16   bIslandFault                       :1;// 17  Bit17 µ
           Uint16   bSelfCheckFault                    :1;// 18  Bit18 Լ
           Uint16   bTempOverFault                     :1;// 19  Bit19 
           Uint16   bLeakageCurrOverFault              :1;// 20  Bit20 ©
           Uint16   bZeroGroundVoltOverFault           :1;// 21  Bit21 صѹ
           Uint16   bPLLFault                          :1;// 22  Bit22 
           Uint16   bCANCommunFault                    :1;// 23  Bit23 CAN ͨ쳣
           Uint16   bSCICommunFault                    :1;// 24  Bit24 SCIͨ쳣
           Uint16   bReserved25Fault                   :1;// 25  Bit25 Ԥ
           Uint16   bReserved26Fault                   :1;// 26  Bit26 Ԥ
           Uint16   bReserved27Fault                   :1;// 27  Bit27 Ԥ
           Uint16   bReserved28Fault                   :1;// 28  Bit28 Ԥ
           Uint16   bReserved29Fault                   :1;// 29  Bit29 Ԥ
           Uint16   bReserved30Fault                   :1;// 30  Bit30 Ԥ
           Uint16   bReserved31Fault                   :1;// 31  Bit31 Ԥ
       }bit;


};



union UnionAdminFault {
       Uint16 UnionAdminFault[5];            // ,ÿ1bitһ
       struct
       {
            Uint16  bAdcIntInvILAFastOverCurrFault         :1;  //  0   Bit0 :Aпٹ
            Uint16  bAdcIntInvILBFastOverCurrFault         :1;  //  1   Bit1 :Bпٹ
            Uint16  bAdcIntInvILCFastOverCurrFault         :1;  //  2   Bit2 :Ԥ/Cпٹ
            Uint16  bAdcIntBalanceILFastOverCurrFault      :1;  //  3   Bit3 :ƽŵпٹ
            Uint16  bAdc1msBusFastOverVoltFault            :1;  //  4   Bit4 :ĸ߿ٹѹ
            Uint16  bAdc1msPosBusFastOverVoltFault         :1;  //  5   Bit5 :ĸ߿ٹѹ
            Uint16  bAdc1msNegBusFastOverVoltFault         :1;  //  6   Bit6 :ĸ߿ٹѹ
            Uint16  bAdc1msGridAFastOverVoltFault          :1;  //  7   Bit7 :Aٹѹ
            Uint16  bAdc1msGridBFastOverVoltFault          :1;  //  8   Bit8 :Bٹѹ
            Uint16  bAdc1ms_Reserved9Fault                 :1;  //  9   Bit9 :Ԥ/Cٹѹ
            Uint16  bIo1msILACurrLimitFault                :1;  //  10  Bit10:A
            Uint16  bIo1msILBCurrLimitFault                :1;  //  11  Bit11:B
            Uint16  bIo1ms_Reserved12Fault                 :1;  //  12  Bit12:Ԥ/C
            Uint16  bIo1msBalanceCurrLimitFault            :1;  //  13  Bit13:ƽŵ
            Uint16  b1msDCOverCurrFault                    :1;  //  14  Bit14:ֱ
            Uint16  bIo1msReserved15Fault                  :1;  //  15  Bit15:Ԥ15
            Uint16  bAdc1msInvAFastOverVoltFault           :1;  //  16  Bit16:Aٹѹ
            Uint16  bAdc1msGrideBFastOverVoltFault         :1;  //  17  Bit17:Bٹѹ
            Uint16  bAdc1ms_Reserved18Fault                :1;  //  18  Bit18:Ԥ/Cٹѹ
            Uint16  bAdc5msDCBusVoltSlowOverFault          :1;  //  19  Bit19:ĸٹѹ
            Uint16  bAdc5msPosBusVoltSlowOverFault         :1;  //  20  Bit20:ĸٹѹ
            Uint16  bAdc5msNegBusVoltSlowOverFault         :1;  //  21  Bit21:ĸٹѹ
            Uint16  bAdc5msDCBusVoltSlowLowerFault         :1;  //  22  Bit22:ĸǷѹ
            Uint16  bAdc5msPosBusVoltSlowLowerFault        :1;  //  23  Bit23:ĸǷѹ
            Uint16  bAdc5msNegBusVoltSlowLowerFault        :1;  //  24  Bit24:ĸǷѹ
            Uint16  bIo5msDCBusVoltUnbalanceFault          :1;  //  25  Bit25:ĸ߲ƽ
            Uint16  bIo5msDCBusReverseConnectFault         :1;  //  26  Bit26:ĸ߽ӷ
            Uint16  bIo5msGridARmsOverVoltFault            :1;  //  27  Bit27:AЧֵѹ
            Uint16  bIo5msGridBRmsOverVoltFault            :1;  //  28  Bit28:BЧֵѹ
            Uint16  bIo5ms_Reserved29Fault                 :1;  //  29  Bit29:Ԥ/CЧֵѹ
            Uint16  bIo5ms_Reserved30Fault                 :1;  //  30  Bit30:Ԥ30
            Uint16  bIo5ms_Reserved31Fault                 :1;  //  31  Bit31:Ԥ31
            Uint16  bIo5msGridARmsLowerVoltFault           :1;  //  32  Bit32:AЧֵǷѹ
            Uint16  bIo5msGridBRmsLowerVoltFault           :1;  //  33  Bit33:BЧֵǷѹ
            Uint16  bIo5ms_Reserved34Fault                 :1;  //  34  Bit34:Ԥ/CЧֵǷѹ
            Uint16  bIo5msGridOverFreqFault                :1;  //  35  Bit35:Ƶ
            Uint16  bIo5msGridLowerFreqFault               :1;  //  36  Bit36:ǷƵ
            Uint16  bIo5msGridARmsOverCurrFault            :1;  //  37  Bit37:AЧֵ
            Uint16  bIo5msGridBRmsOverCurrFault            :1;  //  38  Bit38:BЧֵ
            Uint16  bIo5ms_Reserved39Fault                 :1;  //  39  Bit39:Ԥ/CЧֵ
            Uint16  bIo5msOutPut105LoadOverFault           :1;  //  40  Bit40:105%
            Uint16  bIo5msOutPut125LoadOverFault           :1;  //  41  Bit41:125%
            Uint16  bIo5msOutPut150LoadOverFault           :1;  //  42  Bit42:150%
            Uint16  bIo5msGridARelayFault                  :1;  //  43  Bit43:A̵
            Uint16  bIo5msGridBRelayFault                  :1;  //  44  Bit44:B̵
            Uint16  bIo5msReserved45Fault                  :1;  //  45  Bit45:Ԥ/C̵
            Uint16  bIo5msSoftStartFault                   :1;  //  46  Bit46:
            Uint16  bIo5msOutPutShortFault                 :1;  //  47  Bit47:·
            Uint16  bIo5msSelfCheckFault                   :1;  //  48  Bit48:Լʧ
            Uint16  bIo5msLeakageCurrOverFault             :1;  //  49  Bit49:©
            Uint16  bIo5msZeroGroundVoltOverFault          :1;  //  50  Bit50:صѹ
            Uint16  bIo5msInvACurrDCCompFault              :1;  //  51  Bit51:Aֱ
            Uint16  bIo5msInvBCurrDCCompFault              :1;  //  52  Bit52:Bֱ
            Uint16  bIo5ms_Reserved53Fault                 :1;  //  53  Bit53:Ԥ/Cֱ
            Uint16  bIo5msIslandFault                      :1;  //  54  Bit54:µ
            Uint16  bIo5msPLLFault                         :1;  //  55  Bit55:
            Uint16  bAdc20msInvTempOverFault               :1;  //  56  Bit56:¶ȹ
            Uint16  bAdc20msAmbientTempOverFault           :1;  //  57  Bit57:¶ȹ
            Uint16  bIo20msEepromFault                     :1;  //  58  Bit58:EEPROM 
            Uint16  bIo20msCANCommunFault                  :1;  //  59  Bit59:CAN ͨ쳣
            Uint16  bIo20msSCICommunFault                  :1;  //  60  Bit60:SCIͨ쳣
            Uint16  bAdmin_Reserved61Fault                 :1;  //  61  Bit61:Ԥ61
            Uint16  bAdmin_Reserved62Fault                 :1;  //  62  Bit62:Ԥ62
            Uint16  bAdmin_Reserved63Fault                 :1;  //  63  Bit63:Ԥ63
            Uint16  bAdmin_Reserved64Fault                 :1;  //  64  Bit64:Ԥ64
            Uint16  bAdmin_Reserved65Fault                 :1;  //  65  Bit65:Ԥ65
            Uint16  bAdmin_Reserved66Fault                 :1;  //  66  Bit66:Ԥ66
            Uint16  bAdmin_Reserved67Fault                 :1;  //  67  Bit67:Ԥ67
            Uint16  bAdmin_Reserved68Fault                 :1;  //  68  Bit68:Ԥ68
            Uint16  bAdmin_Reserved69Fault                 :1;  //  69  Bit69:Ԥ69
            Uint16  bAdmin_Reserved70Fault                 :1;  //  70  Bit70:Ԥ70
            Uint16  bAdmin_Reserved71Fault                 :1;  //  71  Bit71:Ԥ71
            Uint16  bAdmin_Reserved72Fault                 :1;  //  72  Bit72:Ԥ72
            Uint16  bAdmin_Reserved73Fault                 :1;  //  73  Bit73:Ԥ73
            Uint16  bAdmin_Reserved74Fault                 :1;  //  74  Bit74:Ԥ74
            Uint16  bAdmin_Reserved75Fault                 :1;  //  75  Bit75:Ԥ75
            Uint16  bAdmin_Reserved76Fault                 :1;  //  76  Bit76:Ԥ76
            Uint16  bAdmin_Reserved77Fault                 :1;  //  77  Bit77:Ԥ77
            Uint16  bAdmin_Reserved78Fault                 :1;  //  78  Bit78:Ԥ78
            Uint16  bAdmin_Reserved79Fault                 :1;  //  79  Bit79:Ԥ79
       }bit;

};




//
//typedef struct  {
//    union   UnionUserFault                      UserFault;                      //û
//    union   UnionAdminFault                     AdminFault;                     //
//    Uint16                                      rsvd1[10];
//
//}User_AdminFault;
//



typedef union
{
    Uint16 uiDigital[(DIGITAL_NUM>>4) + 1];            // ,ÿ1bitһ
    struct
    {
    union   UnionUserFault                      UserFault;                      //û
    union   UnionAdminFault                     AdminFault;                     //
    }Fault;

}SumUserAdminFault;




Protocol_PUBLIC SumUserAdminFault  UserAdminFault     ;




//-----------------------------------------------------------------
//----------------------ID-------------------------------
//-----------------------------------------------------------------
enum
{
    eDCOutVoltSetCmdID          ,   //  0   ֱѹ趨ֵ
    eDCOutCurrLimitSetCmdID     ,   //  1   ֱ趨ֵ
    eACCurrLimitEnCmdID         ,   //  2   ʹ
    eModOutVoltTypeSet0CmdID    ,   //  3   ģѹ0
    eModOutVoltTypeSet1CmdID    ,   //  4   ģѹ1
    eModOnOffCmdID              ,   //  5   ģ鿪ػ
    eModVoltOverLockResetCmdID  ,   //  6   ģѹλ
    eModCommLedCmdID            ,   //  7   ģ̵ͨ˸
    eModAddrCfgCmdID            ,   //  8   ģеַ
    eIndicateLedCmdID           ,   //  9   ָʾƿ
//    bit0~bit1:̵
//        00Զ
//        01̵0.5Hz
//        10̵ƿ4Hz
//        11̵Ƴ
//    bit2~bit3:ƻƵ
//        00Զ
//        01Ƶ0.5Hz
//        10Ƶƿ4Hz
//        11ƵƳ
//    bit4~bit5:ƺ
//        00Զ
//        010.5Hz
//        10ƿ4Hz
//        11Ƴ
//    bit6~bit15
    eMaskAlarm1CmdID           ,   //  10  θ澯1   // 1Σ0Զ
//    bit0:ѹ
//    bit1:
//    bit2:Ԥ
//    bit3:Ԥ
//    bit4:ȹ
//    bit5~bit15:Ԥ
    eMaskAlarm2CmdID           ,   //  11  θ澯2   // 1Σ0Զ
//    bit0:Ԥ
//    bit1:ģǷѹ澯
//    bit2:ģ齻ƽ澯
//    bit3:ģ齻ȱ澯
//    bit4:ģ鲻ܴɵز
//    bit5:Ԥ
//    bit6:ģѹ
//    bit7:ģPFC
//    bit8:ģ鲻
//    bit9:߸澯
//    bit10:ģڲͨ쳣澯
//    bit11:ģ˿ϸ澯
//    bit12:Ԥ
//    bit13:ģͣ澯
//    bit14:ĸߵѹزƽ澯
//    bit15:ַͻ
    eMaskAlarm3CmdID           ,   //  12  θ澯3   // 1Σ0Զ
//    bit0:ģӲַ쳣
//    bit1:ģ빲ģѹ쳣
//    bit2:̵Ȧ·澯
//    bit3:뷴Ӹ澯
//    bit4~bit15:Ԥ
    eMaskAlarm4CmdID           ,   //  13  θ澯4   // 1Σ0Զ
//    bit0~bit15:Ԥ
    eFaultClearCmdID           ,   //  14  
    eRecoverSetDefaultCmdID    ,   //  15  ָĬֵ,111:У׼ϵȫָĬֵ 222ȫָĬֵ 333:ָSOCĬֵ
	eSysControl1CmdID          ,   //  16     ϵͳָ1
	eSysControl2CmdID          ,   //  17     ϵͳָ2
	eOutputVoltAdjustCmdID     ,   //  18     ѹ΢
	eDateTimeCalib1CmdID       ,   //  19     ʱУ׼bit0-bit9:(0~999);bit10-bit15:(0~59)
	eDateTimeCalib2CmdID       ,   //  20     ʱУ׼bit0-bit5:(0~59);bit6-bit10:ʱ(0~23);bit11-bit15:(1~31)
	eDateTimeCalib3CmdID       ,   //  21     ʱУ׼bit0-bit3:(1~12);bit4-bit15:(0~4096)
	//eSciCommdEndID,
};

//----------------------------------------------------------------------------------
//λ
//----------------------------------------------------------------------------------
typedef union
{
    Uint16 uiDigital;            // 
    struct
    {
    	Uint16	bReserved0		:2;		//    bit0~bit1:
    	Uint16	bHardMainVer	:3;		//    bit2~bit4:Ӳ汾,001111ֱʾһ7Ʒ
    	Uint16	bHardSubVer		:4;		//    bit5~bit8:ӲС汾,ÿģӲС汾ݾ壻
    	Uint16	bEfficiencyType	:4;		//    bit9~bit12:Ч
										//        0000<90%
										//        00019091%
										//        00109192%
										//        00119293%
										//        01009394%
										//        01019495%
										//        01109596%
										//        01119697%
										//        10009798%
										//        10019899%
										//        1010>99%
    	Uint16	bOutVoltType	:3;		//    bit13~bit15:ѹ
										//        000:48V
										//        001:24V
										//        010:60V
										//        011:48V/60V
										//        100:240V
										//        101:336V

    }bit;
}Union_CharWord1;


typedef union
{
    Uint16 uiDigital;            // 
    struct
    {
    	Uint16	bRateOutCurrent	:10;	//    bit0~bit9:,1ʾ0.5A,0~1023ʾ0511.5A
    	Uint16	bInputVolt		:2;		//    bit10~bit11:ѹ
										//        00: 220V  AC
										//        01: 110V  AC
										//        11: ֽ֧롢ֱ롢̫
    	Uint16	bACPhaseNum		:2;		//    bit12~bit13:,00,01
    	Uint16	bSupplyPowerMode:2;		//    bit14~bit15:緽ʽ,00,01˫

    }bit;
}Union_CharWord2;


typedef union
{
    Uint16 uiDigital;            // 
    struct
    {
    	Uint16	bGreenLedCmd	:2;		//	0	bit0~bit1	̵ƿ
    	Uint16	bYellowLedCmd	:2;		//	1	bit2~bit3	Ƶƿ
    	Uint16	bRedLedCmd		:2;		//	2	bit4~bit5	ƿ
    	Uint16	bReservedCmd	:10;	//	3	bit6~bit15	Ԥ

    }bit;
}Union_IndicateLedCmd;


typedef union
{
    Uint16 uiDigital[4];            // ,ÿ1bitһ
    struct
    {
    	Uint16	bOutVoltOverLockFault	    :1;	//	0	bit0	ѹ
    	Uint16	bEnviTempOverFault	        :1;	//	1	bit1	¹
    	Uint16	bReserved2Fault	            :1;	//	2	bit2	Ԥ
    	Uint16	bReserved3Fault	            :1;	//	3	bit3	Ԥ
    	Uint16	bFanFault	                :1;	//	4	bit4	ȹ
    	Uint16	bReserved5Fault	            :1;	//	5	bit5	Ԥ
    	Uint16	bReserved6Fault	            :1;	//	6	bit6	Ԥ
    	Uint16	bReserved7Fault	            :1;	//	7	bit7	Ԥ
    	Uint16	bReserved8Fault	            :1;	//	8	bit8	Ԥ
    	Uint16	bReserved9Fault	            :1;	//	9	bit9	Ԥ
    	Uint16	bReserved10Fault	        :1;	//	10	bit10	Ԥ
    	Uint16	bReserved11Fault	        :1;	//	11	bit11	Ԥ
    	Uint16	bReserved12Fault	        :1;	//	12	bit12	Ԥ
    	Uint16	bReserved13Fault	        :1;	//	13	bit13	Ԥ
    	Uint16	bReserved14Fault	        :1;	//	14	bit14	Ԥ
    	Uint16	bReserved15Fault	        :1;	//	15	bit15	Ԥ
    	Uint16	bReserved16Fault	        :1;	//	16	bit0	Ԥ
    	Uint16	bModInputVoltLowAlarm	    :1;	//	17	bit1	ģǷѹ澯
    	Uint16	bModACVoltUnbalanceAlarm	:1;	//	18	bit2	ģ齻ƽ澯
    	Uint16	bModACLossPhaseAlarm	    :1;	//	19	bit3	ģ齻ȱ澯
    	Uint16	bModUnloadToUnevenCurrAlarm	:1;	//	20	bit4	ģ鲻ܴɵز
    	Uint16	bReserved21Fault	        :1;	//	21	bit5	Ԥ
    	Uint16	bModInputVoltOverFault	    :1;	//	22	bit6	ģѹ
    	Uint16	bModPFCFault	            :1;	//	23	bit7	ģPFC
    	Uint16	bModUnevenCurrAlarm	        :1;	//	24	bit8	ģ鲻
    	Uint16	bLossNLineAlarm	            :1;	//	25	bit9	߸澯
    	Uint16	bModInnerCommFault	        :1;	//	26	bit10	ģڲͨ쳣澯
    	Uint16	bModOutputFuseFault	        :1;	//	27	bit11	ģ˿ϸ澯
    	Uint16	bReserved28Fault	        :1;	//	28	bit12	Ԥ
    	Uint16	bModInputPowerOffAlarm	    :1;	//	29	bit13	ģͣ澯
    	Uint16	bBusVoltUnbalanceAlarm	    :1;	//	30	bit14	ĸߵѹزƽ澯
    	Uint16	bCabinAddrConflictAlarm	    :1;	//	31	bit15	ַͻ
    	Uint16	bModHardAddrFault	        :1;	//	32	bit0	ģӲַ쳣
    	Uint16	bModInputCMVFault	        :1;	//	33	bit1	ģ빲ģѹ쳣
    	Uint16	bMainRelayShortAlarm	    :1;	//	34	bit2	̵Ȧ·澯
    	Uint16	bInputReverseConnectAlarm	:1;	//	35	bit3	뷴Ӹ澯
    	Uint16	bReserved36Fault	        :1;	//	36	bit4	Ԥ
    	Uint16	bReserved37Fault	        :1;	//	37	bit5	Ԥ
    	Uint16	bReserved38Fault	        :1;	//	38	bit6	Ԥ
    	Uint16	bReserved39Fault	        :1;	//	39	bit7	Ԥ
    	Uint16	bReserved40Fault	        :1;	//	40	bit8	Ԥ
    	Uint16	bReserved41Fault	        :1;	//	41	bit9	Ԥ
    	Uint16	bReserved42Fault	        :1;	//	42	bit10	Ԥ
    	Uint16	bReserved43Fault	        :1;	//	43	bit11	Ԥ
    	Uint16	bReserved44Fault	        :1;	//	44	bit12	Ԥ
    	Uint16	bReserved45Fault	        :1;	//	45	bit13	Ԥ
    	Uint16	bReserved46Fault	        :1;	//	46	bit14	Ԥ
    	Uint16	bReserved47Fault	        :1;	//	47	bit15	Ԥ
    	Uint16	bReserved48Fault	        :1;	//	48	bit0	Ԥ
    	Uint16	bReserved49Fault	        :1;	//	49	bit1	Ԥ
    	Uint16	bReserved50Fault	        :1;	//	50	bit2	Ԥ
    	Uint16	bReserved51Fault	        :1;	//	51	bit3	Ԥ
    	Uint16	bReserved52Fault	        :1;	//	52	bit4	Ԥ
    	Uint16	bReserved53Fault	        :1;	//	53	bit5	Ԥ
    	Uint16	bReserved54Fault	        :1;	//	54	bit6	Ԥ
    	Uint16	bReserved55Fault	        :1;	//	55	bit7	Ԥ
    	Uint16	bReserved56Fault	        :1;	//	56	bit8	Ԥ
    	Uint16	bReserved57Fault	        :1;	//	57	bit9	Ԥ
    	Uint16	bReserved58Fault	        :1;	//	58	bit10	Ԥ
    	Uint16	bReserved59Fault	        :1;	//	59	bit11	Ԥ
    	Uint16	bReserved60Fault	        :1;	//	60	bit12	Ԥ
    	Uint16	bReserved61Fault	        :1;	//	61	bit13	Ԥ
    	Uint16	bReserved62Fault	        :1;	//	62	bit14	Ԥ
    	Uint16	bReserved63Fault	        :1;	//	63	bit15	Ԥ

    }bit;
}Union_FaultMask;



typedef union
{
	volatile Uint16 uiDigital[2];                    // ,ÿ1bitһ
    struct
    {
    	Uint16	bSysCommand             :4;	//	bit0~3:ָ
    	Uint16	bModLimitDisChrOrChr	:2;	//	bit4~5: 0-Ч 1-ɳɷŵ 2-ɳ粻ɷŵ 3-ɳ粻ɷŵ
    	Uint16	bCalibCapDischg         :1;	//	bit6  : 0-Ч1-ݷŵʹ

    }bit;
}Union_SysCommand;

typedef union
{
    volatile Uint16 uiDigital[2];                    // ,ÿ1bitһ
    struct
    {
    	Uint16 bModDisState         :4; //bit0~3  : ģ״̬:  1-  2-  3-
    	Uint16 bCalibCapSts         :2; //bit4~5  : ״̬:0-δ 1- 2-ݳɹ 3-ʧ
    	Uint16 bChgOrDisChgSts      :2; //bit6~7  : ŵ״̬:0- 1- 2-ŵ 3-ǳǷ
    	Uint16 bDisChargeLimit      :1; //bit8    : ŵ 0-Ч  1-
    	Uint16 bChargeLimit	        :1; //bit9	  :  0-Ч  1-
    	Uint16 bBatEod	            :1; //bit10	  : EOD 0-Ч   1-EOD
    }bit;
}Union_ModState;

enum
{
    eAnlgBeginID,
    eGBmsAnlgID = eAnlgBeginID          ,   //  0   GBMSϢ
    eCBmsAnlgID                         ,   //  1   CBMSϢ
    eDCDCAnlgID                         ,   //  2   DCDCϢ
    eAnlgEndID                          ,

    eSetBeginID = eAnlgEndID            ,
    eDCDCSetID = eSetBeginID            ,   //  3   DCDCò
    eBMSSetID                           ,   //  4   BMSò
    eSetEndID,

    eCommCfgEndID = eSetEndID,
};

typedef struct
{
    Uint16  uiPtlStartAddr;     //  Э鿪ʼַ
    Uint16  uiDspStartAddr;     //  DSPʼַ
    Uint16  uiLen;              //  
    Uint16  *puiCfgDest;        //  Ŀַ

}Struct_CommCfgTbl;

//-----------------------------------------------------------------------------
// Public Variables
//-----------------------------------------------------------------------------


Protocol_PUBLIC float fceshisavenum1  ;  //ģ
Protocol_PUBLIC float fceshisavenum2  ;  //ģ
Protocol_PUBLIC float fceshisavenum3  ;  //ģ
Protocol_PUBLIC float fceshisavenum4  ;  //ģ


Protocol_PUBLIC Uint32 ceshisavenum1  ;
Protocol_PUBLIC Uint32 ceshisavenum2  ;

Protocol_PUBLIC Uint16  uiAnalogDataBag[];      //ģ
Protocol_PUBLIC Uint16  uiCommandDataBag[];    //


//Protocol_PUBLIC Union_UserFault              unUserFault;                //û
//Protocol_PUBLIC Union_AdminFault   	         unAdminFault;				//


Protocol_PUBLIC volatile Union_ModState      unModState;        //ģ״̬
Protocol_PUBLIC volatile Union_SysCommand    unSysCommand;      //ϵͳָ

Protocol_PUBLIC const Struct_CommCfgTbl strCommCfgTbl[];

Protocol_PUBLIC Union_CharWord1			unCharWord1;			//ģ1
Protocol_PUBLIC Union_CharWord2			unCharWord2;			//ģ2
Protocol_PUBLIC Union_IndicateLedCmd  	unIndicateLedCmd;		//ָʾƿ
Protocol_PUBLIC Union_FaultMask 		unFaultMask;         	//
//-----------------------------------------------------------------------------
// Public Function Prototypes
//-----------------------------------------------------------------------------
Protocol_PUBLIC void Protocol_Task_RealTime(void);
Protocol_PUBLIC void Protocol_Task_1ms(void);
Protocol_PUBLIC void Protocol_Task_5ms(void);
Protocol_PUBLIC void Protocol_Task_20ms(void);
Protocol_PUBLIC void Protocol_Task_100ms(void);

#endif //PROTOCOL_H
//===========================================================================
// End of file.
//===========================================================================
