#include "adc.h"
#include "f28x_project.h"
#include "ctrl.h"
#include "MonitorSci.h"
#include "FunState.h"

struct	ADCMES	ADCmes;

void my_memset(void *dest, int set, unsigned len)
{
	char *pdest = (char *)dest;
	while (len-->0)
	{
		*pdest++ = set;
	}
}
//
// initADC - Function to configure and power up ADCA.
//
void initADC(void)
{
    //
    // Setup VREF as internalADC_EXTERNAL
    //
//    SetVREF(ADC_ADCA, ADC_INTERNAL, ADC_VREF3P3);
        SetVREF(ADC_ADCA, ADC_EXTERNAL, ADC_VREF3P3);

    EALLOW;

    //
    // Set ADCCLK divider to /4
    //
    AdcaRegs.ADCCTL2.bit.PRESCALE = 6;

    //
    // Set pulse positions to late
    //
    AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;

    //
    // Power up the ADC and then delay for 1 ms
    //
    AdcaRegs.ADCCTL1.bit.ADCPWDNZ = 1;
    EDIS;

    DELAY_US(1000);
}

//
// initADCSOC - Function to configure ADCA's SOC0 to be triggered by ePWM1.
//
void initADCSOC(void)
{
    //AdcaResultRegs
    // Select the channels to convert and the end of conversion flag
    //
    EALLOW;
    AdcaRegs.ADCINTSEL1N2.bit.INT1E     = 1;       //Enabled ADCINT1
    AdcaRegs.ADCINTSEL1N2.bit.INT1CONT  = 0;   //Disable ADCINT1 Continuous mode
    AdcaRegs.ADCINTSEL1N2.bit.INT1SEL   = 3;	   //setup EOC0 to trigger ADCINT1 to fire
        
    AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1; // Make sure INT1 flag is cleared




    AdcaRegs.ADCSOC0CTL.bit.CHSEL = 10;     // SOC0 will convert pin A1
                                           // 0:A0  1:A1  2:A2  3:A3
                                           // 4:A4   5:A5   6:A6   7:A7
                                           // 8:A8   9:A9   A:A10  B:A11
                                           // C:A12  D:A13  E:A14  F:A15
	AdcaRegs.ADCSOC1CTL.bit.CHSEL  = 11; //set SOC1 channel select to ADCINA1 (V_OUT1)
	AdcaRegs.ADCSOC2CTL.bit.CHSEL  = 12; //set SOC2 channel select to ADCINA3 (V_OUT2)
	AdcaRegs.ADCSOC3CTL.bit.CHSEL  = 13; //set SOC3 channel select to ADCINA3 (V_OUT2)
	AdcaRegs.ADCSOC4CTL.bit.CHSEL  = 14; //set SOC4 channel select to ADCINA4 (ICUR)
    AdcaRegs.ADCSOC5CTL.bit.CHSEL  = 15; //set SOC5 channel select to ADCINA4 (ICUR)
    AdcaRegs.ADCSOC6CTL.bit.CHSEL  = 2; //set SOC6 channel select to ADCINA2 (TNMPdc1)
//    AdcaRegs.ADCSOC7CTL.bit.CHSEL  = 0x1; //set SOC7 channel select to ADCINA6 (REF_2V5)
//    AdcaRegs.ADCSOC8CTL.bit.CHSEL  = 0x1; //set SOC8 channel select to ADCINB0 8(TNMPdc2)
//    AdcaRegs.ADCSOC9CTL.bit.CHSEL  = 0x1; //set SOC9 channel select to ADCINB1 9(TNMPdc3)
//    AdcaRegs.ADCSOC10CTL.bit.CHSEL  = 0x1; //set SOC10 channel select to ADCINB2 10(lip1)
//    AdcaRegs.ADCSOC11CTL.bit.CHSEL  = 0x1; //set SOC11 channel select to ADCINB3 11(bat)
//    AdcaRegs.ADCSOC12CTL.bit.CHSEL  = 0x1;    //set SOC12 channel select to ADCINB7 15 (tempctrl)
                                           
    AdcaRegs.ADCSOC0CTL.bit.ACQPS = 6;     // Sample window is 10 SYSCLK cycles
	AdcaRegs.ADCSOC1CTL.bit.ACQPS  = 6; //set SOC1 channel select to ADCINA1 (V_OUT1)
	AdcaRegs.ADCSOC2CTL.bit.ACQPS  = 6; //set SOC2 channel select to ADCINA3 (V_OUT2)
	AdcaRegs.ADCSOC3CTL.bit.ACQPS  = 6; //set SOC3 channel select to ADCINA3 (V_OUT2)
	AdcaRegs.ADCSOC4CTL.bit.ACQPS  = 6; //set SOC4 channel select to ADCINA4 (ICUR)
    AdcaRegs.ADCSOC5CTL.bit.ACQPS  = 6; //set SOC5 channel select to ADCINA4 (ICUR)
    AdcaRegs.ADCSOC6CTL.bit.ACQPS  = 6; //set SOC6 channel select to ADCINA2 (TNMPdc1)
//    AdcaRegs.ADCSOC7CTL.bit.ACQPS  = 6; //set SOC7 channel select to ADCINA6 (REF_2V5)
//    AdcaRegs.ADCSOC8CTL.bit.ACQPS  = 6; //set SOC8 channel select to ADCINB0 8(TNMPdc2)
//    AdcaRegs.ADCSOC9CTL.bit.ACQPS  = 6; //set SOC9 channel select to ADCINB1 9(TNMPdc3)
//    AdcaRegs.ADCSOC10CTL.bit.ACQPS  = 6; //set SOC10 channel select to ADCINB2 10(lip1)
//    AdcaRegs.ADCSOC11CTL.bit.ACQPS  = 6; //set SOC11 channel select to ADCINB3 11(bat)
//    AdcaRegs.ADCSOC12CTL.bit.ACQPS  = 6;    //set SOC12 channel select to ADCINB7 15 (tempctrl)


    AdcaRegs.ADCSOC0CTL.bit.TRIGSEL = 1;   // Trigger on ePWM1 SOCA
	AdcaRegs.ADCSOC1CTL.bit.TRIGSEL  = 1; //set SOC1 channel select to ADCINA1 (V_OUT1)
	AdcaRegs.ADCSOC2CTL.bit.TRIGSEL  = 1; //set SOC2 channel select to ADCINA3 (V_OUT2)
	AdcaRegs.ADCSOC3CTL.bit.TRIGSEL  = 1; //set SOC3 channel select to ADCINA3 (V_OUT2)
	AdcaRegs.ADCSOC4CTL.bit.TRIGSEL  = 1; //set SOC4 channel select to ADCINA4 (ICUR)
    AdcaRegs.ADCSOC5CTL.bit.TRIGSEL  = 1; //set SOC5 channel select to ADCINA4 (ICUR)
    AdcaRegs.ADCSOC6CTL.bit.TRIGSEL  = 1; //set SOC6 channel select to ADCINA2 (TNMPdc1)
//    AdcaRegs.ADCSOC7CTL.bit.TRIGSEL  = 1; //set SOC7 channel select to ADCINA6 (REF_2V5)
//    AdcaRegs.ADCSOC8CTL.bit.TRIGSEL  = 1; //set SOC8 channel select to ADCINB0 8(TNMPdc2)
//    AdcaRegs.ADCSOC9CTL.bit.TRIGSEL  = 1; //set SOC9 channel select to ADCINB1 9(TNMPdc3)
//    AdcaRegs.ADCSOC10CTL.bit.TRIGSEL  = 1; //set SOC10 channel select to ADCINB2 10(lip1)
//    AdcaRegs.ADCSOC11CTL.bit.TRIGSEL  = 1; //set SOC11 channel select to ADCINB3 11(bat)
//    AdcaRegs.ADCSOC12CTL.bit.TRIGSEL  = 1;    //set SOC12 channel select to ADCINB7 15 (tempctrl)


    AdcaRegs.ADCINTSOCSEL1.all       = 0;
    AdcaRegs.ADCINTSOCSEL2.all       = 0; 
    
    AdccRegs.ADCINTSOCSEL1.all       = 0;
    AdccRegs.ADCINTSOCSEL2.all       = 0;

    
    EDIS;

    DELAY_US(1000L);
}
 


void ADC_INIT(void)
{
    initADC();

    initADCSOC();
}

void ADC_DATA_INIT(void)
{
    my_memset(&ADCmes,0,sizeof(ADCmes));
}


//˲    
void vADC_Filt_show(void)
{
	//ͨ˲10k
	ADCmes.SampleFilt.vbus     = ADCmes.SampleResult.sample_vbus*0.1f + ADCmes.SampleFilt.vbus*0.9f;
    ADCmes.SampleFilt.vbus_pcs = ADCmes.SampleResult.sample_vbus_pcs*0.1f + ADCmes.SampleFilt.vbus_pcs*0.9f;

	
//	ADCmes.SampleFilt.iout = ADCmes.SampleResult.sample_iout*0.1f + ADCmes.SampleFilt.iout*0.9f;

	ADCmes.SampleFilt.ibus = ADCmes.SampleResult.sample_ibus*0.1f + ADCmes.SampleFilt.ibus*0.9f;
	
//	ADCmes.SampleFilt.bat  = ADCmes.SampleResult.sample_bat;
	
	ADCmes.SampleFilt.temp = ADCmes.SampleResult.sample_temp*0.1f + ADCmes.SampleFilt.temp*0.9f;

    if(ADCmes.SampleFilt.ibus<=0.0f)
    {
        ADCmes.SampleFilt.power = 0;
    }
    else
    {
        ADCmes.SampleFilt.power = ADCmes.SampleFilt.vbus*(ADCmes.SampleFilt.ibus);
    }
//    ADCmes.SampleFilt.ibus = 5.34;
	uDCDCReCharMesDataBag[0] = (Uint16)(ADCmes.SampleFilt.vbus*10);
	uDCDCReCharMesDataBag[1] = (int16)(ADCmes.SampleFilt.ibus*10);

    uDCDCReCharMesDataBag[2] = (Uint16)(ADCmes.SampleFilt.vbus_pcs*10);//(Uint16)(ADCmes.SampleFilt.vbus*ADCmes.SampleFilt.ibus*10);
	
}

//
void vADC_TIME(void)//
{
    vADC_Filt_show();
}

#pragma CODE_SECTION(ADC_get, ".TI.ramfunc");
static inline void ADC_get(void)
{
    float ftemp;
    Uint32 utemp1,utemp2;
//    ADCmes.SampleResult.sample_vbus_pcs     = (float)(AdcaResultRegs.ADCRESULT0)*ADCTOVAUL_K*VDSP_BUS_GAIN;
//    ADCmes.SampleResult.sample_vbus         = (float)(AdcaResultRegs.ADCRESULT2)*ADCTOVAUL_K*VDSP_BUS_GAIN;
    ftemp = (float)(AdcaResultRegs.ADCRESULT0)*VBUS_ADCTOREL_A + VBUS_ADCTOREL_B;
    ADCmes.SampleResult.sample_vbus_pcs = ADCmes.SampleResult.sample_vbus_pcs*FILT_B + ftemp*FILT_A;

    ftemp = (float)(AdcaResultRegs.ADCRESULT2)*VBUS_ADCTOREL_A + VBUS_ADCTOREL_B;
    ADCmes.SampleResult.sample_vbus     = ADCmes.SampleResult.sample_vbus*FILT_B + ftemp*FILT_A;
//    ADCmes.SampleResult.sample_vbus_pcs     = (float)(AdcaResultRegs.ADCRESULT0)*VBUS_ADCTOREL_A + VBUS_ADCTOREL_B;
//    ADCmes.SampleResult.sample_vbus         = (float)(AdcaResultRegs.ADCRESULT2)*VBUS_ADCTOREL_A + VBUS_ADCTOREL_B;

    ftemp =  (25.0f-(float)(AdcaResultRegs.ADCRESULT1)*IBUS_ADCTOREL_cal);
    ADCmes.SampleResult.sample_ibus     = ADCmes.SampleResult.sample_ibus*FILT_B + ftemp*FILT_A;
//    ADCmes.SampleResult.sample_ibus     = (2.5f-(float)(AdcaResultRegs.ADCRESULT1)*ADCTOVAUL_K*DSP_Icur_GAIN)*10;

    ADCmes.SampleResult.sample_bat       = (float)(uDCDCCharMesDataBag[0])*0.01f;//

    if(ADCmes.SampleResult.sample_bat<1)
    {
        ADCmes.SampleResult.sample_bat = 1;
    }

    ADCmes.SampleResult.sample_iout = (ADCmes.SampleResult.sample_ibus)*ADCmes.SampleResult.sample_vbus/ADCmes.SampleResult.sample_bat;       

    if(ADCmes.SampleResult.sample_iout<=0.0f)
    {
        ADCmes.SampleResult.sample_iout = 0.0f;
    }
    
    if(ADCmes.SampleResult.sample_iout>=100.0f)
    {
        ADCmes.SampleResult.sample_iout = 100.0f;
    }
//    utemp1 = ftemp*100000;
//    utemp2 = uDCDCCharMesDataBag[0];
//    
//Sec_SysData.tempCTRL = _IQ12toF((_IQ12mpy(_IQ12(uitempctrlAvr), (long)330)))-50.0;//¶

//    ADCmes.SampleResult.sample_iout = _IQtoF(_IQdiv(_IQ(ftemp),_IQ(ADCmes.SampleResult.sample_bat)));
//
//    ADCmes.SampleResult.sample_iout     = (float)(uDCDCCharMesDataBag[1])*0.01f;//uDCDCCharMesDataBag[1]*0.01f;//
//    ADCmes.SampleResult.sample_iout     = (float)(uDCDCCharMesDataBag[1])*0.01f;//uDCDCCharMesDataBag[1]*0.01f;//

}


//
// adcA1ISR - ADC A Interrupt 1 ISR
//
#pragma CODE_SECTION(adcA1ISR, ".TI.ramfunc");

__interrupt void adcA1ISR(void)
{

    GPIO_WritePin(34,1);

    AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;
    if(1 == AdcaRegs.ADCINTOVF.bit.ADCINT1)
    {
        AdcaRegs.ADCINTOVFCLR.bit.ADCINT1 = 1; //clear INT1 overflow flag
        AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1; //clear INT1 flag
    }
    
    //
    // Acknowledge the interrupt
    //
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;

    ADC_get();
    
//    if(SysCmd.bit.openTest==0)
    {
        Ctrl_Fun();
    }
//    //
//    // Check if overflow has occurred
//    //
    GPIO_WritePin(34,0);

}




