/*
 * mdb_Init.h
 *
 *  Created on: 2023112
 *      Author: HP
 */

#ifndef MDB_INIT_H_
#define MDB_INIT_H_

#include "f28002x_device.h"
//==================================================================================================
//
//==================================================================================================
#define MonitorSciIntTime                 100   //жʱ us 1k
#define MonitorSciBaudRate                9600  //
#define MonitorLinBaudRate                19200  //

//#define MonitorSciBaudRate                115200  //
//#define MonitorSciBaudRate                  128000  //

#define MonitorSciLOSPCPCLK               25    //SCIӦĵʱMHz 25MHz   Ĭ4Ƶ
//#define MonitorSciLOSPCPCLK               30    //SCIӦĵʱMHz 30MHz   120/4=30 Ĭ4Ƶ

#define MonitorSciMbCharRecMaxTime       (long)16500000/MonitorSciIntTime/MonitorSciBaudRate
#define MonitorSciSCI_HBAUD_LBAUD        ((long)MonitorSciLOSPCPCLK*125*1000/(MonitorSciBaudRate+1)-1)





//==================================================================================================
//
//==================================================================================================
enum
{
    eWaitReceiveMonitorSci,    //0
    eReceivingMonitorSci,      //1
    eReceiveFinishMonitorSci,  //2
    eCmdIdentifyMonitorSci,    //3
    eCmdDealMonitorSci,        //4
    eWaitSendMonitorSci,       //5
    eSendingMonitorSci,        //6
    eSendFinishMonitorSci,     //7
    eExecuteStepEndMonitorSci  //8
};


typedef struct
{
    Uint16 all;
    struct
    {
        Uint16      bExecuteStep            : 4;        //ͨѶ
        Uint16      bCrcCheckError          : 1;        //CRCУ
        Uint16      bModbusProtocol         : 1;        //MODBUSЭ
        Uint16      bCmdIdentifyFinish      : 1;
        Uint16      bCmdDealFinish          : 1;
        Uint16      bOnOffToggle            : 1;        ///ػת
        Uint16      bToCmdDealFinish        : 1;        //ǷӦ׶
    }bit;
}STRUCT_MonitorSciFlag;


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================
extern      void MonitorSci_System_PinInit(void);

extern      void MonitorSci_System_PeripheralInit(void);


#endif /* APP_SUB_COMM_MDB_INIT_H_ */
