/******************************************************************************
* Copyright (c)
* Original Author	:
* Last rev by		:
* Last rev date		:
* Last change list	:
* Overview			:
* Description		:
* NOTE				:
*******************************************************************************/
#ifndef Monitorlin_C
#define Monitorlin_C
//-----------------------------------------------------------------------------
// Include
//-----------------------------------------------------------------------------
//#include "GlobalHeadFile.h"
//#include "DSP2803x_Cla_typedefs.h"// DSP2803x CLA Type definitions
#include "f28002x_device.h"      // DSP2803x Headerfile Include File
#include "f28002x_examples.h"    // DSP2803x Examples Include File

//#include "sys_protect.h"

#include "mdb_Init.h"
#include "mdb_sci_RX.h"// DSP2803x CLA Type definitions
#include "mdb_sci_TX.h"
#include "MonitorSci.h"
#include "Protocol.h"// DSP2803x CLA Type definitions

#include "mdb_lin_RX.h"// DSP2803x CLA Type definitions
#include "mdb_lin_TX.h"
//#include "MonitorSci.h"

//-----------------------------------------------------------------------------
// Adding Conditional Definitions Stuff
//-----------------------------------------------------------------------------


void MonitorSci_Machine_lin(void);


//-----------------------------------------------------------------------------
//Adding Private Enumerated and Structure Definitions
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
//Adding Public Enumerated and Structure Definitions Stuff
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
//Adding Private Function Prototypes (i.e. static)
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//Adding Public Function Prototypes
//-----------------------------------------------------------------------------
Uint16 uiRTUFrameStartTimeCnt_lin;
Uint16 uiRTUFrameStartMinTime_lin;
Uint16 uiRTUFrameEndTimeCnt_lin;


Uint16      uiBuffLength_lin;
Uint16      uiReceiveDataLengthCnt_lin;
Uint16      uiModbusSlaveAddr_lin;


//
//Uint16           uiMonitorSciAnalogData[eSciAnalogDataEndID + 1]; //ģ
//Uint16           uiMonitorSciSetDataBag[eSciSetDataEndID + 1];   //
//Uint16           unMonitorSciCommandData[eSciCommdEndID + 1];    //
//-----------------------------------------------------------------------------
//Adding Private Variables (i.e. static)
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
//Adding Private Function
//-----------------------------------------------------------------------------

//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: Sci_RealTimeDone
--------------------------------------
Function Descriptions:
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
#pragma CODE_SECTION(MonitorSci_Task_RealTime_lin, ".TI.ramfunc");
void MonitorSci_Task_RealTime_lin(void)
{
    MonitorSci_Machine_lin();
}


//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: Sci_Machine
--------------------------------------
Function Descriptions   :
Parameter Name list :
ReturnTyp           :
Refer doctuments        :
 ******************************************************************************/
void MonitorSci_Machine_lin(void)
{
    static Uint16 uiSendDataLengthCnt_lin = 0;

    if(unMonitorSciFlag_lin.bit.bExecuteStep == eReceivingMonitorSci)//ʶ֡ʼ
    {
        if(++uiRTUFrameStartTimeCnt_lin > 0xFFF0)uiRTUFrameStartTimeCnt_lin = 0xFFF0;
        if(++uiRTUFrameEndTimeCnt_lin   > 0xFFF0)uiRTUFrameEndTimeCnt_lin   = 0xFFF0;
    }
    else
    {
        uiRTUFrameStartTimeCnt_lin = 0;
        uiRTUFrameEndTimeCnt_lin   = 0;
    }

    switch( unMonitorSciFlag_lin.bit.bExecuteStep )
    {
//--------------------------------------------------------//
    case eWaitReceiveMonitorSci:                       //ȴտʼ
    {
        if(Monitorlin_SEND_EMPTY_STATUS == eEnable)
        {
//            MonitorSci_RxEnable();
            MonitorlinRxEnable();
            MonitorlinTxDisable();
            unMonitorSciFlag_lin.bit.bExecuteStep = eReceivingMonitorSci;
            uiReceiveDataLengthCnt_lin = 0;
        }
        break;
    }
//--------------------------------------------------------//
    case eReceivingMonitorSci:            //
    {
//        if( Monitorlin_RECEIVE_STATUS == eEnable )
        if(LinaRegs.SCIFLR.bit.RXRDY == 1)
        {
            uiMonitorSciRxDataBuff_lin[uiReceiveDataLengthCnt_lin] = Monitorlin_READ_RECEIVE_DATA();
            uiReceiveDataLengthCnt_lin ++;
            uiRTUFrameEndTimeCnt_lin  = 0;

            if((uiRTUFrameStartTimeCnt_lin < uiRTUFrameStartMinTime_lin)||(uiMonitorSciRxDataBuff_lin[0] != uiModbusSlaveAddr_lin))
            {
                uiRTUFrameStartTimeCnt_lin = 0;
                uiReceiveDataLengthCnt_lin = 0;
            }
        }
//        else if(MonitorSciBrkDt)   //sciͨŴ
//        {
//            MonitorSciControlAndReset = 0x0003;
//            MonitorSciControlAndReset = 0x0023;
//            unMonitorSciFlag_lin.bit.bExecuteStep = eWaitReceiveMonitorSci;
//            uiReceiveDataLengthCnt_lin = 0;
//            uiRTUFrameStartTimeCnt_lin = 0;
//            uiRTUFrameEndTimeCnt_lin   = 0;
//        }

        if((( uiReceiveDataLengthCnt_lin > 0)&& (uiRTUFrameEndTimeCnt_lin>uiRTUFrameStartMinTime_lin))
            ||(( uiReceiveDataLengthCnt_lin >= RECEIVE_DATA_LENGTH)                                                        )   )
        {
            uiRTUFrameEndTimeCnt_lin       = 0;
            uiRTUFrameStartTimeCnt_lin     = 0;
            unMonitorSciFlag_lin.bit.bExecuteStep = eReceiveFinishMonitorSci;
        }
        break;
    }
//--------------------------------------------------------//
    case eReceiveFinishMonitorSci:        //ս
    {
        MonitorlinRxDisable();
        unMonitorSciFlag_lin.bit.bCmdDealFinish = 0;
        unMonitorSciFlag_lin.bit.bExecuteStep = eCmdIdentifyMonitorSci;
        break;
    }
//--------------------------------------------------------//
    case eCmdIdentifyMonitorSci:          //Խյʶ
    {
        if( unMonitorSciFlag_lin.bit.bCmdIdentifyFinish )
        {
            unMonitorSciFlag_lin.bit.bExecuteStep = eCmdDealMonitorSci;
            unMonitorSciFlag_lin.bit.bCmdIdentifyFinish = 0;
        }
        break;
    }
//--------------------------------------------------------//
    case eCmdDealMonitorSci:              //ԽյӦ,
    {
        if( unMonitorSciFlag_lin.bit.bCmdDealFinish )
        {
            unMonitorSciFlag_lin.bit.bCmdDealFinish = 0;
            if(uiBuffLength_lin > 0)
            {
                MonitorlinTxEnable();
                unMonitorSciFlag_lin.bit.bExecuteStep = eWaitSendMonitorSci;
            }
            else
            {
                unMonitorSciFlag_lin.bit.bExecuteStep = eWaitReceiveMonitorSci;
            }
        }
        break;
    }
//--------------------------------------------------------//
    case eWaitSendMonitorSci:             //ȴ
    {
        uiSendDataLengthCnt_lin        = 0;
        unMonitorSciFlag_lin.bit.bExecuteStep = eSendingMonitorSci;
        break;
    }
//--------------------------------------------------------//
    case eSendingMonitorSci:              //
    {
        if(uiSendDataLengthCnt_lin < uiBuffLength_lin )
        {
            if( Monitorlin_SEND_STATUS == eEnable )
            {
                Monitorlin_LOAD_SEND_DATA( uiMonitorSciTxDataBuff_lin[uiSendDataLengthCnt_lin] );
                uiSendDataLengthCnt_lin ++;
            }
        }
        else unMonitorSciFlag_lin.bit.bExecuteStep = eSendFinishMonitorSci;
        break;
    }
//--------------------------------------------------------//
    case eSendFinishMonitorSci:           //ͽ
    {
        uiBuffLength_lin               = 0;
        unMonitorSciFlag_lin.bit.bExecuteStep = eWaitReceiveMonitorSci;
        break;
    }
//--------------------------------------------------------//
    default:
    {
        break;
    }
    }
}

//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: SCIA_COMM_Initialize
--------------------------------------
Function Descriptions:
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
void MonitorSci_System_AppInit_lin(void)
{
    uiModbusSlaveAddr_lin      = 1;
    uiRTUFrameStartMinTime_lin = MonitorSciMbFrameStartMinTime;
    uBatSetDataBag[4]          = 200;
    uiSetDataBag[0]            = 7;
}


//==================================================================================================
//
//==================================================================================================


//---------------------------------------------------------------------------
#endif //MonitorSci_C
//===========================================================================
// End of file.
//===========================================================================
