/******************************************************************************

	:
*******************************************************************************/
#ifndef  MonitorLin_H
#define  MonitorLin_H
#include "f28002x_device.h"
#include "mdb_Init.h"
//-----------------------------------------------------------------------------
// Conditional Definitions
//-----------------------------------------------------------------------------
//==================================================================================================
//
//==================================================================================================
//-----------------------------------------------------------------------------
// Public Constants and Macro Definitions
//-----------------------------------------------------------------------------
//#define     eEnable                         1


//-----------------------------------------------------------------------------
// Adding Constants and Macro Definitions
//-----------------------------------------------------------------------------
//#define     SciRegs                        SciaRegs
#define     Monitorlin_SEND_STATUS             LinaRegs.SCIFLR.bit.TXRDY
#define     Monitorlin_RECEIVE_STATUS          LinaRegs.SCIFLR.bit.RXRDY
#define     Monitorlin_SEND_EMPTY_STATUS       LinaRegs.SCIFLR.bit.TXEMPTY
#define     Monitorlin_RECEIVE_BREAK_STATUS    LinaRegs.SCIFLR.bit.BRKDT
//#define     MonitorSci_RECEIVE_ERROR_STATUS    LinaRegs.SCIFLR.bit.RXERROR
#define     Monitorlin_LOAD_SEND_DATA(Data)    ((LinaRegs.SCITD.bit.TD)=Data)
#define     Monitorlin_READ_RECEIVE_DATA()     ((LinaRegs.SCIRD.bit.RD)&0x00FF)

#define     MonitorlinTxEnable()               (LinaRegs.SCIGCR1.bit.TXENA = 1)
#define     MonitorlinRxEnable()               (LinaRegs.SCIGCR1.bit.RXENA = 1)
#define     MonitorlinTxDisable()              (LinaRegs.SCIGCR1.bit.TXENA = 0)
#define     MonitorlinRxDisable()              (LinaRegs.SCIGCR1.bit.RXENA = 0)

//#define     MonitorSci_RxEnable()              //(GpioDataRegs.GPCSET.bit.GPIO66   = 1)//ʹ
//#define     MonitorSci_TxEnable()              //(GpioDataRegs.GPCCLEAR.bit.GPIO66 = 1)//ʹ
//
//#define     UartDataError             0x02
//#define     UartAddrNumError          0x03
//#define     UartCrcCodeError          0x04
//#define     UartComTimeout            0x05
//
//
//#define MonitorSciMbFrameStartMinTime    (long)38500000/MonitorSciIntTime/MonitorSciBaudRate


//==================================================================================================
//
//==================================================================================================


//-----------------------------------------------------------------------------
// Public Enumerated and Structure Definitions
//-----------------------------------------------------------------------------


////-----------------------------------------------------------------
////----------------------ID----------------------------------
////-----------------------------------------------------------------
//enum
//{
//    eReseverBmsSetId,
//    eBmsSciSetDataEndID
//};
////-----------------------------------------------------------------
////----------------------ģ״̬ID--------------------------
////-----------------------------------------------------------------
//enum
//{
//    eReseverBmsAnalogID,
//    eBmsSciAnalogEndID
//};
//
//-----------------------------------------------------------------

//
////-----------------------------------------------------------------
////----------------------ID-------------------------------
////-----------------------------------------------------------------
//enum
//{
//    eReseverBmsCommdID,          //0
//
//    eBmsCommdIDEnd
//};


//==================================================================================================
//
//==================================================================================================
//-----------------------------------------------------------------------------
// Public Variables
//-----------------------------------------------------------------------------
//BmsSci_PUBLIC Uint16              uiBmsSciAnalogData[];//ģ
//BmsSci_PUBLIC Uint16              uiBmsSciSetData[];   //
//BmsSci_PUBLIC Uint16              unBmsSciCommandData[];//



extern      Uint16      uiBuffLength_lin;
extern      Uint16      uiReceiveDataLengthCnt_lin;
extern      Uint16      uiModbusSlaveAddr_lin;
//

//==================================================================================================
//
//==================================================================================================
//-----------------------------------------------------------------------------
// Public Function Prototypes
//-----------------------------------------------------------------------------
extern void MonitorSci_Task_RealTime_lin(void);

void   Monitorlin_Machine(void);


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================
MonitorSci_PUBLIC void MonitorSci_System_AppInit_lin(void);


#endif  //
//===========================================================================
// End of file.
//===========================================================================
