/*
 * mdb_sci_TX.c
 *
 *  Created on: 2023112
 *      Author: HP
 */

//#include "DSP2803x_Cla_typedefs.h"// DSP2803x CLA Type definitions

//#include "sys_protect.h"

#include "mdb_Init.h"
#include "mdb_sci_RX.h"// DSP2803x CLA Type definitions
#include "mdb_sci_TX.h"
#include "MonitorSci.h"
#include "Protocol.h"// DSP2803x CLA Type definitions

#include "mdb_lin_RX.h"// DSP2803x CLA Type definitions
#include "mdb_lin_TX.h"

void MonitorSci_ClearBuffer_lin(void);
/******************************************************************************
Function Name: Sci_Task_OneCycleDone
--------------------------------------
Function Descriptions:
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
void MonitorSci_Task_20ms_lin(void)
{
    if( 1//System_InitStateGet()  == eSystemInitAllSuccess
    )
    {
        if( unMonitorSciFlag_lin.bit.bExecuteStep == eCmdIdentifyMonitorSci )    //SCIʶ
        {
            MonitorSci_CommandIdentify_lin();

            unMonitorSciFlag_lin.bit.bCmdIdentifyFinish = 1;
            unMonitorSciFlag_lin.bit.bToCmdDealFinish = FALSE;
        }
        if( unMonitorSciFlag_lin.bit.bExecuteStep == eCmdDealMonitorSci)         //SCI
        {
            MonitorSci_CommandDeal_lin();

            if( unMonitorSciFlag_lin.bit.bCmdDealFinish )
                MonitorSci_ClearBuffer_lin();
        }
    }
    else
    {
        MonitorSci_ClearBuffer_lin();

        unMonitorSciFlag_lin.bit.bCmdDealFinish = 1;
        uiBuffLength_lin                 = 0;
        uiReceiveDataLengthCnt_lin       = 0;
    }
}

//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: Sci_Task_TenPerSecDone
--------------------------------------
Function Descriptions:
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
void MonitorSci_Task_100ms_lin(void)
{


    if( uiMonitorSciErrorCntNum > 0 )
    {
//        unProgramFault.bit.b1MonitorSciErrorCntNum = 1;
    }
}


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: SciProtocol_Sci_ClearBuffer
--------------------------------
Function Descriptions:
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
void MonitorSci_ClearBuffer_lin(void)
{
//    Uint16 uiClearBuffTemp;
//    for(uiClearBuffTemp = 0; uiClearBuffTemp < uiReceiveDataLengthCnt; uiClearBuffTemp ++)
//        uiMonitorSciRxDataBuff_lin[uiClearBuffTemp] = 0;
    uiReceiveDataLengthCnt_lin           = 0;
}




//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: MonitorSci_CrcCaculate
--------------------------------------
Function Descriptions   :
Parameter Name list :
ReturnTyp           :
Refer doctuments        :
 ******************************************************************************/
Uint16 MonitorSci_CrcCaculate_lin(const Uint16 *DataFirstAddPtr,Uint16 uiDataLength)
{
    static Uint16 uiCrc = 0xFFFF;  //crcĴ()ĳֵΪ0xffff
    static Uint16 uiBitLoopCnt;

    uiCrc = 0xFFFF;
    while( uiDataLength-- != 0 )
    {
        uiCrc ^= *DataFirstAddPtr;
        for( uiBitLoopCnt = 0; uiBitLoopCnt < 8; uiBitLoopCnt ++ )
        {
            if(uiCrc &0x0001)
            {
                uiCrc >>= 1;
                uiCrc ^=  0xA001;
            }
            else uiCrc >>= 1;
        }
        DataFirstAddPtr ++;
    }
    return uiCrc;
}


//==================================================================================================
//
//==================================================================================================

