/******************************************************************************
* Copyright (c)
* Original Author	:
* Last rev by		:
* Last rev date		:
* Last change list	:
* Overview			:
* Description		:
* NOTE				:
*******************************************************************************/
#ifndef MonitorSci_C
#define MonitorSci_C
//-----------------------------------------------------------------------------
// Include
//-----------------------------------------------------------------------------
//#include "GlobalHeadFile.h"
//#include "DSP2803x_Cla_typedefs.h"// DSP2803x CLA Type definitions
#include "f28002x_device.h"      // DSP2803x Headerfile Include File
#include "f28002x_examples.h"    // DSP2803x Examples Include File

//#include "sys_protect.h"

#include "mdb_Init.h"
#include "mdb_sci_RX.h"// DSP2803x CLA Type definitions
#include "mdb_sci_TX.h"
#include "MonitorSci.h"
#include "Protocol.h"// DSP2803x CLA Type definitions


//-----------------------------------------------------------------------------
// Adding Conditional Definitions Stuff
//-----------------------------------------------------------------------------





//-----------------------------------------------------------------------------
//Adding Private Enumerated and Structure Definitions
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
//Adding Public Enumerated and Structure Definitions Stuff
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
//Adding Private Function Prototypes (i.e. static)
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//Adding Public Function Prototypes
//-----------------------------------------------------------------------------
Uint16 uiRTUFrameStartTimeCnt;
Uint16 uiRTUFrameStartMinTime;
Uint16 uiRTUFrameEndTimeCnt;


Uint16      uiBuffLength;
Uint16      uiReceiveDataLengthCnt;
Uint16      uiModbusSlaveAddr;

MonitorSci_PUBLIC STRUCT_MonitorSciFlag   unMonitorSciFlag;
MonitorSci_PUBLIC STRUCT_MonitorSciFlag   unMonitorSciFlag_lin;



//
//Uint16           uiMonitorSciAnalogData[eSciAnalogDataEndID + 1]; //ģ
//Uint16           uiMonitorSciSetDataBag[eSciSetDataEndID + 1];   //
//Uint16           unMonitorSciCommandData[eSciCommdEndID + 1];    //
//-----------------------------------------------------------------------------
//Adding Private Variables (i.e. static)
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
//Adding Private Function
//-----------------------------------------------------------------------------

//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: Sci_RealTimeDone
--------------------------------------
Function Descriptions:
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
//#pragma CODE_SECTION(MonitorSci_Task_RealTime, ".TI.ramfunc");
void MonitorSci_Task_RealTime(void)
{
    MonitorSci_Machine();
}


//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: Sci_Machine
--------------------------------------
Function Descriptions   :
Parameter Name list :
ReturnTyp           :
Refer doctuments        :
 ******************************************************************************/
void MonitorSci_Machine(void)
{
    static Uint16 uiSendDataLengthCnt = 0;

    if(unMonitorSciFlag.bit.bExecuteStep == eReceivingMonitorSci)//ʶ֡ʼ
    {
        if(++uiRTUFrameStartTimeCnt > 0xFFF0)uiRTUFrameStartTimeCnt = 0xFFF0;
        if(++uiRTUFrameEndTimeCnt   > 0xFFF0)uiRTUFrameEndTimeCnt   = 0xFFF0;
    }
    else
    {
        uiRTUFrameStartTimeCnt = 0;
        uiRTUFrameEndTimeCnt   = 0;
    }

    switch( unMonitorSciFlag.bit.bExecuteStep )
    {
//--------------------------------------------------------//
    case eWaitReceiveMonitorSci:                       //ȴտʼ
    {
        if(MonitorSci_SEND_EMPTY_STATUS == eEnable)
        {
            MonitorSci_RxEnable();
            MonitorSciRxEnable();
            MonitorSciTxDisable();
            unMonitorSciFlag.bit.bExecuteStep = eReceivingMonitorSci;
            uiReceiveDataLengthCnt = 0;
        }
        break;
    }
//--------------------------------------------------------//
    case eReceivingMonitorSci:            //
    {
        if( MonitorSci_RECEIVE_STATUS == eEnable )
        {
            uiMonitorSciRxDataBuff[uiReceiveDataLengthCnt] = MonitorSci_READ_RECEIVE_DATA();
            uiReceiveDataLengthCnt ++;
            uiRTUFrameEndTimeCnt  = 0;

            if((uiRTUFrameStartTimeCnt < uiRTUFrameStartMinTime)||(uiMonitorSciRxDataBuff[0] != uiModbusSlaveAddr))
//            if(uiMonitorSciRxDataBuff[0] != uiModbusSlaveAddr)
            {
                uiRTUFrameStartTimeCnt = 0;
                uiReceiveDataLengthCnt = 0;
            }
        }
        else if(MonitorSciBrkDt||MonitorSciRxError)   //sciͨŴ
        {
            MonitorSciControlAndReset = 0x0003;
            MonitorSciControlAndReset = 0x0023;
            unMonitorSciFlag.bit.bExecuteStep = eWaitReceiveMonitorSci;
            uiReceiveDataLengthCnt = 0;
            uiRTUFrameStartTimeCnt = 0;
            uiRTUFrameEndTimeCnt   = 0;
        }

        if((( uiReceiveDataLengthCnt > 0)&& (uiRTUFrameEndTimeCnt>uiRTUFrameStartMinTime))
            ||(( uiReceiveDataLengthCnt >= RECEIVE_DATA_LENGTH)                                                        )   )
        {
            uiRTUFrameEndTimeCnt       = 0;
            uiRTUFrameStartTimeCnt     = 0;
            unMonitorSciFlag.bit.bExecuteStep = eReceiveFinishMonitorSci;
        }
        break;
    }
//--------------------------------------------------------//
    case eReceiveFinishMonitorSci:        //ս
    {
        MonitorSciRxDisable();
        unMonitorSciFlag.bit.bCmdDealFinish = 0;
        unMonitorSciFlag.bit.bExecuteStep = eCmdIdentifyMonitorSci;
        break;
    }
//--------------------------------------------------------//
    case eCmdIdentifyMonitorSci:          //Խյʶ
    {
        if( unMonitorSciFlag.bit.bCmdIdentifyFinish )
        {
            unMonitorSciFlag.bit.bExecuteStep = eCmdDealMonitorSci;
            unMonitorSciFlag.bit.bCmdIdentifyFinish = 0;
        }
        break;
    }
//--------------------------------------------------------//
    case eCmdDealMonitorSci:              //ԽյӦ,
    {
        if( unMonitorSciFlag.bit.bCmdDealFinish )
        {
            unMonitorSciFlag.bit.bCmdDealFinish = 0;
            if(uiBuffLength > 0)
            {
                MonitorSci_TxEnable();
                MonitorSciTxEnable();
                unMonitorSciFlag.bit.bExecuteStep = eWaitSendMonitorSci;
            }
            else
            {
                unMonitorSciFlag.bit.bExecuteStep = eWaitReceiveMonitorSci;
            }
        }
        break;
    }
//--------------------------------------------------------//
    case eWaitSendMonitorSci:             //ȴ
    {
        uiSendDataLengthCnt        = 0;
        unMonitorSciFlag.bit.bExecuteStep = eSendingMonitorSci;
        break;
    }
//--------------------------------------------------------//
    case eSendingMonitorSci:              //
    {
        if(uiSendDataLengthCnt < uiBuffLength )
        {
            if( MonitorSci_SEND_STATUS == eEnable )
            {
                MonitorSci_LOAD_SEND_DATA( uiMonitorSciTxDataBuff[uiSendDataLengthCnt] );
                uiSendDataLengthCnt ++;
            }
        }
        else unMonitorSciFlag.bit.bExecuteStep = eSendFinishMonitorSci;
        break;
    }
//--------------------------------------------------------//
    case eSendFinishMonitorSci:           //ͽ
    {
        uiBuffLength               = 0;
        unMonitorSciFlag.bit.bExecuteStep = eWaitReceiveMonitorSci;
        break;
    }
//--------------------------------------------------------//
    default:
    {
        break;
    }
    }
}

//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: SCIA_COMM_Initialize
--------------------------------------
Function Descriptions:
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
void MonitorSci_System_AppInit(void)
{
    MonitorSci_RxEnable();
    uiModbusSlaveAddr      = 1;
    uiRTUFrameStartMinTime = MonitorSciMbFrameStartMinTime;
}


//==================================================================================================
//
//==================================================================================================


//---------------------------------------------------------------------------
#endif //MonitorSci_C
//===========================================================================
// End of file.
//===========================================================================
