/******************************************************************************

	:
*******************************************************************************/
#ifndef  MonitorSci_H
#define  MonitorSci_H
#include "f28002x_device.h"
#include "mdb_Init.h"
//-----------------------------------------------------------------------------
// Conditional Definitions
//-----------------------------------------------------------------------------
#ifdef MonitorSci_C
	#define MonitorSci_PUBLIC
	#define MonitorSci_CONST
#else
	#define MonitorSci_PUBLIC	extern
	#define MonitorSci_CONST 	const
#endif


//==================================================================================================
//
//==================================================================================================
//-----------------------------------------------------------------------------
// Public Constants and Macro Definitions
//-----------------------------------------------------------------------------
#define     eEnable                         1


//-----------------------------------------------------------------------------
// Adding Constants and Macro Definitions
//-----------------------------------------------------------------------------
#define     SciRegs                        SciaRegs
#define     MonitorSci_SEND_STATUS             SciRegs.SCICTL2.bit.TXRDY
#define     MonitorSci_RECEIVE_STATUS          SciRegs.SCIRXST.bit.RXRDY
#define     MonitorSci_SEND_EMPTY_STATUS       SciRegs.SCICTL2.bit.TXEMPTY
#define     MonitorSci_RECEIVE_BREAK_STATUS    SciRegs.SCIRXST.bit.BRKDT
#define     MonitorSci_RECEIVE_ERROR_STATUS    SciRegs.SCIRXST.bit.RXERROR
#define     MonitorSci_LOAD_SEND_DATA(Data)    (SciRegs.SCITXBUF.bit.TXDT=Data)
#define     MonitorSci_READ_RECEIVE_DATA()     (SciRegs.SCIRXBUF.all&0x00FF)

#define     MonitorSciBrkDt                    SciRegs.SCIRXST.bit.BRKDT
#define     MonitorSciRxError                  SciRegs.SCIRXST.bit.RXERROR
#define     MonitorSciControlAndReset          SciRegs.SCICTL1.all
#define     MonitorSciTxEnable()               (SciRegs.SCICTL1.bit.TXENA = 1)
#define     MonitorSciRxEnable()               (SciRegs.SCICTL1.bit.RXENA = 1)
#define     MonitorSciTxDisable()              (SciRegs.SCICTL1.bit.TXENA = 0)
#define     MonitorSciRxDisable()              (SciRegs.SCICTL1.bit.RXENA = 0)

#define     MonitorSci_RxEnable()              //(GpioDataRegs.GPCSET.bit.GPIO66   = 1)//ʹ
#define     MonitorSci_TxEnable()              //(GpioDataRegs.GPCCLEAR.bit.GPIO66 = 1)//ʹ

#define     UartDataError             0x02
#define     UartAddrNumError          0x03
#define     UartCrcCodeError          0x04
#define     UartComTimeout            0x05


#define MonitorSciMbFrameStartMinTime    (long)38500000/MonitorSciIntTime/MonitorSciBaudRate
#define MonitorLinMbFrameStartMinTime    (long)38500000/MonitorSciIntTime/MonitorLinBaudRate


//==================================================================================================
//
//==================================================================================================


//-----------------------------------------------------------------------------
// Public Enumerated and Structure Definitions
//-----------------------------------------------------------------------------


////-----------------------------------------------------------------
////----------------------ID----------------------------------
////-----------------------------------------------------------------
//enum
//{
//    eReseverBmsSetId,
//    eBmsSciSetDataEndID
//};
////-----------------------------------------------------------------
////----------------------ģ״̬ID--------------------------
////-----------------------------------------------------------------
//enum
//{
//    eReseverBmsAnalogID,
//    eBmsSciAnalogEndID
//};
//
//-----------------------------------------------------------------

//
////-----------------------------------------------------------------
////----------------------ID-------------------------------
////-----------------------------------------------------------------
//enum
//{
//    eReseverBmsCommdID,          //0
//
//    eBmsCommdIDEnd
//};


//==================================================================================================
//
//==================================================================================================
//-----------------------------------------------------------------------------
// Public Variables
//-----------------------------------------------------------------------------
//BmsSci_PUBLIC Uint16              uiBmsSciAnalogData[];//ģ
//BmsSci_PUBLIC Uint16              uiBmsSciSetData[];   //
//BmsSci_PUBLIC Uint16              unBmsSciCommandData[];//



extern      Uint16      uiBuffLength;
extern      Uint16      uiReceiveDataLengthCnt;
extern      Uint16      uiModbusSlaveAddr;

MonitorSci_PUBLIC STRUCT_MonitorSciFlag   unMonitorSciFlag;
MonitorSci_PUBLIC STRUCT_MonitorSciFlag   unMonitorSciFlag_lin;

//==================================================================================================
//
//==================================================================================================
//-----------------------------------------------------------------------------
// Public Function Prototypes
//-----------------------------------------------------------------------------
MonitorSci_PUBLIC void MonitorSci_Task_RealTime(void);

void   MonitorSci_Machine(void);


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================
MonitorSci_PUBLIC void MonitorSci_System_AppInit(void);


#endif  //
//===========================================================================
// End of file.
//===========================================================================
