/*
 * mdb_sci_TX.c
 *
 *  Created on: 2023112
 *      Author: HP
 */

//#include "DSP2803x_Cla_typedefs.h"// DSP2803x CLA Type definitions

//#include "sys_protect.h"

#include "mdb_Init.h"
#include "mdb_sci_RX.h"// DSP2803x CLA Type definitions
#include "mdb_sci_TX.h"
#include "MonitorSci.h"
#include "Protocol.h"// DSP2803x CLA Type definitions


//==================================================================================================
//
//==================================================================================================







STRUCT_FAULTFLAG strFaultFlag;


//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: Sci_Task_OneMsDone
--------------------------------------
Function Descriptions:
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
void MonitorSci_Task_1ms(void)
{

}

//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: Sci_Task_QuarterCycleDone
--------------------------------------
Function Descriptions:
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
void MonitorSci_Task_5ms(void)
{

}

//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: Sci_Task_OneCycleDone
--------------------------------------
Function Descriptions:
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
void MonitorSci_Task_20ms(void)
{
    if( 1//System_InitStateGet()  == eSystemInitAllSuccess
    )
    {
        if( unMonitorSciFlag.bit.bExecuteStep == eCmdIdentifyMonitorSci )    //SCIʶ

        {
            MonitorSci_CommandIdentify();

            unMonitorSciFlag.bit.bCmdIdentifyFinish = 1;
            unMonitorSciFlag.bit.bToCmdDealFinish = FALSE;
        }
        if( unMonitorSciFlag.bit.bExecuteStep == eCmdDealMonitorSci)         //SCI
        {
            MonitorSci_CommandDeal();

            if( unMonitorSciFlag.bit.bCmdDealFinish )
                MonitorSci_ClearBuffer();
        }
    }
    else
    {
        MonitorSci_ClearBuffer();

        unMonitorSciFlag.bit.bCmdDealFinish = 1;
        uiBuffLength                 = 0;
        uiReceiveDataLengthCnt       = 0;
    }
}

//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: Sci_Task_TenPerSecDone
--------------------------------------
Function Descriptions:
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
void MonitorSci_Task_100ms(void)
{
    MonitorSci_AlarmRenew();
    MonitorSci_AnologUpdate();

    if( uiMonitorSciErrorCntNum > 0 )
    {
//        unProgramFault.bit.b1MonitorSciErrorCntNum = 1;
    }
}


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: SciProtocol_Sci_ClearBuffer
--------------------------------
Function Descriptions:
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
void MonitorSci_ClearBuffer(void)
{
//    Uint16 uiClearBuffTemp;
//    for(uiClearBuffTemp = 0; uiClearBuffTemp < uiReceiveDataLengthCnt; uiClearBuffTemp ++)
//        uiMonitorSciRxDataBuff[uiClearBuffTemp] = 0;
    uiReceiveDataLengthCnt           = 0;
}


//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: SciProtocol_Sci_AlarmRenew
-------------------------------------
Function Descriptions:¹
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
void MonitorSci_AlarmRenew(void)
{

}


//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: SciProtocol_Sci_StatusRenew
-------------------------------------
Function Descriptions:ģ
Parameter Name list:
ReturnType:
Refer doctuments:
 ******************************************************************************/
void MonitorSci_AnologUpdate(void)
{

}


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================


//==================================================================================================
//
//==================================================================================================
/******************************************************************************
Function Name: MonitorSci_CrcCaculate
--------------------------------------
Function Descriptions   :
Parameter Name list :
ReturnTyp           :
Refer doctuments        :
 ******************************************************************************/
Uint16 MonitorSci_CrcCaculate(const Uint16 *DataFirstAddPtr,Uint16 uiDataLength)
{
    static Uint16 uiCrc = 0xFFFF;  //crcĴ()ĳֵΪ0xffff
    static Uint16 uiBitLoopCnt;

    uiCrc = 0xFFFF;
    while( uiDataLength-- != 0 )
    {
        uiCrc ^= *DataFirstAddPtr;
        for( uiBitLoopCnt = 0; uiBitLoopCnt < 8; uiBitLoopCnt ++ )
        {
            if(uiCrc &0x0001)
            {
                uiCrc >>= 1;
                uiCrc ^=  0xA001;
            }
            else uiCrc >>= 1;
        }
        DataFirstAddPtr ++;
    }
    return uiCrc;
}


//==================================================================================================
//
//==================================================================================================

