#include "timer.h"
#include "FunState.h"
#include "FaultDetect.h"
#include "ctrl.h"
#include "adc.h"
#include "mdb_sci_RX.h"
#include "mdb_sci_TX.h"
#include "mdb_lin_RX.h"
#include "mdb_lin_TX.h"
#include "charger_ecan.h"

struct TIMERMESS TimerMess;

void Time_init(void)
{
    
    InitCpuTimers();


    ConfigCpuTimer(&CpuTimer0,100,25);// 25us
//    CpuTimer0Regs.TCR.all = 0x4000;
    CpuTimer0Regs.TCR.bit.FREE = 1;
    CpuTimer0Regs.TCR.bit.TIF  = 1;
    CpuTimer0Regs.TCR.bit.TSS  = 0;

    
    ConfigCpuTimer(&CpuTimer1,100,100);//0.1ms 10k
    CpuTimer1Regs.TCR.bit.FREE = 1;    
    CpuTimer1Regs.TCR.bit.TIF  = 1;
    CpuTimer1Regs.TCR.bit.TSS  = 0;
}

void BaseTime_init(void)
{
    my_memset(&TimerMess,0,sizeof(TimerMess));
}



//1msʱ䶯
void vMtimer1ms(void)
{
	if(TimerMess.utimerbase_1ms)
	{
        TimerMess.utimerbase_1ms = 0;
        
        
	}

}
//5msʱ䶯
void vMtimer5ms(void)
{
	if(TimerMess.utimerbase_5ms)
	{
		TimerMess.utimerbase_5ms = 0;
	}
}

//10msʱ䶯
void vMtimer10ms(void)
{
	if(TimerMess.utimerbase_10ms)
	{
		TimerMess.utimerbase_10ms = 0;        
	}
}

//20msʱ䶯
void vMtimer20ms(void)
{
	if(TimerMess.utimerbase_20ms)
	{
		TimerMess.utimerbase_20ms = 0;
	}
}

//100msʱ䶯
void vMtimer100ms(void)
{
	if(TimerMess.utimerbase_100ms)
	{
		TimerMess.utimerbase_100ms = 0;

	}
}

void vMtimerTreat(void)
{
    if (CpuTimer1Regs.TCR.bit.TIF == 1)
	{
         CpuTimer1Regs.TCR.bit.TIF = 1;
		 TimerMess.utimerbase_10k++;
        
//         GpioDataRegs.GPATOGGLE.bit.GPIO0 = 1;
//         GpioDataRegs.GPATOGGLE.bit.GPIO1 = 1;
//         GpioDataRegs.GPATOGGLE.bit.GPIO2 = 1;
//         GpioDataRegs.GPATOGGLE.bit.GPIO3 = 1;
//         GpioDataRegs.GPATOGGLE.bit.GPIO4 = 1;
//         GpioDataRegs.GPATOGGLE.bit.GPIO5 = 1;
         
        MonitorSci_Task_RealTime();
        MonitorSci_Task_RealTime_lin();

        
		if((TimerMess.utimerbase_10k%10)==0)
		{
			TimerMess.utimerbase_1ms = 1;
		}
		
		if((TimerMess.utimerbase_10k%50)==0)
		{
			TimerMess.utimerbase_5ms = 1;
		}

		if((TimerMess.utimerbase_10k%100)==0)
		{
			TimerMess.utimerbase_10ms = 1;
		}
		
		if((TimerMess.utimerbase_10k%200)==0)
		{
			TimerMess.utimerbase_20ms = 1;
		}

		if((TimerMess.utimerbase_10k%1000)==0)
		{
			TimerMess.utimerbase_100ms = 1;
			TimerMess.utimerbase_10k   = 0;
		}
	}
    vMtimer1ms();
	vMtimer5ms();
	vMtimer10ms();
	vMtimer20ms();
	vMtimer100ms();

//	//״̬

    
    Fun_Status_RUN();

}

/*********************************************END OF FILE**********************/
