/*
 * Copyright (c) 2020 Texas Instruments Incorporated - http://www.ti.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef BOARD_H
#define BOARD_H

//
// Included Files
//

#include "driverlib.h"
#include "device.h"

#define GPIO_PIN_EPWM5_A 8
#define GPIO_PIN_EPWM5_B 9
#define GPIO_PIN_EPWM1_A 0
#define GPIO_PIN_EPWM1_B 1
#define GPIO_PIN_EPWM2_A 2
#define GPIO_PIN_EPWM2_B 3
#define GPIO_PIN_I2CA_SDA 32
#define GPIO_PIN_I2CA_SCL 33
#define GPIO_PIN_OUTPUTXBAR1 34
#define GPIO_PIN_SCIA_RX 28
#define GPIO_PIN_SCIA_TX 29
#define GPIO_PIN_SCIB_RX 11
#define GPIO_PIN_SCIB_TX 18
#define GPIO_PIN_SPIA_SIMO 16
#define GPIO_PIN_SPIA_SOMI 17
#define GPIO_PIN_SPIA_CLK 56
#define GPIO_PIN_SPIA_STE 57
#define GPIO_PIN_SPIB_SIMO 24
#define GPIO_PIN_SPIB_SOMI 25
#define GPIO_PIN_SPIB_CLK 26
#define GPIO_PIN_SPIB_STE 27

#define VOUT_SEN_AD_BASE ADCB_BASE
#define VOUT_SEN_AD_RESULT_BASE ADCBRESULT_BASE
#define TEMP_2ND_AD_BASE ADCA_BASE
#define TEMP_2ND_AD_RESULT_BASE ADCARESULT_BASE

#define SEC_CT_DET_BASE CMPSS7_BASE
#define PRI_CT_DET_BASE CMPSS4_BASE
#define VOUT_OV_DET_BASE CMPSS2_BASE
#define SEC_CT_integral_BASE CMPSS3_BASE
#define PRI_CT_integral_BASE CMPSS1_BASE
#define IOUT_OC_DET_BASE CMPSS5_BASE

#define SWTIRMER_BASE CPUTIMER2_BASE

#define DAC1_BASE DACA_BASE
#define DAC2_BASE DACB_BASE

#define FAN_PWM_GPIO_BASE EPWM5_BASE
#define DRI_PRI_BASE EPWM1_BASE
#define DRI_2ND_BASE EPWM2_BASE

#define DEBUG_CLA 13
#define DEBUG_C28 12
#define WORK_LED 15
#define FAULT_LED 14
#define PFC_OK_2ND_GPIO 39
#define HIGH_LINE_2ND_GPIO 59
#define PFC_VIN_CROSS_DET_2ND 40
#define FAN_RPM_GPIO 10
#define PFC_OV_DET_GPIO 7

#define I2C_SLAVE_BASE I2CA_BASE
#define I2C_SLAVE_BITRATE 400000
#define I2C_SLAVE_SLAVE_ADDRESS 0
#define I2C_SLAVE_OWN_SLAVE_ADDRESS 0


// Interrupt Setings for INT_VOUT_SEN_AD_1
#define INT_VOUT_SEN_AD_1 INT_ADCB1
#define INT_VOUT_SEN_AD_1_INTERRUPT_ACK_GROUP INTERRUPT_ACK_GROUP1
extern __interrupt void INT_VOUT_SEN_AD_1_ISR(void);


#define DEBUG_SCI_BASE SCIA_BASE
#define DEBUG_SCI_BAUDRATE 115200
#define DEBUG_SCI_CONFIG_WLEN SCI_CONFIG_WLEN_8
#define DEBUG_SCI_CONFIG_STOP SCI_CONFIG_STOP_ONE
#define DEBUG_SCI_CONFIG_PAR SCI_CONFIG_PAR_EVEN
#define PRI_SCI_BASE SCIB_BASE
#define PRI_SCI_BAUDRATE 115200
#define PRI_SCI_CONFIG_WLEN SCI_CONFIG_WLEN_8
#define PRI_SCI_CONFIG_STOP SCI_CONFIG_STOP_ONE
#define PRI_SCI_CONFIG_PAR SCI_CONFIG_PAR_EVEN

#define SPIA_SLAVE_BASE SPIA_BASE
#define SPIA_SLAVE_BITRATE 1250000
#define SPIB_RAM_BASE SPIB_BASE
#define SPIB_RAM_BITRATE 1250000

void	Board_init();
void	ADC_init();
void	ASYSCTL_init();
void	CMPSS_init();
void	CPUTIMER_init();
void	DAC_init();
void	EPWM_init();
void	EPWMXBAR_init();
void	GPIO_init();
void	I2C_init();
void	INTERRUPT_init();
void	OUTPUTXBAR_init();
void	SCI_init();
void	SPI_init();
void	PinMux_init();

#endif  // end of BOARD_H definition
