/*
 * HwConfig.h
 *
 *  Created on: 2022~420
 *      Author: cody_chen
 */

#ifndef HWCONFIG_H_
#define HWCONFIG_H_

#define OSCSRC_FREQ                      10000000    //DEVICE_OSCSRC_FREQ

#define EPWMCLK_FREQ                     100000000   //((OSCSRC_FREQ * 20 * 1)  / 2)

#define HWPWM(x)                (x<<8)
#define PWM_KHZ              100U //KHz
#define PWM_PERIOD           (uint16_t)((uint32_t)EPWMCLK_FREQ/1000/PWM_KHZ-1)
                                  //UP CNT
#define PWM_UP_DONE_TBPRD    (uint16_t)((uint32_t)EPWMCLK_FREQ/1000/PWM_KHZ/2-1)
                                  //UP-DOWN CNT
#define HRPWM_UP_DONE_TBPRD  HWPWM((uint32_t)PWM_UP_DONE_TBPRD)

#define GET_OVP_REF             HWREGH(VOUT_OV_DET_BASE + CMPSS_O_DACHVALS)
#define SET_OVP_REF(value)      HWREGH(VOUT_OV_DET_BASE + CMPSS_O_DACHVALS) = value;
#define GET_OCP_REF             HWREGH(IOUT_OC_DET_BASE + CMPSS_O_DACHVALS)
#define SET_OCP_REF(value)      HWREGH(IOUT_OC_DET_BASE + CMPSS_O_DACHVALS) = value;

#define DUTY_PCMC                        0.0f
#define CNT_PCMC_PWM_DUTY               (uint16_t)(CNT_PCMC_PWM*DUTY_PCMC)

#define SYNC_PHASE_DELAY                 0UL

#define T_PCMC_PWM_DEADBAND_NSEC         150UL      // (nsec)
#define CNT_PCMC_PWM_DEADBAND           (uint16_t)(EPWMCLK_FREQ/1000*T_PCMC_PWM_DEADBAND_NSEC/1000000)

#define IL_SCALE                         7.51666f   // [Apeak]
#define IO_SCALE                         7.51666f   // [Apeak]
#define VO_SCALE                         6.7f       // [Vmax]
#define VIN_SCALE                        13.3f      // [Vmax]

#define VO2IO_RATIO                      (VO_SCALE/IO_SCALE)

#define IO_REF                           1.0f       // [Apeak]
#define IOREF_PU                         (IO_REF/IO_SCALE)

#define VO_REF                           3.3f       // [V]
#define VOREF_PU                         (VO_REF/VO_SCALE)

#define _2PI()                           6.283185f
//f32k1 = 1.0F / (1.0F + ((2PI() * fc) / sample_rate_hz));
#define LPF_FC(khz)                      1.0f/(1.0f+(_2PI() * khz / PCMC_PWM_KHZ))
#define VO_LPF_K1                        LPF_FC(20)
#define IO_LPF_K1                        LPF_FC(100)

//
// 7.10.1.2.2 ADC Characteristics
// ADCCLK Conversion Cycles 100-MHz SYSCLK (min)10.1 ~ (max) 11 ADCCLKs
//
// @ ADC_RESULT_Xy(X, y)
// X:= ADCA/B/C, y:= SOC0-15
#define ADC_RESULT_Xy(X, y) (((float)HWREGH(ADC ## X ##RESULT_BASE + y))*0.00024414f)

#define A0_IN6_IO_FB         ADC_RESULT_Xy(A, 0)
#define A1_IN3_TEMP_SENSE    ADC_RESULT_Xy(A, 1)
//#define A2_IN2_IL_FB         ADC_RESULT_Xy(A, 2)
#define A2_IN2_ILFB_AVG      ADC_RESULT_Xy(A, 2)        // BoosterPack
//#define A3_IN3_IL_FB         ADC_RESULT_Xy(A, 3)
#define A3_IN3_ILFB          ADC_RESULT_Xy(A, 3)        // BoosterPack
#define A4_IN5_OVP_SENSE     ADC_RESULT_Xy(A, 4)

#define B0_IN8_VO_FB         ADC_RESULT_Xy(B, 0)
#define B1_IN1_xx_FB         ADC_RESULT_Xy(B, 1)
#define B2_IN2_VKA           ADC_RESULT_Xy(B, 2)
#define B3_IN4_IO_FRONT_FB   ADC_RESULT_Xy(B, 3)
#define B4_IN0_OCP_SENSE     ADC_RESULT_Xy(B, 4)

#define C0_IN1_VIN_FB        ADC_RESULT_Xy(C, 0)
//#define C1_IN5_VIN_FB        ADC_RESULT_Xy(C, 1)
#define C3_IN5_VINFB         ADC_RESULT_Xy(C, 1)         // BoosterPack
#define C2_IN8_IO_FRONT_FB   ADC_RESULT_Xy(C, 2)
#define C3_IN6_VKA           ADC_RESULT_Xy(C, 3)
//#define C4_IN10_IL_FB        ADC_RESULT_Xy(C, 4)
#define C4_IN3_VOUTFB        ADC_RESULT_Xy(C, 4)         // BoosterPack

#define ENABLE_LAUNCHXL_BOOSTERPACK          1
#define ENABLE_SAMPLE_AVERAGE                1
#define ENABLE_VOLTAGE_LOOP                  1
#define ENABLE_CURRENT_LOOP                  1
#define ENABLE_OPEN_LOOP                     !(ENABLE_VOLTAGE_LOOP|ENABLE_CURRENT_LOOP)

#define GET_RAMP_MAX(base)               HWREGH(base + CMPSS_O_RAMPMAXREFA)
#define SET_RAMP_MAX(value, base)        HWREGH(base + CMPSS_O_RAMPMAXREFS) = value;

#define GET_RAMP_DEC(base)               HWREGH(base + CMPSS_O_RAMPDECVALA)
#define SET_RAMP_DEC(value, base)        HWREGH(base + CMPSS_O_RAMPDECVALS) = value;

#define GET_ADC_RESULT(X, y)             (HWREGH(ADC ## X ##RESULT_BASE + y))


#define DAC_U16(u16value, base) DAC_setShadowValue(base, u16value);
#define DAC_UPU(f32value, base) DAC_setShadowValue(base, (uint16_t)(4095.0f * f32value))
#define DAC_SPU(f32value, base) DAC_setShadowValue(base, (uint16_t)(4095.0f * ((f32value*0.5f)+0.5f))
#define DAC_ABS(f32value, base) DAC_setShadowValue(base, (uint16_t)(4095.0f * f32value *(0.0 <= f32value? 1.0f: -1.0f)))


#define SET_DEBUG_C28()              GPIO_writePin(12, 1);
#define RST_DEBUG_C28()              GPIO_writePin(12, 0);
#define INV_DEBUG_C28()              GPIO_togglePin(12);

#define SET_DEBUG_CLA()              GPIO_writePin(13, 1);
#define RST_DEBUG_CLA()              GPIO_writePin(13, 0);


#endif /* HWCONFIG_H_ */
