/*
 * cla_task.h
 *
 *  Created on: 2022~329
 *      Author: cody_chen
 */

#ifndef CLA_TASK_H_
#define CLA_TASK_H_

#include "ctypedef.h"
#include "cla_cmath.h"

enum {
    _CLA_NO_ERROR        = (0x0000),
    _CLA_IIN_OCP         = (0x0001U<<0),
    _CLA_IOUT_OCP        = (0x0001U<<1),
    _CLA_IPRI_OCP        = (0x0001U<<2),
    _CLA_I2ND_OCP        = (0x0001U<<3),
    _CLA_OCP_MASK        = (_CLA_I2ND_OCP|_CLA_IPRI_OCP|_CLA_IOUT_OCP|_CLA_IIN_OCP),
    _CLA_VIN_OVP         = (0x0001U<<4),
    _CLA_VOUT_OVP        = (0x0001U<<5),
    _CLA_VPRI_OVP        = (0x0001U<<6),
    _CLA_V2ND_OVP        = (0x0001U<<7),
    _CLA_OVP_MASK        = (_CLA_V2ND_OVP|_CLA_VPRI_OVP|_CLA_VOUT_OVP|_CLA_VIN_OVP),
    _CLA_WARNING_OVP     = (0x0001U<<8),
    _CLA_WARNING_UVP     = (0x0001U<<9),
    _CLA_WARNING_OCP     = (0x0001U<<10),
    _CLA_WARNING_OTP     = (0x0001U<<11),
    _CLA_WARNING_MASK    = (_CLA_WARNING_OVP|_CLA_WARNING_OVP|_CLA_WARNING_OCP|_CLA_WARNING_OTP),
    _CLA_ERROR_OVP       = (0x0001U<<12),
    _CLA_ERROR_UVP       = (0x0001U<<13),
    _CLA_ERROR_OCP       = (0x0001U<<14),
    _CLA_ERROR_OTP       = (0x0001U<<15),
    _CLA_ERROR_MASK      = (_CLA_ERROR_OVP|_CLA_ERROR_UVP|_CLA_ERROR_OCP|_CLA_ERROR_OTP),
    _CLA_ALL_ERROR       = (0xFFFFU)
};

enum {
    _CLA_NO_ACTION       =  (0x0000),
    _CLA_INIT_DRV_PARAM  =  (0x0001U<<0),
    _CLA_INIT_CLA_PARAM  =  (0x0001U<<1),
    _CLA_INIT_PWMADC     =  (0x0001U<<2),
    _CLA_INIT_SUCCESS    =  (_CLA_INIT_DRV_PARAM|_CLA_INIT_CLA_PARAM|_CLA_INIT_PWMADC),
    _CLA_TASK1_OK        =  (0x0001U<<3),
    _CLA_PWMADC_OK       =  (0x0001U<<4),
    _CLA_PFC_2ND_OK      =  (0x0001U<<5),
    _CLA_V_PRI_OK        =  (_CLA_TASK1_OK|_CLA_PWMADC_OK|_CLA_PFC_2ND_OK),
    _CLA_PWM_GPIO_OK     =  (0x0001U<<6),
    _CLA_PWM_RESET       =  (0x0001U<<7),
    _CLA_SYSTEM_WARNING  =  (0x0001U<<14),
    _CLA_SYSTEM_ERROR    =  (0x0001U<<15)
};

typedef uint16_t FG_CLASTAT;
typedef uint16_t FG_CLAERROR;



typedef struct {
    float32_t  f32Adc;
    ST_LPF     sLPF;
    ST_CAL     sCali;
} ST_ADCLPF;

typedef struct {
    float32_t  f32Adc;
    ST_IIR     sIIR;
    ST_CAL     sCali;
} ST_ADCIIR;


typedef struct {

    ST_ADCLPF  sIL;
    ST_ADCLPF  sIO;
    ST_ADCLPF  sOCP;
    ST_ADCLPF  sOVP;
    ST_ADCIIR  sSECOTP;
    ST_ADCIIR  sPRIOTP;
    ST_ADCLPF  sVO;
    ST_ADCLPF  sVIN;

    ST_PI sLoopI;
    ST_PI sLoopV;

    ST_PWM    sPWM;

    float32_t f32Vref;
    float32_t f32Vbus;
    float32_t f32Vout;
    float32_t f32Iout;
    float32_t f32Temp;

    FG_CLASTAT  fgStatus;
    FG_CLAERROR fgError;



//    uint16_t  u16Run;



}  ST_CLA;

extern volatile ST_CLA sCLA;


#define FG_GETCLA(x)   FG_GET(x, sCLA.fgStatus)
#define FG_SETCLA(x)   FG_SET(x, sCLA.fgStatus)
#define FG_RSTCLA(x)   FG_RST(x, sCLA.fgStatus)
#define FG_nGETCLA(x)   FG_GETn(x, sCLA.fgStatus)

#define FG_GETERR(x)   FG_GET(x, sCLA.fgError)
#define FG_SETERR(x)   FG_SET(x, sCLA.fgError)
#define FG_RSTERR(x)   FG_RST(x, sCLA.fgError)
#define FG_ANDERR(x)   FG_AND(x, sCLA.fgError)
#define FG_nGETERR(x)  FG_GETn(x, sCLA.fgError)

#define FG_GETPWM(x)   FG_GET(x, sCLA.sPWM.u16CtrlReg)
#define FG_SETPWM(x)   FG_SET(x, sCLA.sPWM.u16CtrlReg)
#define FG_RSTPWM(x)   FG_RST(x, sCLA.sPWM.u16CtrlReg)
#define FG_ANDPWM(x)   FG_AND(x, sCLA.sPWM.u16CtrlReg)
#define FG_nGETPWM(x)  FG_GETn(x, sCLA.sPWM.u16CtrlReg)

#define FG_GETPWMSTATUS(x)   FG_GET(x, sCLA.sPWM.u16StatusReg)
#define FG_SETPWMSTATUS(x)   FG_SET(x, sCLA.sPWM.u16StatusReg)
#define FG_RSTPWMSTATUS(x)   FG_RST(x, sCLA.sPWM.u16StatusReg)
#define FG_ANDPWMSTATUS(x)   FG_AND(x, sCLA.sPWM.u16StatusReg)
#define FG_nGETPWMSTATUS(x)  FG_GETn(x, sCLA.sPWM.u16StatusReg)

//CLA C Tasks defined in Cla1Tasks_C.cla
__attribute__((interrupt))  void Cla1Task1();
__attribute__((interrupt))  void Cla1Task2();
__attribute__((interrupt))  void Cla1Task3();
__attribute__((interrupt))  void Cla1Task4();
__attribute__((interrupt))  void Cla1Task5();
__attribute__((interrupt))  void Cla1Task6();
__attribute__((interrupt))  void Cla1Task7();
__attribute__((interrupt))  void Cla1Task8();

#endif /* CLA_TASK_H_ */
