/*
 * common.h
 *
 *  Created on: 2022~39
 *      Author: cody_chen
 */

#ifndef COMMON_H_
#define COMMON_H_

#include "ctypedef.h"

#include <math.h>
#include <limits.h>
#include "driverlib.h"

#include "board.h"
#include "HwConfig.h"

#define SW_TIMER        50000000

#define T_500US         (SW_TIMER/10000)
#define T_1MS           (SW_TIMER/1000)
#define T_2D5MS         (SW_TIMER/400)
#define T_5MS           (SW_TIMER/200)
#define T_10MS          (SW_TIMER/100)
#define T_20MS          (SW_TIMER/50)
#define T_25MS          (SW_TIMER/40)
#define T_50MS          (SW_TIMER/20)
#define T_100MS         (SW_TIMER/10)
#define T_200MS         (SW_TIMER/5)
#define T_500MS         (SW_TIMER/2)
#define T_1S            (SW_TIMER/1)


#define BLUE_LED_TOGGLE   GPIO_togglePin(D10_BLUE_LED);

#include "cmath.h"

typedef struct {
    ST_RAMPCTRL sVref;

    float32_t  f32Vref;
    float32_t  f32Vout;
    float32_t  f32Iout;
    float32_t  f32IL;
    float32_t  f32Vin;



    uint16_t  fgDrv;
    uint16_t  fgFault;
    uint16_t  u16Reset;
    uint16_t  u16NA;

    uint16_t  t1;
    uint16_t  t2;
}  ST_DRV;

typedef ST_DRV* HAL_DRV;

extern volatile ST_DRV sDrv;

extern volatile ST_RAMPCTRL sABC;


extern volatile uint32_t ePWM[] ;

extern volatile uint16_t status;

#include "linkPeripheral.h"
#include "PowerSequence.h"

#endif /* COMMON_H_ */
