/*
 * CTYPEDEF.h
 *
 *  Created on: 2022~322
 *      Author: cody_chen
 *
 */

#ifndef CTYPEDEF_H_
#define CTYPEDEF_H_

#include <stdbool.h>
#include <stdint.h>
#include "inc/hw_memcfg.h"
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"

#ifndef bool_t
typedef bool bool_t;
#endif

#ifndef true
#define true  ((bool_t)1)
#endif

#ifndef false
#define false ((bool_t)0)
#endif

#define _2PI()                           6.283185f

typedef struct {
    float32_t f32Gain;
    float32_t f32Offset;
    float32_t f32Out;
    float32_t  f32Base;
    float32_t  f32Real;
}  ST_CAL;
typedef ST_CAL * HAL_CAL;

typedef struct {
    float32_t f32Now;
    float32_t f32K1;  //f32k1 = 1.0F / (1.0F + ((2PI() * fc) / sample_rate_hz));
    float32_t f32Out;
}   ST_LPF;
typedef ST_LPF * HAL_LPF;


typedef struct {
    float32_t f32Now;
    float32_t f32K1;
    float32_t f32Out;
}    ST_IIR;
typedef ST_IIR * HAL_IIR;

typedef struct {
    float32_t  f32Out;           // Output: controller output
    float32_t  f32Max;           // Parameter: Limit the controller output by Maximum
    float32_t  f32Min;           // Parameter: Limit the controller output by Minimum
    float32_t  f32Kp;            // Parameter: proportional loop gain
    float32_t  f32Ki;            // Parameter: integral gain (0.0~1.0)
    float32_t  f32Err;           // Data: (f32) Error between the feedback and reference
    float32_t  f32LimitErr;      // Data: (f32) Limit f32Err
    float32_t  f32Pdata;         // Data: (f32) Save the proportional term results
    float32_t  f32Idata;         // Data: (f32) Save the integral term
    float32_t  f32Itemp;         // Data: (F32) Temporarily save the integral term i(k-1)
    float32_t  f32Sum;           // Data: Sum of proportional term and integral term
    uint16_t   u16StopUi;        // Parameter: Used to stop the integral term.
}   ST_PI;
typedef ST_PI * HAL_PI;


typedef struct {    float32_t    f32Target;     // Input: Target input (pu)
                    float32_t    f32Step;       // Parameter: Increase/Decrease Step (pu)
                    float32_t    f32LowLimit;   // Parameter: Minimum limit (pu)
                    float32_t    f32HighLimit;  // Parameter: Maximum limit (pu)
                    float32_t    f32Out;     // Output: Target output (pu)
}  ST_RAMPCTRL;
typedef ST_RAMPCTRL * HAL_RAMPCTRL;


typedef struct {     float32_t    f32Target1;     // Input: Target input (pu)
                     float32_t    f32Target2;     // Input: Target input (pu)
                     float32_t    f32Step1;
                     float32_t    f32Step2;
                     float32_t    f32Error;
                     float32_t    f32LowLimit;   // Parameter: Minimum limit (pu)
                     float32_t    f32HighLimit;  // Parameter: Maximum limit (pu)
                     float32_t    f32Out;     // Output: Target output (pu)
                     bool_t       blCountMode;
}  ST_RAMPUPDN;
typedef ST_RAMPUPDN * HAL_RAMPUPDN;

typedef struct { float32_t    f32Target;     // Input: Target input (pu)
                 float32_t    f32Step;       // Parameter: Increase/Decrease Step (pu)
                 float32_t    f32LowLimit;   // Parameter: Minimum limit (pu)
                 float32_t    f32HighLimit;  // Parameter: Maximum limit (pu)
                 float32_t    f32Out;     // Output: Target output (pu)
} ST_SAWTOOTH;
typedef ST_SAWTOOTH * HAL_SAWTOOTH;


typedef struct {
    float32_t *pf32Buf;
    float32_t f32Scale;
    float32_t f32Sum;
    float32_t f32Avg;
    float32_t f32Now;
    uint16_t  u16Index;
    uint16_t  u16MemSize;
    uint16_t  u16Cycle;
    uint16_t  u16CycleIndex;
}ST_MVFIR;
typedef ST_MVFIR * HAL_MVFIR;

enum {
    _LUKTB_INIT_SUCCESS = (0x00000001<<0),
    _LUKTB_NO_ERROR    =   0x00000000,
    _LUKTB_INITL_FAIL  = ~(0x00000001<<0),
};

typedef struct {
    uint32_t  u32PwmBase_PRI;
    uint32_t  u32PwmBase_2ND;
    float32_t f32Period;
    uint32_t  u32HRCMPA;
    uint32_t  u32HRCMPB;

    uint16_t  u16CtrlReg;
    uint16_t  u16StatusReg;
    uint16_t  u16Trigger;
    int16_t   s16TrgTemp;
    uint16_t  u16CMPA;
    uint16_t  u16CMPB;
    uint16_t  u16Period;
    uint16_t  u16Cnt;
    uint16_t  u16Detal;
    uint16_t  u16fgTZ;
} ST_PWM;


typedef ST_PWM * HAL_PWM;

enum {
    _NO_ACTION_FOR_PWM          = 0,
    _CONTROL_MODE               = (0x0001 << 0),
    _ENABLE_PWM_PRI_SOFTSTART   = (0x0001 << 1),
    _ENABLE_PWM_2ND_SOFTSTART   = (0x0001 << 2),
    _OUTPUT_PWM_AND_SR = (0x0001 << 14),
    _OUTPUT_PWM_ALREADY = (_OUTPUT_PWM_AND_SR),
    _UNDEFINE_PWM_ACTION = (0x0001 << 15)
};
enum {
    _NO_ACTION_FLAG_PWM         = 0,
    _PWM_CONTROL_ENABLE         = (0x0001 << 0),
    _PWM_CLOSE_LOOP_CONTROL     = (0x0001 << 1),
    _PWM_PRI_SOFTSTART_RUN      = (0x0001 << 2),
    _PWM_PRI_SOFTSTART_OK       = (0x0001 << 3),
    _PWM_2ND_SOFTSTART_RUN      = (0x0001 << 4),
    _PWM_2ND_SOFTSTART_OK       = (0x0001 << 5)
};

enum {
    _OPEN_MODE                   = 0,
    _CLOSE_MODE                  = 1
};


#define FG_GETn(x, src)  ((src & (x)) == (x) ? false: true) //!((src & (x)) == (x))
#define FG_GET(x, src)   ((src & (x)) == (x) ? true: false) //((src & (x)) == (x))
#define FG_AND(x, src)   (src & (x))
#define FG_SET(x, src)   {src |= (x);}
#define FG_RST(x, src)   {src &= ~(x);}



#endif /* CTYPEDEF_H_ */
