/*
 * isr.c
 *
 *  Created on: 2022~315
 *      Author: cody_chen
 */

#include <math.h>
#include "common.h"
#include "cla_task.h"



#ifdef _FLASH
#pragma SET_CODE_SECTION(".TI.ramfunc")
#endif //_FLASH

void softstart(void){

}

__interrupt void INT_VOUT_SEN_AD_1_ISR(void) //XXXnsec @ 100KHz
{
    SET_DEBUG_C28();

    if(FG_GETCLA(_CLA_TASK1_OK)) {

        /*
         * Check error
         *
         *
         * */

        if(sCLA.fgError == _CLA_NO_ERROR && FG_GETCLA(_CLA_V_PRI_OK)){
            FG_SETPWMSTATUS(_PWM_CONTROL_ENABLE);

        }
        else{
            FG_RSTPWMSTATUS(_PWM_CONTROL_ENABLE);

        }

        /*
         * control state : state machine
         *      1.check PWM control enable
         *      2.check select control mode
         *          mode 1 : open loop mode
         *          mode 2 : close loop mode
         *
         *
         *
         * */
        if(FG_GETPWMSTATUS(_PWM_CONTROL_ENABLE)){

            if(FG_GETPWMSTATUS(_PWM_CLOSE_LOOP_CONTROL)){


            }
            else{


            }
        }

        /*
         * Measure : slow speed
         *
         *
         * */



        /*
         *  power sequence
         *
         *
         * */



        /*
         *  protection
         *
         *
         * */
        if( 0 == GPIO_readPin(PFC_OV_DET_GPIO)){
            FG_RSTPWMSTATUS(_PWM_CONTROL_ENABLE);
            FG_SETERR(_CLA_VIN_OVP);
        }
        else{
            FG_RSTERR(_CLA_VIN_OVP);
        }

//        if(sCLA.f32Iout > 0.52) SET_OCP_REF(3846)

        /*
         *
         * */
        FG_SETCLA(_CLA_PWMADC_OK);
    }
    // Clear the interrupt flag
    ADC_clearInterruptStatus(VOUT_SEN_AD_BASE, ADC_INT_NUMBER1);

    // Acknowledge the interrupt
    Interrupt_clearACKGroup(INT_VOUT_SEN_AD_1_INTERRUPT_ACK_GROUP);

    //RST_DEBUG_C28();
}





#ifdef _FLASH
#pragma SET_CODE_SECTION()
#endif //_FLASH

