
#include "common.h"
#include "ModbusSlave.h"

volatile ST_DRV sDrv;


void task25msec(void * s)
{
//TEST MODE
    if( 1 == GPIO_readPin(PFC_OK_2ND_GPIO)){
        FG_SETCLA(_CLA_PFC_2ND_OK);
    }
    else{
        FG_RSTCLA(_CLA_PFC_2ND_OK);
    }

}

void task2D5msec(void * s)
{
    //SET_DEBUG_C28();

    execPowerSequence((HAL_DRV)&sDrv);

//    RST_DEBUG_C28();
}

void task1msec(void * s)
{
//    SET_DEBUG_C28();
    /*
     * Check error
     *
     *
     * */
    if(FG_GETPWMSTATUS(_PWM_CONTROL_ENABLE)){
        GPIO_writePin(WORK_LED, 1);
        GPIO_writePin(FAULT_LED, 0);
    }
    else{
        GPIO_writePin(WORK_LED, 0);
        GPIO_writePin(FAULT_LED, 1);
    }
    sCLA.sPWM.u16fgTZ = EPWM_getTripZoneFlagStatus(ePWM[1]);
    if(sCLA.sPWM.u16fgTZ){
        if(sCLA.fgError == _CLA_NO_ERROR){
            sCLA.sPWM.u16CtrlReg = _NO_ACTION_FOR_PWM;
            sCLA.sPWM.u16StatusReg = _NO_ACTION_FLAG_PWM;
        }
        if(sCLA.sPWM.u16fgTZ == 12U) {FG_SETERR(_CLA_VOUT_OVP);}
        else if(sCLA.sPWM.u16fgTZ == 36U) {FG_SETERR(_CLA_IOUT_OCP);}
        else {FG_SETERR(_CLA_ALL_ERROR);}

    }
//    RST_DEBUG_C28();
}

void task50msec(void * s)
{
    if(sDrv.u16Reset == 1){

        if(sCLA.fgError == _CLA_NO_ERROR){
            EPWM_forceTripZoneEvent(sCLA.sPWM.u32PwmBase_PRI, EPWM_TZ_FORCE_EVENT_OST );
            EPWM_forceTripZoneEvent(sCLA.sPWM.u32PwmBase_2ND, EPWM_TZ_FORCE_EVENT_OST );

        }
        else{
            FG_RSTCLA(_CLA_INIT_PWMADC);
            DEVICE_DELAY_US(50);
            FG_RSTCLA(_CLA_TASK1_OK);
            DEVICE_DELAY_US(50);
            EPWM_disableADCTrigger(DRI_2ND_BASE, EPWM_SOC_A);
            DEVICE_DELAY_US(50);

            EPWM_clearTripZoneFlag(sCLA.sPWM.u32PwmBase_PRI, (EPWM_TZ_FLAG_OST |  EPWM_TZ_FLAG_DCAEVT1 | EPWM_TZ_FLAG_DCBEVT1));
            EPWM_clearTripZoneFlag(sCLA.sPWM.u32PwmBase_2ND, (EPWM_TZ_FLAG_OST |  EPWM_TZ_FLAG_DCAEVT1 | EPWM_TZ_FLAG_DCBEVT1));
            EPWM_clearOneShotTripZoneFlag(sCLA.sPWM.u32PwmBase_PRI, (EPWM_TZ_OST_FLAG_DCBEVT1 | EPWM_TZ_OST_FLAG_DCAEVT1));
            EPWM_clearOneShotTripZoneFlag(sCLA.sPWM.u32PwmBase_2ND, (EPWM_TZ_OST_FLAG_DCBEVT1 | EPWM_TZ_OST_FLAG_DCAEVT1));
            initClaCtrlParam();
            initPower((HAL_DRV)&sDrv);
            initPWM();
            sCLA.sPWM.u16CtrlReg = _NO_ACTION_FOR_PWM;
            sCLA.sPWM.u16StatusReg = _NO_ACTION_FLAG_PWM;
            sCLA.fgError = _CLA_NO_ERROR;
            sCLA.sPWM.u16fgTZ = 0;
            EPWM_enableADCTrigger(DRI_2ND_BASE, EPWM_SOC_A);
            sDrv.u16Reset = 0;
        }

    }

}


typedef struct _ST_TIMETASK{
    void (*fn) (void * s);
    uint32_t cnt;
    uint32_t max;
} ST_TIMETASK;

uint16_t id_ttask = 0;
ST_TIMETASK time_task[] = {
        {task50msec,         0,   T_50MS},
        {task2D5msec,         0,   T_2D5MS},
        {task25msec,          0,   T_25MS},
        {task1msec,          0,   T_1MS},
        {0, 0, 0}
};


bool_t scanTimeTask(ST_TIMETASK *t, void *s)
{
    static uint32_t delta_t;
    static uint32_t u32Cnt = 0;

    u32Cnt = SW_TIMER - (uint32_t)CPUTimer_getTimerCount(SWTIRMER_BASE);

    if(t->cnt > u32Cnt) {
        delta_t = u32Cnt + SW_TIMER - t->cnt;
    }
    else {
        delta_t = u32Cnt - t->cnt;
    }

    if(delta_t >= t->max) {
        t->fn(s);
        t->cnt = u32Cnt;
        return true;
    }
    else {
        return false;
    }
}

void main(void)
{
    // Initialize device clock and peripherals
    Device_init();

    // Initialize PIE and clear PIE registers. Disables CPU interrupts.
    Interrupt_initModule();

    // Initialize the PIE vector table with pointers to the shell Interrupt
    // Service Routines (ISR).
    Interrupt_initVectorTable();

    // Initialize GPIO and configure the GPIO pin as a push-pull output
    Board_init();

    initCLA();
    initPower((HAL_DRV)&sDrv);

    initPWM();


    // Enable ADC1 interrupts
    Interrupt_enable(INT_ADCB1);

    // Enable Global Interrupt (INTM) and realtime interrupt (DBGM)
    EINT;
    ERTM;

    // Enable ePWM Trigger to ADC1 interrupts
    EPWM_enableADCTrigger(DRI_2ND_BASE, EPWM_SOC_A);



    // Loop Forever
    while(1)
    {
        scanTimeTask(&time_task[id_ttask++], (void *)0);
        if(0 == time_task[id_ttask].fn) id_ttask = 0;

        exeModbusSlave(&mbcomm);
        updateModbusParameter(&mbcomm);


        //
        // Call the scale factor optimizer lib function SFO()
        // periodically to track for any change due to temp/voltage.
        // This function generates MEP_ScaleFactor by running the
        // MEP calibration module in the HRPWM logic. This scale
        // factor can be used for all HRPWM channels. The SFO()
        // function also updates the HRMSTEP register with the
        // scale factor value.
        //
        status = SFO(); // in background, MEP calibration module
                        // continuously updates MEP_ScaleFactor

        if (status == SFO_ERROR)
        {
            asm(" ESTOP0");     // SFO function returns 2 if an error occurs & #
                                // of MEP steps/coarse step
        }                       // exceeds maximum of 255.
    }
}

//
// End of File
//
