/*
 * ModbusCommFunc.c
 *
 *  Created on: 2018~328
 *      Author: user
 */

#include "ModbusCommon.h"
#include "ModbusSlave.h"

#define HBYTE(x) ((x>>8)&0x00FF)
#define LBYTE(x) (x&0x00FF)

int16_t getGroupIndex(SCI_MODBUS *mbus)
{
    ST_GROUP * tmp = mbus->pfn;
    uint16_t i = 0;
    uint16_t src = 0;
    uint16_t dest = 0;
    while(0 != tmp[i].src) {
        src = mbus->info.rwfrom/1000;
        dest = tmp[i].src->id/1000;
        if(src == dest) {
            return i;
        }

        i++;
    }
    return -1;
}


int16_t pushModbusByte(uint16_t u16Data, SCI_MODBUS *mbus)
{
    if(0 != mbus->RxBuf[0]) {
        mbus->TxBuf[mbus->pushcnts++] = u16Data;
        return ucMBCRC16(u16Data, &mbus->info.tbcrc);
    }
    else {
        //Broadcast
        return 0;
    }
}

int16_t ReservedFunction(SCI_MODBUS *mbus)
{
	mbus->errmsg = MB_ERROR_ILLEGALFUNC;
	return MBUS_FAIL;
}

void rdMbusReg(U16REG *temp, SCI_MODBUS *mbus) {
    uint16_t *pData = &mbus->pReg->u16MbusData[mbus->pfn[mbus->info.group].src->mem_i + mbus->info.addr + mbus->info.index];
    temp->HiByte = HBYTE(*pData);
    temp->LoByte = LBYTE(*pData);
}

int16_t readHoldingRegister(SCI_MODBUS *mbus)
{
	static HEADER_READ_HOLDINGREG *pack = 0;
	static U16REG temp = {0, 0};

    pack = (HEADER_READ_HOLDINGREG *)&mbus->RxBuf[0];

    switch(mbus->evFunc) {
    case _SEND_ADDRESS:
        mbus->info.rwfrom = (pack->Address.HiByte<<8) | pack->Address.LoByte;

        mbus->info.group = getGroupIndex(mbus);//mbus->info.rwfrom % 1000 / 100;

        if(0 <= mbus->info.group) {
            mbus->info.addr = mbus->info.rwfrom % 1000;
            //The number of bytes convert to the number of words.
            mbus->info.words = (((pack->Points.HiByte<<8)&0xFF00) | pack->Points.LoByte);
            // Calculate a valid range
            mbus->info.memrange = mbus->pfn[mbus->info.group].d_size  - (mbus->info.addr+mbus->info.words);
        }
        else {
            mbus->info.memrange = mbus->info.group;
        }

        if(0<=mbus->info.memrange) {
            pushModbusByte(pack->Slave, mbus);
            pushModbusByte(pack->Function, mbus);
            mbus->evFunc = _SEND_BYTE_COUNTS;
        }
        else {
            mbus->errmsg = MB_ERROR_ILLEGALADDR;
            break;
        }

    case _SEND_BYTE_COUNTS:
        pushModbusByte(mbus->info.words*2, mbus);
        mbus->evFunc = _SEND_DATA_OUT;

    case _SEND_DATA_OUT:
        if(mbus->info.index<mbus->info.words) {
            rdMbusReg(&temp, mbus);
            pushModbusByte(temp.HiByte, mbus);
            mbus->info.crc = pushModbusByte(temp.LoByte, mbus);
            mbus->info.index++;
        }
        else {
            pushModbusByte(LBYTE(mbus->info.crc), mbus);
            pushModbusByte(HBYTE(mbus->info.crc), mbus);
            mbus->evFunc = _WAIT_FOR_SEND_READY;
        }
        break;

    case _WAIT_FOR_SEND_READY:
        if(mbus->popcnts<mbus->pushcnts) {
            if(SCI_FIFO_TX16 > SCI_getTxFIFOStatus(mbus->sci)) {
                SCI_writeCharNonBlocking(mbus->sci, mbus->TxBuf[mbus->popcnts++]);
            }
        }
        else {
            mbus->popcnts = mbus->pushcnts = 0;
            mbus->evFunc = _SEND_ADDRESS;
            return MBUS_03H_Read_Holding_Registers;
        }
        break;
    default:
        mbus->info = DEFAULT_REG_INFO;
        mbus->evFunc = _SEND_ADDRESS;
        mbus->errmsg = MB_ERROR_SLVFAILURE;
        break;
    }

    if(MB_NO_ERROR != mbus->errmsg) return MBUS_FAIL;


	return MBUS_WAIT;
}


void wrMbusReg(SCI_MODBUS *mbus) {
     uint16_t *pData = &mbus->pReg->u16MbusData[mbus->pfn[mbus->info.group].src->mem_i + mbus->info.addr + mbus->info.index];
    *pData = (uint16_t)((mbus->info.pData[mbus->info.index].HiByte<<8)&0xFF00)|(mbus->info.pData[mbus->info.index].LoByte&0x00FF);
}


int16_t writeHoldingRegister(SCI_MODBUS *mbus)
{
	static HEADER_WRITE_HOLDINGREG *pack = 0;

    pack = (HEADER_WRITE_HOLDINGREG *)&mbus->RxBuf[0];

    switch(mbus->evFunc) {
    case _SEND_ADDRESS:
        mbus->info.rwfrom = (pack->Address.HiByte<<8) | pack->Address.LoByte;

        mbus->info.group = getGroupIndex(mbus);//mbus->info.rwfrom % 1000 / 100;

        if(0 <= mbus->info.group) {
            mbus->info.addr = mbus->info.rwfrom % 1000;
            //The number of bytes convert to the number of words.
            mbus->info.words = 1;
            // Calculate a valid range
            mbus->info.memrange = mbus->pfn[mbus->info.group].d_size  - (mbus->info.addr+mbus->info.words);

            // Get the start of Data.
            mbus->info.pData = &pack->Data;
        }
        else {
            mbus->info.memrange = mbus->info.group;
        }

        if(0<=mbus->info.memrange) {
            pushModbusByte(pack->Slave, mbus);
            pushModbusByte(pack->Function, mbus);
            mbus->evFunc = _SEND_MEMADDR;
        }
        else {
            mbus->errmsg = MB_ERROR_ILLEGALADDR;
            break;
        }


    case _SEND_MEMADDR:
        pushModbusByte(pack->Address.HiByte, mbus);
        pushModbusByte(pack->Address.LoByte, mbus);
        mbus->evFunc = _SEND_DATA_OUT;

    case _SEND_DATA_OUT:
        if(mbus->info.index<mbus->info.words) {
            wrMbusReg(mbus);
            pushModbusByte(mbus->info.pData[mbus->info.index].HiByte, mbus);
            mbus->info.crc = pushModbusByte(mbus->info.pData[mbus->info.index].LoByte, mbus);
            mbus->info.index++;
        }
        else {
            pushModbusByte(LBYTE(mbus->info.crc), mbus);
            pushModbusByte(HBYTE(mbus->info.crc), mbus);
            mbus->evFunc = _WAIT_FOR_SEND_READY;
        }
        break;

    case _WAIT_FOR_SEND_READY:
        if(mbus->popcnts<mbus->pushcnts) {
            if(SCI_FIFO_TX16 > SCI_getTxFIFOStatus(mbus->sci)) {
                SCI_writeCharNonBlocking(mbus->sci, mbus->TxBuf[mbus->popcnts++]);
            }
        }
        else {
            mbus->popcnts = mbus->pushcnts = 0;
            mbus->evFunc = _SEND_ADDRESS;
            return MBUS_06H_Write_Single_Register;
        }
        break;
    default:
        mbus->info = DEFAULT_REG_INFO;
        mbus->evFunc = _SEND_ADDRESS;
        mbus->errmsg = MB_ERROR_SLVFAILURE;
        break;
    }

    if(MB_NO_ERROR != mbus->errmsg) return MBUS_FAIL;

	return MBUS_WAIT;
}

int16_t writeHoldingNRegister(SCI_MODBUS *mbus)
{
	static HEADER_WRITE_N_HOLDINGREG *pack = 0;

    pack = (HEADER_WRITE_N_HOLDINGREG *)&mbus->RxBuf[0];

    switch(mbus->evFunc) {
    case _SEND_ADDRESS:

        mbus->info.rwfrom = (pack->Address.HiByte<<8) | pack->Address.LoByte;

        mbus->info.group = getGroupIndex(mbus);//mbus->info.rwfrom % 1000 / 100;

        if(0 <= mbus->info.group) {
            mbus->info.addr = mbus->info.rwfrom % 1000;
            //The number of bytes convert to the number of words.
            mbus->info.words = (((pack->Points.HiByte<<8)&0xFF00) | pack->Points.LoByte);
            // Calculate a valid range
            mbus->info.memrange = mbus->pfn[mbus->info.group].d_size  - (mbus->info.addr+mbus->info.words);

            // Get the start of Data.
            mbus->info.pData = &pack->Data;
        }
        else {
            mbus->info.memrange = mbus->info.group;
        }

        if(0<=mbus->info.memrange) {
            pushModbusByte(pack->Slave, mbus);
            pushModbusByte(pack->Function, mbus);
            mbus->evFunc = _SEND_MEMADDR;
        }
        else {
            mbus->errmsg = MB_ERROR_ILLEGALADDR;
            break;
        }


    case _SEND_MEMADDR:
        pushModbusByte(pack->Address.HiByte, mbus);
        pushModbusByte(pack->Address.LoByte, mbus);
        mbus->evFunc = _SEND_MEMSIZE;

    case _SEND_MEMSIZE:
        pushModbusByte(pack->Points.HiByte, mbus);
        mbus->info.crc = pushModbusByte(pack->Points.LoByte, mbus);
        mbus->evFunc = _SAVE_BYTE_COUNTS;

    case _SAVE_BYTE_COUNTS:
        if(mbus->info.index<mbus->info.words) {
            wrMbusReg(mbus);
            mbus->info.index++;
        }
        else {
            pushModbusByte(LBYTE(mbus->info.crc), mbus);
            pushModbusByte(HBYTE(mbus->info.crc), mbus);
            mbus->evFunc = _WAIT_FOR_SEND_READY;
        }
        break;

    case _WAIT_FOR_SEND_READY:
        if(mbus->popcnts<mbus->pushcnts) {
            if(SCI_FIFO_TX16 > SCI_getTxFIFOStatus(mbus->sci)) {
                SCI_writeCharNonBlocking(mbus->sci, mbus->TxBuf[mbus->popcnts++]);
            }
        }
        else {
            mbus->popcnts = mbus->pushcnts = 0;
            mbus->evFunc = _SEND_ADDRESS;
            return MBUS_10H_Write_Multiple_Register;
        }
        break;
    default:
        mbus->info = DEFAULT_REG_INFO;
        mbus->evFunc = _SEND_ADDRESS;
        mbus->errmsg = MB_ERROR_SLVFAILURE;
        break;
    }

    if(MB_NO_ERROR != mbus->errmsg) return MBUS_FAIL;

	return MBUS_WAIT;
}


int16_t (*ModbusFunc[MB_END_OF_FUNCID])(SCI_MODBUS *mbus) = {
		ReservedFunction,		//0x00
		ReservedFunction,		//0x01
		ReservedFunction,		//0x02
		readHoldingRegister,	//0x03		Read Holding Registers
		ReservedFunction,		//0x04
		ReservedFunction,		//0x05
		writeHoldingRegister,	//0x06		Write Single Register
		ReservedFunction,		//0x07
		ReservedFunction,		//0x08
		ReservedFunction,		//0x09
		ReservedFunction,		//0x0A
		ReservedFunction,		//0x0B
		ReservedFunction,		//0x0C
		ReservedFunction,		//0x0D
		ReservedFunction,		//0x0E
		ReservedFunction,		//0x0F
		writeHoldingNRegister,	//0x10		Write Multiple Register
		ReservedFunction,		//0x11
		ReservedFunction,		//0x12
		ReservedFunction,		//0x13
		ReservedFunction,		//0x14
		ReservedFunction,		//0x15
		ReservedFunction,		//0x16
		ReservedFunction,		//0x17
		ReservedFunction		//0x18

};


int16_t ModbusCommError(SCI_MODBUS *mbus)
{
	static MODBUS_HEADER *pack = 0;

    pack = (MODBUS_HEADER *)&mbus->RxBuf[0];

    switch(mbus->evError) {
    case _SEND_ADDRESS:
        mbus->info.tbcrc = DEFAULT_CRC;
        mbus->info.crc = 0;
        pushModbusByte(pack->Slave, mbus);
        ucMBCRC16(pack->Slave, &mbus->info.tbcrc);
        mbus->evError = _SEND_ERROR_FUNCTION;
        break;
    case _SEND_ERROR_FUNCTION:
        pushModbusByte(pack->Function | MB_ERROR_MASK, mbus);
        ucMBCRC16(pack->Function | 0x80, &mbus->info.tbcrc);
        mbus->evError = _SEND_ERROR_ID;
        break;
    case _SEND_ERROR_ID:
        if(SIZE_OF_ERRORLOG > mbus->amount_of_error) {
            mbus->errorlog[mbus->amount_of_error] = mbus->errmsg;
            mbus->amount_of_error++;
        }
        pushModbusByte(mbus->errmsg, mbus);
        mbus->info.crc = ucMBCRC16(mbus->errmsg, &mbus->info.tbcrc);
        mbus->evError = _SEND_CRC;
        break;
    case _SEND_CRC:
        pushModbusByte(mbus->info.crc & 0x00FF, mbus);
        pushModbusByte((mbus->info.crc>>8) & 0x00FF, mbus);
        mbus->evError = _WAIT_FOR_SEND_READY;
        break;
    case _WAIT_FOR_SEND_READY:
        if(mbus->popcnts<mbus->pushcnts) {
            if(SCI_FIFO_TX16 > SCI_getTxFIFOStatus(mbus->sci)) {
                SCI_writeCharNonBlocking(mbus->sci, mbus->TxBuf[mbus->popcnts++]);
            }
        }
        else {
            mbus->errmsg = MB_NO_ERROR;
            mbus->evError = _SEND_ADDRESS;
            if(SIZE_OF_ERRORLOG == mbus->amount_of_error) return MBUS_FAIL;
            else return MBUS_SUCCESS;
        }
        break;
    default:
        break;
    }
	return MBUS_WAIT;
}


extern ST_GROUP gpMbus[];

SCI_MODBUS mbcomm = {
		.pHeader = (MODBUS_HEADER *)&mbcomm.RxBuf[0],
		.sci = DEBUG_SCI_BASE,
		.slaveid = 0x03,
		.pfn = &gpMbus[0],
		.pReg = &regMbusData
};


