#include "ModbusSlave.h"

#define SET_SLAVE_RX_ENABLE  //GpioDataRegs.GPACLEAR.bit.GPIO26 = 1;
#define SET_SLAVE_TX_ENABLE  //GpioDataRegs.GPASET.bit.GPIO26 = 1;

void cntModbusTimeout(SCI_MODBUS *mbus)
{
    if(0<mbus->rw_size) {
        mbus->timetick = SW_TIMER - (uint32_t)CPUTimer_getTimerCount(SWTIRMER_BASE);

        if(mbus->timestamp > mbus->timetick) {
            mbus->timeout = mbus->timetick + SW_TIMER - mbus->timestamp;
        }
        else {
            mbus->timeout = mbus->timetick - mbus->timestamp;
        }

        if(mbus->timeout >= MBUS_TIMEOUT) {
            mbus->timestamp = mbus->timetick;
            mbus->evstep = _INIT_SCI_CONFIG;
        }
    }
}

void rstModbusTimeout(SCI_MODBUS *mbus)
{
    mbus->timestamp = mbus->timetick = SW_TIMER - (uint32_t)CPUTimer_getTimerCount(SWTIRMER_BASE);

}

int16_t initMbusConfig(SCI_MODBUS *mbus)
{
    if(0 == mbus->sci) return 0;

    SCI_init();

    for(; 0<mbus->amount_of_error; mbus->amount_of_error--)
                mbus->errorlog[mbus->amount_of_error-1] = MB_NO_ERROR;

    rstModbusTimeout(mbus);
    mbus->popcnts = mbus->pushcnts = 0;
	mbus->RxBuf[0] = 0xFFFF; //Reset Slave Address
	mbus->pFiFo.pb = mbus->pFiFo.pi = &mbus->RxBuf[0];
	mbus->pFiFo.pe = &mbus->RxBuf[SIZE_OF_RXBUF-1];
	mbus->crcdata = DEFAULT_CRC;
	mbus->crc = 0x0000;
	mbus->rw_size = 0;
    mbus->info = DEFAULT_REG_INFO;
    mbus->state = MBUS_FREE;
    mbus->evstep = _RECEIVE_DATA_FROM_SCI;

    SET_SLAVE_RX_ENABLE;
	return 1;
}

int16_t isrMbusRxData(SCI_MODBUS *mbus)
{
    while(0<SCI_getRxFIFOStatus(mbus->sci)) {
        if(SIZE_OF_RXBUF > mbus->rw_size) {
            rstModbusTimeout(mbus);
            mbus->rw_size++;
            *mbus->pFiFo.pi = (SCI_readCharNonBlocking(mbus->sci) & 0x00FF);
            mbus->crc = ucMBCRC16(*mbus->pFiFo.pi, &mbus->crcdata);
            if(mbus->pFiFo.pi < mbus->pFiFo.pe) mbus->pFiFo.pi++;
            else                                mbus->pFiFo.pi = mbus->pFiFo.pb;
        }
        else return -1;
    }

	return mbus->rw_size;
}

int16_t exeModbusSlave(SCI_MODBUS *mbus)
{
    switch(mbus->evstep) {
    case _INIT_SCI_CONFIG:
        initMbusConfig(mbus);
        break;

    case _RECEIVE_DATA_FROM_SCI:

        if(0 < isrMbusRxData(mbus)) {

            cntModbusTimeout(mbus);

            if(mbus->pFiFo.pi != mbus->pFiFo.pb)
            {
                if(0 == mbus->crc) //CRC matched?
                {
                    if((0 == *mbus->pFiFo.pb)||(mbus->slaveid == *mbus->pFiFo.pb)) //broadcast? or slave id matched?
                    {
                        //response
                        SET_SLAVE_TX_ENABLE;
                        //_PROCESS_RECEIVING_DATA
                        mbus->pHeader = (MODBUS_HEADER *)mbus->pFiFo.pb;
                        mbus->state = (MODBUS_STATUS)ModbusFunc[mbus->pHeader->Function](mbus);
                        if(MBUS_WAIT != mbus->state)
                        {
                            mbus->crcdata = DEFAULT_CRC;
                            mbus->rw_size = 0;
                            mbus->pFiFo.pi = mbus->pFiFo.pb;

                            if(MBUS_FAIL == mbus->state)
                            {
                                mbus->state = (MODBUS_STATUS)ModbusCommError(mbus);
                                mbus->evstep = _SEND_ERROR_MSG_OUT;
                                return mbus->state;
                            }
                            mbus->evstep = _WAIT_FOR_SENDING_FINISH;
                        }
                    }
                    else
                    {
                        mbus->crcdata = DEFAULT_CRC;
                        mbus->rw_size = 0;
                        mbus->pFiFo.pi = mbus->pFiFo.pb;
                        mbus->evstep = _RECEIVE_DATA_FROM_SCI;
                    }
                }
                mbus->timeout++;
            }
        }
        break;

    case _WAIT_FOR_SENDING_FINISH:  //wait for sending data finished to switch RS485 IC DE/RE enable
        if(false == SCI_isTransmitterBusy(mbus->sci)) {
            SET_SLAVE_RX_ENABLE;  //set RS485 IC RE enable
            mbus->state = MBUS_FREE;
            mbus->info = DEFAULT_REG_INFO;
            mbus->evstep = _RECEIVE_DATA_FROM_SCI;
        }
        break;

    case _SEND_ERROR_MSG_OUT:
        mbus->state = (MODBUS_STATUS)ModbusCommError(mbus);
        if(MBUS_WAIT != mbus->state)
        {
            mbus->evstep = _RESET_FIFO_DATA;
        }
        break;

    case _RESET_FIFO_DATA:
        mbus->evstep = _INIT_SCI_CONFIG;
        break;

    default:
        break;
    }

    return mbus->state;
}
