/*
 * ModbusSlave.h
 *
 *  Created on: 2018~326
 *      Author: user
 */

#ifndef MODBUSSLAVE_H_
#define MODBUSSLAVE_H_

#include "ModbusCommon.h"
#include "mbcmd.h"

typedef enum {
	_SEND_ADDRESS = 0,
	_SEND_MEMADDR,
	_SEND_MEMSIZE,
	_SAVE_BYTE_COUNTS,
	_SEND_BYTE_COUNTS,
	_SEND_DATA_OUT,
	_WAIT_FOR_SEND_READY,
	_SEND_ERROR_FUNCTION,
	_SEND_ERROR_ID,
	_SEND_CRC
} MB_EVENT_ID;

#define MBUS_TIMEOUT                    T_10MS

#define SIZE_OF_RXBUF		256

typedef struct {
	uint16_t HiByte;
	uint16_t LoByte;
} U16REG;

typedef struct {
	uint16_t Slave;
	uint16_t Function;
	U16REG Address;
} MODBUS_HEADER;

typedef struct {
	uint16_t Slave;
	uint16_t Function;
	U16REG Address;
	U16REG Points;
} HEADER_READ_HOLDINGREG;


typedef struct {
	uint16_t Slave;
	uint16_t Function;
	U16REG Address;
	U16REG Data;
} HEADER_WRITE_HOLDINGREG;

typedef struct {
	uint16_t Slave;
	uint16_t Function;
	U16REG Address;
	U16REG Points;
	uint16_t Bytes;
	U16REG Data;
} HEADER_WRITE_N_HOLDINGREG;

typedef struct {
	ST_CRC tbcrc;
	uint16_t crc;
	uint16_t words;
	uint16_t index;
	uint16_t addr;
	U16REG *pData;
	int16_t group;
	int16_t memrange;
	uint16_t rwfrom;
} REG_FUNC_INFO;

#define DEFAULT_REG_INFO (REG_FUNC_INFO) { \
							.tbcrc = DEFAULT_CRC, \
							.crc = 0, \
							.words = 0, \
							.index = 0, \
							.addr = 0, \
							.pData = 0, \
							.group = 0, \
							.memrange = 0, \
							.rwfrom = 0 }

typedef enum{
	_INIT_SCI_CONFIG = 0,
	_INIT_MODBUS_INFO,
	_RECEIVE_DATA_FROM_SCI,
	_RECEIVING_TIMEOUT,
	_PROCESS_RECEIVING_DATA,
	_WAIT_FOR_SENDING_FINISH,
	_RESET_FIFO_DATA,
	_SEND_ERROR_MSG_OUT
} EV_MODBUS;


typedef enum {
    T_S16 = 0,
    T_U16,
    T_S32,
    T_U32,
    T_F32,
    T_D64,
    T_STR,
    T_FUNC,
    UNDEFINE_CMD_TPYE
} TYP_CMD;


typedef struct {
   uint16_t id;         //Id Range: 0 ~ 0xFFFF
   TYP_CMD foramt;
   uint16_t mem_i;      //Memory Index
   uint16_t mem_size;   //Memory Size
} ST_CMD;

typedef struct {
    ST_CMD * src;
    uint16_t d_size;
}ST_GROUP;

typedef struct {
    uint16_t *pi;
    uint16_t *po;
    uint16_t *pb;
    uint16_t *pe;
}ST_FIFO;


#define SIZE_OF_ERRORLOG 	16
typedef struct _SCI_MODBUS {
	int16_t errno;
	int16_t rw_size;
	ST_CRC crcdata;
	uint16_t crc;
	EV_MODBUS evstep;	//Event Step;
	MODBUS_STATUS state;
	uint16_t slaveid;
	ST_FIFO pFiFo;
	uint16_t RxBuf[SIZE_OF_RXBUF];
    uint16_t pushcnts;
    uint16_t popcnts;
    uint16_t TxBuf[SIZE_OF_RXBUF];
	MODBUS_HEADER *pHeader;
	MSG_ERROR_ID errmsg;

	REG_FUNC_INFO info;

	MB_EVENT_ID evFunc;
	MB_EVENT_ID evError;

	MSG_ERROR_ID errorlog[SIZE_OF_ERRORLOG];
	int16_t amount_of_error;

	ST_GROUP *pfn;

	REG_MBUSDATA *pReg;

	uint32_t timetick;
	uint32_t timestamp;
	uint32_t timecnt;
	uint32_t timeout;


	uint32_t sci;
} SCI_MODBUS;

extern int16_t (*ModbusFunc[MB_END_OF_FUNCID])(SCI_MODBUS *mbus);
extern int16_t ModbusCommError(SCI_MODBUS *mbus);

extern int16_t exeModbusSlave(SCI_MODBUS *ref);
extern int16_t isrMbusRxData(SCI_MODBUS *mbus);

extern void updateModbusParameter(SCI_MODBUS *p);

extern SCI_MODBUS mbcomm;


#endif /* MODBUSSLAVE_H_ */
