/*
 * linkVariables.c
 *
 *  Created on: 2023/4/6
 */
#include "ModbusCommon.h"
#include "ModbusSlave.h"


void updateModbusParameter(SCI_MODBUS *p) { 

	if( MBUS_03H_Read_Holding_Registers  == p->state) {
	    switch(p->info.group) {
        case 1:
            regMbusData.u16SYStemRESet = sDrv.u16Reset; 
            regMbusData.u16DRVNA = sDrv.u16NA; 
            regMbusData.f32DRVSOFtSTARtRAMp = sDrv.sVref.f32Step; 
            regMbusData.u16DRVCONtrolSTATus = sDrv.fgDrv; 
            regMbusData.u16DRVFAULtSTATus = sDrv.fgFault; 
            regMbusData.u16CLAPWMCONtrolREGister = sCLA.sPWM.u16CtrlReg; 
            regMbusData.u16CLAPWMSTATusREGister = sCLA.sPWM.u16StatusReg; 
            regMbusData.u16CLACONtrolSTATus = sCLA.fgStatus; 
            regMbusData.u16CLAERRorSTATus = sCLA.fgError; 
            regMbusData.f32CLAPWMF32period = sCLA.sPWM.f32Period; 
            regMbusData.f32CLAVREF = sCLA.f32Vref; 
            regMbusData.f32CLAVOUT = sCLA.f32Vout; 
            regMbusData.f32CLAIOUT = sCLA.f32Iout; 
            regMbusData.f32CLATEMp = sCLA.f32Temp; 
            break;
	    default:
	        break;
	    }

	}
	else if( MBUS_06H_Write_Single_Register  == p->state) {
	    switch(p->info.rwfrom) {
        case _muSYStemRESet :   sDrv.u16Reset = regMbusData.u16SYStemRESet; break;
        case _muDRVNA :   sDrv.u16NA = regMbusData.u16DRVNA; break;
        case _muDRVSOFtSTARtRAMp :   sDrv.sVref.f32Step = regMbusData.f32DRVSOFtSTARtRAMp; break;
        case _muDRVCONtrolSTATus :   sDrv.fgDrv = regMbusData.u16DRVCONtrolSTATus; break;
        case _muDRVFAULtSTATus :   sDrv.fgFault = regMbusData.u16DRVFAULtSTATus; break;
        case _muCLAPWMCONtrolREGister :   sCLA.sPWM.u16CtrlReg = regMbusData.u16CLAPWMCONtrolREGister; break;
        case _muCLAPWMSTATusREGister :   sCLA.sPWM.u16StatusReg = regMbusData.u16CLAPWMSTATusREGister; break;
        case _muCLACONtrolSTATus :   sCLA.fgStatus = regMbusData.u16CLACONtrolSTATus; break;
        case _muCLAERRorSTATus :   sCLA.fgError = regMbusData.u16CLAERRorSTATus; break;
        case _muCLAPWMF32period :   sCLA.sPWM.f32Period = regMbusData.f32CLAPWMF32period; break;
        case _muCLAVREF :   sCLA.f32Vref = regMbusData.f32CLAVREF; break;
        case _muCLAVOUT :   sCLA.f32Vout = regMbusData.f32CLAVOUT; break;
        case _muCLAIOUT :   sCLA.f32Iout = regMbusData.f32CLAIOUT; break;
        case _muCLATEMp :   sCLA.f32Temp = regMbusData.f32CLATEMp; break;
	    default:
	        break;
	    }

	}
	else if( MBUS_10H_Write_Multiple_Register  == p->state) {
	    switch(p->info.group) {
        case 1:
            sDrv.u16Reset = regMbusData.u16SYStemRESet; 
            sDrv.u16NA = regMbusData.u16DRVNA; 
            sDrv.sVref.f32Step = regMbusData.f32DRVSOFtSTARtRAMp; 
            sDrv.fgDrv = regMbusData.u16DRVCONtrolSTATus; 
            sDrv.fgFault = regMbusData.u16DRVFAULtSTATus; 
            sCLA.sPWM.u16CtrlReg = regMbusData.u16CLAPWMCONtrolREGister; 
            sCLA.sPWM.u16StatusReg = regMbusData.u16CLAPWMSTATusREGister; 
            sCLA.fgStatus = regMbusData.u16CLACONtrolSTATus; 
            sCLA.fgError = regMbusData.u16CLAERRorSTATus; 
            sCLA.sPWM.f32Period = regMbusData.f32CLAPWMF32period; 
            sCLA.f32Vref = regMbusData.f32CLAVREF; 
            sCLA.f32Vout = regMbusData.f32CLAVOUT; 
            sCLA.f32Iout = regMbusData.f32CLAIOUT; 
            sCLA.f32Temp = regMbusData.f32CLATEMp; 
            break;
	    default:
	        break;
	    }

	}
	else {

	}

}
