/*
 * mbcmd.h
 *
 *  Created on: 2023/4/6
*/

#ifndef MBCMD_H_
#define MBCMD_H_



typedef enum {
	_g0_MODE = 0,
	_g2000_MODE,
	_g9000_MODE,
    _END_OF_MODE
} ID_MODE;


enum {
	_muSYStemSTATus = 0,                     // #0  T_U16                 
	_muCONtrolREGister = 1,                  // #1  T_U16                 
	_muHARdwareFAULtSTATus = 2,              // #2  T_U16                 
	_muSOFtwareFAULtSTATus = 3,              // #3  T_U16                 
    _end_of_0_id = 4
};

enum {
	_muSYStemRESet = 2000,                   // #2000  T_U16              
	_muDRVNA = 2001,                         // #2001  T_U16              
	_muDRVSOFtSTARtRAMp = 2002,              // #2002  T_F32              
	_muDRVCONtrolSTATus = 2004,              // #2004  T_U16              
	_muDRVFAULtSTATus = 2005,                // #2005  T_U16              
	_muCLAPWMCONtrolREGister = 2006,         // #2006  T_U16              
	_muCLAPWMSTATusREGister = 2007,          // #2007  T_U16              
	_muCLACONtrolSTATus = 2008,              // #2008  T_U16              
	_muCLAERRorSTATus = 2009,                // #2009  T_U16              
	_muCLAPWMF32period = 2010,               // #2010  T_F32              
	_muCLAVREF = 2012,                       // #2012  T_F32              
	_muCLAVOUT = 2014,                       // #2014  T_F32              
	_muCLAIOUT = 2016,                       // #2016  T_F32              
	_muCLATEMp = 2018,                       // #2018  T_F32              
    _end_of_2000_id = 14
};

enum {
	_muSOFtwareVERsion = 9000,               // #9000  T_STR              
	_muHARdwareVERsion = 9008,               // #9008  T_STR              
	_muPCBVERsion = 9016,                    // #9016  T_STR              
	_muSERialNUMber = 9024,                  // #9024  T_STR              
    _end_of_9000_id = 4
};

typedef union { 
    uint16_t u16MbusData[56];
    struct { 
        uint16_t u16SYStemSTATus;                 
        uint16_t u16CONtrolREGister;              
        uint16_t u16HARdwareFAULtSTATus;          
        uint16_t u16SOFtwareFAULtSTATus;          
        uint16_t u16SYStemRESet;                  
        uint16_t u16DRVNA;                        
        float32_t f32DRVSOFtSTARtRAMp;             
        uint16_t u16DRVCONtrolSTATus;             
        uint16_t u16DRVFAULtSTATus;               
        uint16_t u16CLAPWMCONtrolREGister;        
        uint16_t u16CLAPWMSTATusREGister;         
        uint16_t u16CLACONtrolSTATus;             
        uint16_t u16CLAERRorSTATus;               
        float32_t f32CLAPWMF32period;              
        float32_t f32CLAVREF;                      
        float32_t f32CLAVOUT;                      
        float32_t f32CLAIOUT;                      
        float32_t f32CLATEMp;                      
        uint16_t u16SOFtwareVERsion[8];           
        uint16_t u16HARdwareVERsion[8];           
        uint16_t u16PCBVERsion[8];                
        uint16_t u16SERialNUMber[8];              
    }; 
} REG_MBUSDATA;
extern REG_MBUSDATA regMbusData;





#endif /* MBCMD_H_ */

