/*
 * initPWM.c
 *
 *  Created on: 2023~317
 *      Author: fornyin_jiang
 */

#include "initPWM.h"

#ifdef _FLASH
#pragma SET_CODE_SECTION(".TI.ramfunc")
#endif //_FLASH

//
// Globals
//
int MEP_ScaleFactor; // Global variable used by the SFO library
                     // Result can be used for all HRPWM channels
                     // This variable is also copied to HRMSTEP
                     // register by SFO() function.
volatile uint16_t status;
uint16_t j;

volatile uint32_t ePWM[] =
    {0, DRI_PRI_BASE, DRI_2ND_BASE};



//
// Globals to hold the ePWM information used in this example
//
/*---------------------------------------------------------------------------------*/
void initHRPWM(void)
{


    HRPWM_setMEPEdgeSelect(ePWM[j], HRPWM_CHANNEL_A, HRPWM_MEP_CTRL_RISING_AND_FALLING_EDGE);
    HRPWM_setMEPControlMode(ePWM[j], HRPWM_CHANNEL_A, HRPWM_MEP_DUTY_PERIOD_CTRL);
    HRPWM_setCounterCompareShadowLoadEvent(ePWM[j], HRPWM_CHANNEL_A, HRPWM_LOAD_ON_CNTR_ZERO_PERIOD);

    HRPWM_setMEPEdgeSelect(ePWM[j], HRPWM_CHANNEL_B, HRPWM_MEP_CTRL_RISING_AND_FALLING_EDGE);
    HRPWM_setMEPControlMode(ePWM[j], HRPWM_CHANNEL_B, HRPWM_MEP_DUTY_PERIOD_CTRL);
    HRPWM_setCounterCompareShadowLoadEvent(ePWM[j], HRPWM_CHANNEL_B, HRPWM_LOAD_ON_CNTR_ZERO_PERIOD);

//    HRPWM_setDeadbandMEPEdgeSelect(ePWM[j],HRPWM_DB_MEP_CTRL_RED_FED);
//    HRPWM_setRisingEdgeDelayLoadMode(ePWM[j],HRPWM_LOAD_ON_CNTR_ZERO);
//    HRPWM_setFallingEdgeDelayLoadMode(ePWM[j],HRPWM_LOAD_ON_CNTR_ZERO);

    HRPWM_setHiResCounterCompareValueOnly(ePWM[j],HRPWM_COUNTER_COMPARE_A,1U);
    HRPWM_setHiResCounterCompareValueOnly(ePWM[j],HRPWM_COUNTER_COMPARE_B,1U);

//    HRPWM_setHiResRisingEdgeDelayOnly(ePWM[j], 64U);
//    HRPWM_setHiResFallingEdgeDelayOnly(ePWM[j], 64U);

    HRPWM_setHiResTimeBasePeriodOnly(ePWM[j],  128U);

    HRPWM_enableAutoConversion(ePWM[j]);

    EPWM_enablePhaseShiftLoad(ePWM[j]);
    HRPWM_enablePhaseShiftLoad(ePWM[j]);
    HRPWM_enablePeriodControl(ePWM[j]);
    EPWM_forceSyncPulse(ePWM[j]);
}

/*---------------------------------------------------------------------------------*/
void init_EPWM()
{
    sCLA.sPWM.u32PwmBase_PRI = DRI_PRI_BASE;
    sCLA.sPWM.u32PwmBase_2ND = DRI_2ND_BASE;
    sCLA.sPWM.u16Period = 20;

    // Calling SFO() updates the HRMSTEP register with calibrated MEP_ScaleFactor.
    // HRMSTEP must be populated with a scale factor value prior to enabling
    // high resolution period control.
    while(status == SFO_INCOMPLETE)
    {
        status = SFO();
        if(status == SFO_ERROR)
        {
            asm(" ESTOP0");     // SFO function returns 2 if an error occurs & # of MEP
        }                       // steps/coarse step exceeds maximum of 255.
    }

    for (j=1;j<LAST_EPWM_INDEX_FOR_EXAMPLE;j++){

        EPWM_setEmulationMode(ePWM[j], EPWM_EMULATION_FREE_RUN);
        // TB FREEZE Time Base Counter Mode
        EPWM_setTimeBaseCounterMode(ePWM[j], EPWM_COUNTER_MODE_STOP_FREEZE);
        // TB Select Active Period module or Shadow module.
        EPWM_setPeriodLoadMode(ePWM[j], EPWM_PERIOD_SHADOW_LOAD);
        // TB Set-up Time Base Period Register
        EPWM_setTimeBasePeriod(ePWM[j], sCLA.sPWM.u16Period);
        // TB Set-up Time Base Phase Register
        EPWM_setPhaseShift(ePWM[j], 0U);
        // TB Set-up Time Base Counter Register
        EPWM_setTimeBaseCounter(ePWM[j], 0U);
        // TB disable Time Base Phase Function
        EPWM_disablePhaseShiftLoad(ePWM[j]);
        // TB Set ePWM clock pre-scaler
        EPWM_setClockPrescaler(ePWM[j],EPWM_CLOCK_DIVIDER_1,EPWM_HSCLOCK_DIVIDER_1);

        // CC Set up Counter Compare shadowing CMPA and CMPB
        EPWM_setCounterCompareShadowLoadMode(ePWM[j],
                                             EPWM_COUNTER_COMPARE_A,
                                             EPWM_COMP_LOAD_ON_CNTR_ZERO);
        EPWM_setCounterCompareShadowLoadMode(ePWM[j],
                                             EPWM_COUNTER_COMPARE_B,
                                             EPWM_COMP_LOAD_ON_CNTR_ZERO);
        // CC Set-up compare COMPA and COMPB Register
        EPWM_setCounterCompareValue(ePWM[j], EPWM_COUNTER_COMPARE_A, 5U);
        EPWM_setCounterCompareValue(ePWM[j], EPWM_COUNTER_COMPARE_B, 5U);

        // AQ Set actions DRI_PRI_BASE and DRI_2ND_BASE
        // Set ePWMxA Action

        EPWM_setActionQualifierAction(ePWM[j],
                                          EPWM_AQ_OUTPUT_A,
                                          EPWM_AQ_OUTPUT_HIGH,
                                          EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
        EPWM_setActionQualifierAction(ePWM[j],
                                          EPWM_AQ_OUTPUT_A,
                                          EPWM_AQ_OUTPUT_LOW,
                                          EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);

        EPWM_selectPeriodLoadEvent(ePWM[j], EPWM_SHADOW_LOAD_MODE_COUNTER_ZERO);
        EPWM_setSyncOutPulseMode(ePWM[j], EPWM_SYNC_OUT_PULSE_DISABLED);
        //
        // Set the Dead Band Clock Source
        //
        EPWM_setDeadBandCounterClock(ePWM[j], EPWM_DB_COUNTER_CLOCK_HALF_CYCLE);
        EPWM_setDeadBandControlShadowLoadMode(ePWM[j], EPWM_DB_LOAD_ON_CNTR_ZERO);
        EPWM_setRisingEdgeDelayCountShadowLoadMode(ePWM[j], EPWM_RED_LOAD_ON_CNTR_ZERO);
        EPWM_setFallingEdgeDelayCountShadowLoadMode(ePWM[j], EPWM_FED_LOAD_ON_CNTR_ZERO);
        //
        // Use EPWMA as the input for both RED and FED
        //
        EPWM_setRisingEdgeDeadBandDelayInput(ePWM[j], EPWM_DB_INPUT_EPWMA);
        EPWM_setFallingEdgeDeadBandDelayInput(ePWM[j], EPWM_DB_INPUT_EPWMA);
        //
        // Set the RED and FED values
        //
        EPWM_setFallingEdgeDelayCount(ePWM[j], 10);
        EPWM_setRisingEdgeDelayCount(ePWM[j], 10);
        //
        // Invert only the Falling Edge delayed output (AHC)
        //
        EPWM_setDeadBandDelayPolarity(ePWM[j], EPWM_DB_RED, EPWM_DB_POLARITY_ACTIVE_HIGH);
        EPWM_setDeadBandDelayPolarity(ePWM[j], EPWM_DB_FED, EPWM_DB_POLARITY_ACTIVE_LOW);
        //
        // Use the delayed signals instead of the original signals
        //
        EPWM_setDeadBandDelayMode(ePWM[j], EPWM_DB_RED, true);
        EPWM_setDeadBandDelayMode(ePWM[j], EPWM_DB_FED, true);
        //
        // DO NOT Switch Output A with Output B
        //
        EPWM_setDeadBandOutputSwapMode(ePWM[j], EPWM_DB_OUTPUT_A, false);
        EPWM_setDeadBandOutputSwapMode(ePWM[j], EPWM_DB_OUTPUT_B, false);
        //
        //
//        initHRPWM();

        EPWM_setTimeBaseCounterMode(ePWM[j], EPWM_COUNTER_MODE_UP_DOWN);
        // ========================================================================
    }
    /*----------------------------Start enabling SOCA -----------------------------*/
    EPWM_setCounterCompareShadowLoadMode(DRI_2ND_BASE,
                                         EPWM_COUNTER_COMPARE_C,
                                         EPWM_COMP_LOAD_ON_CNTR_ZERO);
    EPWM_setCounterCompareValue(DRI_2ND_BASE, EPWM_COUNTER_COMPARE_C, 0U);
    //
    // Disable SOCA
    //
    EPWM_disableADCTrigger(DRI_2ND_BASE, EPWM_SOC_A);
    //
    // Configure the SOC to occur on the first up-count event
    //
    EPWM_setADCTriggerSource(DRI_2ND_BASE, EPWM_SOC_A, EPWM_SOC_TBCTR_U_CMPC);
    EPWM_setADCTriggerEventPrescale(DRI_2ND_BASE, EPWM_SOC_A, 1);
}
/*---------------------------------------------------------------------------------*/

void initPWM(void)
{
    // Disable sync(Freeze clock to PWM as well)
    SysCtl_disablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);
    //
    // Configure DRI_PRI_BASE ePWM Mode
    init_EPWM();

    //
    // Enable the ePWM time base clock before configuring the module
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

}

#ifdef _FLASH
#pragma SET_CODE_SECTION()
#endif //_FLASH




