/*****************************************************************************
 * CM4Run.c
 *****************************************************************************/
#include <stdio.h>
#include <string.h>
#include "cm.h"
#include "ipc.h"
#include "driverlib_cm.h"
#include <CM4Uart.h> // UART
#include <wxemac.h>  // EMAC

uint16_t g_RunTest = 0;

WXEMAC_HANDLE main_emacHandle = NULL; // need
#if defined( ETHER_BOARD2BOARD_TEST_SENDER ) || defined( ETHER_BOARD2BOARD_TEST_RECIEVER )
uint16_t main_test_cbparam; // 内容不明、
void main_test_shelladdin_cb_ether( uint32_t event, void *param )
{
    WXEMAC_FRAME* pframe = (WXEMAC_FRAME*)param;
    if ( event == WXEMAC_EVENT_RECEIVE_FRAME ) {
        // read (get read descripter.)
        WxEmac_Read( main_emacHandle, &pframe );
        // free ( free read descripter. )
        WxEmac_FreeFrame( pframe );
    }
    else if ( event == WXEMAC_EVENT_LINK_UP ) {

    }
    else if ( event == WXEMAC_EVENT_LINK_DOWN ) {

    }
}
#endif // ETHER_BOARD2BOARD_TEST_SENDER


/* main                      */
/* User Program Entry Point. */
int main(void)
{
    /* Initialize device clock and peripherals */
    CM_init();

    CM4Uart_init();

/* ETHERNET -------------------------------------------------------------------------------- */

#if defined( ETHER_BOARD2BOARD_TEST_SENDER ) || defined( ETHER_BOARD2BOARD_TEST_RECIEVER )
    {
        WXEMAC_OPEN_PARAM openParam;

        WxEmac_Init();
        openParam.cbfunc = &main_test_shelladdin_cb_ether;
        openParam.cbparam = &main_test_cbparam;
#if defined( LOOPBACK_MODE_EMAC ) || defined( LOOPBACK_MODE_PHY_MII ) ||   defined( LOOPBACK_MODE_PHY_DEGITAL )
        openParam.mac_address[0] = 0x01;
        openParam.mac_address[1] = 0x02;
        openParam.mac_address[2] = 0x03;
        openParam.mac_address[3] = 0x04;
        openParam.mac_address[4] = 0x05;
        openParam.mac_address[5] = 0x06;
#else // defined( LOOPBACK_MODE_EMAC ) || defined( LOOPBACK_MODE_PHY_MII ) ||   defined( LOOPBACK_MODE_PHY_DEGITAL )
#ifdef ETHER_BOARD2BOARD_TEST_SENDER
        openParam.mac_address[0] = 0x07;
        openParam.mac_address[1] = 0x08;
        openParam.mac_address[2] = 0x09;
        openParam.mac_address[3] = 0x0A;
        openParam.mac_address[4] = 0x0B;
        openParam.mac_address[5] = 0x0C;
#endif // ETHER_BOARD2BOARD_TEST_SENDER
#ifdef ETHER_BOARD2BOARD_TEST_RECIEVER
        openParam.mac_address[0] = 0x01;
        openParam.mac_address[1] = 0x02;
        openParam.mac_address[2] = 0x03;
        openParam.mac_address[3] = 0x04;
        openParam.mac_address[4] = 0x05;
        openParam.mac_address[5] = 0x06;
#endif // ETHER_BOARD2BOARD_TEST_RECIEVER
#endif // defined( LOOPBACK_MODE_EMAC ) || defined( LOOPBACK_MODE_PHY_MII ) ||   defined( LOOPBACK_MODE_PHY_DEGITAL )

        WxEmac_Open( WXEMAC_DEV_0, &openParam, &main_emacHandle );
    }
#endif // ETHER_BOARD2BOARD_TEST_SENDER

    while ( 1 ) {
        DEVICE_DELAY_US(500); // 500us

        /* check Ethernet Link status. */
        WxEmac_Poll();

#ifdef ETHER_BOARD2BOARD_TEST_SENDER
#if 0
        if( g_RunTest++ >= 1000 ) {
            WXEMAC_FRAME* frame = NULL;
            int i = 0;

            // frame get
            while ( WxEmac_TxFrameChk() == false ) DEVICE_DELAY_US(100); // 100us
            frame = WxEmac_AllocFrame();
            if ( frame == NULL ) continue;

            // data set
            *((uint32_t*)&frame->buffer)     = (uint32_t)0x01020304; // LOW
            *((uint32_t*)&frame->buffer + 1) = (uint32_t)0xFFFF0506; // HIGH
            for ( i = 8; i < 1500; i++ ) frame->buffer[i] = i;
            frame->len = 1500;

            //data send
            WxEmac_Write( main_emacHandle, frame );
            g_RunTest = 0;
        }
#else
        if( g_RunTest++ >= 5000 ) {
            int i, j;
            for( j = 0; j < 64; j++ ) {
                WXEMAC_FRAME* frame = NULL;
                // frame get
                while ( WxEmac_TxFrameChk() == false ) DEVICE_DELAY_US(100); // 100us
                frame = WxEmac_AllocFrame();
                if ( frame == NULL ) continue;

                // data set
                *((uint32_t*)&frame->buffer)     = (uint32_t)0x01020304; // LOW
                *((uint32_t*)&frame->buffer + 1) = (uint32_t)0xFFFF0506; // HIGH
                for ( i = 8; i < 1500; i++ ) frame->buffer[i] = i;
                frame->len = 1500;

                //data send
                WxEmac_Write( main_emacHandle, frame );
                DEVICE_DELAY_US(5000); // 5000us
            }
            g_RunTest = 0;
        }

#endif
#endif // ETHER_BOARD2BOARD_TEST_SENDER

        CM4Uart_Exec();
    }
	return 0;
}

