/*****************************************************************************
 * CM4Uart.h
 *****************************************************************************/
#ifndef _INCLUDE_CM4UART_H_
#define _INCLUDE_CM4UART_H_

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>

/* define-------------------------- */
#define MSG_MAX_BUFF  256   // printf maximum number of characters.

/* typedef------------------------- */
typedef struct uart_debug {
    const char* cmd;
    void (*cmd_func)(char *line, int sline);
    const char* help;
} UART_DEBUG_t;
extern UART_DEBUG_t* debug_shell_addin;

/* prototype----------------------- */
void CM4Uart_init( void );
void CM4Uart_Exec( void );
void CM4Uart_title( const char* c );
void CM4Uart_sendMsgSet( char* msg );
void wxdbg_printf(char *format, ...);
void wxdbg_shell_printf(char *format, ...);
void shell_help(char *line, int sline);
void shell_table(char *line, int sline);

#endif /* _INCLUDE_CM4UART_H_ */
